/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.TypedArray;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.ViewDebug;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.android.internal.R;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import libcore.icu.LocaleData;

@RemoteViews.RemoteView
public class TextClock
extends TextView {
    public static final CharSequence DEFAULT_FORMAT_12_HOUR = "h:mm a";
    public static final CharSequence DEFAULT_FORMAT_24_HOUR = "H:mm";
    private boolean mAttached;
    @ViewDebug.ExportedProperty
    private CharSequence mFormat;
    private CharSequence mFormat12;
    private CharSequence mFormat24;
    private final ContentObserver mFormatChangeObserver = new ContentObserver(new Handler()){

        @Override
        public void onChange(boolean bl) {
            TextClock.this.chooseFormat();
            TextClock.this.onTimeChanged();
        }

        @Override
        public void onChange(boolean bl, Uri uri) {
            TextClock.this.chooseFormat();
            TextClock.this.onTimeChanged();
        }
    };
    @ViewDebug.ExportedProperty
    private boolean mHasSeconds;
    private final BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (TextClock.this.mTimeZone == null && "android.intent.action.TIMEZONE_CHANGED".equals(intent.getAction())) {
                String string2 = intent.getStringExtra("time-zone");
                TextClock.this.createTime(string2);
            }
            TextClock.this.onTimeChanged();
        }
    };
    private final Runnable mTicker = new Runnable(){

        @Override
        public void run() {
            TextClock.this.onTimeChanged();
            long l = SystemClock.uptimeMillis();
            long l2 = l + (1000L - l % 1000L);
            TextClock.this.getHandler().postAtTime(TextClock.this.mTicker, l2);
        }
    };
    private Calendar mTime;
    private String mTimeZone;

    public TextClock(Context context) {
        super(context);
        this.init();
    }

    public TextClock(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public TextClock(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public TextClock(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.TextClock, n, n2);
        try {
            this.mFormat12 = typedArray.getText(0);
            this.mFormat24 = typedArray.getText(1);
            this.mTimeZone = typedArray.getString(2);
            this.init();
            return;
        }
        finally {
            typedArray.recycle();
        }
    }

    private static CharSequence abc(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) {
        if (charSequence == null) {
            if (charSequence2 == null) {
                return charSequence3;
            }
            return charSequence2;
        }
        return charSequence;
    }

    private void chooseFormat() {
        this.chooseFormat(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void chooseFormat(boolean bl) {
        boolean bl2 = this.is24HourModeEnabled();
        LocaleData localeData = LocaleData.get((Locale)this.getContext().getResources().getConfiguration().locale);
        this.mFormat = bl2 ? TextClock.abc(this.mFormat24, this.mFormat12, localeData.timeFormat24) : TextClock.abc(this.mFormat12, this.mFormat24, localeData.timeFormat12);
        boolean bl3 = this.mHasSeconds;
        this.mHasSeconds = DateFormat.hasSeconds(this.mFormat);
        if (bl && this.mAttached && bl3 != this.mHasSeconds) {
            if (!bl3) {
                this.mTicker.run();
                return;
            }
            this.getHandler().removeCallbacks(this.mTicker);
        }
    }

    private void createTime(String string2) {
        if (string2 != null) {
            this.mTime = Calendar.getInstance(TimeZone.getTimeZone(string2));
            return;
        }
        this.mTime = Calendar.getInstance();
    }

    private void init() {
        if (this.mFormat12 == null || this.mFormat24 == null) {
            LocaleData localeData = LocaleData.get((Locale)this.getContext().getResources().getConfiguration().locale);
            if (this.mFormat12 == null) {
                this.mFormat12 = localeData.timeFormat12;
            }
            if (this.mFormat24 == null) {
                this.mFormat24 = localeData.timeFormat24;
            }
        }
        this.createTime(this.mTimeZone);
        this.chooseFormat(false);
    }

    private void onTimeChanged() {
        this.mTime.setTimeInMillis(System.currentTimeMillis());
        this.setText(DateFormat.format(this.mFormat, this.mTime));
    }

    private void registerObserver() {
        this.getContext().getContentResolver().registerContentObserver(Settings.System.CONTENT_URI, true, this.mFormatChangeObserver);
    }

    private void registerReceiver() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.TIME_TICK");
        intentFilter.addAction("android.intent.action.TIME_SET");
        intentFilter.addAction("android.intent.action.TIMEZONE_CHANGED");
        this.getContext().registerReceiver(this.mIntentReceiver, intentFilter, null, this.getHandler());
    }

    private void unregisterObserver() {
        this.getContext().getContentResolver().unregisterContentObserver(this.mFormatChangeObserver);
    }

    private void unregisterReceiver() {
        this.getContext().unregisterReceiver(this.mIntentReceiver);
    }

    public CharSequence getFormat() {
        return this.mFormat;
    }

    @ViewDebug.ExportedProperty
    public CharSequence getFormat12Hour() {
        return this.mFormat12;
    }

    @ViewDebug.ExportedProperty
    public CharSequence getFormat24Hour() {
        return this.mFormat24;
    }

    public String getTimeZone() {
        return this.mTimeZone;
    }

    public boolean is24HourModeEnabled() {
        return DateFormat.is24HourFormat(this.getContext());
    }

    @Override
    protected void onAttachedToWindow() {
        block3: {
            block2: {
                super.onAttachedToWindow();
                if (this.mAttached) break block2;
                this.mAttached = true;
                this.registerReceiver();
                this.registerObserver();
                this.createTime(this.mTimeZone);
                if (!this.mHasSeconds) break block3;
                this.mTicker.run();
            }
            return;
        }
        this.onTimeChanged();
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAttached) {
            this.unregisterReceiver();
            this.unregisterObserver();
            this.getHandler().removeCallbacks(this.mTicker);
            this.mAttached = false;
        }
    }

    @RemotableViewMethod
    public void setFormat12Hour(CharSequence charSequence) {
        this.mFormat12 = charSequence;
        this.chooseFormat();
        this.onTimeChanged();
    }

    @RemotableViewMethod
    public void setFormat24Hour(CharSequence charSequence) {
        this.mFormat24 = charSequence;
        this.chooseFormat();
        this.onTimeChanged();
    }

    @RemotableViewMethod
    public void setTimeZone(String string2) {
        this.mTimeZone = string2;
        this.createTime(string2);
        this.onTimeChanged();
    }
}

