/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.content.pm.PackageParser;
import android.os.Build;
import android.os.SELinux;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Slog;
import dalvik.system.CloseGuard;
import dalvik.system.VMRuntime;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class NativeLibraryHelper {
    private static final int BITCODE_PRESENT = 1;
    public static final String CLEAR_ABI_OVERRIDE = "-";
    private static final boolean DEBUG_NATIVE = false;
    public static final String LIB64_DIR_NAME = "lib64";
    public static final String LIB_DIR_NAME = "lib";
    private static final String TAG = "NativeHelper";

    public static int copyNativeBinaries(Handle handle, File file, String string2) {
        long[] lArray = handle.apkHandles;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = NativeLibraryHelper.nativeCopyNativeBinaries(lArray[i], file.getPath(), string2);
            if (n2 == 1) continue;
            return n2;
        }
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int copyNativeBinariesForSupportedAbi(Handle handle, File file, String[] stringArray, boolean bl) throws IOException {
        NativeLibraryHelper.createNativeLibrarySubdir(file);
        int n = NativeLibraryHelper.findSupportedAbi(handle, stringArray);
        if (n >= 0) {
            int n2;
            File file2;
            String string2 = VMRuntime.getInstructionSet((String)stringArray[n]);
            if (bl) {
                File file3 = new File(file, string2);
                NativeLibraryHelper.createNativeLibrarySubdir(file3);
                file2 = file3;
            } else {
                file2 = file;
            }
            if ((n2 = NativeLibraryHelper.copyNativeBinaries(handle, file2, stringArray[n])) != 1) {
                return n2;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int copyNativeBinariesWithOverride(Handle handle, File file, String string2) {
        try {
            if (handle.multiArch) {
                int n;
                int n2;
                if (string2 != null && !CLEAR_ABI_OVERRIDE.equals(string2)) {
                    Slog.w(TAG, "Ignoring abiOverride for multi arch application.");
                }
                if (Build.SUPPORTED_32_BIT_ABIS.length > 0 && (n2 = NativeLibraryHelper.copyNativeBinariesForSupportedAbi(handle, file, Build.SUPPORTED_32_BIT_ABIS, true)) < 0 && n2 != -114 && n2 != -113) {
                    Slog.w(TAG, "Failure copying 32 bit native libraries; copyRet=" + n2);
                    return n2;
                }
                if (Build.SUPPORTED_64_BIT_ABIS.length <= 0 || (n = NativeLibraryHelper.copyNativeBinariesForSupportedAbi(handle, file, Build.SUPPORTED_64_BIT_ABIS, true)) >= 0 || n == -114 || n == -113) return 1;
                Slog.w(TAG, "Failure copying 64 bit native libraries; copyRet=" + n);
                return n;
            }
        }
        catch (IOException iOException) {
            Slog.e(TAG, "Copying native libraries failed", iOException);
            return -110;
        }
        {
            int n;
            String string3;
            if (CLEAR_ABI_OVERRIDE.equals(string2)) {
                string3 = null;
            } else {
                string3 = null;
                if (string2 != null) {
                    string3 = string2;
                }
            }
            String[] stringArray = string3 != null ? new String[]{string3} : Build.SUPPORTED_ABIS;
            if (Build.SUPPORTED_64_BIT_ABIS.length > 0 && string3 == null && NativeLibraryHelper.hasRenderscriptBitcode(handle)) {
                stringArray = Build.SUPPORTED_32_BIT_ABIS;
            }
            if ((n = NativeLibraryHelper.copyNativeBinariesForSupportedAbi(handle, file, stringArray, true)) >= 0 || n == -114) return 1;
            Slog.w(TAG, "Failure copying native libraries [errorCode=" + n + "]");
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void createNativeLibrarySubdir(File file) throws IOException {
        if (!file.isDirectory()) {
            file.delete();
            if (!file.mkdir()) {
                throw new IOException("Cannot create " + file.getPath());
            }
            try {
                Os.chmod(file.getPath(), OsConstants.S_IRWXU | OsConstants.S_IRGRP | OsConstants.S_IXGRP | OsConstants.S_IROTH | OsConstants.S_IXOTH);
                return;
            }
            catch (ErrnoException errnoException) {
                throw new IOException("Cannot chmod native library directory " + file.getPath(), errnoException);
            }
        } else {
            if (SELinux.restorecon(file)) return;
            throw new IOException("Cannot set SELinux context for " + file.getPath());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int findSupportedAbi(Handle handle, String[] stringArray) {
        int n = -114;
        long[] lArray = handle.apkHandles;
        int n2 = lArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = NativeLibraryHelper.nativeFindSupportedAbi(lArray[n3], stringArray, handle.pkgName);
            if (n4 != -114) {
                if (n4 == -113) {
                    if (n < 0) {
                        n = -113;
                    }
                } else {
                    if (n4 < 0) return n4;
                    if (n < 0 || n4 < n) {
                        n = n4;
                    }
                }
            }
            ++n3;
        }
        return n;
    }

    private static native int hasRenderscriptBitcode(long var0);

    public static boolean hasRenderscriptBitcode(Handle handle) throws IOException {
        long[] lArray = handle.apkHandles;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = NativeLibraryHelper.hasRenderscriptBitcode(lArray[i]);
            if (n2 < 0) {
                throw new IOException("Error scanning APK, code: " + n2);
            }
            if (n2 != 1) continue;
            return true;
        }
        return false;
    }

    private static native void nativeClose(long var0);

    private static native int nativeCopyNativeBinaries(long var0, String var2, String var3);

    private static native int nativeFindSupportedAbi(long var0, String[] var2, String var3);

    private static native long nativeOpenApk(String var0);

    private static native long nativeSumNativeBinaries(long var0, String var2);

    /*
     * Enabled aggressive block sorting
     */
    public static void removeNativeBinariesFromDirLI(File file, boolean bl) {
        if (file.exists()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    if (fileArray[i].isDirectory()) {
                        NativeLibraryHelper.removeNativeBinariesFromDirLI(fileArray[i], true);
                        continue;
                    }
                    if (fileArray[i].delete()) continue;
                    Slog.w(TAG, "Could not delete native binary: " + fileArray[i].getPath());
                }
            }
            if (bl && !file.delete()) {
                Slog.w(TAG, "Could not delete native binary directory: " + file.getPath());
            }
        }
    }

    public static void removeNativeBinariesLI(String string2) {
        if (string2 == null) {
            return;
        }
        NativeLibraryHelper.removeNativeBinariesFromDirLI(new File(string2), false);
    }

    private static long sumNativeBinaries(Handle handle, String string2) {
        long l = 0L;
        long[] lArray = handle.apkHandles;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            l += NativeLibraryHelper.nativeSumNativeBinaries(lArray[i], string2);
        }
        return l;
    }

    private static long sumNativeBinariesForSupportedAbi(Handle handle, String[] stringArray) {
        int n = NativeLibraryHelper.findSupportedAbi(handle, stringArray);
        if (n >= 0) {
            return NativeLibraryHelper.sumNativeBinaries(handle, stringArray[n]);
        }
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static long sumNativeBinariesWithOverride(Handle handle, String string2) throws IOException {
        String string3;
        long l = 0L;
        if (handle.multiArch) {
            if (string2 != null && !CLEAR_ABI_OVERRIDE.equals(string2)) {
                Slog.w(TAG, "Ignoring abiOverride for multi arch application.");
            }
            if (Build.SUPPORTED_32_BIT_ABIS.length > 0) {
                l += NativeLibraryHelper.sumNativeBinariesForSupportedAbi(handle, Build.SUPPORTED_32_BIT_ABIS);
            }
            if (Build.SUPPORTED_64_BIT_ABIS.length > 0) {
                l += NativeLibraryHelper.sumNativeBinariesForSupportedAbi(handle, Build.SUPPORTED_64_BIT_ABIS);
            }
            return l;
        }
        if (CLEAR_ABI_OVERRIDE.equals(string2)) {
            string3 = null;
        } else {
            string3 = null;
            if (string2 != null) {
                string3 = string2;
            }
        }
        String[] stringArray = string3 != null ? new String[]{string3} : Build.SUPPORTED_ABIS;
        if (Build.SUPPORTED_64_BIT_ABIS.length > 0 && string3 == null && NativeLibraryHelper.hasRenderscriptBitcode(handle)) {
            stringArray = Build.SUPPORTED_32_BIT_ABIS;
        }
        return l + NativeLibraryHelper.sumNativeBinariesForSupportedAbi(handle, stringArray);
    }

    public static class Handle
    implements Closeable {
        final long[] apkHandles;
        private volatile boolean mClosed;
        private final CloseGuard mGuard = CloseGuard.get();
        final boolean multiArch;
        final String pkgName;

        Handle(long[] lArray, boolean bl, String string2) {
            this.apkHandles = lArray;
            this.multiArch = bl;
            this.pkgName = string2;
            this.mGuard.open("close");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static Handle create(PackageParser.Package package_) throws IOException {
            boolean bl;
            List<String> list = package_.getAllCodePaths();
            if ((Integer.MIN_VALUE & package_.applicationInfo.flags) != 0) {
                bl = true;
                return Handle.create(list, bl, package_.packageName);
            }
            bl = false;
            return Handle.create(list, bl, package_.packageName);
        }

        public static Handle create(PackageParser.PackageLite packageLite) throws IOException {
            return Handle.create(packageLite.getAllCodePaths(), packageLite.multiArch, packageLite.packageName);
        }

        public static Handle create(File file) throws IOException {
            try {
                Handle handle = Handle.create(PackageParser.parsePackageLite(file, 0));
                return handle;
            }
            catch (PackageParser.PackageParserException packageParserException) {
                throw new IOException("Failed to parse package: " + file, packageParserException);
            }
        }

        private static Handle create(List<String> list, boolean bl, String string2) throws IOException {
            int n = list.size();
            long[] lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                String string3 = list.get(i);
                lArray[i] = NativeLibraryHelper.nativeOpenApk(string3);
                if (lArray[i] != 0L) continue;
                for (int j = 0; j < i; ++j) {
                    NativeLibraryHelper.nativeClose(lArray[j]);
                }
                throw new IOException("Unable to open APK: " + string3);
            }
            return new Handle(lArray, bl, string2);
        }

        @Override
        public void close() {
            long[] lArray = this.apkHandles;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                NativeLibraryHelper.nativeClose(lArray[i]);
            }
            this.mGuard.close();
            this.mClosed = true;
        }

        protected void finalize() throws Throwable {
            if (this.mGuard != null) {
                this.mGuard.warnIfOpen();
            }
            try {
                if (!this.mClosed) {
                    this.close();
                }
                return;
            }
            finally {
                super.finalize();
            }
        }
    }
}

