/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.database.ContentObserver;
import android.graphics.Point;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.Log;
import android.view.IWindowManager;
import android.view.WindowManagerGlobal;

public final class RotationPolicy {
    private static final int CURRENT_ROTATION = -1;
    private static final int NATURAL_ROTATION = 0;
    private static final String TAG = "RotationPolicy";

    private RotationPolicy() {
    }

    private static boolean areAllRotationsAllowed(Context context) {
        return context.getResources().getBoolean(17956902);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getRotationLockOrientation(Context context) {
        boolean bl = RotationPolicy.areAllRotationsAllowed(context);
        int n = 0;
        if (bl) return n;
        Point point = new Point();
        IWindowManager iWindowManager = WindowManagerGlobal.getWindowManagerService();
        try {
            iWindowManager.getInitialDisplaySize(0, point);
            int n2 = point.x;
            int n3 = point.y;
            if (n2 >= n3) return 2;
            return 1;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Unable to get the display size");
            return 0;
        }
    }

    public static boolean isRotationLockToggleVisible(Context context) {
        boolean bl = RotationPolicy.isRotationSupported(context);
        boolean bl2 = false;
        if (bl) {
            int n = Settings.System.getIntForUser(context.getContentResolver(), "hide_rotation_lock_toggle_for_accessibility", 0, -2);
            bl2 = false;
            if (n == 0) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public static boolean isRotationLocked(Context context) {
        int n = Settings.System.getIntForUser(context.getContentResolver(), "accelerometer_rotation", 0, -2);
        boolean bl = false;
        if (n == 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isRotationSupported(Context context) {
        PackageManager packageManager = context.getPackageManager();
        return packageManager.hasSystemFeature("android.hardware.sensor.accelerometer") && packageManager.hasSystemFeature("android.hardware.screen.portrait") && packageManager.hasSystemFeature("android.hardware.screen.landscape") && context.getResources().getBoolean(17956901);
    }

    public static void registerRotationPolicyListener(Context context, RotationPolicyListener rotationPolicyListener) {
        RotationPolicy.registerRotationPolicyListener(context, rotationPolicyListener, UserHandle.getCallingUserId());
    }

    public static void registerRotationPolicyListener(Context context, RotationPolicyListener rotationPolicyListener, int n) {
        context.getContentResolver().registerContentObserver(Settings.System.getUriFor("accelerometer_rotation"), false, rotationPolicyListener.mObserver, n);
        context.getContentResolver().registerContentObserver(Settings.System.getUriFor("hide_rotation_lock_toggle_for_accessibility"), false, rotationPolicyListener.mObserver, n);
    }

    public static void setRotationLock(Context context, boolean bl) {
        Settings.System.putIntForUser(context.getContentResolver(), "hide_rotation_lock_toggle_for_accessibility", 0, -2);
        boolean bl2 = RotationPolicy.areAllRotationsAllowed(context);
        int n = 0;
        if (bl2) {
            n = -1;
        }
        RotationPolicy.setRotationLock(bl, n);
    }

    private static void setRotationLock(final boolean bl, final int n) {
        AsyncTask.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    IWindowManager iWindowManager = WindowManagerGlobal.getWindowManagerService();
                    if (bl) {
                        iWindowManager.freezeRotation(n);
                        return;
                    }
                    iWindowManager.thawRotation();
                    return;
                }
                catch (RemoteException remoteException) {
                    Log.w(RotationPolicy.TAG, "Unable to save auto-rotate setting");
                    return;
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void setRotationLockForAccessibility(Context context, boolean bl) {
        ContentResolver contentResolver = context.getContentResolver();
        int n = bl ? 1 : 0;
        Settings.System.putIntForUser(contentResolver, "hide_rotation_lock_toggle_for_accessibility", n, -2);
        RotationPolicy.setRotationLock(bl, 0);
    }

    public static void unregisterRotationPolicyListener(Context context, RotationPolicyListener rotationPolicyListener) {
        context.getContentResolver().unregisterContentObserver(rotationPolicyListener.mObserver);
    }

    public static abstract class RotationPolicyListener {
        final ContentObserver mObserver = new ContentObserver(new Handler()){

            @Override
            public void onChange(boolean bl, Uri uri) {
                RotationPolicyListener.this.onChange();
            }
        };

        public abstract void onChange();
    }
}

