/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.os.Bundle;
import android.text.Editable;
import android.text.Spanned;
import android.text.method.KeyListener;
import android.text.style.SuggestionSpan;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.widget.TextView;

public class EditableInputConnection
extends BaseInputConnection {
    private static final boolean DEBUG = false;
    private static final String TAG = "EditableInputConnection";
    private int mBatchEditNesting;
    private final TextView mTextView;

    public EditableInputConnection(TextView textView) {
        super(textView, true);
        this.mTextView = textView;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean beginBatchEdit() {
        synchronized (this) {
            if (this.mBatchEditNesting >= 0) {
                this.mTextView.beginBatchEdit();
                this.mBatchEditNesting = 1 + this.mBatchEditNesting;
                return true;
            }
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean clearMetaKeyStates(int n) {
        Editable editable = this.getEditable();
        if (editable == null) {
            return false;
        }
        KeyListener keyListener = this.mTextView.getKeyListener();
        if (keyListener == null) return true;
        try {
            keyListener.clearMetaKeyState(this.mTextView, editable, n);
            return true;
        }
        catch (AbstractMethodError abstractMethodError) {
            return true;
        }
    }

    @Override
    public boolean commitCompletion(CompletionInfo completionInfo) {
        this.mTextView.beginBatchEdit();
        this.mTextView.onCommitCompletion(completionInfo);
        this.mTextView.endBatchEdit();
        return true;
    }

    @Override
    public boolean commitCorrection(CorrectionInfo correctionInfo) {
        this.mTextView.beginBatchEdit();
        this.mTextView.onCommitCorrection(correctionInfo);
        this.mTextView.endBatchEdit();
        return true;
    }

    @Override
    public boolean commitText(CharSequence charSequence, int n) {
        if (this.mTextView == null) {
            return super.commitText(charSequence, n);
        }
        if (charSequence instanceof Spanned) {
            SuggestionSpan[] suggestionSpanArray = ((Spanned)charSequence).getSpans(0, charSequence.length(), SuggestionSpan.class);
            this.mIMM.registerSuggestionSpansForNotification(suggestionSpanArray);
        }
        this.mTextView.resetErrorChangedFlag();
        boolean bl = super.commitText(charSequence, n);
        this.mTextView.hideErrorIfUnchanged();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean endBatchEdit() {
        synchronized (this) {
            if (this.mBatchEditNesting > 0) {
                this.mTextView.endBatchEdit();
                this.mBatchEditNesting = -1 + this.mBatchEditNesting;
                return true;
            }
            return false;
        }
    }

    @Override
    public Editable getEditable() {
        TextView textView = this.mTextView;
        if (textView != null) {
            return textView.getEditableText();
        }
        return null;
    }

    @Override
    public ExtractedText getExtractedText(ExtractedTextRequest extractedTextRequest, int n) {
        ExtractedText extractedText;
        if (this.mTextView != null && this.mTextView.extractText(extractedTextRequest, extractedText = new ExtractedText())) {
            if ((n & 1) != 0) {
                this.mTextView.setExtracting(extractedTextRequest);
            }
            return extractedText;
        }
        return null;
    }

    @Override
    public boolean performContextMenuAction(int n) {
        this.mTextView.beginBatchEdit();
        this.mTextView.onTextContextMenuItem(n);
        this.mTextView.endBatchEdit();
        return true;
    }

    @Override
    public boolean performEditorAction(int n) {
        this.mTextView.onEditorAction(n);
        return true;
    }

    @Override
    public boolean performPrivateCommand(String string2, Bundle bundle) {
        this.mTextView.onPrivateIMECommand(string2, bundle);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void reportFinish() {
        super.reportFinish();
        synchronized (this) {
            while (true) {
                if (this.mBatchEditNesting <= 0) {
                    this.mBatchEditNesting = -1;
                    return;
                }
                this.endBatchEdit();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean requestCursorUpdates(int n) {
        if ((n & 0xFFFFFFFC) != 0) {
            return false;
        }
        if (this.mIMM == null) return false;
        this.mIMM.setUpdateCursorAnchorInfoMode(n);
        if ((n & 1) == 0) return true;
        if (this.mTextView == null) {
            return true;
        }
        if (this.mTextView.isInLayout()) return true;
        this.mTextView.requestLayout();
        return true;
    }
}

