/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.multiwaveview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.media.AudioAttributes;
import android.os.Bundle;
import android.os.Vibrator;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityManager;
import com.android.internal.R;
import com.android.internal.widget.multiwaveview.Ease;
import com.android.internal.widget.multiwaveview.PointCloud;
import com.android.internal.widget.multiwaveview.TargetDrawable;
import com.android.internal.widget.multiwaveview.Tweener;
import java.util.ArrayList;

public class GlowPadView
extends View {
    private static final boolean DEBUG = false;
    private static final int HIDE_ANIMATION_DELAY = 200;
    private static final int HIDE_ANIMATION_DURATION = 200;
    private static final int INITIAL_SHOW_HANDLE_DURATION = 200;
    private static final int RETURN_TO_HOME_DELAY = 1200;
    private static final int RETURN_TO_HOME_DURATION = 200;
    private static final int REVEAL_GLOW_DELAY = 0;
    private static final int REVEAL_GLOW_DURATION = 0;
    private static final float RING_SCALE_COLLAPSED = 0.5f;
    private static final float RING_SCALE_EXPANDED = 1.0f;
    private static final int SHOW_ANIMATION_DELAY = 50;
    private static final int SHOW_ANIMATION_DURATION = 200;
    private static final float SNAP_MARGIN_DEFAULT = 20.0f;
    private static final int STATE_FINISH = 5;
    private static final int STATE_FIRST_TOUCH = 2;
    private static final int STATE_IDLE = 0;
    private static final int STATE_SNAP = 4;
    private static final int STATE_START = 1;
    private static final int STATE_TRACKING = 3;
    private static final String TAG = "GlowPadView";
    private static final float TAP_RADIUS_SCALE_ACCESSIBILITY_ENABLED = 1.3f;
    private static final float TARGET_SCALE_COLLAPSED = 0.8f;
    private static final float TARGET_SCALE_EXPANDED = 1.0f;
    private static final AudioAttributes VIBRATION_ATTRIBUTES = new AudioAttributes.Builder().setContentType(4).setUsage(13).build();
    private static final int WAVE_ANIMATION_DURATION = 1000;
    private int mActiveTarget = -1;
    private boolean mAllowScaling;
    private boolean mAlwaysTrackFinger;
    private boolean mAnimatingTargets;
    private Tweener mBackgroundAnimator;
    private ArrayList<String> mDirectionDescriptions;
    private int mDirectionDescriptionsResourceId;
    private boolean mDragging;
    private int mFeedbackCount = 3;
    private float mFirstItemOffset = 0.0f;
    private AnimationBundle mGlowAnimations;
    private float mGlowRadius;
    private int mGrabbedState;
    private int mGravity = 48;
    private TargetDrawable mHandleDrawable;
    private int mHorizontalInset;
    private boolean mInitialLayout = true;
    private float mInnerRadius;
    private boolean mMagneticTargets = false;
    private int mMaxTargetHeight;
    private int mMaxTargetWidth;
    private int mNewTargetResources;
    private OnTriggerListener mOnTriggerListener;
    private float mOuterRadius = 0.0f;
    private TargetDrawable mOuterRing;
    private PointCloud mPointCloud;
    private int mPointerId;
    private Animator.AnimatorListener mResetListener;
    private Animator.AnimatorListener mResetListenerWithPing;
    private float mRingScaleFactor = 1.0f;
    private float mSnapMargin = 0.0f;
    private AnimationBundle mTargetAnimations;
    private ArrayList<String> mTargetDescriptions;
    private int mTargetDescriptionsResourceId;
    private ArrayList<TargetDrawable> mTargetDrawables = new ArrayList();
    private int mTargetResourceId;
    private Animator.AnimatorListener mTargetUpdateListener;
    private ValueAnimator.AnimatorUpdateListener mUpdateListener;
    private int mVerticalInset;
    private int mVibrationDuration = 0;
    private Vibrator mVibrator;
    private AnimationBundle mWaveAnimations = new AnimationBundle();
    private float mWaveCenterX;
    private float mWaveCenterY;

    public GlowPadView(Context context) {
        this(context, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public GlowPadView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mTargetAnimations = new AnimationBundle();
        this.mGlowAnimations = new AnimationBundle();
        this.mResetListener = new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animator2) {
                GlowPadView.this.switchToState(0, GlowPadView.this.mWaveCenterX, GlowPadView.this.mWaveCenterY);
                GlowPadView.this.dispatchOnFinishFinalAnimation();
            }
        };
        this.mResetListenerWithPing = new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animator2) {
                GlowPadView.this.ping();
                GlowPadView.this.switchToState(0, GlowPadView.this.mWaveCenterX, GlowPadView.this.mWaveCenterY);
                GlowPadView.this.dispatchOnFinishFinalAnimation();
            }
        };
        this.mUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

            @Override
            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                GlowPadView.this.invalidate();
            }
        };
        this.mTargetUpdateListener = new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animator2) {
                if (GlowPadView.this.mNewTargetResources != 0) {
                    GlowPadView.this.internalSetTargetResources(GlowPadView.this.mNewTargetResources);
                    GlowPadView.access$502(GlowPadView.this, 0);
                    GlowPadView.this.hideTargets(false, false);
                }
                GlowPadView.access$802(GlowPadView.this, false);
            }
        };
        Resources resources = context.getResources();
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.GlowPadView);
        this.mInnerRadius = typedArray.getDimension(1, this.mInnerRadius);
        this.mOuterRadius = typedArray.getDimension(8, this.mOuterRadius);
        this.mSnapMargin = typedArray.getDimension(11, this.mSnapMargin);
        this.mFirstItemOffset = (float)Math.toRadians(typedArray.getFloat(14, (float)Math.toDegrees(this.mFirstItemOffset)));
        this.mVibrationDuration = typedArray.getInt(10, this.mVibrationDuration);
        this.mFeedbackCount = typedArray.getInt(12, this.mFeedbackCount);
        this.mAllowScaling = typedArray.getBoolean(16, false);
        TypedValue typedValue = typedArray.peekValue(5);
        int n = typedValue != null ? typedValue.resourceId : 0;
        this.mHandleDrawable = new TargetDrawable(resources, n);
        this.mHandleDrawable.setState(TargetDrawable.STATE_INACTIVE);
        this.mOuterRing = new TargetDrawable(resources, this.getResourceId(typedArray, 6));
        this.mAlwaysTrackFinger = typedArray.getBoolean(13, false);
        this.mMagneticTargets = typedArray.getBoolean(15, this.mMagneticTargets);
        int n2 = this.getResourceId(typedArray, 7);
        Drawable drawable2 = n2 != 0 ? context.getDrawable(n2) : null;
        this.mGlowRadius = typedArray.getDimension(9, 0.0f);
        this.mPointCloud = new PointCloud(drawable2);
        this.mPointCloud.makePointCloud(this.mInnerRadius, this.mOuterRadius);
        this.mPointCloud.glowManager.setRadius(this.mGlowRadius);
        TypedValue typedValue2 = new TypedValue();
        if (typedArray.getValue(4, typedValue2)) {
            this.internalSetTargetResources(typedValue2.resourceId);
        }
        if (this.mTargetDrawables == null || this.mTargetDrawables.size() == 0) {
            throw new IllegalStateException("Must specify at least one target drawable");
        }
        if (typedArray.getValue(2, typedValue2)) {
            int n3 = typedValue2.resourceId;
            if (n3 == 0) {
                throw new IllegalStateException("Must specify target descriptions");
            }
            this.setTargetDescriptionsResourceId(n3);
        }
        if (typedArray.getValue(3, typedValue2)) {
            int n4 = typedValue2.resourceId;
            if (n4 == 0) {
                throw new IllegalStateException("Must specify direction descriptions");
            }
            this.setDirectionDescriptionsResourceId(n4);
        }
        this.mGravity = typedArray.getInt(0, 48);
        typedArray.recycle();
        boolean bl = this.mVibrationDuration > 0;
        this.setVibrateEnabled(bl);
        this.assignDefaultsIfNeeded();
    }

    static /* synthetic */ int access$502(GlowPadView glowPadView, int n) {
        glowPadView.mNewTargetResources = n;
        return n;
    }

    static /* synthetic */ boolean access$802(GlowPadView glowPadView, boolean bl) {
        glowPadView.mAnimatingTargets = bl;
        return bl;
    }

    private void announceTargets() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.mTargetDrawables.size();
        for (int i = 0; i < n; ++i) {
            String string2 = this.getTargetDescription(i);
            String string3 = this.getDirectionDescription(i);
            if (TextUtils.isEmpty(string2) || TextUtils.isEmpty(string3)) continue;
            stringBuilder.append(String.format(string3, string2));
        }
        if (stringBuilder.length() > 0) {
            this.announceForAccessibility(stringBuilder.toString());
        }
    }

    private void assignDefaultsIfNeeded() {
        if (this.mOuterRadius == 0.0f) {
            this.mOuterRadius = (float)Math.max(this.mOuterRing.getWidth(), this.mOuterRing.getHeight()) / 2.0f;
        }
        if (this.mSnapMargin == 0.0f) {
            this.mSnapMargin = TypedValue.applyDimension(1, 20.0f, this.getContext().getResources().getDisplayMetrics());
        }
        if (this.mInnerRadius == 0.0f) {
            this.mInnerRadius = (float)this.mHandleDrawable.getWidth() / 10.0f;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void computeInsets(int n, int n2) {
        int n3 = this.getLayoutDirection();
        int n4 = Gravity.getAbsoluteGravity(this.mGravity, n3);
        switch (n4 & 7) {
            default: {
                this.mHorizontalInset = n / 2;
                break;
            }
            case 3: {
                this.mHorizontalInset = 0;
                break;
            }
            case 5: {
                this.mHorizontalInset = n;
            }
        }
        switch (n4 & 0x70) {
            default: {
                this.mVerticalInset = n2 / 2;
                return;
            }
            case 48: {
                this.mVerticalInset = 0;
                return;
            }
            case 80: 
        }
        this.mVerticalInset = n2;
    }

    private float computeScaleFactor(int n, int n2, int n3, int n4) {
        if (!this.mAllowScaling) {
            return 1.0f;
        }
        int n5 = this.getLayoutDirection();
        int n6 = Gravity.getAbsoluteGravity(this.mGravity, n5);
        float f = 1.0f;
        float f2 = 1.0f;
        switch (n6 & 7) {
            default: {
                if (n <= n3) break;
                f = (1.0f * (float)n3 - (float)this.mMaxTargetWidth) / (float)(n - this.mMaxTargetWidth);
            }
            case 3: 
            case 5: 
        }
        switch (n6 & 0x70) {
            default: {
                if (n2 <= n4) break;
                f2 = (1.0f * (float)n4 - (float)this.mMaxTargetHeight) / (float)(n2 - this.mMaxTargetHeight);
            }
            case 48: 
            case 80: 
        }
        return Math.min(f, f2);
    }

    private void deactivateTargets() {
        int n = this.mTargetDrawables.size();
        for (int i = 0; i < n; ++i) {
            this.mTargetDrawables.get(i).setState(TargetDrawable.STATE_INACTIVE);
        }
        this.mActiveTarget = -1;
    }

    private void dispatchOnFinishFinalAnimation() {
        if (this.mOnTriggerListener != null) {
            this.mOnTriggerListener.onFinishFinalAnimation();
        }
    }

    private void dispatchTriggerEvent(int n) {
        this.vibrate();
        if (this.mOnTriggerListener != null) {
            this.mOnTriggerListener.onTrigger(this, n);
        }
    }

    private float dist2(float f, float f2) {
        return f * f + f2 * f2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doFinish() {
        int n = this.mActiveTarget;
        boolean bl = n != -1;
        if (bl) {
            this.highlightSelected(n);
            this.hideGlow(200, 1200, 0.0f, this.mResetListener);
            this.dispatchTriggerEvent(n);
            if (!this.mAlwaysTrackFinger) {
                this.mTargetAnimations.stop();
            }
        } else {
            this.hideGlow(200, 0, 0.0f, this.mResetListenerWithPing);
            this.hideTargets(true, false);
        }
        this.setGrabbedState(0);
    }

    private void dump() {
        Log.v(TAG, "Outer Radius = " + this.mOuterRadius);
        Log.v(TAG, "SnapMargin = " + this.mSnapMargin);
        Log.v(TAG, "FeedbackCount = " + this.mFeedbackCount);
        Log.v(TAG, "VibrationDuration = " + this.mVibrationDuration);
        Log.v(TAG, "GlowRadius = " + this.mGlowRadius);
        Log.v(TAG, "WaveCenterX = " + this.mWaveCenterX);
        Log.v(TAG, "WaveCenterY = " + this.mWaveCenterY);
    }

    private float getAngle(float f, int n) {
        return this.mFirstItemOffset + f * (float)n;
    }

    private String getDirectionDescription(int n) {
        if (this.mDirectionDescriptions == null || this.mDirectionDescriptions.isEmpty()) {
            this.mDirectionDescriptions = this.loadDescriptions(this.mDirectionDescriptionsResourceId);
            if (this.mTargetDrawables.size() != this.mDirectionDescriptions.size()) {
                Log.w(TAG, "The number of target drawables must be equal to the number of direction descriptions.");
                return null;
            }
        }
        return this.mDirectionDescriptions.get(n);
    }

    private int getResourceId(TypedArray typedArray, int n) {
        TypedValue typedValue = typedArray.peekValue(n);
        if (typedValue == null) {
            return 0;
        }
        return typedValue.resourceId;
    }

    private float getRingHeight() {
        return this.mRingScaleFactor * Math.max((float)this.mOuterRing.getHeight(), 2.0f * this.mOuterRadius);
    }

    private float getRingWidth() {
        return this.mRingScaleFactor * Math.max((float)this.mOuterRing.getWidth(), 2.0f * this.mOuterRadius);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private float getScaledGlowRadiusSquared() {
        float f;
        if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            f = 1.3f * this.mGlowRadius;
            return this.square(f);
        }
        f = this.mGlowRadius;
        return this.square(f);
    }

    private float getSliceAngle() {
        return (float)(Math.PI * -2 / (double)this.mTargetDrawables.size());
    }

    private String getTargetDescription(int n) {
        if (this.mTargetDescriptions == null || this.mTargetDescriptions.isEmpty()) {
            this.mTargetDescriptions = this.loadDescriptions(this.mTargetDescriptionsResourceId);
            if (this.mTargetDrawables.size() != this.mTargetDescriptions.size()) {
                Log.w(TAG, "The number of target drawables must be equal to the number of target descriptions.");
                return null;
            }
        }
        return this.mTargetDescriptions.get(n);
    }

    private void handleCancel(MotionEvent motionEvent) {
        this.mActiveTarget = -1;
        int n = motionEvent.findPointerIndex(this.mPointerId);
        if (n == -1) {
            n = 0;
        }
        this.switchToState(5, motionEvent.getX(n), motionEvent.getY(n));
    }

    private void handleDown(MotionEvent motionEvent) {
        int n = motionEvent.getActionIndex();
        float f = motionEvent.getX(n);
        float f2 = motionEvent.getY(n);
        this.switchToState(1, f, f2);
        if (!this.trySwitchToFirstTouchState(f, f2)) {
            this.mDragging = false;
            return;
        }
        this.mPointerId = motionEvent.getPointerId(n);
        this.updateGlowPosition(f, f2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleMove(MotionEvent motionEvent) {
        block13: {
            int n = -1;
            int n2 = motionEvent.getHistorySize();
            ArrayList<TargetDrawable> arrayList = this.mTargetDrawables;
            int n3 = arrayList.size();
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            int n4 = motionEvent.findPointerIndex(this.mPointerId);
            if (n4 == -1) break block13;
            int n5 = 0;
            while (true) {
                float f4;
                float f5;
                block15: {
                    float f6;
                    double d;
                    float f7;
                    float f8;
                    block16: {
                        block14: {
                            if (n5 >= n2 + 1) break block14;
                            float f9 = n5 < n2 ? motionEvent.getHistoricalX(n4, n5) : motionEvent.getX(n4);
                            float f10 = n5 < n2 ? motionEvent.getHistoricalY(n4, n5) : motionEvent.getY(n4);
                            f8 = f9 - this.mWaveCenterX;
                            f7 = f10 - this.mWaveCenterY;
                            float f11 = (float)Math.sqrt(this.dist2(f8, f7));
                            float f12 = f11 > this.mOuterRadius ? this.mOuterRadius / f11 : 1.0f;
                            f5 = f8 * f12;
                            f4 = f7 * f12;
                            d = Math.atan2(-f7, f8);
                            if (!this.mDragging) {
                                this.trySwitchToFirstTouchState(f9, f10);
                            }
                            if (!this.mDragging) break block15;
                            float f13 = this.mRingScaleFactor * this.mOuterRadius - this.mSnapMargin;
                            f6 = f13 * f13;
                            break block16;
                        }
                        if (!this.mDragging) break;
                        if (n != -1) {
                            this.switchToState(4, f, f2);
                            this.updateGlowPosition(f, f2);
                        } else {
                            this.switchToState(3, f, f2);
                            this.updateGlowPosition(f, f2);
                        }
                        if (this.mActiveTarget != n) {
                            if (this.mActiveTarget != -1) {
                                TargetDrawable targetDrawable = arrayList.get(this.mActiveTarget);
                                if (targetDrawable.hasState(TargetDrawable.STATE_FOCUSED)) {
                                    targetDrawable.setState(TargetDrawable.STATE_INACTIVE);
                                }
                                if (this.mMagneticTargets) {
                                    this.updateTargetPosition(this.mActiveTarget, this.mWaveCenterX, this.mWaveCenterY);
                                }
                            }
                            if (n != -1) {
                                TargetDrawable targetDrawable = arrayList.get(n);
                                if (targetDrawable.hasState(TargetDrawable.STATE_FOCUSED)) {
                                    targetDrawable.setState(TargetDrawable.STATE_FOCUSED);
                                }
                                if (this.mMagneticTargets) {
                                    this.updateTargetPosition(n, this.mWaveCenterX, this.mWaveCenterY, f3);
                                }
                                if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
                                    this.announceForAccessibility(this.getTargetDescription(n));
                                }
                            }
                        }
                        this.mActiveTarget = n;
                        return;
                    }
                    for (int i = 0; i < n3; ++i) {
                        boolean bl;
                        TargetDrawable targetDrawable = arrayList.get(i);
                        double d2 = (double)this.mFirstItemOffset + Math.PI * (2.0 * ((double)i - 0.5)) / (double)n3;
                        double d3 = (double)this.mFirstItemOffset + Math.PI * (2.0 * (0.5 + (double)i)) / (double)n3;
                        if (!targetDrawable.isEnabled() || !(bl = d > d2 && d <= d3 || Math.PI * 2 + d > d2 && Math.PI * 2 + d <= d3 || d - Math.PI * 2 > d2 && d - Math.PI * 2 <= d3) || !(this.dist2(f8, f7) > f6)) continue;
                        n = i;
                        f3 = (float)(-d);
                    }
                }
                f = f5;
                f2 = f4;
                ++n5;
            }
        }
    }

    private void handleUp(MotionEvent motionEvent) {
        int n = motionEvent.getActionIndex();
        if (motionEvent.getPointerId(n) == this.mPointerId) {
            this.switchToState(5, motionEvent.getX(n), motionEvent.getY(n));
        }
    }

    private void hideGlow(int n, int n2, float f, Animator.AnimatorListener animatorListener) {
        this.mGlowAnimations.cancel();
        AnimationBundle animationBundle = this.mGlowAnimations;
        PointCloud.GlowManager glowManager = this.mPointCloud.glowManager;
        long l = n;
        Object[] objectArray = new Object[]{"ease", Ease.Quart.easeOut, "delay", n2, "alpha", Float.valueOf(f), "x", Float.valueOf(0.0f), "y", Float.valueOf(0.0f), "onUpdate", this.mUpdateListener, "onComplete", animatorListener};
        animationBundle.add(Tweener.to(glowManager, l, objectArray));
        this.mGlowAnimations.start();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void hideTargets(boolean bl, boolean bl2) {
        this.mTargetAnimations.cancel();
        this.mAnimatingTargets = bl;
        int n = bl ? 200 : 0;
        int n2 = bl ? 200 : 0;
        float f = bl2 ? 1.0f : 0.8f;
        int n3 = this.mTargetDrawables.size();
        TimeInterpolator timeInterpolator = Ease.Cubic.easeOut;
        for (int i = 0; i < n3; ++i) {
            TargetDrawable targetDrawable = this.mTargetDrawables.get(i);
            targetDrawable.setState(TargetDrawable.STATE_INACTIVE);
            AnimationBundle animationBundle = this.mTargetAnimations;
            long l = n;
            Object[] objectArray = new Object[]{"ease", timeInterpolator, "alpha", Float.valueOf(0.0f), "scaleX", Float.valueOf(f), "scaleY", Float.valueOf(f), "delay", n2, "onUpdate", this.mUpdateListener};
            animationBundle.add(Tweener.to(targetDrawable, l, objectArray));
        }
        float f2 = bl2 ? 1.0f : 0.5f;
        float f3 = f2 * this.mRingScaleFactor;
        AnimationBundle animationBundle = this.mTargetAnimations;
        TargetDrawable targetDrawable = this.mOuterRing;
        long l = n;
        Object[] objectArray = new Object[]{"ease", timeInterpolator, "alpha", Float.valueOf(0.0f), "scaleX", Float.valueOf(f3), "scaleY", Float.valueOf(f3), "delay", n2, "onUpdate", this.mUpdateListener, "onComplete", this.mTargetUpdateListener};
        animationBundle.add(Tweener.to(targetDrawable, l, objectArray));
        this.mTargetAnimations.start();
    }

    private void hideUnselected(int n) {
        for (int i = 0; i < this.mTargetDrawables.size(); ++i) {
            if (i == n) continue;
            this.mTargetDrawables.get(i).setAlpha(0.0f);
        }
    }

    private void highlightSelected(int n) {
        this.mTargetDrawables.get(n).setState(TargetDrawable.STATE_ACTIVE);
        this.hideUnselected(n);
    }

    private void internalSetTargetResources(int n) {
        ArrayList<TargetDrawable> arrayList = this.loadDrawableArray(n);
        this.mTargetDrawables = arrayList;
        this.mTargetResourceId = n;
        int n2 = this.mHandleDrawable.getWidth();
        int n3 = this.mHandleDrawable.getHeight();
        int n4 = arrayList.size();
        for (int i = 0; i < n4; ++i) {
            TargetDrawable targetDrawable = arrayList.get(i);
            n2 = Math.max(n2, targetDrawable.getWidth());
            n3 = Math.max(n3, targetDrawable.getHeight());
        }
        if (this.mMaxTargetWidth != n2 || this.mMaxTargetHeight != n3) {
            this.mMaxTargetWidth = n2;
            this.mMaxTargetHeight = n3;
            this.requestLayout();
            return;
        }
        this.updateTargetPositions(this.mWaveCenterX, this.mWaveCenterY);
        this.updatePointCloudPosition(this.mWaveCenterX, this.mWaveCenterY);
    }

    private ArrayList<String> loadDescriptions(int n) {
        TypedArray typedArray = this.getContext().getResources().obtainTypedArray(n);
        int n2 = typedArray.length();
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (int i = 0; i < n2; ++i) {
            arrayList.add(typedArray.getString(i));
        }
        typedArray.recycle();
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ArrayList<TargetDrawable> loadDrawableArray(int n) {
        Resources resources = this.getContext().getResources();
        TypedArray typedArray = resources.obtainTypedArray(n);
        int n2 = typedArray.length();
        ArrayList<TargetDrawable> arrayList = new ArrayList<TargetDrawable>(n2);
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                typedArray.recycle();
                return arrayList;
            }
            TypedValue typedValue = typedArray.peekValue(n3);
            int n4 = typedValue != null ? typedValue.resourceId : 0;
            arrayList.add(new TargetDrawable(resources, n4));
            ++n3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean replaceTargetDrawables(Resources resources, int n, int n2) {
        if (n == 0) return false;
        if (n2 == 0) {
            return false;
        }
        boolean bl = false;
        ArrayList<TargetDrawable> arrayList = this.mTargetDrawables;
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            TargetDrawable targetDrawable = arrayList.get(i);
            if (targetDrawable == null || targetDrawable.getResourceId() != n) continue;
            targetDrawable.setDrawable(resources, n2);
            bl = true;
        }
        if (!bl) return bl;
        this.requestLayout();
        return bl;
    }

    private int resolveMeasured(int n, int n2) {
        int n3 = View.MeasureSpec.getSize(n);
        switch (View.MeasureSpec.getMode(n)) {
            default: {
                return n3;
            }
            case 0: {
                return n2;
            }
            case -2147483648: 
        }
        return Math.min(n3, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setGrabbedState(int n) {
        if (n != this.mGrabbedState) {
            if (n != 0) {
                this.vibrate();
            }
            this.mGrabbedState = n;
            if (this.mOnTriggerListener != null) {
                if (n == 0) {
                    this.mOnTriggerListener.onReleased(this, 1);
                } else {
                    this.mOnTriggerListener.onGrabbed(this, 1);
                }
                this.mOnTriggerListener.onGrabbedStateChange(this, n);
            }
        }
    }

    private void showGlow(int n, int n2, float f, Animator.AnimatorListener animatorListener) {
        this.mGlowAnimations.cancel();
        AnimationBundle animationBundle = this.mGlowAnimations;
        PointCloud.GlowManager glowManager = this.mPointCloud.glowManager;
        long l = n;
        Object[] objectArray = new Object[]{"ease", Ease.Cubic.easeIn, "delay", n2, "alpha", Float.valueOf(f), "onUpdate", this.mUpdateListener, "onComplete", animatorListener};
        animationBundle.add(Tweener.to(glowManager, l, objectArray));
        this.mGlowAnimations.start();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void showTargets(boolean bl) {
        this.mTargetAnimations.stop();
        this.mAnimatingTargets = bl;
        int n = bl ? 50 : 0;
        int n2 = bl ? 200 : 0;
        int n3 = this.mTargetDrawables.size();
        int n4 = 0;
        while (true) {
            if (n4 >= n3) {
                float f = 1.0f * this.mRingScaleFactor;
                AnimationBundle animationBundle = this.mTargetAnimations;
                TargetDrawable targetDrawable = this.mOuterRing;
                long l = n2;
                Object[] objectArray = new Object[]{"ease", Ease.Cubic.easeOut, "alpha", Float.valueOf(1.0f), "scaleX", Float.valueOf(f), "scaleY", Float.valueOf(f), "delay", n, "onUpdate", this.mUpdateListener, "onComplete", this.mTargetUpdateListener};
                animationBundle.add(Tweener.to(targetDrawable, l, objectArray));
                this.mTargetAnimations.start();
                return;
            }
            TargetDrawable targetDrawable = this.mTargetDrawables.get(n4);
            targetDrawable.setState(TargetDrawable.STATE_INACTIVE);
            AnimationBundle animationBundle = this.mTargetAnimations;
            long l = n2;
            Object[] objectArray = new Object[]{"ease", Ease.Cubic.easeOut, "alpha", Float.valueOf(1.0f), "scaleX", Float.valueOf(1.0f), "scaleY", Float.valueOf(1.0f), "delay", n, "onUpdate", this.mUpdateListener};
            animationBundle.add(Tweener.to(targetDrawable, l, objectArray));
            ++n4;
        }
    }

    private float square(float f) {
        return f * f;
    }

    private void startBackgroundAnimation(int n, float f) {
        Drawable drawable2 = this.getBackground();
        if (this.mAlwaysTrackFinger && drawable2 != null) {
            if (this.mBackgroundAnimator != null) {
                this.mBackgroundAnimator.animator.cancel();
            }
            long l = n;
            Object[] objectArray = new Object[]{"ease", Ease.Cubic.easeIn, "alpha", (int)(255.0f * f), "delay", 50};
            this.mBackgroundAnimator = Tweener.to(drawable2, l, objectArray);
            this.mBackgroundAnimator.animator.start();
        }
    }

    private void startWaveAnimation() {
        this.mWaveAnimations.cancel();
        this.mPointCloud.waveManager.setAlpha(1.0f);
        this.mPointCloud.waveManager.setRadius((float)this.mHandleDrawable.getWidth() / 2.0f);
        AnimationBundle animationBundle = this.mWaveAnimations;
        PointCloud.WaveManager waveManager = this.mPointCloud.waveManager;
        Object[] objectArray = new Object[]{"ease", Ease.Quad.easeOut, "delay", 0, "radius", Float.valueOf(2.0f * this.mOuterRadius), "onUpdate", this.mUpdateListener, "onComplete", new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animator2) {
                ((GlowPadView)GlowPadView.this).mPointCloud.waveManager.setRadius(0.0f);
                ((GlowPadView)GlowPadView.this).mPointCloud.waveManager.setAlpha(0.0f);
            }
        }};
        animationBundle.add(Tweener.to(waveManager, 1000L, objectArray));
        this.mWaveAnimations.start();
    }

    private void stopAndHideWaveAnimation() {
        this.mWaveAnimations.cancel();
        this.mPointCloud.waveManager.setAlpha(0.0f);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void switchToState(int n, float f, float f2) {
        switch (n) {
            case 0: {
                this.deactivateTargets();
                this.hideGlow(0, 0, 0.0f, null);
                this.startBackgroundAnimation(0, 0.0f);
                this.mHandleDrawable.setState(TargetDrawable.STATE_INACTIVE);
                this.mHandleDrawable.setAlpha(1.0f);
                return;
            }
            case 1: {
                this.startBackgroundAnimation(0, 0.0f);
                return;
            }
            case 2: {
                this.mHandleDrawable.setAlpha(0.0f);
                this.deactivateTargets();
                this.showTargets(true);
                this.startBackgroundAnimation(200, 1.0f);
                this.setGrabbedState(1);
                if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
                    this.announceTargets();
                    return;
                }
            }
            default: {
                return;
            }
            case 3: {
                this.mHandleDrawable.setAlpha(0.0f);
                this.showGlow(0, 0, 1.0f, null);
                return;
            }
            case 4: {
                this.mHandleDrawable.setAlpha(0.0f);
                this.showGlow(0, 0, 0.0f, null);
                return;
            }
            case 5: 
        }
        this.doFinish();
    }

    private boolean trySwitchToFirstTouchState(float f, float f2) {
        float f3 = f - this.mWaveCenterX;
        float f4 = f2 - this.mWaveCenterY;
        if (this.mAlwaysTrackFinger || this.dist2(f3, f4) <= this.getScaledGlowRadiusSquared()) {
            this.switchToState(2, f, f2);
            this.updateGlowPosition(f3, f4);
            this.mDragging = true;
            return true;
        }
        return false;
    }

    private void updateGlowPosition(float f, float f2) {
        float f3 = f - this.mOuterRing.getX();
        float f4 = f2 - this.mOuterRing.getY();
        float f5 = f3 * (1.0f / this.mRingScaleFactor);
        float f6 = f4 * (1.0f / this.mRingScaleFactor);
        this.mPointCloud.glowManager.setX(f5 + this.mOuterRing.getX());
        this.mPointCloud.glowManager.setY(f6 + this.mOuterRing.getY());
    }

    private void updatePointCloudPosition(float f, float f2) {
        this.mPointCloud.setCenter(f, f2);
    }

    private void updateTargetPosition(int n, float f, float f2) {
        this.updateTargetPosition(n, f, f2, this.getAngle(this.getSliceAngle(), n));
    }

    private void updateTargetPosition(int n, float f, float f2, float f3) {
        float f4 = this.getRingWidth() / 2.0f;
        float f5 = this.getRingHeight() / 2.0f;
        if (n >= 0) {
            TargetDrawable targetDrawable = this.mTargetDrawables.get(n);
            targetDrawable.setPositionX(f);
            targetDrawable.setPositionY(f2);
            targetDrawable.setX(f4 * (float)Math.cos(f3));
            targetDrawable.setY(f5 * (float)Math.sin(f3));
        }
    }

    private void updateTargetPositions(float f, float f2) {
        this.updateTargetPositions(f, f2, false);
    }

    private void updateTargetPositions(float f, float f2, boolean bl) {
        int n = this.mTargetDrawables.size();
        float f3 = this.getSliceAngle();
        for (int i = 0; i < n; ++i) {
            if (bl && i == this.mActiveTarget) continue;
            this.updateTargetPosition(i, f, f2, this.getAngle(f3, i));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void vibrate() {
        int n = 1;
        if (Settings.System.getIntForUser(this.mContext.getContentResolver(), "haptic_feedback_enabled", n, -2) == 0) {
            n = 0;
        }
        if (this.mVibrator != null && n != 0) {
            this.mVibrator.vibrate(this.mVibrationDuration, VIBRATION_ATTRIBUTES);
        }
    }

    public int getDirectionDescriptionsResourceId() {
        return this.mDirectionDescriptionsResourceId;
    }

    public int getResourceIdForTarget(int n) {
        TargetDrawable targetDrawable = this.mTargetDrawables.get(n);
        if (targetDrawable == null) {
            return 0;
        }
        return targetDrawable.getResourceId();
    }

    protected int getScaledSuggestedMinimumHeight() {
        return (int)(this.mRingScaleFactor * Math.max((float)this.mOuterRing.getHeight(), 2.0f * this.mOuterRadius) + (float)this.mMaxTargetHeight);
    }

    protected int getScaledSuggestedMinimumWidth() {
        return (int)(this.mRingScaleFactor * Math.max((float)this.mOuterRing.getWidth(), 2.0f * this.mOuterRadius) + (float)this.mMaxTargetWidth);
    }

    @Override
    protected int getSuggestedMinimumHeight() {
        return (int)(Math.max((float)this.mOuterRing.getHeight(), 2.0f * this.mOuterRadius) + (float)this.mMaxTargetHeight);
    }

    @Override
    protected int getSuggestedMinimumWidth() {
        return (int)(Math.max((float)this.mOuterRing.getWidth(), 2.0f * this.mOuterRadius) + (float)this.mMaxTargetWidth);
    }

    public int getTargetDescriptionsResourceId() {
        return this.mTargetDescriptionsResourceId;
    }

    public int getTargetPosition(int n) {
        for (int i = 0; i < this.mTargetDrawables.size(); ++i) {
            if (this.mTargetDrawables.get(i).getResourceId() != n) continue;
            return i;
        }
        return -1;
    }

    public int getTargetResourceId() {
        return this.mTargetResourceId;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        this.mPointCloud.draw(canvas);
        this.mOuterRing.draw(canvas);
        int n = this.mTargetDrawables.size();
        for (int i = 0; i < n; ++i) {
            TargetDrawable targetDrawable = this.mTargetDrawables.get(i);
            if (targetDrawable == null) continue;
            targetDrawable.draw(canvas);
        }
        this.mHandleDrawable.draw(canvas);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onHoverEvent(MotionEvent motionEvent) {
        if (AccessibilityManager.getInstance(this.mContext).isTouchExplorationEnabled()) {
            int n = motionEvent.getAction();
            switch (n) {
                case 9: {
                    motionEvent.setAction(0);
                    break;
                }
                case 7: {
                    motionEvent.setAction(2);
                    break;
                }
                case 10: {
                    motionEvent.setAction(1);
                    break;
                }
            }
            this.onTouchEvent(motionEvent);
            motionEvent.setAction(n);
        }
        super.onHoverEvent(motionEvent);
        return true;
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        int n5 = n3 - n;
        int n6 = n4 - n2;
        float f = this.getRingWidth();
        float f2 = this.getRingHeight();
        float f3 = (float)this.mHorizontalInset + Math.max((float)n5, f + (float)this.mMaxTargetWidth) / 2.0f;
        float f4 = (float)this.mVerticalInset + Math.max((float)n6, f2 + (float)this.mMaxTargetHeight) / 2.0f;
        if (this.mInitialLayout) {
            this.stopAndHideWaveAnimation();
            this.hideTargets(false, false);
            this.mInitialLayout = false;
        }
        this.mOuterRing.setPositionX(f3);
        this.mOuterRing.setPositionY(f4);
        this.mPointCloud.setScale(this.mRingScaleFactor);
        this.mHandleDrawable.setPositionX(f3);
        this.mHandleDrawable.setPositionY(f4);
        this.updateTargetPositions(f3, f4);
        this.updatePointCloudPosition(f3, f4);
        this.updateGlowPosition(f3, f4);
        this.mWaveCenterX = f3;
        this.mWaveCenterY = f4;
    }

    @Override
    protected void onMeasure(int n, int n2) {
        int n3 = this.getSuggestedMinimumWidth();
        int n4 = this.getSuggestedMinimumHeight();
        int n5 = this.resolveMeasured(n, n3);
        int n6 = this.resolveMeasured(n2, n4);
        this.mRingScaleFactor = this.computeScaleFactor(n3, n4, n5, n6);
        int n7 = this.getScaledSuggestedMinimumWidth();
        int n8 = this.getScaledSuggestedMinimumHeight();
        this.computeInsets(n5 - n7, n6 - n8);
        this.setMeasuredDimension(n5, n6);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getActionMasked();
        boolean bl = false;
        switch (n) {
            case 0: 
            case 5: {
                this.handleDown(motionEvent);
                this.handleMove(motionEvent);
                bl = true;
                break;
            }
            case 2: {
                this.handleMove(motionEvent);
                bl = true;
                break;
            }
            case 1: 
            case 6: {
                this.handleMove(motionEvent);
                this.handleUp(motionEvent);
                bl = true;
                break;
            }
            case 3: {
                this.handleMove(motionEvent);
                this.handleCancel(motionEvent);
                bl = true;
            }
        }
        this.invalidate();
        if (bl) {
            return true;
        }
        return super.onTouchEvent(motionEvent);
    }

    public void ping() {
        if (this.mFeedbackCount > 0) {
            boolean bl = true;
            AnimationBundle animationBundle = this.mWaveAnimations;
            if (animationBundle.size() > 0 && ((Tweener)animationBundle.get((int)0)).animator.isRunning() && ((Tweener)animationBundle.get((int)0)).animator.getCurrentPlayTime() < 500L) {
                bl = false;
            }
            if (bl) {
                this.startWaveAnimation();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean replaceTargetDrawablesIfPresent(ComponentName componentName, String string2, int n) {
        boolean bl;
        block6: {
            if (n == 0) {
                return false;
            }
            bl = false;
            if (componentName != null) {
                try {
                    PackageManager packageManager = this.mContext.getPackageManager();
                    Bundle bundle = packageManager.getActivityInfo((ComponentName)componentName, (int)128).metaData;
                    bl = false;
                    if (bundle == null) break block6;
                    int n2 = bundle.getInt(string2);
                    bl = false;
                    if (n2 != 0) {
                        boolean bl2;
                        bl = bl2 = this.replaceTargetDrawables(packageManager.getResourcesForActivity(componentName), n, n2);
                    }
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    Log.w(TAG, "Failed to swap drawable; " + componentName.flattenToShortString() + " not found", nameNotFoundException);
                    bl = false;
                }
                catch (Resources.NotFoundException notFoundException) {
                    Log.w(TAG, "Failed to swap drawable from " + componentName.flattenToShortString(), notFoundException);
                    bl = false;
                }
            }
        }
        if (bl) return bl;
        this.replaceTargetDrawables(this.mContext.getResources(), n, n);
        return bl;
    }

    public void reset(boolean bl) {
        this.mGlowAnimations.stop();
        this.mTargetAnimations.stop();
        this.startBackgroundAnimation(0, 0.0f);
        this.stopAndHideWaveAnimation();
        this.hideTargets(bl, false);
        this.hideGlow(0, 0, 0.0f, null);
        Tweener.reset();
    }

    public void resumeAnimations() {
        this.mWaveAnimations.setSuspended(false);
        this.mTargetAnimations.setSuspended(false);
        this.mGlowAnimations.setSuspended(false);
        this.mWaveAnimations.start();
        this.mTargetAnimations.start();
        this.mGlowAnimations.start();
    }

    public void setDirectionDescriptionsResourceId(int n) {
        this.mDirectionDescriptionsResourceId = n;
        if (this.mDirectionDescriptions != null) {
            this.mDirectionDescriptions.clear();
        }
    }

    public void setEnableTarget(int n, boolean bl) {
        int n2 = 0;
        while (true) {
            block4: {
                block3: {
                    if (n2 >= this.mTargetDrawables.size()) break block3;
                    TargetDrawable targetDrawable = this.mTargetDrawables.get(n2);
                    if (targetDrawable.getResourceId() != n) break block4;
                    targetDrawable.setEnabled(bl);
                }
                return;
            }
            ++n2;
        }
    }

    public void setOnTriggerListener(OnTriggerListener onTriggerListener) {
        this.mOnTriggerListener = onTriggerListener;
    }

    public void setTargetDescriptionsResourceId(int n) {
        this.mTargetDescriptionsResourceId = n;
        if (this.mTargetDescriptions != null) {
            this.mTargetDescriptions.clear();
        }
    }

    public void setTargetResources(int n) {
        if (this.mAnimatingTargets) {
            this.mNewTargetResources = n;
            return;
        }
        this.internalSetTargetResources(n);
    }

    public void setVibrateEnabled(boolean bl) {
        if (bl && this.mVibrator == null) {
            this.mVibrator = (Vibrator)this.getContext().getSystemService("vibrator");
            return;
        }
        this.mVibrator = null;
    }

    public void suspendAnimations() {
        this.mWaveAnimations.setSuspended(true);
        this.mTargetAnimations.setSuspended(true);
        this.mGlowAnimations.setSuspended(true);
    }

    private class AnimationBundle
    extends ArrayList<Tweener> {
        private static final long serialVersionUID = -6319262269245852568L;
        private boolean mSuspended;

        private AnimationBundle() {
        }

        public void cancel() {
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                ((Tweener)this.get((int)i)).animator.cancel();
            }
            this.clear();
        }

        public void setSuspended(boolean bl) {
            this.mSuspended = bl;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void start() {
            if (!this.mSuspended) {
                int n = this.size();
                for (int i = 0; i < n; ++i) {
                    ((Tweener)this.get((int)i)).animator.start();
                }
            }
        }

        public void stop() {
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                ((Tweener)this.get((int)i)).animator.end();
            }
            this.clear();
        }
    }

    public static interface OnTriggerListener {
        public static final int CENTER_HANDLE = 1;
        public static final int NO_HANDLE;

        public void onFinishFinalAnimation();

        public void onGrabbed(View var1, int var2);

        public void onGrabbedStateChange(View var1, int var2);

        public void onReleased(View var1, int var2);

        public void onTrigger(View var1, int var2);
    }
}

