/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.ate;

import de.upb.pga3.ate.Generator;
import de.upb.pga3.ate.Level1Exp;
import de.upb.pga3.ate.Level2aExp;
import de.upb.pga3.ate.Level2bExp;
import de.upb.pga3.ate.TestCase;
import de.upb.pga3.panda2.client.cmdline.CommandLine;
import de.upb.pga3.panda2.client.core.ClientGUI;
import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.extension.lvl1.AnalysisResultLvl1;
import de.upb.pga3.panda2.extension.lvl2a.AnalysisResultLvl2a;
import de.upb.pga3.panda2.extension.lvl2b.AnalysisResultLvl2b;
import java.io.File;
import java.util.List;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AutomatedTestGUI
extends Application {
    private ClientGUI clientGUI;
    private static CommandLine commandLine;
    Button jar;
    Button path;
    Button run;
    TextArea ta;
    static File jarFile;
    static File pathFile;
    TextField jarField = new TextField();
    TextField pathField = new TextField("");
    String text1 = "START ";
    int counter = 0;
    Generator gen = new Generator();
    private static final Logger LOGGER;

    static {
        LOGGER = LogManager.getLogger(AutomatedTestGUI.class);
    }

    public void start(final Stage inStage) {
        inStage.setTitle("Automated Test Runner");
        inStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent we) {
                we.consume();
                System.exit(0);
            }
        });
        HBox sampleBox = new HBox();
        HBox sampleBox2 = new HBox();
        this.jar = new Button("Select Jar");
        this.path = new Button("Select Root Path");
        this.path.setMinWidth(100.0);
        this.run = new Button("Run Automated Tests");
        this.jar.setPrefWidth(125.0);
        this.path.setPrefWidth(125.0);
        this.run.setPrefWidth(200.0);
        this.jarField.setMinWidth(400.0);
        this.jarField.setPrefWidth(400.0);
        this.jarField.setMaxWidth(400.0);
        this.jarField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                AutomatedTestGUI.this.jarField.setPrefWidth((double)(AutomatedTestGUI.this.jarField.getText().length() * 7));
            }
        });
        this.pathField.setMinWidth(400.0);
        this.pathField.setPrefWidth(400.0);
        this.pathField.setMaxWidth(400.0);
        this.pathField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                AutomatedTestGUI.this.pathField.setPrefWidth((double)(AutomatedTestGUI.this.pathField.getText().length() * 7));
            }
        });
        Image image = new Image("file:data/images/right_16.png");
        ImageView iv1 = new ImageView();
        iv1.setImage(image);
        ImageView iv2 = new ImageView();
        iv2.setImage(image);
        final FileChooser chooserDialog1 = new FileChooser();
        FileChooser.ExtensionFilter apkFilter1 = new FileChooser.ExtensionFilter("*.jar - java executable archieve", new String[]{"*.jar"});
        chooserDialog1.getExtensionFilters().add((Object)apkFilter1);
        this.jar.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                jarFile = chooserDialog1.showOpenDialog((Window)inStage);
                AutomatedTestGUI.this.jarField.setText(jarFile.toString());
            }
        });
        final DirectoryChooser chooserDialog2 = new DirectoryChooser();
        this.path.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                pathFile = chooserDialog2.showDialog((Window)inStage);
                AutomatedTestGUI.this.pathField.setText(pathFile.toString());
            }
        });
        this.run.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                AutomatedTestGUI.this.proceed();
            }
        });
        sampleBox2.getChildren().addAll((Object[])new Node[]{this.path, this.pathField});
        sampleBox.setAlignment(Pos.BASELINE_CENTER);
        sampleBox.setSpacing(35.0);
        sampleBox2.setAlignment(Pos.BASELINE_CENTER);
        sampleBox2.setSpacing(35.0);
        this.ta = new TextArea();
        this.ta.setPrefHeight(500.0);
        VBox displayBox = new VBox();
        displayBox.getChildren().addAll((Object[])new Node[]{sampleBox, sampleBox2, this.run, this.ta});
        displayBox.setAlignment(Pos.CENTER);
        displayBox.setSpacing(15.0);
        Scene scene = new Scene((Parent)displayBox, 700.0, 700.0, (Paint)Color.BROWN);
        inStage.setScene(scene);
        inStage.getIcons().add((Object)new Image("file:data/images/document_16.png"));
        inStage.show();
    }

    public void proceed() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                AutomatedTestGUI.this.ta.setText(AutomatedTestGUI.this.text1);
            }
        }).start();
        this.ta.setText(this.text1);
        Thread t = new Thread(){

            @Override
            public void run() {
                for (TestCase testCase : AutomatedTestGUI.this.gen.generateTestCases()) {
                    ++AutomatedTestGUI.this.counter;
                    try {
                        List<String> getExpResults;
                        AutomatedTestGUI.commandLine = new CommandLine();
                        if (commandLine.validateInitialInput(testCase.getExec())) {
                            LOGGER.info("Command Line string validated");
                        }
                        commandLine.saveOrShowResult();
                        AnalysisResult analysisResult = commandLine.getClientCommandLine().getAnalysisResult();
                        if (analysisResult instanceof AnalysisResultLvl1) {
                            AutomatedTestGUI.this.text1 = String.valueOf(AutomatedTestGUI.this.text1) + "\n\nTest " + AutomatedTestGUI.this.counter + "-Stored at path" + " (" + testCase.getTestName() + ")" + "\nLevel 1 ran Successfully ";
                            AutomatedTestGUI.this.ta.setText(AutomatedTestGUI.this.text1);
                            getExpResults = testCase.getExpResults();
                            if (getExpResults.isEmpty()) continue;
                            Level1Exp level1exp = new Level1Exp(getExpResults, analysisResult);
                            String level1Appender = level1exp.getterDisplayString();
                            AutomatedTestGUI.this.text1 = String.valueOf(AutomatedTestGUI.this.text1) + level1Appender;
                            AutomatedTestGUI.this.ta.setText(AutomatedTestGUI.this.text1);
                            continue;
                        }
                        if (analysisResult instanceof AnalysisResultLvl2a) {
                            AutomatedTestGUI.this.text1 = String.valueOf(AutomatedTestGUI.this.text1) + "\n\nTest " + AutomatedTestGUI.this.counter + "-Stored at path" + " (" + testCase.getTestName() + ")" + "\nLevel 2a ran Successfully ";
                            AutomatedTestGUI.this.ta.setText(AutomatedTestGUI.this.text1);
                            getExpResults = testCase.getExpResults();
                            if (getExpResults.isEmpty()) continue;
                            Level2aExp level2aexp = new Level2aExp(getExpResults, analysisResult);
                            String level2aAppender = level2aexp.getterDisplayString();
                            AutomatedTestGUI.this.text1 = String.valueOf(AutomatedTestGUI.this.text1) + level2aAppender;
                            AutomatedTestGUI.this.ta.setText(AutomatedTestGUI.this.text1);
                            continue;
                        }
                        if (analysisResult instanceof AnalysisResultLvl2b) {
                            AutomatedTestGUI.this.text1 = String.valueOf(AutomatedTestGUI.this.text1) + "\n\nTest " + AutomatedTestGUI.this.counter + "-Stored at path" + " (" + testCase.getTestName() + ")" + "\nLevel 2b ran Successfully ";
                            AutomatedTestGUI.this.ta.setText(AutomatedTestGUI.this.text1);
                            getExpResults = testCase.getExpResults();
                            if (getExpResults.isEmpty()) continue;
                            Level2bExp level2bexp = new Level2bExp(getExpResults, analysisResult);
                            String level2bAppender = level2bexp.getterDisplayString();
                            AutomatedTestGUI.this.text1 = String.valueOf(AutomatedTestGUI.this.text1) + level2bAppender;
                            AutomatedTestGUI.this.ta.setText(AutomatedTestGUI.this.text1);
                            continue;
                        }
                        AutomatedTestGUI.this.text1 = String.valueOf(AutomatedTestGUI.this.text1) + "\n\nTest " + AutomatedTestGUI.this.counter + "-Stored at path" + " (" + testCase.getTestName() + ")" + "\n" + commandLine.getClientCommandLine().getMessages();
                        AutomatedTestGUI.this.ta.setText(AutomatedTestGUI.this.text1);
                    }
                    catch (Exception e) {
                        AutomatedTestGUI.this.text1 = String.valueOf(AutomatedTestGUI.this.text1) + "\n\nTest " + AutomatedTestGUI.this.counter + "-Stored at path" + " (" + testCase.getTestName() + ")" + "\n" + " Test has thrown an exception:";
                        AutomatedTestGUI.this.ta.setText(AutomatedTestGUI.this.text1);
                        e.printStackTrace();
                    }
                }
            }
        };
        t.start();
        this.ta.setText(this.text1);
    }
}

