/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.client.core;

import de.upb.pga3.panda2.client.core.datastructures.AnalysisKey;
import de.upb.pga3.panda2.client.core.datastructures.ExtraAnalysisInput;
import de.upb.pga3.panda2.core.AnalysisFactory;
import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.extension.lvl1.AnalysisFactoryLvl1;
import de.upb.pga3.panda2.extension.lvl1.AnalysisResultLvl1;
import de.upb.pga3.panda2.extension.lvl2a.AnalysisFactoryLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.AnalysisResultLvl2a;
import de.upb.pga3.panda2.extension.lvl2b.AnalysisFactoryLvl2b;
import de.upb.pga3.panda2.extension.lvl2b.AnalysisResultLvl2b;
import de.upb.pga3.panda2.extension.lvl2b.ExtraAnalysisInputLvl2b;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public final class AnalysisRegistry {
    private static final AnalysisRegistry INSTANCE = new AnalysisRegistry();
    public static final String LEVEL1 = "Permission Usage (Intra App - Level 1)";
    public static final String LEVEL2A = "Information Flow (Intra App - Level 2a)";
    public static final String LEVEL2B = "Permission Usage (Inter App - Level 2b)";
    public static final String UNKNOWN = "Unknown";
    List<AnalysisKey> list = new ArrayList<AnalysisKey>();

    private AnalysisRegistry() {
        this.list.add(new AnalysisKey(LEVEL1, "1", "l1", "level1", "level 1", "INTRA-APP-PERMISSION", "INTRA-PERM", "INTRA-APP-PERM"));
        this.list.add(new AnalysisKey(LEVEL2A, "2a", "l2a", "level2a", "level 2a", "INTRA-APP-INFO-FLOW", "INTRA-INFO-FLOW", "INTRA-IF"));
        this.list.add(new AnalysisKey(LEVEL2B, "2b", "l2b", "level2b", "level 2b", "INTER-APP-PERMISSION", "INTER-APP-PERM", "INTER-PERM"));
    }

    public static AnalysisRegistry getInstance() {
        return INSTANCE;
    }

    public AnalysisFactory getFactory(String name, File apkFile, AnalysisResult previousResult, File apkComparison, List<File> additionalApks, ExtraAnalysisInput extraInput) {
        if (name == LEVEL1) {
            if (previousResult == null) {
                return new AnalysisFactoryLvl1(apkFile, apkComparison);
            }
            if (previousResult instanceof AnalysisResultLvl1) {
                return new AnalysisFactoryLvl1(apkFile, (AnalysisResultLvl1)previousResult);
            }
        } else if (name == LEVEL2A) {
            if (previousResult == null) {
                if (apkComparison != null) {
                    return new AnalysisFactoryLvl2a(apkFile.toPath(), apkComparison.toPath());
                }
                Path path = null;
                return new AnalysisFactoryLvl2a(apkFile.toPath(), path);
            }
            if (previousResult instanceof AnalysisResultLvl2a) {
                return new AnalysisFactoryLvl2a(apkFile.toPath(), (AnalysisResultLvl2a)previousResult);
            }
        } else if (name == LEVEL2B) {
            if (previousResult == null) {
                return new AnalysisFactoryLvl2b(apkFile, additionalApks, apkComparison, ((ExtraAnalysisInputLvl2b)extraInput).getAllMode());
            }
            if (previousResult instanceof AnalysisResultLvl2b) {
                return new AnalysisFactoryLvl2b(apkFile, additionalApks, (AnalysisResultLvl2b)previousResult, ((ExtraAnalysisInputLvl2b)extraInput).getAllMode());
            }
        }
        return null;
    }

    public String getName(String shortcutOrName) {
        for (AnalysisKey key : this.list) {
            if (key.getName().equalsIgnoreCase(shortcutOrName) || key.getShortcuts().contains(shortcutOrName)) {
                return key.getName();
            }
            for (String shortcut : key.getShortcuts()) {
                if (!shortcut.equalsIgnoreCase(shortcutOrName)) continue;
                return key.getName();
            }
        }
        return UNKNOWN;
    }

    public String getName(AnalysisResult loadedResult) {
        if (loadedResult instanceof AnalysisResultLvl1) {
            return LEVEL1;
        }
        if (loadedResult instanceof AnalysisResultLvl2a) {
            return LEVEL2A;
        }
        if (loadedResult instanceof AnalysisResultLvl2b) {
            return LEVEL2B;
        }
        return UNKNOWN;
    }

    public List<String> getAnalysisNames() {
        ArrayList<String> tempList = new ArrayList<String>();
        for (AnalysisKey key : this.list) {
            tempList.add(key.getName());
        }
        return tempList;
    }
}

