/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.client.core;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import de.upb.pga3.panda2.client.core.AnalysisRegistry;
import de.upb.pga3.panda2.client.core.Client;
import de.upb.pga3.panda2.client.core.UserInput;
import de.upb.pga3.panda2.client.core.datastructures.Mode;
import de.upb.pga3.panda2.client.core.datastructures.ResultRepresentation;
import de.upb.pga3.panda2.client.core.datastructures.ResultView;
import de.upb.pga3.panda2.client.core.datastructures.ToolSpecificOption;
import de.upb.pga3.panda2.core.datastructures.DetailLevel;
import java.util.List;

public class ClientCommandLine
extends Client {
    private boolean isSaveResult;
    private boolean isGraphicalViewResult;
    private boolean isMessageViewResult;
    private boolean isProgramTerminate;
    private boolean isTestingScenario;
    private boolean isLoadOptionSelected;
    private boolean isHelpOptionSelected;

    public boolean isGraphicalViewResult() {
        return this.isGraphicalViewResult;
    }

    public void setGraphicalViewResult(boolean isGraphicalViewResult) {
        this.isGraphicalViewResult = isGraphicalViewResult;
    }

    public boolean validateCommandLineInputArguments(String ... args) {
        JCommander jCommander = new JCommander((Object)this.getUserInput());
        try {
            jCommander.parse(args);
            UserInput userInput = this.getUserInput();
            ToolSpecificOption toolSpecificOption = userInput.getTsOption();
            ResultRepresentation resultRepresentation = userInput.getResultRepresentation();
            ResultView resultView = userInput.getResultView();
            if (!toolSpecificOption.equals((Object)ToolSpecificOption.ANALYSIS)) {
                this.setLoadOptionSelected(toolSpecificOption.equals((Object)ToolSpecificOption.LOAD));
                if (!this.isLoadOptionSelected()) {
                    this.setHelpOptionSelected(true);
                    jCommander.usage();
                } else {
                    if (userInput.getFilePath() == null || userInput.getFilePath().isEmpty()) {
                        throw new ParameterException("File for viewing the result is not given. Please input the correct value as this field is mandatory for the LOADING/VIEWING mode");
                    }
                    if (!userInput.getFilePath().toLowerCase().endsWith(".pa2")) {
                        throw new ParameterException("A file is without an PA2 extension. Unsupported input file format for LOADING the result. File name= " + userInput.getFilePath());
                    }
                }
            } else {
                if (userInput.getLevel() == null) {
                    throw new ParameterException("Level value is " + userInput.getLevel() + ". " + "Please input the correct value as this field (-l) is mandatory for the ANALYSIS mode");
                }
                if (AnalysisRegistry.getInstance().getName(userInput.getLevel()).equals("Permission Usage (Inter App - Level 2b)") && userInput.getLevelSpecificMode() == null) {
                    throw new ParameterException("Level Specific Mode value is " + (Object)((Object)userInput.getLevelSpecificMode()) + ". " + "Please input the correct value as this field (-lm) is mandatory for LEVEL2B");
                }
                if (userInput.getSelectedInitialInput() == null || userInput.getSelectedInitialInput().isEmpty()) {
                    throw new ParameterException("Input APK's are not given. Please input the correct value as this field (-i) is mandatory for the ANALYSIS mode");
                }
                for (String input : userInput.getSelectedInitialInput()) {
                    if (input.toLowerCase().endsWith(".apk")) continue;
                    throw new ParameterException("A file is without an APK extension. Unsupported input file format. File name= " + input);
                }
            }
            if (!this.isHelpOptionSelected()) {
                if (resultRepresentation != null) {
                    this.setSaveResult(resultRepresentation.equals((Object)ResultRepresentation.SAVE));
                }
                if (resultView != null && !resultView.equals((Object)ResultView.TEXTUAL)) {
                    this.setGraphicalViewResult(resultView.equals((Object)ResultView.GRAPHICAL));
                    if (!this.isGraphicalViewResult()) {
                        this.setMessageViewResult(true);
                    }
                }
                if (userInput.getSelectedComparisonInput() != null && !userInput.getSelectedComparisonInput().trim().equals("")) {
                    userInput.setMode(Mode.COMPARISON);
                    this.setComparisonMode(true);
                }
                this.setProgramTerminate(userInput.isTerminate());
                this.setTestingScenario(userInput.isTestingScenario());
            }
        }
        catch (ParameterException ex) {
            JCommander.getConsole().println("Cannot parse arguments: " + ex.getMessage());
            jCommander.usage();
            return false;
        }
        return true;
    }

    public boolean continueAnalysis(String continueAnalysis) {
        String userSelectedValue = continueAnalysis;
        if (userSelectedValue == null) {
            userSelectedValue = "Yes";
        }
        return userSelectedValue.equalsIgnoreCase("Yes") || userSelectedValue.equalsIgnoreCase("Y");
    }

    @Override
    public String filterTextViewResult(DetailLevel detailLevel, List<String> resultFilter) {
        String textualResult = this.getAnalysisResult().getTextualResult(detailLevel, resultFilter, this.getUserInput().isShowTestStatistics());
        return textualResult;
    }

    public boolean isSaveResult() {
        return this.isSaveResult;
    }

    public void setSaveResult(boolean isSaveResult) {
        this.isSaveResult = isSaveResult;
    }

    public boolean isMessageViewResult() {
        return this.isMessageViewResult;
    }

    public void setMessageViewResult(boolean isMessageViewResult) {
        this.isMessageViewResult = isMessageViewResult;
    }

    public boolean isProgramTerminate() {
        return this.isProgramTerminate;
    }

    public void setProgramTerminate(boolean isProgramTerminate) {
        this.isProgramTerminate = isProgramTerminate;
    }

    public boolean isTestingScenario() {
        return this.isTestingScenario;
    }

    public void setTestingScenario(boolean isTestingScenario) {
        this.isTestingScenario = isTestingScenario;
    }

    public boolean isLoadOptionSelected() {
        return this.isLoadOptionSelected;
    }

    public void setLoadOptionSelected(boolean isLoadOptionSelected) {
        this.isLoadOptionSelected = isLoadOptionSelected;
    }

    public boolean isHelpOptionSelected() {
        return this.isHelpOptionSelected;
    }

    public void setHelpOptionSelected(boolean isHelpOptionSelected) {
        this.isHelpOptionSelected = isHelpOptionSelected;
    }

    @Override
    public String filterGraphicalViewResult(DetailLevel detailLevel, List<String> resultFilter) {
        return null;
    }
}

