/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.core.services;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ARSCParser {
    private static final Logger LOGGER = LogManager.getLogger(ARSCParser.class);
    private static final boolean DEBUG = false;
    protected static final int RES_STRING_POOL_TYPE = 1;
    protected static final int RES_TABLE_TYPE = 2;
    protected static final int RES_TABLE_PACKAGE_TYPE = 512;
    protected static final int RES_TABLE_TYPE_SPEC_TYPE = 514;
    protected static final int RES_TABLE_TYPE_TYPE = 513;
    protected static final int SORTED_FLAG = 1;
    protected static final int UTF8_FLAG = 256;
    protected static final int SPEC_PUBLIC = 0x40000000;
    protected static final int TYPE_NULL = 0;
    protected static final int TYPE_REFERENCE = 1;
    protected static final int TYPE_ATTRIBUTE = 2;
    protected static final int TYPE_STRING = 3;
    protected static final int TYPE_FLOAT = 4;
    protected static final int TYPE_DIMENSION = 5;
    protected static final int TYPE_FRACTION = 6;
    protected static final int TYPE_FIRST_INT = 16;
    protected static final int TYPE_INT_DEC = 16;
    protected static final int TYPE_INT_HEX = 17;
    protected static final int TYPE_INT_BOOLEAN = 18;
    protected static final int TYPE_FIRST_COLOR_INT = 28;
    protected static final int TYPE_INT_COLOR_ARGB8 = 28;
    protected static final int TYPE_INT_COLOR_RGB8 = 29;
    protected static final int TYPE_INT_COLOR_ARGB4 = 30;
    protected static final int TYPE_INT_COLOR_RGB4 = 31;
    protected static final int TYPE_LAST_COLOR_INT = 31;
    protected static final int TYPE_LAST_INT = 31;
    protected static final int ATTR_TYPE = 0x1000000;
    protected static final int ATTR_MIN = 0x1000001;
    protected static final int ATTR_MAX = 0x1000002;
    protected static final int ATTR_L10N = 0x1000003;
    protected static final int ATTR_OTHER = 0x1000004;
    protected static final int ATTR_ZERO = 0x1000005;
    protected static final int ATTR_ONE = 0x1000006;
    protected static final int ATTR_TWO = 0x1000007;
    protected static final int ATTR_FEW = 0x1000008;
    protected static final int ATTR_MANY = 0x1000009;
    protected static final int NO_ENTRY = -1;
    protected static final int COMPLEX_UNIT_SHIFT = 0;
    protected static final int COMPLEX_UNIT_MASK = 15;
    protected static final int COMPLEX_UNIT_PX = 0;
    protected static final int COMPLEX_UNIT_DIP = 1;
    protected static final int COMPLEX_UNIT_SP = 2;
    protected static final int COMPLEX_UNIT_PT = 3;
    protected static final int COMPLEX_UNIT_IN = 4;
    protected static final int COMPLEX_UNIT_MM = 5;
    protected static final int COMPLEX_UNIT_FRACTION = 0;
    protected static final int COMPLEX_UNIT_FRACTION_PARENT = 1;
    protected static final int COMPLEX_RADIX_SHIFT = 4;
    protected static final int COMPLEX_RADIX_MASK = 3;
    protected static final int COMPLEX_RADIX_23p0 = 0;
    protected static final int COMPLEX_RADIX_16p7 = 1;
    protected static final int COMPLEX_RADIX_8p15 = 2;
    protected static final int COMPLEX_RADIX_0p23 = 3;
    protected static final int COMPLEX_MANTISSA_SHIFT = 8;
    protected static final int COMPLEX_MANTISSA_MASK = 0xFFFFFF;
    protected static final float MANTISSA_MULT = 0.00390625f;
    protected static final float[] RADIX_MULTS = new float[]{0.00390625f, 3.0517578E-5f, 1.1920929E-7f, 4.656613E-10f};
    public static final int FLAG_COMPLEX = 1;
    public static final int FLAG_PUBLIC = 2;
    private final Map<Integer, String> stringTable = new HashMap<Integer, String>();
    private final List<ResPackage> packages = new ArrayList<ResPackage>();

    public void parse(String apkName) throws IOException {
        File apkFile = new File(apkName);
        if (!apkFile.exists()) {
            throw new RuntimeException("File " + apkName + " doesn't exist.");
        }
        try {
            ZipFile zFile = new ZipFile(apkFile);
            Enumeration<? extends ZipEntry> entries = zFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.equals("resources.arsc")) continue;
                this.parse(zFile.getInputStream(entry));
            }
        }
        catch (IOException ex) {
            LOGGER.info("Could not read resource file: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void parse(InputStream stream) throws IOException {
        this.readResourceHeader(stream);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void readResourceHeader(InputStream stream) throws IOException {
        BLOCK_SIZE = 2048;
        resourceHeader = new ResTable_Header();
        this.readChunkHeader(stream, resourceHeader.header);
        resourceHeader.packageCount = this.readUInt32(stream);
        remainingSize = resourceHeader.header.size - resourceHeader.header.headerSize;
        if (remainingSize <= 0) {
            return;
        }
        remainingData = new byte[remainingSize];
        totalBytesRead = 0;
        while (totalBytesRead < remainingSize) {
            block = new byte[Math.min(2048, remainingSize - totalBytesRead)];
            bytesRead = stream.read(block);
            if (bytesRead < 0) {
                ARSCParser.LOGGER.info("Could not read block from resource file");
                return;
            }
            System.arraycopy(block, 0, remainingData, totalBytesRead, bytesRead);
            totalBytesRead += bytesRead;
        }
        offset = 0;
        beforeBlock = 0;
        packageCtr = 0;
        keyStrings = new HashMap<Integer, String>();
        typeStrings = new HashMap<Integer, String>();
        while (offset < remainingData.length - 1) {
            block22: {
                block21: {
                    beforeBlock = offset;
                    nextChunkHeader = new ResChunk_Header();
                    offset = this.readChunkHeader(nextChunkHeader, remainingData, offset);
                    if (nextChunkHeader.type != 1) break block21;
                    stringPoolHeader = new ResStringPool_Header();
                    stringPoolHeader.header = nextChunkHeader;
                    offset = this.parseStringPoolHeader(stringPoolHeader, remainingData, offset);
                    offset = this.readStringTable(remainingData, offset, beforeBlock, stringPoolHeader, this.stringTable);
                    if (!ARSCParser.$assertionsDisabled && this.stringTable.size() != stringPoolHeader.stringCount) {
                        throw new AssertionError();
                    }
                    break block22;
                }
                if (nextChunkHeader.type != 512) break block22;
                packageTable = new ResTable_Package();
                packageTable.header = nextChunkHeader;
                offset = this.parsePackageTable(packageTable, remainingData, offset);
                endOfRecord = beforeBlock + nextChunkHeader.size;
                resPackage = new ResPackage();
                this.packages.add(resPackage);
                ResPackage.access$0(resPackage, packageTable.id);
                ResPackage.access$1(resPackage, packageTable.name);
                beforeStringBlock = typeStringsOffset = beforeBlock + packageTable.typeStrings;
                typePoolHeader = new ResChunk_Header();
                typeStringsOffset = this.readChunkHeader(typePoolHeader, remainingData, typeStringsOffset);
                if (typePoolHeader.type != 1) {
                    throw new RuntimeException("Unexpected block type for package type strings");
                }
                typePool = new ResStringPool_Header();
                typePool.header = typePoolHeader;
                typeStringsOffset = this.parseStringPoolHeader(typePool, remainingData, typeStringsOffset);
                this.readStringTable(remainingData, typeStringsOffset, beforeStringBlock, typePool, typeStrings);
                beforeStringBlock = keyStringsOffset = beforeBlock + packageTable.keyStrings;
                keyPoolHeader = new ResChunk_Header();
                keyStringsOffset = this.readChunkHeader(keyPoolHeader, remainingData, keyStringsOffset);
                if (keyPoolHeader.type != 1) {
                    throw new RuntimeException("Unexpected block type for package key strings");
                }
                keyPool = new ResStringPool_Header();
                keyPool.header = keyPoolHeader;
                keyStringsOffset = this.parseStringPoolHeader(keyPool, remainingData, keyStringsOffset);
                this.readStringTable(remainingData, keyStringsOffset, beforeStringBlock, keyPool, keyStrings);
                offset = beforeStringBlock + keyPoolHeader.size;
                while (offset < endOfRecord) {
                    block24: {
                        block23: {
                            innerHeader = new ResChunk_Header();
                            beforeInnerBlock = offset;
                            offset = this.readChunkHeader(innerHeader, remainingData, offset);
                            if (innerHeader.type != 514) break block23;
                            typeSpecTable = new ResTable_TypeSpec();
                            typeSpecTable.header = innerHeader;
                            offset = this.readTypeSpecTable(typeSpecTable, remainingData, offset);
                            if (!ARSCParser.$assertionsDisabled && offset != beforeInnerBlock + typeSpecTable.header.headerSize) {
                                throw new AssertionError();
                            }
                            tp = new ResType();
                            ResType.access$0(tp, typeSpecTable.id);
                            ResType.access$1(tp, (String)typeStrings.get(typeSpecTable.id - 1));
                            ResPackage.access$2(resPackage).add(tp);
                            break block24;
                        }
                        if (innerHeader.type != 513) break block24;
                        typeTable = new ResTable_Type();
                        typeTable.header = innerHeader;
                        offset = this.readTypeTable(typeTable, remainingData, offset);
                        if (!ARSCParser.$assertionsDisabled && offset != beforeInnerBlock + typeTable.header.headerSize) {
                            throw new AssertionError();
                        }
                        resType = null;
                        for (ResType rt : ResPackage.access$2(resPackage)) {
                            if (ResType.access$2(rt) != typeTable.id) continue;
                            resType = rt;
                            break;
                        }
                        if (resType == null) {
                            throw new RuntimeException("Reference to undeclared type found");
                        }
                        config = new ResConfig();
                        ResType.access$3(resType).add(config);
                        resourceIdx = 0;
                        i = 0;
                        while (i < typeTable.entryCount) {
                            block26: {
                                block27: {
                                    block25: {
                                        entryOffset = this.readUInt32(remainingData, offset);
                                        offset += 4;
                                        if (entryOffset != -1) break block25;
                                        ++resourceIdx;
                                        break block26;
                                    }
                                    entry = this.readEntryTable(remainingData, entryOffset += beforeInnerBlock + typeTable.entriesStart);
                                    entryOffset += entry.size;
                                    if (!entry.flagsComplex) break block27;
                                    res /* !! */  = cmpRes = new ComplexResource();
                                    j = 0;
                                    while (j < ((ResTable_Map_Entry)entry).count) {
                                        map = new ResTable_Map();
                                        entryOffset = this.readComplexValue(map, remainingData, entryOffset);
                                        ComplexResource.access$0(cmpRes).put(String.valueOf(map.name), this.parseValue(map.value));
                                        ++j;
                                    }
                                    ** GOTO lbl-1000
                                }
                                val = new Res_Value();
                                entryOffset = this.readValue(val, remainingData, entryOffset);
                                res /* !! */  = this.parseValue(val);
                                if (res /* !! */  == null) {
                                    ARSCParser.LOGGER.info("Could not parse resource " + (String)keyStrings.get(entry.key) + " of type " + Integer.toHexString(val.dataType) + ", skipping entry");
                                } else lbl-1000:
                                // 2 sources

                                {
                                    if (keyStrings.containsKey(entry.key)) {
                                        AbstractResource.access$2(res /* !! */ , (String)keyStrings.get(entry.key));
                                    } else {
                                        AbstractResource.access$2(res /* !! */ , "<INVALID RESOURCE>");
                                    }
                                    r = resType.getResourceByName(AbstractResource.access$0(res /* !! */ ));
                                    if (r != null) {
                                        AbstractResource.access$3(res /* !! */ , AbstractResource.access$1(r));
                                    }
                                    if (AbstractResource.access$1(res /* !! */ ) <= 0) {
                                        AbstractResource.access$3(res /* !! */ , (packageTable.id << 24) + (typeTable.id << 16) + resourceIdx);
                                    }
                                    ResConfig.access$0(config).add(res /* !! */ );
                                    ++resourceIdx;
                                }
                            }
                            ++i;
                        }
                    }
                    offset = beforeInnerBlock + innerHeader.size;
                }
                for (ResType var16_19 : ResPackage.access$2(resPackage)) {
                }
                ++packageCtr;
            }
            offset = beforeBlock + nextChunkHeader.size;
            remainingSize -= nextChunkHeader.size;
        }
    }

    protected boolean isAttribute(ResTable_Map map) {
        return map.name == 0x1000000 || map.name == 0x1000001 || map.name == 0x1000002 || map.name == 0x1000003 || map.name == 0x1000004 || map.name == 0x1000005 || map.name == 0x1000006 || map.name == 0x1000007 || map.name == 0x1000008 || map.name == 0x1000009;
    }

    protected static float complexToFloat(int complex) {
        return (float)(complex & 0xFFFFFF00) * RADIX_MULTS[complex >> 4 & 3];
    }

    private AbstractResource parseValue(Res_Value val) {
        AbstractResource res;
        switch (val.dataType) {
            case 0: {
                res = new NullResource();
                break;
            }
            case 1: {
                res = new ReferenceResource(val.data);
                break;
            }
            case 2: {
                res = new AttributeResource(val.data);
                break;
            }
            case 3: {
                res = new StringResource(this.stringTable.get(val.data));
                break;
            }
            case 16: 
            case 17: {
                res = new IntegerResource(val.data);
                break;
            }
            case 18: {
                res = new BooleanResource(val.data);
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                res = new ColorResource(val.data & 0xFFFFFFFF, val.data & 0xFF, val.data & 0xFF, val.data & 0xFF);
                break;
            }
            case 5: {
                res = new DimensionResource(val.data & 0xF, val.data >> 0);
                break;
            }
            case 4: {
                res = new FloatResource(Float.intBitsToFloat(val.data));
                break;
            }
            case 6: {
                int fracType = val.data >> 0 & 0xF;
                float data = ARSCParser.complexToFloat(val.data);
                if (fracType == 0) {
                    res = new FractionResource(FractionType.Fraction, data);
                    break;
                }
                res = new FractionResource(FractionType.FractionParent, data);
                break;
            }
            default: {
                return null;
            }
        }
        return res;
    }

    private int readComplexValue(ResTable_Map map, byte[] remainingData, int offset) throws IOException {
        map.name = this.readUInt32(remainingData, offset);
        return this.readValue(map.value, remainingData, offset += 4);
    }

    private int readValue(Res_Value val, byte[] remainingData, int offset) throws IOException {
        int initialOffset = offset;
        val.size = this.readUInt16(remainingData, offset);
        offset += 2;
        if (val.size > 8) {
            return 0;
        }
        val.res0 = this.readUInt8(remainingData, offset);
        if (val.res0 != 0) {
            throw new RuntimeException("File format error, res0 was not zero");
        }
        val.dataType = this.readUInt8(remainingData, ++offset);
        val.data = this.readUInt32(remainingData, ++offset);
        assert ((offset += 4) == initialOffset + val.size);
        return offset;
    }

    private ResTable_Entry readEntryTable(byte[] data, int offset) throws IOException {
        ResTable_Entry entry;
        int size = this.readUInt16(data, offset);
        offset += 2;
        if (size == 8) {
            entry = new ResTable_Entry();
        } else if (size == 16) {
            entry = new ResTable_Map_Entry();
        } else {
            throw new RuntimeException("Unknown entry type");
        }
        entry.size = size;
        int flags = this.readUInt16(data, offset);
        entry.flagsComplex = (flags & 1) == 1;
        entry.flagsPublic = (flags & 2) == 2;
        entry.key = this.readUInt32(data, offset += 2);
        offset += 4;
        if (entry instanceof ResTable_Map_Entry) {
            ResTable_Map_Entry mapEntry = (ResTable_Map_Entry)entry;
            mapEntry.parent = this.readUInt32(data, offset);
            mapEntry.count = this.readUInt32(data, offset += 4);
            offset += 4;
        }
        return entry;
    }

    private int readTypeTable(ResTable_Type typeTable, byte[] data, int offset) throws IOException {
        typeTable.id = this.readUInt8(data, offset);
        typeTable.res0 = this.readUInt8(data, ++offset);
        if (typeTable.res0 != 0) {
            throw new RuntimeException("File format error, res0 was not zero");
        }
        typeTable.res1 = this.readUInt16(data, ++offset);
        if (typeTable.res1 != 0) {
            throw new RuntimeException("File format error, res1 was not zero");
        }
        typeTable.entryCount = this.readUInt32(data, offset += 2);
        typeTable.entriesStart = this.readUInt32(data, offset += 4);
        return this.readConfigTable(typeTable.config, data, offset += 4);
    }

    private int readConfigTable(ResTable_Config config, byte[] data, int offset) throws IOException {
        config.size = this.readUInt32(data, offset);
        config.mmc = this.readUInt16(data, offset += 4);
        config.mnc = this.readUInt16(data, offset += 2);
        config.language[0] = (char)data[offset += 2];
        config.language[1] = (char)data[offset + 1];
        config.country[0] = (char)data[offset += 2];
        config.country[1] = (char)data[offset + 1];
        config.orientation = this.readUInt8(data, offset += 2);
        config.touchscreen = this.readUInt8(data, ++offset);
        config.density = this.readUInt16(data, ++offset);
        config.keyboard = this.readUInt8(data, offset += 2);
        config.navigation = this.readUInt8(data, ++offset);
        config.inputFlags = this.readUInt8(data, ++offset);
        config.inputPad0 = this.readUInt8(data, ++offset);
        config.screenWidth = this.readUInt16(data, ++offset);
        config.screenHeight = this.readUInt16(data, offset += 2);
        config.sdkVersion = this.readUInt16(data, offset += 2);
        config.minorVersion = this.readUInt16(data, offset += 2);
        offset += 2;
        if (config.size <= 28) {
            return offset;
        }
        config.screenLayout = this.readUInt8(data, offset);
        config.uiMode = this.readUInt8(data, ++offset);
        config.smallestScreenWidthDp = this.readUInt16(data, ++offset);
        offset += 2;
        if (config.size <= 32) {
            return offset;
        }
        config.screenWidthDp = this.readUInt16(data, offset);
        config.screenHeightDp = this.readUInt16(data, offset += 2);
        offset += 2;
        if (config.size <= 36) {
            return offset;
        }
        int i = 0;
        while (i < 4) {
            config.localeScript[i] = (char)data[offset + i];
            ++i;
        }
        offset += 4;
        if (config.size <= 40) {
            return offset;
        }
        i = 0;
        while (i < 8) {
            config.localeVariant[i] = (char)data[offset + i];
            ++i;
        }
        offset += 8;
        if (config.size <= 48) {
            return offset;
        }
        int remainingSize = config.size - 48;
        if (remainingSize > 0) {
            byte[] remainingBytes = new byte[remainingSize];
            System.arraycopy(data, offset, remainingBytes, 0, remainingSize);
            if (!new BigInteger(1, remainingBytes).equals(BigInteger.ZERO)) assert (false);
            offset += remainingSize;
        }
        return offset;
    }

    private int readTypeSpecTable(ResTable_TypeSpec typeSpecTable, byte[] data, int offset) throws IOException {
        typeSpecTable.id = this.readUInt8(data, offset);
        typeSpecTable.res0 = this.readUInt8(data, ++offset);
        ++offset;
        if (typeSpecTable.res0 != 0) {
            throw new RuntimeException("File format violation, res0 was not zero");
        }
        typeSpecTable.res1 = this.readUInt16(data, offset);
        offset += 2;
        if (typeSpecTable.res1 != 0) {
            throw new RuntimeException("File format violation, res1 was not zero");
        }
        typeSpecTable.entryCount = this.readUInt32(data, offset);
        return offset += 4;
    }

    private int readStringTable(byte[] remainingData, int offset, int blockStart, ResStringPool_Header stringPoolHeader, Map<Integer, String> stringList) throws IOException {
        int i = 0;
        while (i < stringPoolHeader.stringCount) {
            int stringIdx = this.readUInt32(remainingData, offset);
            offset += 4;
            String str = "";
            str = stringPoolHeader.flagsUTF8 ? this.readStringUTF8(remainingData, stringIdx).trim() : this.readString(remainingData, stringIdx += stringPoolHeader.stringsStart + blockStart).trim();
            stringList.put(i, str);
            ++i;
        }
        return offset;
    }

    private int parsePackageTable(ResTable_Package packageTable, byte[] data, int offset) throws IOException {
        packageTable.id = this.readUInt32(data, offset);
        offset += 4;
        StringBuilder bld = new StringBuilder();
        int i = 0;
        while (i < 128) {
            int curChar = this.readUInt16(data, offset);
            bld.append((char)curChar);
            offset += 2;
            ++i;
        }
        packageTable.name = bld.toString().trim();
        packageTable.typeStrings = this.readUInt32(data, offset);
        packageTable.lastPublicType = this.readUInt32(data, offset += 4);
        packageTable.keyStrings = this.readUInt32(data, offset += 4);
        packageTable.lastPublicKey = this.readUInt32(data, offset += 4);
        return offset += 4;
    }

    private String readString(byte[] remainingData, int stringIdx) throws IOException {
        int strLen = this.readUInt16(remainingData, stringIdx);
        if (strLen == 0) {
            return "";
        }
        byte[] str = new byte[strLen * 2];
        System.arraycopy(remainingData, stringIdx += 2, str, 0, strLen * 2);
        return new String(remainingData, stringIdx, strLen * 2, "UTF-16LE");
    }

    private String readStringUTF8(byte[] remainingData, int stringIdx) throws IOException {
        int strLen = this.readUInt8(remainingData, stringIdx + 1);
        String str = new String(remainingData, stringIdx += 2, strLen, "UTF-8");
        return str;
    }

    private int parseStringPoolHeader(ResStringPool_Header stringPoolHeader, byte[] data, int offset) throws IOException {
        stringPoolHeader.stringCount = this.readUInt32(data, offset);
        stringPoolHeader.styleCount = this.readUInt32(data, offset + 4);
        int flags = this.readUInt32(data, offset + 8);
        stringPoolHeader.flagsSorted = (flags & 1) == 1;
        stringPoolHeader.flagsUTF8 = (flags & 0x100) == 256;
        stringPoolHeader.stringsStart = this.readUInt32(data, offset + 12);
        stringPoolHeader.stylesStart = this.readUInt32(data, offset + 16);
        return offset + 20;
    }

    private void readChunkHeader(InputStream stream, ResChunk_Header nextChunkHeader) throws IOException {
        byte[] header = new byte[8];
        stream.read(header);
        this.readChunkHeader(nextChunkHeader, header, 0);
    }

    private int readChunkHeader(ResChunk_Header nextChunkHeader, byte[] data, int offset) throws IOException {
        nextChunkHeader.type = this.readUInt16(data, offset);
        nextChunkHeader.headerSize = this.readUInt16(data, offset += 2);
        nextChunkHeader.size = this.readUInt32(data, offset += 2);
        return offset += 4;
    }

    private int readUInt8(byte[] uint16, int offset) throws IOException {
        int b0 = uint16[0 + offset] & 0xFF;
        return b0;
    }

    private int readUInt16(byte[] uint16, int offset) throws IOException {
        int b0 = uint16[0 + offset] & 0xFF;
        int b1 = uint16[1 + offset] & 0xFF;
        return (b1 << 8) + b0;
    }

    private int readUInt32(InputStream stream) throws IOException {
        byte[] uint32 = new byte[4];
        stream.read(uint32);
        return this.readUInt32(uint32, 0);
    }

    private int readUInt32(byte[] uint32, int offset) throws IOException {
        int b0 = uint32[0 + offset] & 0xFF;
        int b1 = uint32[1 + offset] & 0xFF;
        int b2 = uint32[2 + offset] & 0xFF;
        int b3 = uint32[3 + offset] & 0xFF;
        return (Math.abs(b3) << 24) + (Math.abs(b2) << 16) + (Math.abs(b1) << 8) + Math.abs(b0);
    }

    public Map<Integer, String> getGlobalStringPool() {
        return this.stringTable;
    }

    public List<ResPackage> getPackages() {
        return this.packages;
    }

    public AbstractResource findResource(int resourceId) {
        ResourceId id = this.parseResourceId(resourceId);
        for (ResPackage resPackage : this.packages) {
            if (resPackage.packageId != id.packageId) continue;
            for (ResType resType : resPackage.types) {
                if (resType.id != id.typeId) continue;
                return resType.getFirstResource(resourceId);
            }
        }
        return null;
    }

    public ResourceId parseResourceId(int resourceId) {
        return new ResourceId((resourceId & 0xFF000000) >> 24, (resourceId & 0xFF0000) >> 16, resourceId & 0xFFFF);
    }

    public abstract class AbstractResource {
        private String resourceName;
        private int resourceID;

        public String getResourceName() {
            return this.resourceName;
        }

        public int getResourceID() {
            return this.resourceID;
        }

        static /* synthetic */ void access$2(AbstractResource abstractResource, String string) {
            abstractResource.resourceName = string;
        }

        static /* synthetic */ void access$3(AbstractResource abstractResource, int n) {
            abstractResource.resourceID = n;
        }
    }

    public class AttributeResource
    extends AbstractResource {
        private int attributeID;

        public AttributeResource(int id) {
            this.attributeID = id;
        }

        public int getAttributeID() {
            return this.attributeID;
        }
    }

    public class BooleanResource
    extends AbstractResource {
        private boolean value;

        public BooleanResource(int value) {
            this.value = value != 0;
        }

        public boolean getValue() {
            return this.value;
        }

        public String toString() {
            return Boolean.toString(this.value);
        }
    }

    public class ColorResource
    extends AbstractResource {
        private int a;
        private int r;
        private int g;
        private int b;

        public ColorResource(int a, int r, int g, int b) {
            this.a = a;
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public int getA() {
            return this.a;
        }

        public int getR() {
            return this.r;
        }

        public int getG() {
            return this.g;
        }

        public int getB() {
            return this.b;
        }

        public String toString() {
            return String.format("#%02x%02x%02x%02x", this.a, this.r, this.g, this.b);
        }
    }

    public class ComplexResource
    extends AbstractResource {
        private Map<String, AbstractResource> value;

        public ComplexResource() {
            this.value = new HashMap<String, AbstractResource>();
        }

        public ComplexResource(Map<String, AbstractResource> value) {
            this.value = value;
        }

        public Map<String, AbstractResource> getValue() {
            return this.value;
        }

        static /* synthetic */ Map access$0(ComplexResource complexResource) {
            return complexResource.value;
        }
    }

    public static enum Dimension {
        PX,
        DIP,
        SP,
        PT,
        IN,
        MM;

    }

    public class DimensionResource
    extends AbstractResource {
        private int value;
        private Dimension unit;

        public DimensionResource(int value, Dimension unit) {
            this.value = value;
            this.unit = unit;
        }

        DimensionResource(int dimension, int value) {
            this.value = value;
            switch (dimension) {
                case 0: {
                    this.unit = Dimension.PX;
                    break;
                }
                case 1: {
                    this.unit = Dimension.DIP;
                    break;
                }
                case 2: {
                    this.unit = Dimension.SP;
                    break;
                }
                case 3: {
                    this.unit = Dimension.PT;
                    break;
                }
                case 4: {
                    this.unit = Dimension.IN;
                    break;
                }
                case 5: {
                    this.unit = Dimension.MM;
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid dimension: " + dimension);
                }
            }
        }

        public int getValue() {
            return this.value;
        }

        public Dimension getUnit() {
            return this.unit;
        }

        public String toString() {
            return String.valueOf(Integer.toString(this.value)) + this.unit.toString().toLowerCase();
        }
    }

    public class FloatResource
    extends AbstractResource {
        private float value;

        public FloatResource(float value) {
            this.value = value;
        }

        public float getValue() {
            return this.value;
        }

        public String toString() {
            return Float.toString(this.value);
        }
    }

    public class FractionResource
    extends AbstractResource {
        private FractionType type;
        private float value;

        public FractionResource(FractionType type, float value) {
            this.type = type;
            this.value = value;
        }

        public FractionType getType() {
            return this.type;
        }

        public float getValue() {
            return this.value;
        }
    }

    public static enum FractionType {
        Fraction,
        FractionParent;

    }

    public class IntegerResource
    extends AbstractResource {
        private int value;

        public IntegerResource(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }

    public class NullResource
    extends AbstractResource {
    }

    public class ReferenceResource
    extends AbstractResource {
        private int referenceID;

        public ReferenceResource(int id) {
            this.referenceID = id;
        }

        public int getReferenceID() {
            return this.referenceID;
        }
    }

    protected class ResChunk_Header {
        int type;
        int headerSize;
        int size;

        protected ResChunk_Header() {
        }
    }

    public class ResConfig {
        private List<AbstractResource> resources = new ArrayList<AbstractResource>();

        public List<AbstractResource> getResources() {
            return this.resources;
        }

        static /* synthetic */ List access$0(ResConfig resConfig) {
            return resConfig.resources;
        }
    }

    public class ResPackage {
        private int packageId;
        private String packageName;
        private List<ResType> types = new ArrayList<ResType>();

        public int getPackageId() {
            return this.packageId;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public List<ResType> getDeclaredTypes() {
            return this.types;
        }

        static /* synthetic */ void access$0(ResPackage resPackage, int n) {
            resPackage.packageId = n;
        }

        static /* synthetic */ void access$1(ResPackage resPackage, String string) {
            resPackage.packageName = string;
        }
    }

    protected class ResStringPool_Header {
        ResChunk_Header header;
        int stringCount;
        int styleCount;
        boolean flagsSorted;
        boolean flagsUTF8;
        int stringsStart;
        int stylesStart;

        protected ResStringPool_Header() {
        }
    }

    protected class ResTable_Config {
        int size;
        int mmc;
        int mnc;
        char[] language = new char[2];
        char[] country = new char[2];
        int orientation;
        int touchscreen;
        int density;
        int keyboard;
        int navigation;
        int inputFlags;
        int inputPad0;
        int screenWidth;
        int screenHeight;
        int sdkVersion;
        int minorVersion;
        int screenLayout;
        int uiMode;
        int smallestScreenWidthDp;
        int screenWidthDp;
        int screenHeightDp;
        char[] localeScript = new char[4];
        char[] localeVariant = new char[8];

        protected ResTable_Config() {
        }
    }

    protected class ResTable_Entry {
        int size;
        boolean flagsComplex;
        boolean flagsPublic;
        int key;

        protected ResTable_Entry() {
        }
    }

    protected class ResTable_Header {
        ResChunk_Header header;
        int packageCount;

        protected ResTable_Header() {
            this.header = new ResChunk_Header();
        }
    }

    protected class ResTable_Map {
        int name;
        Res_Value value;

        protected ResTable_Map() {
            this.value = new Res_Value();
        }
    }

    protected class ResTable_Map_Entry
    extends ResTable_Entry {
        int parent;
        int count;

        protected ResTable_Map_Entry() {
        }
    }

    protected class ResTable_Package {
        ResChunk_Header header;
        int id;
        String name;
        int typeStrings;
        int lastPublicType;
        int keyStrings;
        int lastPublicKey;

        protected ResTable_Package() {
        }
    }

    protected class ResTable_Type {
        ResChunk_Header header;
        int id;
        int res0;
        int res1;
        int entryCount;
        int entriesStart;
        ResTable_Config config;

        protected ResTable_Type() {
            this.config = new ResTable_Config();
        }
    }

    protected class ResTable_TypeSpec {
        ResChunk_Header header;
        int id;
        int res0;
        int res1;
        int entryCount;

        protected ResTable_TypeSpec() {
        }
    }

    public class ResType {
        private int id;
        private String typeName;
        private List<ResConfig> configurations = new ArrayList<ResConfig>();

        public String getTypeName() {
            return this.typeName;
        }

        public List<ResConfig> getConfigurations() {
            return this.configurations;
        }

        public Collection<AbstractResource> getAllResources() {
            HashMap<String, AbstractResource> resources = new HashMap<String, AbstractResource>();
            for (ResConfig rc : this.configurations) {
                for (AbstractResource res : rc.getResources()) {
                    if (resources.containsKey(res.resourceName)) continue;
                    resources.put(res.resourceName, res);
                }
            }
            return resources.values();
        }

        public AbstractResource getResourceByName(String resourceName) {
            for (ResConfig rc : this.configurations) {
                for (AbstractResource res : rc.getResources()) {
                    if (!res.getResourceName().equals(resourceName)) continue;
                    return res;
                }
            }
            return null;
        }

        public AbstractResource getFirstResource(String resourceName) {
            for (ResConfig rc : this.configurations) {
                for (AbstractResource res : rc.getResources()) {
                    if (!res.resourceName.equals(resourceName)) continue;
                    return res;
                }
            }
            return null;
        }

        public AbstractResource getFirstResource(int resourceID) {
            for (ResConfig rc : this.configurations) {
                for (AbstractResource res : rc.getResources()) {
                    if (res.resourceID != resourceID) continue;
                    return res;
                }
            }
            return null;
        }

        public String toString() {
            return this.typeName;
        }

        static /* synthetic */ void access$0(ResType resType, int n) {
            resType.id = n;
        }

        static /* synthetic */ void access$1(ResType resType, String string) {
            resType.typeName = string;
        }

        static /* synthetic */ List access$3(ResType resType) {
            return resType.configurations;
        }
    }

    protected class Res_Value {
        int size;
        int res0;
        int dataType;
        int data;

        protected Res_Value() {
        }
    }

    public class ResourceId {
        private int packageId;
        private int typeId;
        private int itemIndex;

        public ResourceId(int packageId, int typeId, int itemIndex) {
            this.packageId = packageId;
            this.typeId = typeId;
            this.itemIndex = itemIndex;
        }

        public int getPackageId() {
            return this.packageId;
        }

        public int getTypeId() {
            return this.typeId;
        }

        public int getItemIndex() {
            return this.itemIndex;
        }

        public String toString() {
            return "Package " + this.packageId + ", type " + this.typeId + ", item " + this.itemIndex;
        }
    }

    public class StringResource
    extends AbstractResource {
        private String value;

        public StringResource(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }
}

