/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.core.services;

import java.util.ArrayList;
import java.util.List;
import soot.SootClass;
import soot.Unit;
import soot.ValueBox;

public class GlobalVariable {
    private SootClass mParentClass;
    private String mVarName;
    private String mType;
    private List<String> mLstValues;
    private List<Unit> mLstUnits;

    public SootClass getParentClass() {
        return this.mParentClass;
    }

    public void setParentClass(SootClass mParentClass) {
        this.mParentClass = mParentClass;
    }

    public String getVarName() {
        return this.mVarName;
    }

    public void setVarName(String inVarName) {
        this.mVarName = inVarName;
    }

    public String getType() {
        return this.mType;
    }

    public void setType(String inType) {
        this.mType = inType;
    }

    private void addValue(String inValue) {
        if (inValue != null && !inValue.isEmpty()) {
            this.mLstValues.add(inValue);
        }
    }

    public List<String> getValues() {
        return this.mLstValues;
    }

    public void addUnit(Unit inUnit) {
        if (inUnit != null) {
            this.mLstUnits.add(inUnit);
            List<ValueBox> lstUsedBoxes = inUnit.getUseBoxes();
            if (lstUsedBoxes != null && lstUsedBoxes.size() >= 2) {
                this.addValue(lstUsedBoxes.get(1).getValue().toString());
            }
        }
    }

    public GlobalVariable(SootClass parent) {
        this.mParentClass = parent;
        this.mVarName = "";
        this.mType = "";
        this.mLstValues = new ArrayList<String>();
        this.mLstUnits = new ArrayList<Unit>();
    }

    public String toString() {
        return String.valueOf(this.mParentClass.getName()) + ": " + this.mType + " " + this.mVarName;
    }

    public boolean equals(Object inObj) {
        if (inObj != null && inObj instanceof GlobalVariable) {
            String className = inObj.toString();
            if (!className.equals(this.mParentClass.toString())) {
                return false;
            }
            GlobalVariable inVar = (GlobalVariable)inObj;
            if (this.mVarName != null && inVar.mVarName != null && !this.mVarName.equals(inVar.mVarName)) {
                return false;
            }
            return inVar.mType == null || this.mType == null || this.mType.equals(inVar.mType);
        }
        return false;
    }

    public boolean isInTypeOf(String inString) {
        if (inString != null && this.mType != null) {
            return this.mType.equals(inString);
        }
        return false;
    }
}

