/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension;

import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.core.services.CoreServices;
import de.upb.pga3.panda2.core.services.DataStorage;
import de.upb.pga3.panda2.core.services.XMLParser;
import java.util.List;
import java.util.Map;
import soot.SootClass;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.internal.AbstractInvokeExpr;

public class PermissionMapper {
    EnhancedInput ei;
    private List<String> usesPermissions;
    private Map<String, String> requiredPermissions;
    private DataStorage dataStorage;
    private Map<String, Permission> allPermissions;

    PermissionMapper(EnhancedInput ei) {
        this.ei = ei;
        this.dataStorage = CoreServices.getDataStorageInstance();
        this.allPermissions = this.dataStorage.getAllPermissions();
        XMLParser parser = CoreServices.getXMLParserInstance();
        this.usesPermissions = parser.getUsesPermission();
        this.requiredPermissions = parser.getRequiredPermissions();
    }

    public void mapPermissionsToApp() {
        for (String permissionStr : this.usesPermissions) {
            this.ei.addPermission(this.allPermissions.get(permissionStr));
        }
    }

    public void mapPermissionsToStatement(Unit element) {
        block12: {
            String stmtStr;
            block13: {
                block11: {
                    stmtStr = element.toString();
                    if (!stmtStr.contains("android.net.Uri parse(java.lang.String)")) break block11;
                    String uriStr = null;
                    for (ValueBox item : element.getUseBoxes()) {
                        AbstractInvokeExpr aExpr;
                        Value value = item.getValue();
                        if (!(value instanceof AbstractInvokeExpr) || (aExpr = (AbstractInvokeExpr)value).getArgs() == null || aExpr.getArgs().isEmpty()) continue;
                        uriStr = ((AbstractInvokeExpr)value).getArg(0).toString();
                        break;
                    }
                    if (uriStr != null) {
                        List<Permission> permList = this.dataStorage.mapContentProviderURI(uriStr = uriStr.substring(1, uriStr.length() - 1));
                        if (permList != null) {
                            for (Permission permission : permList) {
                                this.ei.addPermissionTo(element, this.allPermissions.get(permission.getName()));
                            }
                        }
                        this.ei.addToMaybeMoreList(element);
                    }
                    break block12;
                }
                if (!stmtStr.contains("<android.content.Intent:")) break block13;
                String actionStr = null;
                if (!stmtStr.contains("void <init>(java.lang.String)") && !stmtStr.contains("android.content.Intent setAction(java.lang.String)")) break block12;
                for (ValueBox item : element.getUseBoxes()) {
                    AbstractInvokeExpr aExpr;
                    Value value = item.getValue();
                    if (!(value instanceof AbstractInvokeExpr) || (aExpr = (AbstractInvokeExpr)value).getArgs() == null || aExpr.getArgs().isEmpty()) continue;
                    actionStr = ((AbstractInvokeExpr)value).getArg(0).toString();
                    break;
                }
                if (actionStr == null) break block12;
                List<Permission> permList = this.dataStorage.mapImplicitIntent(actionStr = actionStr.substring(1, actionStr.length() - 1));
                if (permList != null) {
                    for (Permission permission : permList) {
                        this.ei.addPermissionTo(element, this.allPermissions.get(permission.getName()));
                    }
                }
                this.ei.addToMaybeMoreList(element);
                break block12;
            }
            List<Permission> fetchedPermissionList = null;
            try {
                String pkgName = stmtStr.substring(stmtStr.indexOf("<") + 1, stmtStr.indexOf(":"));
                String string = stmtStr.substring(stmtStr.indexOf(" ", stmtStr.indexOf(":") + 3) + 1, stmtStr.indexOf(">"));
                fetchedPermissionList = this.dataStorage.mapAPICall(pkgName, string);
            }
            catch (StringIndexOutOfBoundsException e) {
                return;
            }
            if (fetchedPermissionList == null || fetchedPermissionList.isEmpty()) {
                return;
            }
            for (Permission permission : fetchedPermissionList) {
                this.ei.addPermissionTo(element, this.allPermissions.get(permission.getName()));
            }
        }
    }

    public void mapPermissionsToComponent(SootClass element) {
        if (this.allPermissions.get(this.requiredPermissions.get(element.toString())) != null) {
            this.ei.addPermissionTo(element, this.allPermissions.get(this.requiredPermissions.get(element.toString())));
        }
    }
}

