/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl2a;

import de.upb.pga3.panda2.core.datastructures.DetailLevel;
import de.upb.pga3.panda2.extension.lvl2a.AnalysisResultLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.ClassElement;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.FlowPath;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.MethodElement;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.PathElement;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.ResourceElement;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.StatementElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HtmlTableBuilder {
    private static final Logger LOGGER = LogManager.getLogger(HtmlTableBuilder.class);
    private StringBuilder mTableComponent = new StringBuilder("");
    private StringBuilder mInfoContent = new StringBuilder("");
    private int mIntCols;
    private boolean mBHighLineRow = false;
    private boolean mBComparisionMode = false;
    public static String cssStyle = "body { background: #F4F4F4; font-family: Verdana, Geneva, sans-serif; font-size: 12px;}#level2a { width:100%; border-collapse:collapse; }#level2a td { border: 1px solid #000000; padding: 3px 7px 2px 7px; vertical-align:text-top;}#level2a tr.alt td\t{ color: #000000; background-color: #eeeeee;}#level2a th {background-color:gray; color: black; border:1px solid #000000; font-size: 15px; text-align: left; padding:3px 7px 2px 7px; padding-top:5px; padding-bottom:4px; }#level2a th.alt {background-color:#AAAAAA; color:black; font-size:13px; text-align: left; padding:3px 7px 2px 7px; padding-top:5px; padding-bottom:4px; }#level2a tr.alt th {background-color: #AAAAAA; color: black; font-size: 13px; text-align: left; padding: 3px 7px 2px 7px; padding-top: 5px; padding-bottom: 4px; }div.legend {background: #FFFFFF; border: 1px inset #CCCCCC; padding: 10px 10px 10px 10px; position: fixed; top: 10px; right: 10px;}div.icon { float: left; border: 1px solid #000000; width: 12px; height: 7px; margin-right: 5px; margin-top: 3px;}div.stats {display: inline-block; background: #FFFFFF; border: 1px inset #CCCCCC; padding:10px 10px 10px 10px; width: auto; height: auto;}.list-permission li { position:relative;list-style-type:none;text-indent:-2em;} .list-permission li:before { content: ' ';}.list-class li { position: relative; list-style-type: none; text-indent: -2em;}.list-method li { position: relative; list-style-type: none; text-indent: -2em;}.list-statement li { position: relative; list-style-type: none; text-indent: -2em;}.list-class li:before { content: '\\27A4';}.list-method li:before { content:'\\00BB';}.list-statement li:before { content:'\\25BA'; } ";
    public static String strLegend = "<div class=\"legend\"><center><strong>Legend</strong></center><br /><div class=\"icon\" style=\"background:#ff0000;\"></div>SOURCE PERMISSION<br /><div class=\"icon\" style=\"background:#0006fd;\"></div>SINK PERMISSION<br /></div>";

    public HtmlTableBuilder(boolean inIsComparisionMode, String inAppName) {
        this.mIntCols = inIsComparisionMode ? 3 : 2;
        this.mBComparisionMode = inIsComparisionMode;
        this.initTable(inAppName);
    }

    public void processResult(Collection<FlowPath> inPaths, DetailLevel inDetailLvl) {
        this.addAnalysisInfo(false, inDetailLvl);
        if (inDetailLvl.equals(AnalysisResultLvl2a.DetailLevelLvl2a.RES_TO_RES)) {
            this.computeResourceSummary(inPaths);
        } else if (inDetailLvl.equals(AnalysisResultLvl2a.DetailLevelLvl2a.COMPONENT)) {
            this.computeComponentSummary(inPaths);
        } else if (inDetailLvl.equals(AnalysisResultLvl2a.DetailLevelLvl2a.STATEMENT)) {
            this.computeStatementSummary(inPaths);
        } else if (inDetailLvl.equals(AnalysisResultLvl2a.DetailLevelLvl2a.METHOD)) {
            this.computeMethodSummary(inPaths);
        } else {
            LOGGER.warn("Unknown analysis detail level is specified.");
        }
    }

    public void processResult(Collection<FlowPath> inNewPaths, Collection<FlowPath> inRemovePaths, DetailLevel inDetailLvl) {
        this.addAnalysisInfo(true, inDetailLvl);
        if (inDetailLvl.equals(AnalysisResultLvl2a.DetailLevelLvl2a.RES_TO_RES)) {
            this.computeResourceComparison(inNewPaths, inRemovePaths);
        } else if (inDetailLvl.equals(AnalysisResultLvl2a.DetailLevelLvl2a.COMPONENT)) {
            this.computeComponentComparison(inNewPaths, inRemovePaths);
        } else if (inDetailLvl.equals(AnalysisResultLvl2a.DetailLevelLvl2a.STATEMENT)) {
            this.computeStatementComparison(inNewPaths, inRemovePaths);
        } else if (inDetailLvl.equals(AnalysisResultLvl2a.DetailLevelLvl2a.METHOD)) {
            this.computeMethodComparison(inNewPaths, inRemovePaths);
        } else {
            LOGGER.warn("Unknown analysis detail level is specified.");
        }
    }

    public HtmlTableBuilder(int inNumCol, String inAppName) {
        this.mIntCols = inNumCol;
        this.initTable(inAppName);
    }

    public void addAnalysisInfo(boolean isComparisonMode, DetailLevel inDetailLvl) {
        if (!isComparisonMode) {
            this.mInfoContent.append("<strong>Analysis Mode: </strong>Summary<br/>\n");
        } else {
            this.mInfoContent.append("<strong>Analysis Mode: </strong>Comparision<br/>\n");
        }
        this.mInfoContent.append("<strong>Detail Level: </strong>" + inDetailLvl.toString() + "<br/>\n");
    }

    public void computeComponentComparison(Collection<FlowPath> inNewLstPaths, Collection<FlowPath> inRemovedLstPaths) {
        if ((inNewLstPaths == null || inNewLstPaths.isEmpty()) && (inRemovedLstPaths == null || inRemovedLstPaths.isEmpty())) {
            LOGGER.warn("List of found paths is invalid ");
            return;
        }
        Map<String, List<String>> mapNewPaths = this.getComponentComparison(true, inNewLstPaths);
        Map<String, List<String>> mapRemovedPaths = this.getComponentComparison(false, inRemovedLstPaths);
        this.addRowForComparisonVer2(mapNewPaths, mapRemovedPaths);
    }

    private void computeComponentSummary(Collection<FlowPath> inPaths) {
        if (inPaths != null && !inPaths.isEmpty()) {
            HashMap<String, List<String>> mapResults = new HashMap<String, List<String>>();
            for (FlowPath inFlowPath : inPaths) {
                ResourceElement soPerm = inFlowPath.getSource();
                ResourceElement siPerm = inFlowPath.getSink();
                StringBuilder row = new StringBuilder("");
                StringBuilder pathContent = new StringBuilder("");
                pathContent.append("<ul class=\"list-class\">");
                String sourcePerm = HtmlTableBuilder.setColor(soPerm.getPermissionName(), "red");
                row.append(this.generateCol(sourcePerm));
                String sinkPerm = HtmlTableBuilder.setColor(siPerm.getPermissionName(), "blue");
                String flowPath = this.processFlowPathsForComponents(inFlowPath);
                if (!flowPath.contains("<li>")) continue;
                pathContent.append(flowPath);
                pathContent.append("</ul>");
                pathContent.append("<ul class=\"list-permission\"><li>" + sinkPerm + "</li></ul>");
                String col2 = this.generateCol(pathContent.toString());
                row.append(col2);
                ArrayList<String> lstValues = (ArrayList<String>)mapResults.get(soPerm.getPermissionName());
                if (lstValues == null) {
                    lstValues = new ArrayList<String>();
                    lstValues.add(row.toString());
                    mapResults.put(soPerm.getPermissionName(), lstValues);
                    continue;
                }
                if (lstValues.contains(row.toString())) continue;
                lstValues.add(row.toString());
            }
            this.addRowForSummary(mapResults);
        }
    }

    private void computeResourceComparison(Collection<FlowPath> inNewLstPaths, Collection<FlowPath> inRemovedLstPaths) {
        StringBuilder lstFlow;
        StringBuilder column;
        String sink;
        int iPost;
        String source;
        if (inNewLstPaths == null && inRemovedLstPaths == null) {
            LOGGER.warn("List of found paths is invalid ");
            return;
        }
        HashMap<String, List<String>> mapNewPaths = new HashMap<String, List<String>>();
        HashMap<String, List<String>> mapRemovedPaths = new HashMap<String, List<String>>();
        this.processFlowPathsForResource(inNewLstPaths, mapNewPaths);
        this.processFlowPathsForResource(inRemovedLstPaths, mapRemovedPaths);
        ArrayList<String> lstCheckedPermission = new ArrayList<String>();
        Set setNewPermissions = mapNewPaths.keySet();
        for (String keyPerm : setNewPermissions) {
            List newSiPermissions = (List)mapNewPaths.get(keyPerm);
            List oldSiPermission = (List)mapRemovedPaths.get(keyPerm);
            source = HtmlTableBuilder.setColor(keyPerm, "red");
            for (String newStrPerm : newSiPermissions) {
                StringBuilder column2 = new StringBuilder("");
                StringBuilder lstFlow2 = new StringBuilder("<ul>");
                String sink2 = HtmlTableBuilder.setColor(newStrPerm, "blue");
                column2.append(this.generateCol(source));
                lstFlow2.append(HtmlTableBuilder.generateItem(sink2));
                lstFlow2.append("</ul>");
                column2.append(this.generateCol(lstFlow2.toString()));
                column2.append(this.generateCol(""));
                iPost = this.mTableComponent.indexOf("</tbody>");
                this.mTableComponent.insert(iPost, this.generateRow(column2.toString()));
            }
            if (oldSiPermission == null) continue;
            lstCheckedPermission.add(keyPerm);
            for (String oldStrPerm : oldSiPermission) {
                sink = HtmlTableBuilder.setColor(oldStrPerm, "blue");
                column = new StringBuilder("");
                lstFlow = new StringBuilder("<ul>");
                column.append(this.generateCol(source));
                column.append(this.generateCol(""));
                lstFlow.append(HtmlTableBuilder.generateItem(sink));
                lstFlow.append("</ul>");
                column.append(this.generateCol(lstFlow.toString()));
                iPost = this.mTableComponent.indexOf("</tbody>");
                this.mTableComponent.insert(iPost, this.generateRow(column.toString()));
            }
        }
        Set setRemovedPermissions = mapRemovedPaths.keySet();
        for (String keyPerm : setRemovedPermissions) {
            if (lstCheckedPermission.contains(keyPerm)) continue;
            List removedPermissions = (List)mapRemovedPaths.get(keyPerm);
            source = HtmlTableBuilder.setColor(keyPerm, "red");
            for (String newStrPerm : removedPermissions) {
                sink = HtmlTableBuilder.setColor(newStrPerm, "blue");
                column = new StringBuilder("");
                lstFlow = new StringBuilder("<ul>");
                column.append(this.generateCol(source));
                column.append(this.generateCol(""));
                lstFlow.append(HtmlTableBuilder.generateItem(sink));
                lstFlow.append("</ul>");
                column.append(this.generateCol(lstFlow.toString()));
                iPost = this.mTableComponent.indexOf("</tbody>");
                this.mTableComponent.insert(iPost, this.generateRow(column.toString()));
            }
        }
    }

    private void computeResourceSummary(Collection<FlowPath> inPaths) {
        if (inPaths != null && !inPaths.isEmpty()) {
            HashMap mapPerms = new HashMap();
            for (FlowPath flow : inPaths) {
                ArrayList<String> lstStrPerm = new ArrayList<String>();
                ResourceElement sourcePerm = flow.getSource();
                String strSourcePerm = sourcePerm.getPermissionName();
                ResourceElement sinkPerm = flow.getSink();
                String strSinkPerm = sinkPerm.getPermissionName();
                List lstPerms = (List)mapPerms.get(sourcePerm);
                if (lstPerms == null) {
                    ArrayList<ResourceElement> newLstPerms = new ArrayList<ResourceElement>();
                    newLstPerms.add(sinkPerm);
                    mapPerms.put(sourcePerm, newLstPerms);
                } else {
                    if (lstPerms.contains(sinkPerm)) continue;
                    lstPerms.add(sinkPerm);
                }
                lstStrPerm.add(strSourcePerm);
                lstStrPerm.add(strSinkPerm);
                this.addRow(lstStrPerm);
            }
        }
    }

    public void computeStatementComparison(Collection<FlowPath> inNewLstPaths, Collection<FlowPath> inRemovedLstPaths) {
        if ((inNewLstPaths == null || inNewLstPaths.isEmpty()) && (inRemovedLstPaths == null || inRemovedLstPaths.isEmpty())) {
            LOGGER.warn("List of found paths is invalid ");
            return;
        }
        Map<String, List<String>> mapNewPaths = this.getStatementComparison(true, inNewLstPaths);
        Map<String, List<String>> mapRemovedPaths = this.getStatementComparison(false, inRemovedLstPaths);
        this.addRowForComparisonVer2(mapNewPaths, mapRemovedPaths);
    }

    public void computeStatementSummary(Collection<FlowPath> inPaths) {
        if (inPaths == null) {
            LOGGER.warn("Invalid flow path");
            return;
        }
        HashMap<String, List<String>> mapPaths = new HashMap<String, List<String>>();
        for (FlowPath inFlowPath : inPaths) {
            ResourceElement sourcePerm = inFlowPath.getSource();
            ResourceElement sinkPerm = inFlowPath.getSink();
            StringBuilder row = new StringBuilder("");
            StringBuilder pathContent = new StringBuilder("");
            String strSourcePerm = HtmlTableBuilder.setColor(sourcePerm.getPermissionName(), "red");
            row.append(this.generateCol(strSourcePerm));
            String strSinkPerm = HtmlTableBuilder.setColor(sinkPerm.getPermissionName(), "blue");
            pathContent.append(this.processFlowPathsForStatements(inFlowPath));
            pathContent.append("<ul class=\"list-permission\"><li>" + strSinkPerm + "</li></ul>");
            String col2 = this.generateCol(pathContent.toString());
            row.append(col2);
            ArrayList<String> lstValues = (ArrayList<String>)mapPaths.get(sourcePerm.getPermissionName());
            if (lstValues == null) {
                lstValues = new ArrayList<String>();
                lstValues.add(row.toString());
                mapPaths.put(sourcePerm.getPermissionName(), lstValues);
                continue;
            }
            if (lstValues.contains(row.toString())) continue;
            lstValues.add(row.toString());
        }
        this.addRowForSummary(mapPaths);
    }

    private void computeMethodComparison(Collection<FlowPath> inNewLstPaths, Collection<FlowPath> inRemovedLstPaths) {
        if ((inNewLstPaths == null || inNewLstPaths.isEmpty()) && (inRemovedLstPaths == null || inRemovedLstPaths.isEmpty())) {
            LOGGER.warn("List of found paths is invalid ");
            return;
        }
        Map<String, List<String>> mapNewPaths = this.getMethodComparison(true, inNewLstPaths);
        Map<String, List<String>> mapRemovedPaths = this.getMethodComparison(false, inRemovedLstPaths);
        this.addRowForComparisonVer2(mapNewPaths, mapRemovedPaths);
    }

    private void computeMethodSummary(Collection<FlowPath> inPaths) {
        HashMap<String, List<String>> mapPaths = new HashMap<String, List<String>>();
        for (FlowPath inFlowPath : inPaths) {
            ResourceElement soTran = inFlowPath.getSource();
            ResourceElement siTran = inFlowPath.getSink();
            StringBuilder row = new StringBuilder("");
            StringBuilder pathContent = new StringBuilder("");
            String sourcePerm = HtmlTableBuilder.setColor(soTran.getPermissionName(), "red");
            row.append(this.generateCol(sourcePerm));
            String sinkPerm = HtmlTableBuilder.setColor(siTran.getPermissionName(), "blue");
            pathContent.append(this.processFlowPathsForMethods(inFlowPath));
            pathContent.append("<ul class=\"list-permission\"><li>" + sinkPerm + "</li></ul>");
            String col2 = this.generateCol(pathContent.toString());
            row.append(col2);
            ArrayList<String> lstValues = (ArrayList<String>)mapPaths.get(soTran.getPermissionName());
            if (lstValues == null) {
                lstValues = new ArrayList<String>();
                lstValues.add(row.toString());
                mapPaths.put(soTran.getPermissionName(), lstValues);
                continue;
            }
            if (lstValues.contains(row.toString())) continue;
            lstValues.add(row.toString());
        }
        this.addRowForSummary(mapPaths);
    }

    public String toString() {
        String result = this.mInfoContent.toString();
        result = String.valueOf(result) + this.mTableComponent.toString();
        return result;
    }

    private void initTable(String inAppName) {
        if (!this.mBComparisionMode) {
            String headerAppName = "App's name: " + inAppName;
            this.mTableComponent.append("<table style= \"width:100%\" id=\"level2a\"><tbody>");
            this.mTableComponent.append("<tr><th colspan=\"2\">" + headerAppName + "\t</th></tr>");
            this.mTableComponent.append("<tr class=\"alt\"><th>Source(s)</th><th>Paths (to sinks)</th></tr>");
            this.mTableComponent.append("</tbody></table>");
        } else {
            String headerAppName = "App's name: " + inAppName;
            this.mTableComponent.append("<table style= \"width:100%\" id=\"level2a\"><tbody>");
            this.mTableComponent.append("<tr><th colspan=\"3\">" + headerAppName + "\t</th></tr>");
            this.mTableComponent.append("<tr class=\"alt\"><th>Source(s)</th><th>New paths in new version</th><th>Removed paths from current version</th></tr>");
            this.mTableComponent.append("</tbody></table>");
        }
    }

    private Map<String, List<String>> getStatementComparison(boolean inIsNewPath, Collection<FlowPath> inLstFlowPaths) {
        HashMap<String, List<String>> mapPaths = new HashMap<String, List<String>>();
        for (FlowPath inFlowPath : inLstFlowPaths) {
            ResourceElement soPerm = inFlowPath.getSource();
            ResourceElement siPerm = inFlowPath.getSink();
            StringBuilder row = new StringBuilder("");
            StringBuilder pathContent = new StringBuilder("");
            String sourcePerm = HtmlTableBuilder.setColor(soPerm.getPermissionName(), "red");
            row.append(this.generateCol(sourcePerm));
            String sinkPerm = HtmlTableBuilder.setColor(siPerm.getPermissionName(), "blue");
            pathContent.append(this.processFlowPathsForStatements(inFlowPath));
            pathContent.append("<br/><ul class=\"list-permission\"><li>" + sinkPerm + "</li></ul>");
            String col2 = this.generateCol(pathContent.toString());
            if (inIsNewPath) {
                row.append(col2);
                row.append(this.generateCol(""));
            } else {
                row.append(this.generateCol(""));
                row.append(col2);
            }
            ArrayList<String> lstValues = (ArrayList<String>)mapPaths.get(soPerm.getPermissionName());
            if (lstValues == null) {
                lstValues = new ArrayList<String>();
                lstValues.add(row.toString());
                mapPaths.put(soPerm.getPermissionName(), lstValues);
                continue;
            }
            if (lstValues.contains(row.toString())) continue;
            lstValues.add(row.toString());
        }
        return mapPaths;
    }

    private void processFlowPathsForResource(Collection<FlowPath> inLstFlowPaths, Map<String, List<String>> mapResultPaths) {
        for (FlowPath flow : inLstFlowPaths) {
            ResourceElement sourcePerm = flow.getSource();
            ResourceElement sinkPerm = flow.getSink();
            List<String> lstStrPerms = mapResultPaths.get(sourcePerm.getPermissionName());
            if (lstStrPerms == null) {
                ArrayList<String> newLstPerms = new ArrayList<String>();
                newLstPerms.add(sinkPerm.getPermissionName());
                mapResultPaths.put(sourcePerm.getPermissionName(), newLstPerms);
                continue;
            }
            if (lstStrPerms.contains(sinkPerm.getPermissionName())) continue;
            lstStrPerms.add(sinkPerm.getPermissionName());
        }
    }

    private String processFlowPathsForComponents(FlowPath inFlowPath) {
        String currentClass = "";
        StringBuilder pathContent = new StringBuilder("");
        int iLengthFlowPath = inFlowPath.getLength();
        int i = 1;
        while (i < iLengthFlowPath) {
            String strComp;
            ClassElement ce;
            if (i == iLengthFlowPath - 1) break;
            PathElement pathEle = inFlowPath.getElement(i);
            if (pathEle instanceof ClassElement && (ce = (ClassElement)pathEle).isAndroidComponent() && (strComp = ce.toFullString()) != null && !strComp.isEmpty() && !currentClass.equals(strComp)) {
                currentClass = strComp;
                pathContent.append("<li> " + currentClass + "</li>");
            }
            ++i;
        }
        return pathContent.toString();
    }

    private String processFlowPathsForStatements(FlowPath inFlowPath) {
        int iLengthFlowPath = inFlowPath.getLength();
        String currentClass = "";
        String currentMethod = "";
        StringBuilder pathContent = new StringBuilder("<ul class=\"list-class\">");
        boolean tagClassOpen = false;
        boolean tagMethodOpen = false;
        boolean tagStatementOpent = false;
        int i = 1;
        while (i < iLengthFlowPath - 1) {
            PathElement pathEle = inFlowPath.getElement(i);
            if (pathEle instanceof StatementElement) {
                StatementElement sEle = (StatementElement)pathEle;
                MethodElement mEle = sEle.getMethodElement();
                ClassElement cEle = mEle.getClassElement();
                if (!cEle.getClassName().equals(currentClass)) {
                    if (tagStatementOpent) {
                        pathContent.append("</ul>");
                        tagStatementOpent = false;
                    }
                    if (tagMethodOpen) {
                        pathContent.append("</li>");
                        pathContent.append("</ul>");
                        tagMethodOpen = false;
                    }
                    if (tagClassOpen) {
                        pathContent.append("</li>");
                        tagClassOpen = false;
                    }
                    pathContent.append("<li>" + cEle.getClassName());
                    tagClassOpen = true;
                    pathContent.append("<ul class=\"list-method\">");
                    pathContent.append("<li>" + HtmlTableBuilder.encodeString(mEle.getMethodSubSignature()));
                    tagMethodOpen = true;
                    pathContent.append("<ul class=\"list-statement\">");
                    pathContent.append("<li>" + HtmlTableBuilder.encodeString(sEle.toString()) + "</li>");
                    tagStatementOpent = true;
                    currentClass = cEle.getClassName();
                    currentMethod = mEle.getMethodSubSignature();
                } else if (!mEle.getMethodSubSignature().equals(currentMethod)) {
                    if (tagStatementOpent) {
                        pathContent.append("</ul>");
                        tagStatementOpent = false;
                    }
                    if (tagMethodOpen) {
                        pathContent.append("</li>");
                        pathContent.append("</ul>");
                        tagMethodOpen = false;
                    }
                    pathContent.append("<ul class=\"list-method\">");
                    pathContent.append("<li>" + HtmlTableBuilder.encodeString(mEle.getMethodSubSignature()));
                    tagMethodOpen = true;
                    pathContent.append("<ul class=\"list-statement\">");
                    pathContent.append("<li>" + HtmlTableBuilder.encodeString(sEle.toString()) + "</li>");
                    tagStatementOpent = true;
                    currentMethod = mEle.getMethodSubSignature();
                } else {
                    pathContent.append("<li>" + HtmlTableBuilder.encodeString(sEle.toString()) + "</li>");
                    tagStatementOpent = true;
                }
            }
            ++i;
        }
        if (tagStatementOpent) {
            pathContent.append("</ul>");
            tagStatementOpent = false;
        }
        if (tagMethodOpen) {
            pathContent.append("</li>");
            pathContent.append("</ul>");
            tagMethodOpen = false;
        }
        if (tagClassOpen) {
            pathContent.append("</li>");
            pathContent.append("</ul>");
            tagClassOpen = false;
        }
        return pathContent.toString();
    }

    private String processFlowPathsForMethods(FlowPath inFlowPath) {
        int iLengthFlowPath = inFlowPath.getLength();
        String currentClass = "";
        String currentMethod = "";
        StringBuilder pathContent = new StringBuilder("<ul class=\"list-class\">");
        boolean tagClassOpen = false;
        boolean tagMethodOpen = false;
        int i = 1;
        while (i < iLengthFlowPath - 1) {
            PathElement pathEle = inFlowPath.getElement(i);
            if (pathEle instanceof MethodElement) {
                MethodElement mEle = (MethodElement)pathEle;
                ClassElement cEle = mEle.getClassElement();
                if (!cEle.getClassName().equals(currentClass)) {
                    if (tagMethodOpen) {
                        pathContent.append("</li>");
                        pathContent.append("</ul>");
                        tagMethodOpen = false;
                    }
                    if (tagClassOpen) {
                        pathContent.append("</li>");
                        tagClassOpen = false;
                    }
                    pathContent.append("<li>" + cEle.getClassName());
                    tagClassOpen = true;
                    pathContent.append("<ul class=\"list-method\">");
                    pathContent.append("<li>" + HtmlTableBuilder.encodeString(mEle.getMethodSubSignature()));
                    tagMethodOpen = true;
                    currentClass = cEle.getClassName();
                    currentMethod = mEle.getMethodSubSignature();
                } else if (!mEle.getMethodSubSignature().equals(currentMethod)) {
                    if (tagMethodOpen) {
                        pathContent.append("</li>");
                        pathContent.append("</ul>");
                        tagMethodOpen = false;
                    }
                    pathContent.append("<ul class=\"list-method\">");
                    pathContent.append("<li>" + HtmlTableBuilder.encodeString(mEle.getMethodSubSignature()));
                    tagMethodOpen = true;
                    currentMethod = mEle.getMethodSubSignature();
                }
            }
            ++i;
        }
        if (tagMethodOpen) {
            pathContent.append("</li>");
            pathContent.append("</ul>");
            tagMethodOpen = false;
        }
        if (tagClassOpen) {
            pathContent.append("</li>");
            pathContent.append("</ul>");
            tagClassOpen = false;
        }
        return pathContent.toString();
    }

    private void addRowForSummary(Map<String, List<String>> inMapNewPaths) {
        Set<String> keyPerms = inMapNewPaths.keySet();
        for (String perm : keyPerms) {
            List<String> setEntries = inMapNewPaths.get(perm);
            for (String strRow : setEntries) {
                int iPost = this.mTableComponent.indexOf("</tbody>");
                this.mTableComponent.insert(iPost, this.generateRow(strRow));
            }
        }
    }

    private void addRowForComparisonVer2(Map<String, List<String>> inMapNewPaths, Map<String, List<String>> inMapRemovedPaths) {
        int iPost;
        ArrayList<String> lstCheckedPermission = new ArrayList<String>();
        Set<String> keyPerms = inMapNewPaths.keySet();
        for (String perm : keyPerms) {
            List<String> lstNewEntries = inMapNewPaths.get(perm);
            List<String> lstRemovedEntries = inMapRemovedPaths.get(perm);
            for (String newPath : lstNewEntries) {
                iPost = this.mTableComponent.indexOf("</tbody>");
                this.mTableComponent.insert(iPost, this.generateRow(newPath));
            }
            if (lstRemovedEntries == null) continue;
            lstCheckedPermission.add(perm);
            for (String removedPath : lstRemovedEntries) {
                iPost = this.mTableComponent.indexOf("</tbody>");
                this.mTableComponent.insert(iPost, this.generateRow(removedPath));
            }
        }
        Set<String> keyRemovedPerms = inMapRemovedPaths.keySet();
        for (String removedPerm : keyRemovedPerms) {
            if (lstCheckedPermission.contains(removedPerm)) continue;
            List<String> lstRemovedPaths = inMapRemovedPaths.get(removedPerm);
            for (String removedPath : lstRemovedPaths) {
                iPost = this.mTableComponent.indexOf("</tbody>");
                this.mTableComponent.insert(iPost, this.generateRow(removedPath));
            }
        }
    }

    private Map<String, List<String>> getComponentComparison(boolean inIsNewPath, Collection<FlowPath> inLstFlowPaths) {
        HashMap<String, List<String>> mapResults = new HashMap<String, List<String>>();
        for (FlowPath inFlowPath : inLstFlowPaths) {
            ResourceElement soPerm = inFlowPath.getSource();
            ResourceElement siPerm = inFlowPath.getSink();
            StringBuilder row = new StringBuilder("");
            StringBuilder pathContent = new StringBuilder("");
            pathContent.append("<ul class=\"list-class\">");
            String sourcePerm = HtmlTableBuilder.setColor(soPerm.getPermissionName(), "red");
            row.append(this.generateCol(sourcePerm));
            String sinkPerm = HtmlTableBuilder.setColor(siPerm.getPermissionName(), "blue");
            String flowPath = this.processFlowPathsForComponents(inFlowPath);
            if (!flowPath.contains("<li>")) continue;
            pathContent.append(flowPath);
            pathContent.append("</ul>");
            pathContent.append("<ul class=\"list-permission\"><li>" + sinkPerm + "</li></ul>");
            String col2 = this.generateCol(pathContent.toString());
            if (inIsNewPath) {
                row.append(col2);
                row.append(this.generateCol(""));
            } else {
                row.append(this.generateCol(""));
                row.append(col2);
            }
            ArrayList<String> lstValues = (ArrayList<String>)mapResults.get(soPerm.getPermissionName());
            if (lstValues == null) {
                lstValues = new ArrayList<String>();
                lstValues.add(row.toString());
                mapResults.put(soPerm.getPermissionName(), lstValues);
                continue;
            }
            if (lstValues.contains(row.toString())) continue;
            lstValues.add(row.toString());
        }
        return mapResults;
    }

    private static String setColor(String inContent, String inColor) {
        StringBuilder strBuilder = new StringBuilder("<font color=\"" + inColor + "\">" + inContent + "</font>");
        return strBuilder.toString();
    }

    private static String generateItem(String inContent) {
        StringBuilder strBuilder = new StringBuilder("<li>");
        strBuilder.append(inContent);
        strBuilder.append("</li>");
        return strBuilder.toString();
    }

    private String generateCol(String inContent) {
        StringBuilder col = new StringBuilder("<td>");
        col.append(inContent);
        col.append("</td>");
        return col.toString();
    }

    private String generateRow(String inContent) {
        StringBuilder row = new StringBuilder("");
        if (this.mBHighLineRow) {
            row.append("<tr class=\"alt\">");
            this.mBHighLineRow = false;
        } else {
            row.append("<tr>");
            this.mBHighLineRow = true;
        }
        row.append(inContent);
        row.append("</tr>");
        return row.toString();
    }

    private static String encodeString(String inContent) {
        if (inContent != null) {
            inContent = inContent.replace("<", "&lt;");
            inContent = inContent.replace(">", "&gt;");
            return inContent;
        }
        return "";
    }

    void addRow(List<String> inLstStrContent) {
        if (inLstStrContent != null && !inLstStrContent.isEmpty()) {
            StringBuilder column = new StringBuilder("");
            StringBuilder lstFlow = new StringBuilder("<ul class= \"list-permission\">");
            int minSize = Math.min(this.mIntCols, inLstStrContent.size());
            int i = 0;
            while (i < minSize) {
                String inContent = inLstStrContent.get(i);
                if (i == 0) {
                    inContent = HtmlTableBuilder.setColor(inContent, "red");
                    column.append(this.generateCol(inContent));
                } else if (i == minSize - 1) {
                    lstFlow.append(HtmlTableBuilder.setColor(HtmlTableBuilder.generateItem(inContent), "blue"));
                } else {
                    lstFlow.append(HtmlTableBuilder.generateItem(inContent));
                }
                ++i;
            }
            lstFlow.append("</ul>");
            String col2 = this.generateCol(lstFlow.toString());
            column.append(col2);
            int iPost = this.mTableComponent.indexOf("</tbody>");
            this.mTableComponent.insert(iPost, this.generateRow(column.toString()));
        }
    }

    private Map<String, List<String>> getMethodComparison(boolean inIsNewPath, Collection<FlowPath> inLstFlowPaths) {
        HashMap<String, List<String>> mapPaths = new HashMap<String, List<String>>();
        for (FlowPath inFlowPath : inLstFlowPaths) {
            int iLengthFlowPath = inFlowPath.getLength();
            ResourceElement soPerm = inFlowPath.getSource();
            ResourceElement siPerm = inFlowPath.getSink();
            StringBuilder row = new StringBuilder("");
            StringBuilder pathContent = new StringBuilder("");
            String sourcePerm = HtmlTableBuilder.setColor(soPerm.getPermissionName(), "red");
            row.append(this.generateCol(sourcePerm));
            String sinkPerm = HtmlTableBuilder.setColor(siPerm.getPermissionName(), "blue");
            pathContent.append(this.processFlowPathsForMethods(inFlowPath));
            pathContent.append("<br/><ul class=\"list-permission\"><li>" + sinkPerm + "</li></ul>");
            String col2 = this.generateCol(pathContent.toString());
            if (inIsNewPath) {
                row.append(col2);
                row.append(this.generateCol(""));
            } else {
                row.append(this.generateCol(""));
                row.append(col2);
            }
            ArrayList<String> lstValues = (ArrayList<String>)mapPaths.get(soPerm.getPermissionName());
            if (lstValues == null) {
                lstValues = new ArrayList<String>();
                lstValues.add(row.toString());
                mapPaths.put(soPerm.getPermissionName(), lstValues);
                continue;
            }
            if (lstValues.contains(row.toString())) continue;
            lstValues.add(row.toString());
        }
        return mapPaths;
    }
}

