/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl2a.analyzer;

import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.core.services.CoreServices;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.internal.AbstractInvokeExpr;
import soot.jimple.internal.JInvokeStmt;

public class SourceAndSinkComputer {
    public Map<Permission, List<Unit>> computeSources(List<Unit> inLstStm, EnhancedInput inp) {
        if (inLstStm != null && !inLstStm.isEmpty()) {
            HashMap<Permission, List<Unit>> mapOfSources = new HashMap<Permission, List<Unit>>();
            for (Unit unit : inLstStm) {
                Stmt stmt = (Stmt)unit;
                if (stmt instanceof JInvokeStmt && stmt.containsInvokeExpr()) {
                    Object colPerms;
                    JInvokeStmt invokeStmt = (JInvokeStmt)unit;
                    InvokeExpr invExp = invokeStmt.getInvokeExpr();
                    if (invExp == null || invExp.getMethod() == null) continue;
                    String signature = invExp.getMethod().getSignature();
                    if (signature.contains("void setResult(int,android.content.Intent)") || signature.contains("void setResult(int)")) {
                        SootMethod smethod;
                        SootClass sclass;
                        Body body = inp.getBodyForUnit(unit);
                        if (body == null || !inp.isAndroidComponent(sclass = (smethod = body.getMethod()).getDeclaringClass()) || (colPerms = inp.getPermissionsFor(sclass)) == null) continue;
                        Iterator iterator = colPerms.iterator();
                        while (iterator.hasNext()) {
                            Permission perm = (Permission)iterator.next();
                            ArrayList<Unit> lstUnits = (ArrayList<Unit>)mapOfSources.get(perm);
                            if (lstUnits == null) {
                                lstUnits = new ArrayList<Unit>();
                                lstUnits.add(unit);
                                mapOfSources.put(perm, lstUnits);
                                continue;
                            }
                            lstUnits.add(unit);
                        }
                        continue;
                    }
                    String className = invExp.getMethod().getDeclaringClass().getName();
                    boolean isSource = CoreServices.getDataStorageInstance().isSource(className, signature);
                    if (!isSource) continue;
                    colPerms = inp.getPermissionsFor(unit).iterator();
                    while (colPerms.hasNext()) {
                        Permission permission = (Permission)colPerms.next();
                        ArrayList<Unit> lstUnits = (ArrayList<Unit>)mapOfSources.get(permission);
                        if (lstUnits == null) {
                            lstUnits = new ArrayList<Unit>();
                            lstUnits.add(unit);
                            mapOfSources.put(permission, lstUnits);
                            continue;
                        }
                        lstUnits.add(unit);
                    }
                    continue;
                }
                List<ValueBox> valueBoxes = stmt.getUseBoxes();
                if (valueBoxes == null || valueBoxes.isEmpty()) continue;
                for (ValueBox valueBox : valueBoxes) {
                    AbstractInvokeExpr expr;
                    Value value = valueBox.getValue();
                    if (!(value instanceof AbstractInvokeExpr) || (expr = (AbstractInvokeExpr)value).getMethod() == null) continue;
                    String signature = expr.getMethod().getSignature();
                    String className = expr.getMethod().getDeclaringClass().getName();
                    boolean isSource = CoreServices.getDataStorageInstance().isSource(className, signature);
                    if (!isSource) continue;
                    for (Permission permission : inp.getPermissionsFor(unit)) {
                        ArrayList<Unit> lstUnits = (ArrayList<Unit>)mapOfSources.get(permission);
                        if (lstUnits == null) {
                            lstUnits = new ArrayList<Unit>();
                            lstUnits.add(unit);
                            mapOfSources.put(permission, lstUnits);
                            continue;
                        }
                        lstUnits.add(unit);
                    }
                }
            }
            return mapOfSources;
        }
        return null;
    }

    public Map<Permission, List<Unit>> computeSinks(List<Unit> inLstStm, EnhancedInput inp) {
        if (inLstStm != null && !inLstStm.isEmpty()) {
            HashMap<Permission, List<Unit>> mapOfSinks = new HashMap<Permission, List<Unit>>();
            for (Unit unit : inLstStm) {
                Stmt stmnt = (Stmt)unit;
                if (stmnt instanceof JInvokeStmt && stmnt.containsInvokeExpr()) {
                    JInvokeStmt invokeStmt = (JInvokeStmt)unit;
                    InvokeExpr invExp = invokeStmt.getInvokeExpr();
                    if (invExp == null || invExp.getMethod() == null) continue;
                    String signature = invExp.getMethod().getSignature();
                    String className = invExp.getMethod().getDeclaringClass().getName();
                    boolean isSink = CoreServices.getDataStorageInstance().isSink(className, signature);
                    if (!isSink) continue;
                    for (Permission permission : inp.getPermissionsFor(unit)) {
                        ArrayList<Unit> lstUnits = (ArrayList<Unit>)mapOfSinks.get(permission);
                        if (lstUnits == null) {
                            lstUnits = new ArrayList<Unit>();
                            lstUnits.add(unit);
                            mapOfSinks.put(permission, lstUnits);
                            continue;
                        }
                        lstUnits.add(unit);
                    }
                    continue;
                }
                List<ValueBox> valueBoxes = stmnt.getUseBoxes();
                if (valueBoxes == null || valueBoxes.isEmpty()) continue;
                for (ValueBox valueBox : valueBoxes) {
                    AbstractInvokeExpr expr;
                    Value value = valueBox.getValue();
                    if (!(value instanceof AbstractInvokeExpr) || (expr = (AbstractInvokeExpr)value).getMethod() == null) continue;
                    String signature = expr.getMethod().getSignature();
                    String className = expr.getMethod().getDeclaringClass().getName();
                    boolean isSink = CoreServices.getDataStorageInstance().isSink(className, signature);
                    if (!isSink) continue;
                    for (Permission permission : inp.getPermissionsFor(unit)) {
                        ArrayList<Unit> lstUnits = (ArrayList<Unit>)mapOfSinks.get(permission);
                        if (lstUnits == null) {
                            lstUnits = new ArrayList<Unit>();
                            lstUnits.add(unit);
                            mapOfSinks.put(permission, lstUnits);
                            continue;
                        }
                        lstUnits.add(unit);
                    }
                }
            }
            return mapOfSinks;
        }
        return null;
    }
}

