/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl2a.graphgenerator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import soot.Body;
import soot.Local;
import soot.MethodOrMethodContext;
import soot.RefType;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.SmartLocalDefs;
import soot.util.queue.QueueReader;

public final class CallBackAnalyser
extends SceneTransformer {
    private final String sysClassAnd = "android.";
    private final String sysClassJava = "java.";
    private Set<String> androidCallBacks = new HashSet<String>();
    private Set<String> entryPointClasses = new HashSet<String>();
    private final Map<String, List<SootMethod>> callBackMethods = new HashMap<String, List<SootMethod>>();
    private final Map<String, List<Integer>> actvtyLayoutMap = new HashMap<String, List<Integer>>();
    public static CallBackAnalyser Instance = new CallBackAnalyser();

    public void setInputs(Set<String> androidCallBacks, Set<String> entryPointClasses) {
        this.androidCallBacks = androidCallBacks;
        this.entryPointClasses = entryPointClasses;
    }

    public static CallBackAnalyser getInstance() {
        return Instance;
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        for (String clName : this.entryPointClasses) {
            SootClass sclass = Scene.v().getSootClass(clName);
            this.getLayoutIDs();
            ArrayList<MethodOrMethodContext> methods = new ArrayList<MethodOrMethodContext>();
            methods.addAll(sclass.getMethods());
            this.analyseReachableMethods(sclass, methods);
            this.methodOverRideCallBackAnalysis(sclass);
        }
    }

    private void getLayoutIDs() {
        for (String className : this.entryPointClasses) {
            SootClass sclass = Scene.v().getSootClass(className);
            Iterator<SootMethod> methodsIt = sclass.getMethods().iterator();
            while (methodsIt.hasNext()) {
                SootMethod sMethod = methodsIt.next().method();
                SootClass declaringClass = sMethod.getDeclaringClass();
                if (!sMethod.isConcrete()) continue;
                for (Unit u : sMethod.retrieveActiveBody().getUnits()) {
                    InvokeExpr iExpr;
                    Stmt stmnt;
                    if (!(u instanceof Stmt) || !(stmnt = (Stmt)u).containsInvokeExpr() || !this.isViewInvoked(iExpr = stmnt.getInvokeExpr())) continue;
                    for (Value v : iExpr.getArgs()) {
                        if (!(v instanceof IntConstant)) continue;
                        IntConstant intVal = (IntConstant)v;
                        if (this.actvtyLayoutMap.containsKey(declaringClass.getName())) {
                            this.actvtyLayoutMap.get(declaringClass.getName()).add(intVal.value);
                            continue;
                        }
                        ArrayList<Integer> layoutIds = new ArrayList<Integer>();
                        layoutIds.add(intVal.value);
                        this.actvtyLayoutMap.put(declaringClass.getName(), layoutIds);
                    }
                }
            }
        }
    }

    private boolean isViewInvoked(InvokeExpr iExpr) {
        SootMethod invkdMethod = iExpr.getMethod();
        if (invkdMethod.getName().equals("setContentView")) {
            return true;
        }
        SootClass curClass = iExpr.getMethod().getDeclaringClass();
        while (curClass != null) {
            if (curClass.getName().equals("android.app.Activity") || curClass.getName().equals("android.support.v7.app.ActionBarActivity")) {
                return true;
            }
            if (curClass.declaresMethod("void setContentView(int)")) {
                return true;
            }
            SootClass sootClass = curClass = curClass.hasSuperclass() ? curClass.getSuperclass() : null;
        }
        return false;
    }

    private void methodOverRideCallBackAnalysis(SootClass sclass) {
        if (!sclass.isConcrete() || sclass.isInterface() || this.isSystemClass(sclass.getName())) {
            return;
        }
        HashSet<String> systemMethods = new HashSet<String>();
        for (SootClass parentClass : Scene.v().getActiveHierarchy().getSuperclassesOf(sclass)) {
            if (!this.isSystemClass(parentClass.getName())) continue;
            for (SootMethod sm : parentClass.getMethods()) {
                if (sm.isConstructor()) continue;
                systemMethods.add(sm.getSubSignature());
            }
        }
        for (SootClass parentClass : Scene.v().getActiveHierarchy().getSubclassesOfIncluding(sclass)) {
            if (parentClass.getName().startsWith("android.")) continue;
            for (SootMethod method : parentClass.getMethods()) {
                if (!systemMethods.contains(method.getSubSignature())) continue;
                this.checkAndAddMethod(method, sclass);
            }
        }
    }

    private boolean isSystemClass(String name) {
        return name.startsWith("android.") || name.startsWith("java.") || name.startsWith("sun.") || name.startsWith("com.google.");
    }

    private void analyseReachableMethods(SootClass sclass, List<MethodOrMethodContext> methods) {
        ReachableMethods recMeth = new ReachableMethods(Scene.v().getCallGraph(), methods);
        recMeth.update();
        QueueReader<MethodOrMethodContext> recMethIt = recMeth.listener();
        while (recMethIt.hasNext()) {
            SootMethod smethod = ((MethodOrMethodContext)recMethIt.next()).method();
            this.callBackRegistrationAnalysis(sclass, smethod);
        }
    }

    private void callBackRegistrationAnalysis(SootClass lifecycleClass, SootMethod smethod) {
        if (smethod.getDeclaringClass().getName().startsWith("android.") || smethod.getDeclaringClass().getName().startsWith("java.") || !smethod.isConcrete()) {
            return;
        }
        ExceptionalUnitGraph graph = new ExceptionalUnitGraph(smethod.retrieveActiveBody());
        SmartLocalDefs smd = new SmartLocalDefs(graph, new SimpleLiveLocals(graph));
        HashSet<SootClass> callbackClasses = new HashSet<SootClass>();
        for (Unit u : smethod.retrieveActiveBody().getUnits()) {
            Stmt stmt = (Stmt)u;
            if (!stmt.containsInvokeExpr() || !(stmt.getInvokeExpr() instanceof InstanceInvokeExpr)) continue;
            InstanceInvokeExpr iinv = (InstanceInvokeExpr)stmt.getInvokeExpr();
            String[] parameters = this.parseParmaetersFromSubSignature(iinv.getMethodRef().getSubSignature().getString());
            int i = 0;
            while (i < parameters.length) {
                Value arg;
                String param = parameters[i];
                if (this.androidCallBacks.contains(param) && (arg = iinv.getArg(i)).getType() instanceof RefType && arg instanceof Local) {
                    for (Unit def : smd.getDefsOfAt((Local)arg, u)) {
                        assert (def instanceof DefinitionStmt);
                        Type type = ((DefinitionStmt)def).getRightOp().getType();
                        if (!(type instanceof RefType)) continue;
                        SootClass callbackClass = ((RefType)type).getSootClass();
                        if (callbackClass.isInterface()) {
                            for (SootClass impl : Scene.v().getActiveHierarchy().getImplementersOf(callbackClass)) {
                                for (SootClass c : Scene.v().getActiveHierarchy().getSubclassesOfIncluding(impl)) {
                                    callbackClasses.add(c);
                                }
                            }
                            continue;
                        }
                        for (SootClass c : Scene.v().getActiveHierarchy().getSubclassesOfIncluding(callbackClass)) {
                            callbackClasses.add(c);
                        }
                    }
                }
                ++i;
            }
        }
        for (SootClass sClass : callbackClasses) {
            this.analyzeSootClass(sClass, lifecycleClass);
        }
    }

    private void analyzeSootClass(SootClass sClass, SootClass lifecycleClass) {
        if (sClass.getName().startsWith("android.") || sClass.getName().startsWith("java.")) {
            return;
        }
        this.checkForCallBackInterfaces(sClass, sClass, lifecycleClass);
    }

    private void checkForCallBackInterfaces(SootClass baseClass, SootClass sClass, SootClass lifecycleClass) {
        if (!baseClass.isConcrete() || baseClass.getName().startsWith("android.")) {
            return;
        }
        if (sClass.hasSuperclass()) {
            this.checkForCallBackInterfaces(baseClass, sClass.getSuperclass(), lifecycleClass);
        }
        for (SootClass i : this.collectAllInterfaces(sClass)) {
            if (!this.androidCallBacks.contains(i.getName())) continue;
            for (SootMethod sMethod : i.getMethods()) {
                this.checkAndAddMethod(this.getMethodFromHierarchyEx(baseClass, sMethod.getSubSignature()), lifecycleClass);
            }
        }
    }

    private void checkAndAddMethod(SootMethod sootmethod, SootClass lifecycleClass) {
        if (sootmethod.getDeclaringClass().getName().startsWith("android.") || sootmethod.getDeclaringClass().getName().startsWith("java.")) {
            return;
        }
        if (sootmethod.isConcrete() && this.isEmpty(sootmethod.retrieveActiveBody())) {
            return;
        }
        if (this.callBackMethods.containsKey(lifecycleClass.getName())) {
            this.callBackMethods.get(lifecycleClass.getName()).add(sootmethod);
        } else {
            ArrayList<SootMethod> methods = new ArrayList<SootMethod>();
            methods.add(sootmethod);
            this.callBackMethods.put(lifecycleClass.getName(), methods);
        }
    }

    private SootMethod getMethodFromHierarchyEx(SootClass baseClass, String subSignature) {
        if (baseClass.declaresMethod(subSignature)) {
            return baseClass.getMethod(subSignature);
        }
        if (baseClass.hasSuperclass()) {
            return this.getMethodFromHierarchyEx(baseClass.getSuperclass(), subSignature);
        }
        throw new RuntimeException("Could not find method");
    }

    private Set<SootClass> collectAllInterfaces(SootClass sClass) {
        HashSet<SootClass> interfaces = new HashSet<SootClass>(sClass.getInterfaces());
        for (SootClass i : sClass.getInterfaces()) {
            interfaces.addAll(this.collectAllInterfaces(i));
        }
        return interfaces;
    }

    private String[] parseParmaetersFromSubSignature(String subSignature) {
        Matcher matcher;
        Pattern pattSubsigToName = null;
        if (pattSubsigToName == null) {
            Pattern pattern;
            pattSubsigToName = pattern = Pattern.compile("^\\s*(.+)\\s+(.+)\\((.*?)\\)\\s*$");
        }
        if (!(matcher = pattSubsigToName.matcher(subSignature)).find() || matcher.groupCount() < 3) {
            return null;
        }
        String params = matcher.group(3);
        return params.split("\\s*,\\s*");
    }

    private boolean isEmpty(Body activeBody) {
        for (Unit u : activeBody.getUnits()) {
            if (u instanceof IdentityStmt || u instanceof ReturnVoidStmt) continue;
            return false;
        }
        return true;
    }

    public Map<String, List<SootMethod>> getCallBackMethods() {
        return this.callBackMethods;
    }

    public Map<String, List<Integer>> getActivityLayoutIDMap() {
        return this.actvtyLayoutMap;
    }
}

