/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl2a.graphgenerator;

import de.upb.pga3.panda2.core.SootAdapter;
import de.upb.pga3.panda2.core.services.ARSCParser;
import de.upb.pga3.panda2.core.services.CoreServices;
import de.upb.pga3.panda2.core.services.XMLLayoutParser;
import de.upb.pga3.panda2.extension.lvl2a.graphgenerator.CallBackAnalyser;
import de.upb.pga3.panda2.utilities.Constants;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.SootClass;
import soot.SootMethod;
import soot.Transform;
import soot.Type;
import soot.Value;
import soot.VoidType;
import soot.dava.internal.javaRep.DIntConstant;
import soot.javaToJimple.LocalGenerator;
import soot.jimple.AssignStmt;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.LongConstant;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NullConstant;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.toolkits.scalar.NopEliminator;
import soot.options.Options;

public class DummyMain {
    private static final Logger LOGGER = LogManager.getLogger(DummyMain.class);
    private final Set<String> entryPoints = new HashSet<String>();
    private SootMethod mainMethod;
    private LocalGenerator generator;
    private JimpleBody body;
    private final String dummyClassName = "dummyMainClass";
    private final String dummyMethodName = "dummyMain";
    SootClass applicationClass = null;
    private final Set<SootClass> failedClasses = new HashSet<SootClass>();
    private final Map<String, Local> localVarClass = new HashMap<String, Local>();
    private final Set<SootMethod> failedMethods = new HashSet<SootMethod>();
    private final Set<SootClass> applCallbkClasses = new HashSet<SootClass>();
    private Local applicationLocal = null;
    private Map<String, List<SootMethod>> callbackFunctions = new HashMap<String, List<SootMethod>>();
    private Map<String, List<Integer>> actvtyLyoutMap = new HashMap<String, List<Integer>>();
    private Map<String, List<String>> layoutCallbackMap = new HashMap<String, List<String>>();
    private static final boolean DEBUG = false;

    public SootMethod initialize() {
        this.getEntryPoints();
        Set<String> androidCallBacks = CoreServices.getDataStorageInstance().getCallBackClasses();
        CallBackAnalyser cbAny = CallBackAnalyser.getInstance();
        cbAny.setInputs(androidCallBacks, this.entryPoints);
        SootAdapter.getInstance().addTransformer(new Transform("wjtp.callbkanly", cbAny), SootAdapter.SootPhase.WJTP);
        XMLLayoutParser layoutParser = CoreServices.getXMLParserInstance().getLayoutParser();
        ARSCParser arscParser = CoreServices.getXMLParserInstance().getArscParser();
        SootAdapter.getInstance().addTransformer(new Transform("wjtp.layoutpars", layoutParser), SootAdapter.SootPhase.WJTP);
        SootAdapter.getInstance().run(SootAdapter.SootPhase.WJTP);
        this.callbackFunctions = cbAny.getCallBackMethods();
        this.actvtyLyoutMap = cbAny.getActivityLayoutIDMap();
        this.layoutCallbackMap = layoutParser.getLayoutCallbackMethods();
        this.addlayoutCallBackMethods(arscParser);
        SootMethod emptyMain = this.createDummyMain(Jimple.v().newBody());
        this.mainMethod = this.createMainBody(emptyMain);
        return this.mainMethod;
    }

    private void getEntryPoints() {
        List<String> lstActivities = CoreServices.getXMLParserInstance().getLstActivities();
        List<String> lstProviders = CoreServices.getXMLParserInstance().getLstProviders();
        List<String> lstReceivers = CoreServices.getXMLParserInstance().getLstReceivers();
        List<String> lstServices = CoreServices.getXMLParserInstance().getLstServices();
        if (lstActivities != null) {
            for (String actName : lstActivities) {
                this.entryPoints.add(actName);
            }
        }
        if (lstProviders != null) {
            for (String proName : lstProviders) {
                this.entryPoints.add(proName);
            }
        }
        if (lstReceivers != null) {
            for (String recName : lstReceivers) {
                this.entryPoints.add(recName);
            }
        }
        if (lstServices != null) {
            for (String serName : lstServices) {
                this.entryPoints.add(serName);
            }
        }
    }

    private SootMethod createDummyMain(Body mainBody) {
        SootClass dummyClass = new SootClass("dummyMainClass");
        Scene.v().addClass(dummyClass);
        dummyClass.setApplicationClass();
        ArrayType stringArrayType = ArrayType.v(RefType.v("java.lang.String"), 1);
        SootMethod dummyMain = new SootMethod("dummyMain", Collections.singletonList(stringArrayType), VoidType.v(), 9);
        mainBody.setMethod(dummyMain);
        dummyMain.setActiveBody(mainBody);
        dummyClass.addMethod(dummyMain);
        LocalGenerator locgen = new LocalGenerator(mainBody);
        Local paramLocal = locgen.generateLocal(stringArrayType);
        mainBody.getUnits().addFirst(Jimple.v().newIdentityStmt(paramLocal, Jimple.v().newParameterRef(stringArrayType, 0)));
        dummyClass.setApplicationClass();
        return dummyMain;
    }

    private SootMethod createMainBody(SootMethod emptySootMethod) {
        SootClass currentClass;
        this.mainMethod = emptySootMethod;
        this.body = (JimpleBody)this.mainMethod.getActiveBody();
        this.generator = new LocalGenerator(this.body);
        for (String className : this.entryPoints) {
            Scene.v().forceResolve(className, 2);
        }
        for (String sootClassName : this.entryPoints) {
            currentClass = Scene.v().getSootClass(sootClassName);
            if (this.getComponentType(currentClass) != componentType.ContentProvider) continue;
            Local contentLoc = this.generateClassConstructor(currentClass, this.body);
            if (contentLoc == null) {
                LOGGER.warn("Unable to create constructor for {}", currentClass.getName());
            } else {
                this.localVarClass.put(currentClass.getName(), contentLoc);
            }
            SootMethod currentMethod = this.findMethod(currentClass, "boolean onCreate()");
            this.buildMethodCall(currentMethod, this.body, contentLoc, this.generator);
        }
        block8: for (String className : this.entryPoints) {
            currentClass = Scene.v().getSootClass(className);
            List<SootClass> parentClasses = Scene.v().getActiveHierarchy().getSuperclassesOf(currentClass);
            for (SootClass sClass : parentClasses) {
                if (!sClass.getName().contains("android.app.Application")) continue;
                if (this.applicationClass != null) {
                    throw new RuntimeException("App has multiple application classes");
                }
                this.applicationClass = currentClass;
                this.applCallbkClasses.add(currentClass);
                this.applicationLocal = this.generateClassConstructor(this.applicationClass, this.body);
                if (this.applicationLocal == null) {
                    LOGGER.warn("Constructor cannot be created for {}", this.applicationClass);
                } else {
                    this.localVarClass.put(this.applicationClass.getName(), this.applicationLocal);
                }
                if (!this.callbackFunctions.containsKey(this.applicationClass.getName())) continue;
                for (SootMethod callBackfn : this.callbackFunctions.get(this.applicationClass.getName())) {
                    String callBackClass = callBackfn.getDeclaringClass().getName();
                    Local loc = this.localVarClass.get(callBackClass);
                    if (loc != null) continue;
                    SootClass sClass1 = Scene.v().getSootClass(callBackClass);
                    this.applCallbkClasses.add(sClass1);
                    loc = this.generateClassConstructor(sClass1, this.body, Collections.singleton(this.applicationClass));
                    if (loc != null) {
                        this.localVarClass.put(callBackClass, loc);
                        continue;
                    }
                    LOGGER.warn("Unable to create constructor for {}", callBackClass);
                }
                this.searchAndBuildMethod("void onCreate()", this.applicationClass, this.entryPoints, this.applicationLocal);
                continue block8;
            }
        }
        for (String className : this.entryPoints) {
            currentClass = Scene.v().getSootClass(className);
            currentClass.setApplicationClass();
            componentType componentType2 = this.getComponentType(currentClass);
            if (!this.localVarClass.containsKey(currentClass.getName())) {
                Local localVal = this.generateClassConstructor(currentClass, this.body);
                if (localVal == null) {
                    LOGGER.warn("Constructor not created for {} ", currentClass.getName());
                } else {
                    this.localVarClass.put(currentClass.getName(), localVal);
                }
            }
            Local classLocal = this.localVarClass.get(currentClass.getName());
            switch (componentType2) {
                case Activity: {
                    this.generateActivityLifecycle(this.entryPoints, currentClass, classLocal);
                    break;
                }
                case Service: {
                    this.generateServiceLifecycle(this.entryPoints, currentClass, classLocal);
                    break;
                }
                case BroadcastReceiver: {
                    this.generateBroadcastReceiverLifecycle(this.entryPoints, currentClass, classLocal);
                    break;
                }
                case ContentProvider: {
                    this.generateContentProviderLifecycle(this.entryPoints, currentClass, classLocal);
                    break;
                }
            }
        }
        this.body.getUnits().add(Jimple.v().newReturnVoidStmt());
        NopEliminator.v().transform(this.body);
        if (Options.v().validate()) {
            this.mainMethod.getActiveBody().validate();
        }
        return this.mainMethod;
    }

    private componentType getComponentType(SootClass sClass) {
        componentType cType = componentType.Dummy;
        List<SootClass> superClasses = Scene.v().getActiveHierarchy().getSuperclassesOf(sClass);
        Iterator<SootClass> iterator = superClasses.iterator();
        if (iterator.hasNext()) {
            SootClass superClass = iterator.next();
            String superClassName = superClass.getName();
            cType = superClassName.contains("Activity") ? componentType.Activity : (superClassName.contains("Service") ? componentType.Service : (superClassName.contains("ContentProvider") ? componentType.ContentProvider : (superClassName.contains("BroadcastReceiver") ? componentType.BroadcastReceiver : componentType.Dummy)));
        }
        return cType;
    }

    private Local generateClassConstructor(SootClass createdClass, Body body) {
        return this.generateClassConstructor(createdClass, body, new HashSet<SootClass>(), Collections.emptySet());
    }

    private Local generateClassConstructor(SootClass createdClass, Body body, Set<SootClass> parentClasses) {
        return this.generateClassConstructor(createdClass, body, new HashSet<SootClass>(), parentClasses);
    }

    private Local generateClassConstructor(SootClass createdClass, Body body, Set<SootClass> constructionStack, Set<SootClass> parentClasses) {
        String outerClass;
        if (createdClass == null || this.failedClasses.contains(createdClass)) {
            return null;
        }
        if (createdClass.isPhantom() || createdClass.isPhantomClass()) {
            this.failedClasses.add(createdClass);
            return null;
        }
        if (DummyMain.isSimpleType(createdClass.toString())) {
            Local varLocal = this.generator.generateLocal(this.getSimpleTypeFromType(createdClass.getType()));
            AssignStmt aStmt = Jimple.v().newAssignStmt(varLocal, this.getSimpleDefaultValue(createdClass.toString()));
            body.getUnits().add(aStmt);
            return varLocal;
        }
        boolean isInnerClass = createdClass.getName().contains("$");
        String string = outerClass = isInnerClass ? createdClass.getName().substring(0, createdClass.getName().lastIndexOf("$")) : "";
        if (!constructionStack.add(createdClass)) {
            Local tempLocal = this.generator.generateLocal(RefType.v(createdClass));
            AssignStmt assignStmt = Jimple.v().newAssignStmt(tempLocal, NullConstant.v());
            body.getUnits().add(assignStmt);
            return tempLocal;
        }
        for (SootMethod currentMethod : createdClass.getMethods()) {
            if (currentMethod.isPrivate() || !currentMethod.isConstructor()) continue;
            LinkedList<Value> params = new LinkedList<Value>();
            for (Type type : currentMethod.getParameterTypes()) {
                String typeName = type.toString().replaceAll("\\[\\]]", "");
                if (type instanceof RefType && isInnerClass && typeName.equals(outerClass) && this.localVarClass.containsKey(typeName)) {
                    params.add(this.localVarClass.get(typeName));
                    continue;
                }
                params.add(this.getValueForType(body, this.generator, type, constructionStack, parentClasses));
            }
            NewExpr newExpr = Jimple.v().newNewExpr(RefType.v(createdClass));
            Local tempLocal = this.generator.generateLocal(RefType.v(createdClass));
            AssignStmt assignStmt = Jimple.v().newAssignStmt(tempLocal, newExpr);
            body.getUnits().add(assignStmt);
            SpecialInvokeExpr vInvokeExpr = params.isEmpty() || params.contains(null) ? Jimple.v().newSpecialInvokeExpr(tempLocal, currentMethod.makeRef()) : Jimple.v().newSpecialInvokeExpr(tempLocal, currentMethod.makeRef(), params);
            if (!(currentMethod.getReturnType() instanceof VoidType)) {
                Local possibleReturn = this.generator.generateLocal(currentMethod.getReturnType());
                AssignStmt assignStmt2 = Jimple.v().newAssignStmt(possibleReturn, vInvokeExpr);
                body.getUnits().add(assignStmt2);
            } else {
                body.getUnits().add(Jimple.v().newInvokeStmt(vInvokeExpr));
            }
            return tempLocal;
        }
        this.failedClasses.add(createdClass);
        return null;
    }

    private static boolean isSimpleType(String type) {
        return Constants.METHOD_TYPES.contains(type);
    }

    private Type getSimpleTypeFromType(Type type) {
        if (type.toString().equals("java.lang.String")) {
            assert (type instanceof RefType);
            return RefType.v(((RefType)type).getSootClass());
        }
        if (type.toString().equals("void")) {
            return VoidType.v();
        }
        if (type.toString().equals("char")) {
            return CharType.v();
        }
        if (type.toString().equals("byte")) {
            return ByteType.v();
        }
        if (type.toString().equals("short")) {
            return ShortType.v();
        }
        if (type.toString().equals("int")) {
            return IntType.v();
        }
        if (type.toString().equals("float")) {
            return FloatType.v();
        }
        if (type.toString().equals("long")) {
            return LongType.v();
        }
        if (type.toString().equals("double")) {
            return DoubleType.v();
        }
        if (type.toString().equals("boolean")) {
            return BooleanType.v();
        }
        throw new RuntimeException("Unknown simple type: " + type);
    }

    private Value getSimpleDefaultValue(String type) {
        if ("java.lang.String".equals(type)) {
            return StringConstant.v("");
        }
        if ("char".equals(type)) {
            return DIntConstant.v(0, CharType.v());
        }
        if ("byte".equals(type)) {
            return DIntConstant.v(0, ByteType.v());
        }
        if ("short".equals(type)) {
            return DIntConstant.v(0, ShortType.v());
        }
        if ("int".equals(type)) {
            return IntConstant.v(0);
        }
        if ("float".equals(type)) {
            return FloatConstant.v(0.0f);
        }
        if ("long".equals(type)) {
            return LongConstant.v(0L);
        }
        if ("double".equals(type)) {
            return DoubleConstant.v(0.0);
        }
        if ("boolean".equals(type)) {
            return DIntConstant.v(0, BooleanType.v());
        }
        return G.v().soot_jimple_NullConstant();
    }

    private SootMethod findMethod(SootClass sClass, String subsignature) {
        if (sClass.declaresMethod(subsignature)) {
            return sClass.getMethod(subsignature);
        }
        if (sClass.hasSuperclass()) {
            this.findMethod(sClass.getSuperclass(), subsignature);
        }
        return null;
    }

    private Stmt buildMethodCall(SootMethod methodToCall, Body body, Local classLocal, LocalGenerator gen) {
        Set<SootClass> parentClasses = Collections.emptySet();
        return this.buildMethodCall(methodToCall, body, classLocal, gen, parentClasses);
    }

    private Stmt buildMethodCall(SootMethod methodToCall, Body body, Local classLocal, LocalGenerator gen, Set<SootClass> parentClasses) {
        Stmt stmt;
        InvokeExpr invokeExpr;
        assert (methodToCall != null) : "Current method was null";
        assert (body != null) : "Body was null";
        assert (gen != null) : "Local generator was null";
        if (classLocal == null && !methodToCall.isStatic()) {
            this.failedMethods.add(methodToCall);
            return null;
        }
        LinkedList<Value> args = new LinkedList<Value>();
        if (methodToCall.getParameterCount() > 0) {
            for (Type tp : methodToCall.getParameterTypes()) {
                args.add(this.getValueForType(body, gen, tp, new HashSet<SootClass>(), parentClasses));
            }
            if (methodToCall.isStatic()) {
                invokeExpr = Jimple.v().newStaticInvokeExpr(methodToCall.makeRef(), args);
            } else {
                assert (classLocal != null) : "Class local method was null for non-static method call";
                invokeExpr = methodToCall.isConstructor() ? Jimple.v().newSpecialInvokeExpr(classLocal, methodToCall.makeRef(), args) : Jimple.v().newVirtualInvokeExpr(classLocal, methodToCall.makeRef(), args);
            }
        } else if (methodToCall.isStatic()) {
            invokeExpr = Jimple.v().newStaticInvokeExpr(methodToCall.makeRef());
        } else {
            assert (classLocal != null) : "Class local method was null for non-static method call";
            invokeExpr = methodToCall.isConstructor() ? Jimple.v().newSpecialInvokeExpr(classLocal, methodToCall.makeRef()) : Jimple.v().newVirtualInvokeExpr(classLocal, methodToCall.makeRef());
        }
        if (!(methodToCall.getReturnType() instanceof VoidType)) {
            Local returnLocal = gen.generateLocal(methodToCall.getReturnType());
            stmt = Jimple.v().newAssignStmt(returnLocal, invokeExpr);
        } else {
            stmt = Jimple.v().newInvokeStmt(invokeExpr);
        }
        body.getUnits().add(stmt);
        return stmt;
    }

    private Value getValueForType(Body body, LocalGenerator gen, Type type, Set<SootClass> constructionStack, Set<SootClass> parentClasses) {
        if (DummyMain.isSimpleType(type.toString())) {
            return this.getSimpleDefaultValue(type.toString());
        }
        if (type instanceof RefType) {
            SootClass classToType = ((RefType)type).getSootClass();
            if (classToType != null) {
                for (SootClass parent : parentClasses) {
                    Value val;
                    if (!this.isCompatible(parent, classToType) || (val = (Value)this.localVarClass.get(parent.getName())) == null) continue;
                    return val;
                }
                Local val = this.generateClassConstructor(classToType, body, constructionStack, parentClasses);
                if (val == null) {
                    return NullConstant.v();
                }
                return val;
            }
        } else {
            if (type instanceof ArrayType) {
                Value arrVal = this.buildArrayOfType(body, gen, (ArrayType)type, constructionStack, parentClasses);
                if (arrVal == null) {
                    return NullConstant.v();
                }
                return arrVal;
            }
            return null;
        }
        throw new RuntimeException("Found no value for type");
    }

    private boolean isCompatible(SootClass actual, SootClass expected) {
        SootClass act = actual;
        while (!act.getName().equals(expected.getName())) {
            if (expected.isInterface()) {
                for (SootClass intf : act.getInterfaces()) {
                    if (!intf.getName().equals(expected.getName())) continue;
                    return true;
                }
            }
            if (!act.hasSuperclass()) {
                return false;
            }
            act = act.getSuperclass();
        }
        return true;
    }

    private Value buildArrayOfType(Body body, LocalGenerator gen, ArrayType type, Set<SootClass> constructionStack, Set<SootClass> parentClasses) {
        Local local = gen.generateLocal(type);
        NewArrayExpr newArrayExpr = Jimple.v().newNewArrayExpr(type.getElementType(), IntConstant.v(1));
        AssignStmt assignArray = Jimple.v().newAssignStmt(local, newArrayExpr);
        body.getUnits().add(assignArray);
        AssignStmt assign = Jimple.v().newAssignStmt(Jimple.v().newArrayRef(local, IntConstant.v(0)), this.getValueForType(body, gen, type.getElementType(), constructionStack, parentClasses));
        body.getUnits().add(assign);
        return local;
    }

    private Stmt searchAndBuildMethod(String subsignature, SootClass currentClass, Set<String> entryPoints, Local classLocal) {
        if (currentClass == null || classLocal == null) {
            return null;
        }
        SootMethod method = this.findMethod(currentClass, subsignature);
        if (method == null) {
            return null;
        }
        entryPoints.remove(method.getSignature());
        if (method.getDeclaringClass().getName().startsWith("android.")) {
            return null;
        }
        assert (method.isStatic() || classLocal != null) : "Class local was null for non-static method " + method.getSignature();
        return this.buildMethodCall(method, this.body, classLocal, this.generator);
    }

    private void generateActivityLifecycle(Set<String> entryPoints, SootClass currentClass, Local classLoc) {
        HashSet<SootClass> referenceClasses = new HashSet<SootClass>();
        if (this.applicationClass != null) {
            referenceClasses.add(this.applicationClass);
        }
        for (SootClass callbackClass : this.applCallbkClasses) {
            referenceClasses.add(callbackClass);
        }
        referenceClasses.add(currentClass);
        this.searchAndBuildMethod("void onCreate(android.os.Bundle)", currentClass, entryPoints, classLoc);
        this.addCallbackMethods(this.applicationClass, referenceClasses, "void onActivityCreated(android.app.Activity,android.os.Bundle)");
        this.searchAndBuildMethod("void onStart()", currentClass, entryPoints, classLoc);
        this.addCallbackMethods(this.applicationClass, referenceClasses, "void onActivityStarted(android.app.Activity)");
        this.searchAndBuildMethod("void onRestoreInstanceState(android.os.Bundle)", currentClass, entryPoints, classLoc);
        this.searchAndBuildMethod("void onPostCreate(android.os.Bundle)", currentClass, entryPoints, classLoc);
        this.searchAndBuildMethod("void onResume()", currentClass, entryPoints, classLoc);
        this.addCallbackMethods(this.applicationClass, referenceClasses, "void onActivityResumed(android.app.Activity)");
        this.searchAndBuildMethod("void onPostResume()", currentClass, entryPoints, classLoc);
        boolean hasCallBacks = this.callbackFunctions.containsKey(currentClass.getName());
        if (hasCallBacks) {
            this.addCallbackMethods(currentClass);
        }
        this.searchAndBuildMethod("void onPause()", currentClass, this.entryPoints, classLoc);
        this.addCallbackMethods(this.applicationClass, referenceClasses, "void onActivityPaused(android.app.Activity)");
        this.searchAndBuildMethod("java.lang.CharSequence onCreateDescription()", currentClass, this.entryPoints, classLoc);
        this.searchAndBuildMethod("void onSaveInstanceState(android.os.Bundle)", currentClass, entryPoints, classLoc);
        this.addCallbackMethods(this.applicationClass, referenceClasses, "void onActivitySaveInstanceState(android.app.Activity,android.os.Bundle)");
        this.searchAndBuildMethod("void onStop()", currentClass, entryPoints, classLoc);
        this.addCallbackMethods(this.applicationClass, referenceClasses, "void onActivityStopped(android.app.Activity)");
        this.searchAndBuildMethod("void onRestart()", currentClass, entryPoints, classLoc);
        this.searchAndBuildMethod("void onDestroy()", currentClass, entryPoints, classLoc);
        this.addCallbackMethods(this.applicationClass, referenceClasses, "void onActivityDestroyed(android.app.Activity)");
    }

    private void generateServiceLifecycle(Set<String> entryPoints, SootClass currentClass, Local classLoc) {
        SootMethod smethod;
        boolean isGCMBaseIntent = this.isGCMBaseIntentService(currentClass);
        boolean isGCMListener = !isGCMBaseIntent && this.isGCMListenerService(currentClass);
        this.searchAndBuildMethod("void onCreate()", currentClass, entryPoints, classLoc);
        this.searchAndBuildMethod("void onStart(android.content.Intent,int)", currentClass, entryPoints, classLoc);
        this.searchAndBuildMethod("int onStartCommand(android.content.Intent,int,int)", currentClass, entryPoints, classLoc);
        boolean hasAddMethods = false;
        if (isGCMBaseIntent) {
            for (String signature : Constants.getGCMIntentServiceMethods()) {
                smethod = this.findMethod(currentClass, signature);
                if (smethod == null || smethod.getDeclaringClass().getName().equals("com.google.android.gcm.GCMBaseIntentService")) continue;
                hasAddMethods |= this.createPlainMethodCall(classLoc, smethod);
            }
        } else if (isGCMListener) {
            for (String signature : Constants.getGCMListenerServiceMethods()) {
                SootMethod sMethod = this.findMethod(currentClass, signature);
                if (sMethod == null || sMethod.getDeclaringClass().getName().equals("com.google.android.gms.gcm.GcmListenerService")) continue;
                hasAddMethods |= this.createPlainMethodCall(classLoc, sMethod);
            }
        }
        this.addCallbackMethods(currentClass);
        this.searchAndBuildMethod("android.os.IBinder onBind(android.content.Intent)", currentClass, entryPoints, classLoc);
        hasAddMethods = false;
        if (isGCMBaseIntent) {
            for (String signature : Constants.getGCMIntentServiceMethods()) {
                smethod = this.findMethod(currentClass, signature);
                if (smethod == null || smethod.getDeclaringClass().getName().equals("com.google.android.gcm.GCMBaseIntentService")) continue;
                hasAddMethods |= this.createPlainMethodCall(classLoc, smethod);
            }
        }
        this.addCallbackMethods(currentClass);
        this.searchAndBuildMethod("boolean onUnbind(android.content.Intent)", currentClass, entryPoints, classLoc);
        this.searchAndBuildMethod("void onRebind(android.content.Intent)", currentClass, entryPoints, classLoc);
        this.searchAndBuildMethod("void onDestroy()", currentClass, entryPoints, classLoc);
    }

    private boolean isGCMListenerService(SootClass currentClass) {
        while (currentClass.hasSuperclass()) {
            if (currentClass.getSuperclass().getName().equals("com.google.android.gms.gcm.GcmListenerService")) {
                return true;
            }
            currentClass = currentClass.getSuperclass();
        }
        return false;
    }

    private boolean isGCMBaseIntentService(SootClass currentClass) {
        while (currentClass.hasSuperclass()) {
            if (currentClass.getSuperclass().getName().equals("com.google.android.gcm.GCMBaseIntentService")) {
                return true;
            }
            currentClass = currentClass.getSuperclass();
        }
        return false;
    }

    private void generateBroadcastReceiverLifecycle(Set<String> entryPoints, SootClass currentClass, Local classLoc) {
        this.searchAndBuildMethod("void onReceive(android.content.Context,android.content.Intent)", currentClass, entryPoints, classLoc);
        this.addCallbackMethods(currentClass);
    }

    private void generateContentProviderLifecycle(Set<String> entryPoints, SootClass currentClass, Local classLoc) {
        this.addCallbackMethods(currentClass);
    }

    private void addCallbackMethods(SootClass currentClass) {
        this.addCallbackMethods(currentClass, null, "");
    }

    private void addCallbackMethods(SootClass currentClass, Set<SootClass> referenceClasses, String callbackSignature) {
        if (currentClass == null) {
            return;
        }
        if (!this.callbackFunctions.containsKey(currentClass.getName())) {
            return;
        }
        HashMap callbackClasses = new HashMap();
        for (SootMethod sMethod : this.callbackFunctions.get(currentClass.getName())) {
            SootClass theClass;
            SootMethod theMethod;
            if (!callbackSignature.isEmpty() && !callbackSignature.equals(sMethod.getSubSignature()) || (theMethod = this.findMethod(theClass = Scene.v().getSootClass(sMethod.getDeclaringClass().getName()), sMethod.getSubSignature())) == null || this.getComponentType(theClass) == componentType.Activity && Constants.getActivityLifecycleMethods().contains(theMethod.getSubSignature()) || this.getComponentType(theClass) == componentType.Service && Constants.getServiceLifecycleMethods().contains(theMethod.getSubSignature()) || this.getComponentType(theClass) == componentType.BroadcastReceiver && Constants.getBroadcastLifecycleMethods().contains(theMethod.getSubSignature()) || this.getComponentType(theClass) == componentType.ContentProvider && Constants.getContentproviderLifecycleMethods().contains(theMethod.getSubSignature())) continue;
            if (callbackClasses.containsKey(theClass)) {
                ((Set)callbackClasses.get(theClass)).add(theMethod);
                continue;
            }
            HashSet<SootMethod> methods = new HashSet<SootMethod>();
            methods.add(theMethod);
            callbackClasses.put(theClass, methods);
        }
        if (referenceClasses == null || referenceClasses.isEmpty()) {
            referenceClasses = Collections.singleton(currentClass);
        } else {
            referenceClasses = new HashSet<SootClass>(referenceClasses);
            referenceClasses.add(currentClass);
        }
        for (SootClass callbackClass : callbackClasses.keySet()) {
            HashSet<Local> classLocals = new HashSet<Local>();
            for (SootClass parentClass : referenceClasses) {
                Local parentLocal = this.localVarClass.get(parentClass.getName());
                if (!this.isCompatible(parentClass, callbackClass)) continue;
                classLocals.add(parentLocal);
            }
            if (classLocals.isEmpty()) {
                Local classLocal = this.generateClassConstructor(callbackClass, this.body, referenceClasses);
                if (classLocal == null) {
                    LOGGER.warn("Constructor cannot be generated for callback class {}", callbackClass.getName());
                    continue;
                }
                classLocals.add(classLocal);
            }
            for (Local classLocal : classLocals) {
                for (SootMethod callbackMethod : (Set)callbackClasses.get(callbackClass)) {
                    this.buildMethodCall(callbackMethod, this.body, classLocal, this.generator, referenceClasses);
                }
            }
        }
    }

    private boolean createPlainMethodCall(Local classLocal, SootMethod currentMethod) {
        if (Constants.getServiceLifecycleMethods().contains(currentMethod.getSubSignature())) {
            return false;
        }
        this.buildMethodCall(currentMethod, this.body, classLocal, this.generator);
        return true;
    }

    private void addlayoutCallBackMethods(ARSCParser arscParser) {
        for (Map.Entry<String, List<Integer>> lcentry : this.actvtyLyoutMap.entrySet()) {
            SootClass callbackClass = Scene.v().getSootClass(lcentry.getKey());
            for (int classId : lcentry.getValue()) {
                String layoutFileName;
                List<String> callbackMethods;
                ARSCParser.AbstractResource resource = arscParser.findResource(classId);
                if (!(resource instanceof ARSCParser.StringResource) || (callbackMethods = this.layoutCallbackMap.get(layoutFileName = ((ARSCParser.StringResource)resource).getValue())) == null) continue;
                block2: for (String methodName : callbackMethods) {
                    String subSig = "void " + methodName + "(android.view.View)";
                    SootClass currentClass = callbackClass;
                    while (true) {
                        SootMethod callbackMethod;
                        if ((callbackMethod = currentClass.getMethodUnsafe(subSig)) != null) {
                            this.callbackFunctions.get(callbackClass.getName()).add(callbackMethod);
                            continue block2;
                        }
                        if (!currentClass.hasSuperclass()) continue block2;
                        currentClass = currentClass.getSuperclass();
                    }
                }
            }
        }
    }

    private static enum componentType {
        Dummy,
        Application,
        Activity,
        ContentProvider,
        Service,
        BroadcastReceiver;

    }
}

