/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.test.client.core;

import de.upb.pga3.panda2.client.core.AppIdentifier;
import de.upb.pga3.panda2.client.core.datastructures.ManifestInfo;
import de.upb.pga3.panda2.client.core.datastructures.UIMessage;
import de.upb.pga3.panda2.client.core.datastructures.validation.FileConverter;
import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.extension.Enhancer;
import de.upb.pga3.panda2.extension.lvl1.AnalysisResultLvl1;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AppIdentifierTest {
    String apkPath = "";
    String apkPath2 = "";
    File file;
    File file2;
    FileConverter fc;
    Enhancer enhancer;
    EnhancedInput enhInput;
    AnalysisGraph ag;
    AnalysisResultLvl1 ar;
    AppIdentifier ai;

    @Before
    public void setUp() throws Exception {
        this.apkPath = "test_resources/SimpleIntents.apk";
        this.apkPath2 = "test_resources/SimpleIntents.apk";
        this.fc = new FileConverter();
        this.file = this.fc.convert(this.apkPath);
        this.file2 = this.fc.convert(this.apkPath2);
        Path p = Paths.get("test_resources/OnlyExplicit.apk", new String[0]);
        this.enhancer = new Enhancer();
        this.enhInput = (EnhancedInput)this.enhancer.enhance(p);
        this.ag = new AnalysisGraph(this.enhInput);
        this.ar = new AnalysisResultLvl1(this.ag);
        this.ai = new AppIdentifier();
    }

    @Test
    public void compareAppWithPreviousResulttest() {
        UIMessage ui = this.ai.compareAppWithPreviousResult(this.file, this.ar);
        Assert.assertNotNull((Object)ui);
    }

    @Test
    public void getManifestInfo1test() {
        ManifestInfo mff = new ManifestInfo("vc", "vn", "pck");
        this.ai.setManifestInfo1(mff);
        ManifestInfo mf1 = this.ai.getManifestInfo1();
        Assert.assertNotNull((Object)mf1);
    }

    @Test
    public void getManifestInfo2test() {
        ManifestInfo mff2 = new ManifestInfo("vc2", "vn2", "pck2");
        this.ai.setManifestInfo2(mff2);
        ManifestInfo mf2 = this.ai.getManifestInfo2();
        Assert.assertNotNull((Object)mf2);
    }

    @Test
    public void getApp1FingerPrinttest() {
        this.ai.setApp1FingerPrint("fp1");
        String getfp1 = this.ai.getApp1FingerPrint();
        Assert.assertNotNull((Object)getfp1);
    }

    @Test
    public void getApp2FingerPrinttest() {
        this.ai.setApp2FingerPrint("fp2");
        String getfp2 = this.ai.getApp2FingerPrint();
        Assert.assertNotNull((Object)getfp2);
    }

    @Test
    public void compareAppWithApp() {
        UIMessage ui = this.ai.compareAppWithApp(this.file, this.file2);
        Assert.assertNotNull((Object)ui);
    }
}

