/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.test.extension.lvl2a;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.DetailLevel;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.extension.lvl2a.AnalysisResultLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.analyzer.AnalyzerLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.analyzer.SourceAndSinkComputer;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.FlowPath;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.ResourceElement;
import de.upb.pga3.panda2.test.extension.lvl2a.TestCodeFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import soot.Unit;

public class AnalysisResultLvl2aTest {
    private AnalysisGraph inGraph = TestCodeFactory.createAnalysisGraph("test_resources/ExpoAppLvl2a.apk");
    private AnalysisResultLvl2a result = (AnalysisResultLvl2a)new AnalyzerLvl2a().analyze(this.inGraph, null);

    @Test
    public void testAnalysisResultLvl2a_1() throws Exception {
        AnalysisResultLvl2a result1 = new AnalysisResultLvl2a();
        Assert.assertNotNull((Object)result1);
    }

    @Test
    public void testAddPath_1() throws Exception {
        AnalysisResultLvl2a fixture = this.result;
        FlowPath inPath = fixture.getPaths().iterator().next();
        boolean result1 = fixture.addPath(inPath);
        Assert.assertTrue((boolean)result1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddPath_2() throws Exception {
        AnalysisResultLvl2a fixture = this.result;
        FlowPath inPath = null;
        boolean result1 = fixture.addPath(inPath);
        Assert.assertTrue((boolean)result1);
    }

    @Test
    public void testAddSinks() throws Exception {
        SourceAndSinkComputer susi = new SourceAndSinkComputer();
        Object[] lstNode = this.inGraph.getNodes().toArray();
        ArrayList<Unit> lstNodeUnit = new ArrayList<Unit>();
        if (lstNode != null && lstNode.length > 0) {
            Object[] objectArray = lstNode;
            int n = lstNode.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof Unit) {
                    lstNodeUnit.add((Unit)obj);
                }
                ++n2;
            }
        }
        Map<Permission, List<Unit>> inSinksMap = susi.computeSinks(lstNodeUnit, (EnhancedInput)this.inGraph.getInput());
        AnalysisResultLvl2a fixture = new AnalysisResultLvl2a();
        fixture.addSinks(inSinksMap.keySet().stream().map(p -> ResourceElement.get(p)).collect(Collectors.toList()));
    }

    @Test
    public void testAddSources() throws Exception {
        SourceAndSinkComputer susi = new SourceAndSinkComputer();
        Object[] lstNode = this.inGraph.getNodes().toArray();
        ArrayList<Unit> lstNodeUnit = new ArrayList<Unit>();
        if (lstNode != null && lstNode.length > 0) {
            Object[] objectArray = lstNode;
            int n = lstNode.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof Unit) {
                    lstNodeUnit.add((Unit)obj);
                }
                ++n2;
            }
        }
        AnalysisResultLvl2a fixture = new AnalysisResultLvl2a();
        Map<Permission, List<Unit>> inSourcesMap = susi.computeSources(lstNodeUnit, (EnhancedInput)this.inGraph.getInput());
        fixture.addSources(inSourcesMap.keySet().stream().map(p -> ResourceElement.get(p)).collect(Collectors.toList()));
    }

    @Test
    public void testCreateFilters() throws Exception {
        AnalysisResultLvl2a fixture = (AnalysisResultLvl2a)new AnalyzerLvl2a().analyze(this.inGraph, null);
        fixture.createFilters();
    }

    @Test
    public void testGetDetailLevels_1() throws Exception {
        AnalysisResultLvl2a fixture = (AnalysisResultLvl2a)new AnalyzerLvl2a().analyze(this.inGraph, null);
        List<DetailLevel> result1 = fixture.getDetailLevels();
        Assert.assertNotNull(result1);
        Assert.assertEquals((long)4L, (long)result1.size());
    }

    @Test
    public void testGetFilters() throws Exception {
        AnalysisResultLvl2a fixture = (AnalysisResultLvl2a)new AnalyzerLvl2a().analyze(this.inGraph, null);
        List<String> result1 = fixture.getFilters();
        Assert.assertNotNull(result1);
    }

    @Test
    public void testGetGraphicalResult() throws Exception {
        AnalysisResultLvl2a fixture = (AnalysisResultLvl2a)new AnalyzerLvl2a().analyze(this.inGraph, null);
        DetailLevel inDetailLvl = fixture.getDetailLevels().get(0);
        List<String> inFilters = fixture.getFilters();
        boolean inShowStats = true;
        String result1 = fixture.getGraphicalResult(inDetailLvl, inFilters, true);
        Assert.assertNotNull((Object)result1);
    }

    @Test
    public void testGetPaths() throws Exception {
        AnalysisResultLvl2a fixture = (AnalysisResultLvl2a)new AnalyzerLvl2a().analyze(this.inGraph, null);
        Set<FlowPath> result1 = fixture.getPaths();
        Assert.assertNotNull(result1);
    }

    @Test
    public void testGetTextualResult_Statement() throws Exception {
        AnalysisResultLvl2a fixture = (AnalysisResultLvl2a)new AnalyzerLvl2a().analyze(this.inGraph, null);
        DetailLevel inDetailLvl = fixture.getDetailLevels().get(3);
        List<String> inFilters = fixture.getFilters();
        boolean inShowStats = true;
        String result1 = fixture.getTextualResult(inDetailLvl, inFilters, true);
        Assert.assertNotNull((Object)result1);
    }

    @Test
    public void testGetTextualResult_Method() throws Exception {
        AnalysisResultLvl2a fixture = (AnalysisResultLvl2a)new AnalyzerLvl2a().analyze(this.inGraph, null);
        DetailLevel inDetailLvl = fixture.getDetailLevels().get(2);
        List<String> inFilters = fixture.getFilters();
        boolean inShowStats = true;
        String result1 = fixture.getTextualResult(inDetailLvl, inFilters, true);
        Assert.assertNotNull((Object)result1);
    }

    @Test
    public void testGetTextualResult_Resource() throws Exception {
        AnalysisResultLvl2a fixture = (AnalysisResultLvl2a)new AnalyzerLvl2a().analyze(this.inGraph, null);
        DetailLevel inDetailLvl = fixture.getDetailLevels().get(0);
        List<String> inFilters = fixture.getFilters();
        boolean inShowStats = true;
        String result1 = fixture.getTextualResult(inDetailLvl, inFilters, true);
        Assert.assertNotNull((Object)result1);
    }

    @Test
    public void testGetTextualResult_Component() throws Exception {
        AnalysisResultLvl2a fixture = (AnalysisResultLvl2a)new AnalyzerLvl2a().analyze(this.inGraph, null);
        DetailLevel inDetailLvl = fixture.getDetailLevels().get(1);
        List<String> inFilters = fixture.getFilters();
        boolean inShowStats = true;
        String result1 = fixture.getTextualResult(inDetailLvl, inFilters, true);
        Assert.assertNotNull((Object)result1);
    }

    @Test
    public void testGetPathsForSink() {
        Map<Permission, List<Unit>> inSinksMap;
        AnalysisResultLvl2a fixture = (AnalysisResultLvl2a)new AnalyzerLvl2a().analyze(this.inGraph, null);
        SourceAndSinkComputer susi = new SourceAndSinkComputer();
        Object[] lstNode = this.inGraph.getNodes().toArray();
        ArrayList<Unit> lstNodeUnit = new ArrayList<Unit>();
        if (lstNode != null && lstNode.length > 0) {
            Object[] objectArray = lstNode;
            int n = lstNode.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof Unit) {
                    lstNodeUnit.add((Unit)obj);
                }
                ++n2;
            }
        }
        if ((inSinksMap = susi.computeSinks(lstNodeUnit, (EnhancedInput)this.inGraph.getInput())) != null && !inSinksMap.isEmpty()) {
            Set<Permission> setPermss = inSinksMap.keySet();
            for (Permission perm : setPermss) {
                List<FlowPath> lstFlows = fixture.getPathsForSink(ResourceElement.get(perm));
                Assert.assertTrue((lstFlows == null || lstFlows.size() > 0 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testGetPathsForSource() {
        Map<Permission, List<Unit>> inSourcesMap;
        AnalysisResultLvl2a fixture = (AnalysisResultLvl2a)new AnalyzerLvl2a().analyze(this.inGraph, null);
        SourceAndSinkComputer susi = new SourceAndSinkComputer();
        Object[] lstNode = this.inGraph.getNodes().toArray();
        ArrayList<Unit> lstNodeUnit = new ArrayList<Unit>();
        if (lstNode != null && lstNode.length > 0) {
            Object[] objectArray = lstNode;
            int n = lstNode.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof Unit) {
                    lstNodeUnit.add((Unit)obj);
                }
                ++n2;
            }
        }
        if ((inSourcesMap = susi.computeSources(lstNodeUnit, (EnhancedInput)this.inGraph.getInput())) != null && !inSourcesMap.isEmpty()) {
            Set<Permission> setPermss = inSourcesMap.keySet();
            for (Permission perm : setPermss) {
                List<FlowPath> lstFlows = fixture.getPathsForSource(ResourceElement.get(perm));
                Assert.assertTrue((lstFlows == null || lstFlows.size() > 0 ? 1 : 0) != 0);
            }
        }
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    public static void main(String[] args) {
        new JUnitCore().run(new Class[]{AnalysisResultLvl2aTest.class});
    }
}

