/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.utilities;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Transition;
import de.upb.pga3.panda2.extension.lvl2a.AnalysisGraphLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.ParameterNode;
import de.upb.pga3.panda2.extension.lvl2a.TransitionLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.TransitionType;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import soot.Body;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.toolkits.scalar.Pair;
import soot.util.HashMultiMap;

public class GraphPlotter {
    private static final Logger logger = LogManager.getLogger(GraphPlotter.class);
    private static GraphPlotter instance;
    private final TObjectIntMap<Object> indexes = new TObjectIntHashMap();
    private final TIntObjectMap<String> labels = new TIntObjectHashMap();
    private static final String rSubName = "R_Class_Substitude";
    private static final int rSubIdx = 0;

    public static GraphPlotter getInstance() {
        if (instance == null) {
            instance = new GraphPlotter();
        }
        return instance;
    }

    public void reset() {
        this.indexes.clear();
        this.labels.clear();
    }

    public void resetAndPlotGraph(AnalysisGraphLvl2a g) {
        this.reset();
        this.plotGraph(g);
    }

    public void plotGraph(AnalysisGraphLvl2a g) {
        HashMultiMap<String, TransitionType> out = new HashMultiMap<String, TransitionType>();
        out.putAll("graph_lvl2a_CD.gv", new HashSet<TransitionType>(Arrays.asList(TransitionType.CONTROLDEPENDENCY)));
        out.putAll("graph_lvl2a_CF.gv", new HashSet<TransitionType>(Arrays.asList(TransitionType.CONTROLFLOW)));
        out.putAll("graph_lvl2a_DF.gv", new HashSet<TransitionType>(Arrays.asList(TransitionType.DATAFLOW)));
        out.putAll("graph_lvl2a_CALL.gv", new HashSet<TransitionType>(Arrays.asList(TransitionType.CALL)));
        out.putAll("graph_lvl2a_PARAM.gv", new HashSet<TransitionType>(Arrays.asList(TransitionType.PARAMIN, TransitionType.PARAMOUT)));
        out.putAll("graph_lvl2a_SUMMARY.gv", new HashSet<TransitionType>(Arrays.asList(TransitionType.SUMMARY)));
        out.putAll("graph_lvl2a_CD_CF.gv", new HashSet<TransitionType>(Arrays.asList(TransitionType.CONTROLDEPENDENCY, TransitionType.CONTROLFLOW)));
        out.putAll("graph_lvl2a_CALL_PARAM.gv", new HashSet<TransitionType>(Arrays.asList(TransitionType.CALL, TransitionType.PARAMIN, TransitionType.PARAMOUT)));
        out.putAll("graph_lvl2a_CF_CALL_PARAM.gv", new HashSet<TransitionType>(Arrays.asList(TransitionType.CONTROLFLOW, TransitionType.CALL, TransitionType.PARAMIN, TransitionType.PARAMOUT)));
        out.putAll("graph_lvl2a_ALL_NO_CF.gv", new HashSet<TransitionType>(Arrays.asList(TransitionType.CONTROLDEPENDENCY, TransitionType.DATAFLOW, TransitionType.SUMMARY, TransitionType.CALL, TransitionType.PARAMIN, TransitionType.PARAMOUT)));
        out.putAll("graph_lvl2a_ALL.gv", new HashSet<TransitionType>(Arrays.asList(TransitionType.values())));
        this.labels.put(0, (Object)rSubName);
        for (String file : out.keySet()) {
            Process p;
            Path path = Paths.get(file, new String[0]).toAbsolutePath();
            try {
                Throwable throwable = null;
                Object var7_11 = null;
                try (BufferedWriter bw = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                    this.plotGraph(bw, g, out.get(file));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            try {
                String[] dotCmd = new String[]{"dot", "-Tpdf", path.toString(), "-o", String.valueOf(path.toString()) + ".dot.pdf"};
                p = Runtime.getRuntime().exec(dotCmd);
                p.waitFor();
            }
            catch (IOException | InterruptedException e) {
                logger.warn("Unable to plot graph with graphviz: {}", e.getMessage());
            }
            try {
                String[] neatoCmd = new String[]{"neato", "-Goverlap=scale", "-Tpdf", path.toString(), "-o", String.valueOf(path.toString()) + ".neato.pdf"};
                p = Runtime.getRuntime().exec(neatoCmd);
                p.waitFor();
            }
            catch (IOException | InterruptedException e) {
                logger.warn("Unable to plot graph with graphviz: {}", e.getMessage());
            }
        }
    }

    private void plotGraph(Appendable app, AnalysisGraph g, Set<TransitionType> filter) throws IOException {
        app.append("digraph g {\n");
        app.append("edge [penwidth=2]\n");
        int numTrans = 0;
        TreeSet<Integer> drawnNodes = new TreeSet<Integer>();
        Set<Object> nodes = g.getNodes();
        logger.debug("Drawing outgoing transitions for {} nodes", nodes.size());
        StringBuilder sb = new StringBuilder();
        for (Object node : nodes) {
            for (Transition t : g.getOutgoingTransitions(node)) {
                Pair<Integer, Integer> sourceTargetIdx;
                if (!(t instanceof TransitionLvl2a) || (sourceTargetIdx = this.plotTransition(sb, g, (TransitionLvl2a)t, filter)) == null) continue;
                drawnNodes.add(sourceTargetIdx.getO1());
                drawnNodes.add(sourceTargetIdx.getO2());
                ++numTrans;
            }
        }
        logger.debug("Drawing {} transitions for filters {}", numTrans, filter.toString());
        logger.debug("Drawing {} nodes for filters {}", drawnNodes.size(), filter.toString());
        Iterator<Object> iterator = drawnNodes.iterator();
        while (iterator.hasNext()) {
            int idx = (Integer)iterator.next();
            app.append(Integer.toString(idx));
            app.append(" [label=<");
            app.append((CharSequence)this.labels.get(idx));
            app.append(">];\n");
        }
        app.append(sb.toString());
        app.append("}");
    }

    private Pair<Integer, Integer> plotTransition(Appendable app, AnalysisGraph g, TransitionLvl2a trans, Set<TransitionType> filter) throws IOException {
        if (filter.contains((Object)trans.getTransitionType())) {
            int sourceIdx = this.getNodeIndex(trans.getSource(), g);
            int targetIdx = this.getNodeIndex(trans.getTarget(), g);
            if (sourceIdx == 0 && targetIdx == 0) {
                return null;
            }
            app.append(Integer.toString(sourceIdx));
            app.append(" -> ");
            app.append(Integer.toString(targetIdx));
            app.append(" [label=");
            app.append(trans.getTransitionType().name());
            String color = "black";
            switch (trans.getTransitionType()) {
                case CALL: {
                    color = "firebrick1";
                    break;
                }
                case DATAFLOW: {
                    color = "dodgerblue3";
                    break;
                }
                case SUMMARY: {
                    color = "gold3";
                    break;
                }
                case PARAMIN: {
                    color = "green3";
                    break;
                }
                case PARAMOUT: {
                    color = "green3";
                    break;
                }
                case CONTROLDEPENDENCY: {
                    color = "darkorange";
                    break;
                }
                case CONTROLFLOW: {
                    color = "darkorchid";
                    break;
                }
                default: {
                    color = "black";
                }
            }
            app.append(",color=");
            app.append(color);
            app.append(",fontcolor=");
            app.append(color);
            app.append("];\n");
            return new Pair<Integer, Integer>(sourceIdx, targetIdx);
        }
        return null;
    }

    private int getNodeIndex(Object node, AnalysisGraph g) {
        if (this.indexes.containsKey(node)) {
            return this.indexes.get(node);
        }
        String unitStr = "-";
        String classStr = "-";
        String methodStr = "-";
        if (node instanceof Unit) {
            EnhancedInput ei = (EnhancedInput)g.getInput();
            Body body = ei.getBodyForUnit((Unit)node);
            classStr = body.getMethod().getDeclaringClass().toString();
            methodStr = body.getMethod().toString();
            unitStr = node.toString();
        } else if (node instanceof SootMethod) {
            classStr = ((SootMethod)node).getDeclaringClass().toString();
            methodStr = node.toString();
        } else if (node instanceof SootClass) {
            classStr = node.toString();
        } else if (node instanceof ParameterNode) {
            unitStr = "parameterNode" + node.hashCode();
        } else {
            throw new IllegalArgumentException("Unknown type: " + node.getClass());
        }
        classStr = classStr.replace("&", "&amp;").replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;");
        methodStr = methodStr.replace("&", "&amp;").replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;");
        unitStr = unitStr.replace("&", "&amp;").replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;");
        String uName = String.valueOf(classStr) + "<BR/>" + methodStr + "<BR/>" + unitStr + "<BR/>" + node.hashCode();
        if (uName.contains(".R$")) {
            this.indexes.put(node, 0);
            return 0;
        }
        int idx = this.labels.size();
        this.indexes.put(node, idx);
        this.labels.put(idx, (Object)uName);
        return idx;
    }
}

