/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import java.util.HashSet;
import java.util.Set;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.OneRegisterInstruction;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.instruction.formats.Instruction21c;
import org.jf.dexlib2.iface.reference.TypeReference;
import soot.RefType;
import soot.Type;
import soot.dexpler.DexBody;
import soot.dexpler.DexType;
import soot.dexpler.Util;
import soot.dexpler.instructions.DexlibAbstractInstruction;
import soot.jimple.AssignStmt;
import soot.jimple.Jimple;
import soot.jimple.NewExpr;

public class NewInstanceInstruction
extends DexlibAbstractInstruction {
    AssignStmt assign = null;

    public NewInstanceInstruction(Instruction instruction, int codeAdress) {
        super(instruction, codeAdress);
    }

    @Override
    public void jimplify(DexBody body) {
        Instruction21c i = (Instruction21c)this.instruction;
        int dest = i.getRegisterA();
        String className = Util.dottedClassName(((TypeReference)i.getReference()).toString());
        RefType type = RefType.v(className);
        NewExpr n = Jimple.v().newNewExpr(type);
        this.assign = Jimple.v().newAssignStmt(body.getRegisterLocal(dest), n);
        this.setUnit(this.assign);
        this.addTags(this.assign);
        body.add(this.assign);
    }

    @Override
    boolean overridesRegister(int register) {
        OneRegisterInstruction i = (OneRegisterInstruction)this.instruction;
        int dest = i.getRegisterA();
        return register == dest;
    }

    @Override
    public Set<Type> introducedTypes() {
        ReferenceInstruction i = (ReferenceInstruction)this.instruction;
        HashSet<Type> types = new HashSet<Type>();
        types.add(DexType.toSoot((TypeReference)i.getReference()));
        return types;
    }
}

