/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.base;

import java.util.HashMap;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.Local;
import soot.PatchingChain;
import soot.Trap;
import soot.Unit;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;
import soot.jimple.toolkits.scalar.LocalNameStandardizer;

public class ThisInliner
extends BodyTransformer {
    public void internalTransform(Body b, String phaseName, Map options) {
        if (!b.getMethod().getName().equals("<init>")) {
            return;
        }
        InvokeStmt invokeStmt = this.getFirstSpecialInvoke(b);
        if (invokeStmt == null) {
            return;
        }
        SpecialInvokeExpr specInvokeExpr = (SpecialInvokeExpr)invokeStmt.getInvokeExpr();
        if (specInvokeExpr.getMethod().getDeclaringClass().equals(b.getMethod().getDeclaringClass())) {
            Stmt inlineeStmt;
            if (!specInvokeExpr.getMethod().hasActiveBody()) {
                specInvokeExpr.getMethod().retrieveActiveBody();
            }
            HashMap<Local, Local> oldLocalsToNew = new HashMap<Local, Local>();
            for (Local l : specInvokeExpr.getMethod().getActiveBody().getLocals()) {
                Local newLocal = (Local)l.clone();
                b.getLocals().add(newLocal);
                oldLocalsToNew.put(l, newLocal);
            }
            IdentityStmt origIdStmt = this.findIdentityStmt(b);
            HashMap<Stmt, Stmt> oldStmtsToNew = new HashMap<Stmt, Stmt>();
            PatchingChain<Unit> containerUnits = b.getUnits();
            for (Unit u : specInvokeExpr.getMethod().getActiveBody().getUnits()) {
                inlineeStmt = (Stmt)u;
                if (inlineeStmt instanceof IdentityStmt) {
                    IdentityStmt idStmt = (IdentityStmt)inlineeStmt;
                    if (idStmt.getRightOp() instanceof ThisRef) {
                        AssignStmt newThis = Jimple.v().newAssignStmt((Local)oldLocalsToNew.get(idStmt.getLeftOp()), origIdStmt.getLeftOp());
                        containerUnits.insertBefore(newThis, (Unit)invokeStmt);
                        oldStmtsToNew.put(inlineeStmt, newThis);
                        continue;
                    }
                    if (idStmt.getRightOp() instanceof CaughtExceptionRef) {
                        Stmt newInlinee = (Stmt)inlineeStmt.clone();
                        for (ValueBox next : newInlinee.getUseAndDefBoxes()) {
                            if (!(next.getValue() instanceof Local)) continue;
                            next.setValue((Local)oldLocalsToNew.get(next.getValue()));
                        }
                        containerUnits.insertBefore(newInlinee, (Unit)invokeStmt);
                        oldStmtsToNew.put(inlineeStmt, newInlinee);
                        continue;
                    }
                    if (!(idStmt.getRightOp() instanceof ParameterRef)) continue;
                    AssignStmt newParam = Jimple.v().newAssignStmt((Local)oldLocalsToNew.get(idStmt.getLeftOp()), specInvokeExpr.getArg(((ParameterRef)idStmt.getRightOp()).getIndex()));
                    containerUnits.insertBefore(newParam, (Unit)invokeStmt);
                    oldStmtsToNew.put(inlineeStmt, newParam);
                    continue;
                }
                if (inlineeStmt instanceof ReturnVoidStmt) {
                    GotoStmt newRet = Jimple.v().newGotoStmt((Stmt)containerUnits.getSuccOf(invokeStmt));
                    containerUnits.insertBefore(newRet, (Unit)invokeStmt);
                    System.out.println("adding to stmt map: " + inlineeStmt + " and " + newRet);
                    oldStmtsToNew.put(inlineeStmt, newRet);
                    continue;
                }
                Stmt newInlinee = (Stmt)inlineeStmt.clone();
                for (ValueBox next : newInlinee.getUseAndDefBoxes()) {
                    if (!(next.getValue() instanceof Local)) continue;
                    next.setValue((Local)oldLocalsToNew.get(next.getValue()));
                }
                containerUnits.insertBefore(newInlinee, (Unit)invokeStmt);
                oldStmtsToNew.put(inlineeStmt, newInlinee);
            }
            for (Trap t : specInvokeExpr.getMethod().getActiveBody().getTraps()) {
                System.out.println("begin: " + t.getBeginUnit());
                Stmt newBegin = (Stmt)oldStmtsToNew.get(t.getBeginUnit());
                System.out.println("end: " + t.getEndUnit());
                Stmt newEnd = (Stmt)oldStmtsToNew.get(t.getEndUnit());
                System.out.println("handler: " + t.getHandlerUnit());
                Stmt newHandler = (Stmt)oldStmtsToNew.get(t.getHandlerUnit());
                if (newBegin == null || newEnd == null || newHandler == null) {
                    throw new RuntimeException("couldn't map trap!");
                }
                b.getTraps().add(Jimple.v().newTrap(t.getException(), newBegin, newEnd, newHandler));
            }
            for (Unit u : specInvokeExpr.getMethod().getActiveBody().getUnits()) {
                inlineeStmt = (Stmt)u;
                if (!(inlineeStmt instanceof GotoStmt)) continue;
                System.out.println("inlinee goto target: " + ((GotoStmt)inlineeStmt).getTarget());
                ((GotoStmt)oldStmtsToNew.get(inlineeStmt)).setTarget((Unit)oldStmtsToNew.get(((GotoStmt)inlineeStmt).getTarget()));
            }
            containerUnits.remove(invokeStmt);
            LocalNameStandardizer.v().transform(b, "ji.lns");
        }
    }

    private InvokeStmt getFirstSpecialInvoke(Body b) {
        for (Unit u : b.getUnits()) {
            InvokeExpr invokeExpr;
            Stmt s = (Stmt)u;
            if (!(s instanceof InvokeStmt) || !((invokeExpr = ((InvokeStmt)s).getInvokeExpr()) instanceof SpecialInvokeExpr)) continue;
            return (InvokeStmt)s;
        }
        return null;
    }

    private IdentityStmt findIdentityStmt(Body b) {
        for (Unit u : b.getUnits()) {
            Stmt s = (Stmt)u;
            if (!(s instanceof IdentityStmt) || !(((IdentityStmt)s).getRightOp() instanceof ThisRef)) continue;
            return (IdentityStmt)s;
        }
        return null;
    }
}

