/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ext.jl.types.ArrayType_c;
import polyglot.ext.jl.types.ConstructorInstance_c;
import polyglot.ext.jl.types.Context_c;
import polyglot.ext.jl.types.FieldInstance_c;
import polyglot.ext.jl.types.InitializerInstance_c;
import polyglot.ext.jl.types.LazyClassInitializer_c;
import polyglot.ext.jl.types.LocalInstance_c;
import polyglot.ext.jl.types.MethodInstance_c;
import polyglot.ext.jl.types.NullType_c;
import polyglot.ext.jl.types.Package_c;
import polyglot.ext.jl.types.ParsedClassType_c;
import polyglot.ext.jl.types.PlaceHolder_c;
import polyglot.ext.jl.types.PrimitiveType_c;
import polyglot.ext.jl.types.TypeObject_c;
import polyglot.ext.jl.types.UnknownPackage_c;
import polyglot.ext.jl.types.UnknownQualifier_c;
import polyglot.ext.jl.types.UnknownType_c;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.Source;
import polyglot.main.Report;
import polyglot.types.ArrayType;
import polyglot.types.CachingResolver;
import polyglot.types.ClassContextResolver;
import polyglot.types.ClassType;
import polyglot.types.CompoundResolver;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.ImportTable;
import polyglot.types.InitializerInstance;
import polyglot.types.LazyClassInitializer;
import polyglot.types.LoadedClassResolver;
import polyglot.types.LocalInstance;
import polyglot.types.MemberInstance;
import polyglot.types.MethodInstance;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.NoMemberException;
import polyglot.types.NullType;
import polyglot.types.Package;
import polyglot.types.PackageContextResolver;
import polyglot.types.ParsedClassType;
import polyglot.types.PrimitiveType;
import polyglot.types.ProcedureInstance;
import polyglot.types.ReferenceType;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.TableResolver;
import polyglot.types.TopLevelResolver;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.types.UnknownPackage;
import polyglot.types.UnknownQualifier;
import polyglot.types.UnknownType;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.StringUtil;

public class TypeSystem_c
implements TypeSystem {
    protected TopLevelResolver systemResolver;
    protected TableResolver parsedResolver;
    protected LoadedClassResolver loadedResolver;
    protected Map flagsForName;
    protected ClassType OBJECT_;
    protected ClassType CLASS_;
    protected ClassType STRING_;
    protected ClassType THROWABLE_;
    protected final NullType NULL_ = this.createNull();
    protected final PrimitiveType VOID_ = this.createPrimitive(PrimitiveType.VOID);
    protected final PrimitiveType BOOLEAN_ = this.createPrimitive(PrimitiveType.BOOLEAN);
    protected final PrimitiveType CHAR_ = this.createPrimitive(PrimitiveType.CHAR);
    protected final PrimitiveType BYTE_ = this.createPrimitive(PrimitiveType.BYTE);
    protected final PrimitiveType SHORT_ = this.createPrimitive(PrimitiveType.SHORT);
    protected final PrimitiveType INT_ = this.createPrimitive(PrimitiveType.INT);
    protected final PrimitiveType LONG_ = this.createPrimitive(PrimitiveType.LONG);
    protected final PrimitiveType FLOAT_ = this.createPrimitive(PrimitiveType.FLOAT);
    protected final PrimitiveType DOUBLE_ = this.createPrimitive(PrimitiveType.DOUBLE);
    protected UnknownType unknownType = new UnknownType_c(this);
    protected UnknownPackage unknownPackage = new UnknownPackage_c(this);
    protected UnknownQualifier unknownQualifier = new UnknownQualifier_c(this);
    protected LazyClassInitializer defaultClassInit;
    protected final Flags ACCESS_FLAGS = this.Public().Protected().Private();
    protected final Flags LOCAL_FLAGS = this.Final();
    protected final Flags FIELD_FLAGS = this.ACCESS_FLAGS.Static().Final().Transient().Volatile();
    protected final Flags CONSTRUCTOR_FLAGS = this.ACCESS_FLAGS.Synchronized().Native();
    protected final Flags INITIALIZER_FLAGS = this.Static();
    protected final Flags METHOD_FLAGS = this.ACCESS_FLAGS.Abstract().Static().Final().Native().Synchronized().StrictFP();
    protected final Flags TOP_LEVEL_CLASS_FLAGS = this.ACCESS_FLAGS.clear(this.Private()).Abstract().Final().StrictFP().Interface();
    protected final Flags MEMBER_CLASS_FLAGS = this.ACCESS_FLAGS.Static().Abstract().Final().StrictFP().Interface();
    protected final Flags LOCAL_CLASS_FLAGS = this.TOP_LEVEL_CLASS_FLAGS.clear(this.ACCESS_FLAGS);

    public void initialize(LoadedClassResolver loadedResolver, ExtensionInfo extInfo) throws SemanticException {
        if (Report.should_report("types", 1)) {
            Report.report(1, "Initializing " + this.getClass().getName());
        }
        this.parsedResolver = new TableResolver();
        this.loadedResolver = loadedResolver;
        CompoundResolver compoundResolver = new CompoundResolver(this.parsedResolver, loadedResolver);
        this.systemResolver = new CachingResolver(compoundResolver, extInfo);
        this.initFlags();
        this.initTypes();
    }

    protected void initTypes() throws SemanticException {
    }

    public TopLevelResolver systemResolver() {
        return this.systemResolver;
    }

    public TableResolver parsedResolver() {
        return this.parsedResolver;
    }

    public LoadedClassResolver loadedResolver() {
        return this.loadedResolver;
    }

    public ImportTable importTable(String sourceName, Package pkg) {
        this.assert_(pkg);
        return new ImportTable(this, this.systemResolver, pkg, sourceName);
    }

    public ImportTable importTable(Package pkg) {
        this.assert_(pkg);
        return new ImportTable(this, this.systemResolver, pkg);
    }

    public boolean packageExists(String name) {
        return this.systemResolver.packageExists(name);
    }

    protected void assert_(Collection l) {
        Iterator i = l.iterator();
        while (i.hasNext()) {
            TypeObject o = (TypeObject)i.next();
            this.assert_(o);
        }
    }

    protected void assert_(TypeObject o) {
        if (o != null && o.typeSystem() != this) {
            throw new InternalCompilerError("we are " + this + " but " + o + " is from " + o.typeSystem());
        }
    }

    public String wrapperTypeString(PrimitiveType t) {
        this.assert_(t);
        if (t.kind() == PrimitiveType.BOOLEAN) {
            return "java.lang.Boolean";
        }
        if (t.kind() == PrimitiveType.CHAR) {
            return "java.lang.Character";
        }
        if (t.kind() == PrimitiveType.BYTE) {
            return "java.lang.Byte";
        }
        if (t.kind() == PrimitiveType.SHORT) {
            return "java.lang.Short";
        }
        if (t.kind() == PrimitiveType.INT) {
            return "java.lang.Integer";
        }
        if (t.kind() == PrimitiveType.LONG) {
            return "java.lang.Long";
        }
        if (t.kind() == PrimitiveType.FLOAT) {
            return "java.lang.Float";
        }
        if (t.kind() == PrimitiveType.DOUBLE) {
            return "java.lang.Double";
        }
        if (t.kind() == PrimitiveType.VOID) {
            return "java.lang.Void";
        }
        throw new InternalCompilerError("Unrecognized primitive type.");
    }

    public Context createContext() {
        return new Context_c(this);
    }

    public Resolver packageContextResolver(Resolver cr, Package p) {
        this.assert_(p);
        return new PackageContextResolver(this, p, cr);
    }

    public Resolver classContextResolver(ClassType type) {
        this.assert_(type);
        return new ClassContextResolver(this, type);
    }

    public FieldInstance fieldInstance(Position pos, ReferenceType container2, Flags flags, Type type, String name) {
        this.assert_(container2);
        this.assert_(type);
        return new FieldInstance_c(this, pos, container2, flags, type, name);
    }

    public LocalInstance localInstance(Position pos, Flags flags, Type type, String name) {
        this.assert_(type);
        return new LocalInstance_c(this, pos, flags, type, name);
    }

    public ConstructorInstance defaultConstructor(Position pos, ClassType container2) {
        this.assert_(container2);
        Flags access = Flags.NONE;
        if (container2.flags().isPrivate()) {
            access = access.Private();
        }
        if (container2.flags().isProtected()) {
            access = access.Protected();
        }
        if (container2.flags().isPublic()) {
            access = access.Public();
        }
        return this.constructorInstance(pos, container2, access, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    public ConstructorInstance constructorInstance(Position pos, ClassType container2, Flags flags, List argTypes, List excTypes) {
        this.assert_(container2);
        this.assert_(argTypes);
        this.assert_(excTypes);
        return new ConstructorInstance_c((TypeSystem)this, pos, container2, flags, argTypes, excTypes);
    }

    public InitializerInstance initializerInstance(Position pos, ClassType container2, Flags flags) {
        this.assert_(container2);
        return new InitializerInstance_c(this, pos, container2, flags);
    }

    public MethodInstance methodInstance(Position pos, ReferenceType container2, Flags flags, Type returnType, String name, List argTypes, List excTypes) {
        this.assert_(container2);
        this.assert_(returnType);
        this.assert_(argTypes);
        this.assert_(excTypes);
        return new MethodInstance_c(this, pos, container2, flags, returnType, name, argTypes, excTypes);
    }

    public boolean descendsFrom(Type child, Type ancestor) {
        this.assert_(child);
        this.assert_(ancestor);
        return child.descendsFromImpl(ancestor);
    }

    public boolean isCastValid(Type fromType, Type toType) {
        this.assert_(fromType);
        this.assert_(toType);
        return fromType.isCastValidImpl(toType);
    }

    public boolean isImplicitCastValid(Type fromType, Type toType) {
        this.assert_(fromType);
        this.assert_(toType);
        return fromType.isImplicitCastValidImpl(toType);
    }

    public boolean equals(TypeObject type1, TypeObject type2) {
        this.assert_(type1);
        this.assert_(type2);
        if (type1 instanceof TypeObject_c) {
            return ((TypeObject_c)type1).equalsImpl(type2);
        }
        throw new InternalCompilerError("Unknown implementation of TypeObject", type1.position());
    }

    public boolean numericConversionValid(Type t, Object value) {
        this.assert_(t);
        return t.numericConversionValidImpl(value);
    }

    public boolean numericConversionValid(Type t, long value) {
        this.assert_(t);
        return t.numericConversionValidImpl(value);
    }

    public boolean isCanonical(Type type) {
        this.assert_(type);
        return type.isCanonical();
    }

    public boolean isAccessible(MemberInstance mi, Context context) {
        return this.isAccessible(mi, context.currentClass());
    }

    protected boolean isAccessible(MemberInstance mi, ClassType contextClass) {
        this.assert_(mi);
        ReferenceType target = mi.container();
        Flags flags = mi.flags();
        if (!target.isClass()) {
            return flags.isPublic();
        }
        ClassType targetClass = target.toClass();
        if (!this.classAccessible(targetClass, contextClass)) {
            return false;
        }
        if (this.equals(targetClass, contextClass)) {
            return true;
        }
        if (this.isEnclosed(contextClass, targetClass) || this.isEnclosed(targetClass, contextClass)) {
            return true;
        }
        ClassType ct = contextClass;
        while (!ct.isTopLevel()) {
            if (!this.isEnclosed(targetClass, ct = ct.outer())) continue;
            return true;
        }
        if (flags.isProtected()) {
            if (this.descendsFrom(contextClass, targetClass)) {
                return true;
            }
            ct = contextClass;
            while (!ct.isTopLevel()) {
                if (!this.descendsFrom(ct = ct.outer(), targetClass)) continue;
                return true;
            }
        }
        return this.accessibleFromPackage(flags, targetClass.package_(), contextClass.package_());
    }

    public boolean classAccessible(ClassType targetClass, Context context) {
        if (context.currentClass() == null) {
            return this.classAccessibleFromPackage(targetClass, context.importTable().package_());
        }
        return this.classAccessible(targetClass, context.currentClass());
    }

    protected boolean classAccessible(ClassType targetClass, ClassType contextClass) {
        this.assert_(targetClass);
        if (targetClass.isMember()) {
            return this.isAccessible((MemberInstance)targetClass, contextClass);
        }
        if (!targetClass.isTopLevel()) {
            return true;
        }
        if (this.equals(targetClass, contextClass)) {
            return true;
        }
        if (this.isEnclosed(contextClass, targetClass)) {
            return true;
        }
        return this.accessibleFromPackage(targetClass.flags(), targetClass.package_(), contextClass.package_());
    }

    public boolean classAccessibleFromPackage(ClassType targetClass, Package pkg) {
        this.assert_(targetClass);
        if (!targetClass.isTopLevel() && !targetClass.isMember()) {
            return false;
        }
        Flags flags = targetClass.flags();
        if (targetClass.isMember()) {
            if (!targetClass.container().isClass()) {
                return flags.isPublic();
            }
            if (!this.classAccessibleFromPackage(targetClass.container().toClass(), pkg)) {
                return false;
            }
        }
        return this.accessibleFromPackage(flags, targetClass.package_(), pkg);
    }

    protected boolean accessibleFromPackage(Flags flags, Package pkg1, Package pkg2) {
        if (flags.isPublic()) {
            return true;
        }
        if (flags.isPackage() || flags.isProtected()) {
            if (pkg1 == null && pkg2 == null) {
                return true;
            }
            if (pkg1 != null && pkg1.equals(pkg2)) {
                return true;
            }
        }
        return false;
    }

    public boolean isEnclosed(ClassType inner, ClassType outer) {
        return inner.isEnclosedImpl(outer);
    }

    public boolean hasEnclosingInstance(ClassType inner, ClassType encl) {
        return inner.hasEnclosingInstanceImpl(encl);
    }

    public void checkCycles(ReferenceType goal) throws SemanticException {
        this.checkCycles(goal, goal);
    }

    protected void checkCycles(ReferenceType curr, ReferenceType goal) throws SemanticException {
        this.assert_(curr);
        this.assert_(goal);
        if (curr == null) {
            return;
        }
        ReferenceType superType = null;
        if (curr.superType() != null) {
            superType = curr.superType().toReference();
        }
        if (goal == superType) {
            throw new SemanticException("Circular inheritance involving " + goal, curr.position());
        }
        this.checkCycles(superType, goal);
        Iterator i = curr.interfaces().iterator();
        while (i.hasNext()) {
            Type si = (Type)i.next();
            if (si == goal) {
                throw new SemanticException("Circular inheritance involving " + goal, curr.position());
            }
            this.checkCycles(si.toReference(), goal);
        }
        if (curr.isClass()) {
            this.checkCycles(curr.toClass().outer(), goal);
        }
    }

    public boolean canCoerceToString(Type t, Context c) {
        return !t.isVoid();
    }

    public boolean isThrowable(Type type) {
        this.assert_(type);
        return type.isThrowable();
    }

    public boolean isUncheckedException(Type type) {
        this.assert_(type);
        return type.isUncheckedException();
    }

    public Collection uncheckedExceptions() {
        ArrayList<ClassType> l = new ArrayList<ClassType>(2);
        l.add(this.Error());
        l.add(this.RuntimeException());
        return l;
    }

    public boolean isSubtype(Type t1, Type t2) {
        this.assert_(t1);
        this.assert_(t2);
        return t1.isSubtypeImpl(t2);
    }

    public FieldInstance findField(ReferenceType container2, String name, Context c) throws SemanticException {
        ClassType ct = null;
        if (c != null) {
            ct = c.currentClass();
        }
        return this.findField(container2, name, ct);
    }

    public FieldInstance findField(ReferenceType container2, String name, ClassType currClass) throws SemanticException {
        Set fields = this.findFields(container2, name);
        if (fields.size() == 0) {
            throw new NoMemberException(3, "Field \"" + name + "\" not found in type \"" + container2 + "\".");
        }
        Iterator i = fields.iterator();
        FieldInstance fi = (FieldInstance)i.next();
        if (i.hasNext()) {
            FieldInstance fi2 = (FieldInstance)i.next();
            throw new SemanticException("Field \"" + name + "\" is ambiguous; it is defined in both " + fi.container() + " and " + fi2.container() + ".");
        }
        if (currClass != null && !this.isAccessible((MemberInstance)fi, currClass)) {
            throw new SemanticException("Cannot access " + fi + ".");
        }
        return fi;
    }

    public FieldInstance findField(ReferenceType container2, String name) throws SemanticException {
        return this.findField(container2, name, (ClassType)null);
    }

    protected Set findFields(ReferenceType container2, String name) {
        this.assert_(container2);
        if (container2 == null) {
            throw new InternalCompilerError("Cannot access field \"" + name + "\" within a null container type.");
        }
        FieldInstance fi = container2.fieldNamed(name);
        if (fi != null) {
            return Collections.singleton(fi);
        }
        HashSet fields = new HashSet();
        if (container2.superType() != null && container2.superType().isReference()) {
            Set superFields = this.findFields(container2.superType().toReference(), name);
            fields.addAll(superFields);
        }
        if (container2.isClass()) {
            ClassType ct = container2.toClass();
            Iterator i = ct.interfaces().iterator();
            while (i.hasNext()) {
                Type it = (Type)i.next();
                Set superFields = this.findFields(it.toReference(), name);
                fields.addAll(superFields);
            }
        }
        return fields;
    }

    public ClassType findMemberClass(ClassType container2, String name, Context c) throws SemanticException {
        return this.findMemberClass(container2, name, c.currentClass());
    }

    public ClassType findMemberClass(ClassType container2, String name, ClassType currClass) throws SemanticException {
        this.assert_(container2);
        Set s = this.findMemberClasses(container2, name);
        if (s.size() == 0) {
            throw new NoClassException(name, container2);
        }
        Iterator i = s.iterator();
        ClassType t = (ClassType)i.next();
        if (i.hasNext()) {
            ClassType t2 = (ClassType)i.next();
            throw new SemanticException("Member type \"" + name + "\" is ambiguous; it is defined in both " + t.container() + " and " + t2.container() + ".");
        }
        if (currClass != null && !this.isAccessible((MemberInstance)t, currClass)) {
            throw new SemanticException("Cannot access member type \"" + t + "\".");
        }
        return t;
    }

    public Set findMemberClasses(ClassType container2, String name) throws SemanticException {
        this.assert_(container2);
        ClassType mt = container2.memberClassNamed(name);
        if (mt != null) {
            if (!mt.isMember()) {
                throw new InternalCompilerError("Class " + mt + " is not a member class, " + " but is in " + container2 + "'s list of members.");
            }
            if (mt.outer() != container2) {
                throw new InternalCompilerError("Class " + mt + " has outer class " + mt.outer() + " but is a member of " + container2);
            }
            return Collections.singleton(mt);
        }
        HashSet memberClasses = new HashSet();
        if (container2.superType() != null) {
            Set s = this.findMemberClasses(container2.superType().toClass(), name);
            memberClasses.addAll(s);
        }
        Iterator i = container2.interfaces().iterator();
        while (i.hasNext()) {
            Type it = (Type)i.next();
            Set s = this.findMemberClasses(it.toClass(), name);
            memberClasses.addAll(s);
        }
        return memberClasses;
    }

    public ClassType findMemberClass(ClassType container2, String name) throws SemanticException {
        return this.findMemberClass(container2, name, (ClassType)null);
    }

    protected static String listToString(List l) {
        StringBuffer sb = new StringBuffer();
        Iterator i = l.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            sb.append(o.toString());
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public MethodInstance findMethod(ReferenceType container2, String name, List argTypes, Context c) throws SemanticException {
        return this.findMethod(container2, name, argTypes, c.currentClass());
    }

    public boolean hasMethodNamed(ReferenceType container2, String name) {
        this.assert_(container2);
        if (container2 == null) {
            throw new InternalCompilerError("Cannot access method \"" + name + "\" within a null container type.");
        }
        if (!container2.methodsNamed(name).isEmpty()) {
            return true;
        }
        if (container2.superType() != null && container2.superType().isReference() && this.hasMethodNamed(container2.superType().toReference(), name)) {
            return true;
        }
        if (container2.isClass()) {
            ClassType ct = container2.toClass();
            Iterator i = ct.interfaces().iterator();
            while (i.hasNext()) {
                Type it = (Type)i.next();
                if (!this.hasMethodNamed(it.toReference(), name)) continue;
                return true;
            }
        }
        return false;
    }

    public MethodInstance findMethod(ReferenceType container2, String name, List argTypes, ClassType currClass) throws SemanticException {
        this.assert_(container2);
        this.assert_(argTypes);
        List acceptable = this.findAcceptableMethods(container2, name, argTypes, currClass);
        if (acceptable.size() == 0) {
            throw new NoMemberException(1, "No valid method call found for " + name + "(" + TypeSystem_c.listToString(argTypes) + ")" + " in " + container2 + ".");
        }
        MethodInstance mi = (MethodInstance)this.findProcedure(acceptable, container2, argTypes, currClass);
        if (mi == null) {
            throw new SemanticException("Reference to " + name + " is ambiguous, multiple methods match: " + acceptable);
        }
        return mi;
    }

    public ConstructorInstance findConstructor(ClassType container2, List argTypes, Context c) throws SemanticException {
        return this.findConstructor(container2, argTypes, c.currentClass());
    }

    public ConstructorInstance findConstructor(ClassType container2, List argTypes, ClassType currClass) throws SemanticException {
        this.assert_(container2);
        this.assert_(argTypes);
        List acceptable = this.findAcceptableConstructors(container2, argTypes, currClass);
        if (acceptable.size() == 0) {
            throw new NoMemberException(2, "No valid constructor found for " + container2 + "(" + TypeSystem_c.listToString(argTypes) + ").");
        }
        ConstructorInstance ci = (ConstructorInstance)this.findProcedure(acceptable, container2, argTypes, currClass);
        if (ci == null) {
            throw new NoMemberException(2, "Reference to " + container2 + " is ambiguous, multiple " + "constructors match: " + acceptable);
        }
        return ci;
    }

    protected ProcedureInstance findProcedure(List acceptable, ReferenceType container2, List argTypes, ClassType currClass) throws SemanticException {
        Collection maximal = this.findMostSpecificProcedures(acceptable, container2, argTypes, currClass);
        if (maximal.size() == 1) {
            return (ProcedureInstance)maximal.iterator().next();
        }
        return null;
    }

    protected Collection findMostSpecificProcedures(List acceptable, ReferenceType container2, List argTypes, ClassType currClass) throws SemanticException {
        this.assert_(container2);
        this.assert_(argTypes);
        MostSpecificComparator msc = new MostSpecificComparator();
        Collections.sort(acceptable, msc);
        List<ProcedureInstance> maximal = new ArrayList<ProcedureInstance>(acceptable.size());
        Iterator i = acceptable.iterator();
        ProcedureInstance first = (ProcedureInstance)i.next();
        maximal.add(first);
        while (i.hasNext()) {
            ProcedureInstance p = (ProcedureInstance)i.next();
            if (msc.compare(first, p) < 0) continue;
            maximal.add(p);
        }
        if (maximal.size() > 1) {
            ProcedureInstance p;
            ArrayList<ProcedureInstance> notAbstract = new ArrayList<ProcedureInstance>(maximal.size());
            Iterator j = maximal.iterator();
            while (j.hasNext()) {
                p = (ProcedureInstance)j.next();
                if (p.flags().isAbstract()) continue;
                notAbstract.add(p);
            }
            if (notAbstract.size() == 1) {
                maximal = notAbstract;
            } else if (notAbstract.size() == 0) {
                j = maximal.iterator();
                first = (ProcedureInstance)j.next();
                while (j.hasNext()) {
                    p = (ProcedureInstance)j.next();
                    if (first.hasFormals(p.formalTypes())) continue;
                    return maximal;
                }
                maximal = Collections.singletonList(first);
            }
        }
        return maximal;
    }

    protected List findAcceptableMethods(ReferenceType container2, String name, List argTypes, ClassType currClass) throws SemanticException {
        this.assert_(container2);
        this.assert_(argTypes);
        ArrayList<MethodInstance> acceptable = new ArrayList<MethodInstance>();
        ArrayList<MethodInstance> unacceptable = new ArrayList<MethodInstance>();
        HashSet<Type> visitedTypes = new HashSet<Type>();
        LinkedList<Type> typeQueue = new LinkedList<Type>();
        typeQueue.addLast(container2);
        while (!typeQueue.isEmpty()) {
            Type type = (Type)typeQueue.removeFirst();
            if (visitedTypes.contains(type)) continue;
            visitedTypes.add(type);
            if (Report.should_report("types", 2)) {
                Report.report(2, "Searching type " + type + " for method " + name + "(" + TypeSystem_c.listToString(argTypes) + ")");
            }
            if (!type.isReference()) {
                throw new SemanticException("Cannot call method in  non-reference type " + type + ".");
            }
            Iterator i = type.toReference().methods().iterator();
            while (i.hasNext()) {
                MethodInstance mi = (MethodInstance)i.next();
                if (Report.should_report("types", 3)) {
                    Report.report(3, "Trying " + mi);
                }
                if (!this.methodCallValid(mi, name, argTypes)) continue;
                if (this.isAccessible((MemberInstance)mi, currClass)) {
                    if (Report.should_report("types", 3)) {
                        Report.report(3, "->acceptable: " + mi + " in " + mi.container());
                    }
                    acceptable.add(mi);
                    continue;
                }
                unacceptable.add(mi);
            }
            if (type.toReference().superType() != null) {
                typeQueue.addLast(type.toReference().superType());
            }
            typeQueue.addAll(type.toReference().interfaces());
        }
        Iterator i = unacceptable.iterator();
        while (i.hasNext()) {
            MethodInstance mi = (MethodInstance)i.next();
            acceptable.removeAll(mi.overrides());
        }
        return acceptable;
    }

    protected List findAcceptableConstructors(ClassType container2, List argTypes, ClassType currClass) throws SemanticException {
        this.assert_(container2);
        this.assert_(argTypes);
        ArrayList<ConstructorInstance> acceptable = new ArrayList<ConstructorInstance>();
        if (Report.should_report("types", 2)) {
            Report.report(2, "Searching type " + container2 + " for constructor " + container2 + "(" + TypeSystem_c.listToString(argTypes) + ")");
        }
        Iterator i = container2.constructors().iterator();
        while (i.hasNext()) {
            ConstructorInstance ci = (ConstructorInstance)i.next();
            if (Report.should_report("types", 3)) {
                Report.report(3, "Trying " + ci);
            }
            if (!this.callValid(ci, argTypes) || !this.isAccessible((MemberInstance)ci, currClass)) continue;
            if (Report.should_report("types", 3)) {
                Report.report(3, "->acceptable: " + ci);
            }
            acceptable.add(ci);
        }
        return acceptable;
    }

    public boolean moreSpecific(ProcedureInstance p1, ProcedureInstance p2) {
        return p1.moreSpecificImpl(p2);
    }

    public Type superType(ReferenceType type) {
        this.assert_(type);
        return type.superType();
    }

    public List interfaces(ReferenceType type) {
        this.assert_(type);
        return type.interfaces();
    }

    public Type leastCommonAncestor(Type type1, Type type2) throws SemanticException {
        this.assert_(type1);
        this.assert_(type2);
        if (this.equals(type1, type2)) {
            return type1;
        }
        if (type1.isNumeric() && type2.isNumeric()) {
            if (this.isImplicitCastValid(type1, type2)) {
                return type2;
            }
            if (this.isImplicitCastValid(type2, type1)) {
                return type1;
            }
            if (type1.isChar() && type2.isByte() || type1.isByte() && type2.isChar()) {
                return this.Int();
            }
            if (type1.isChar() && type2.isShort() || type1.isShort() && type2.isChar()) {
                return this.Int();
            }
        }
        if (type1.isArray() && type2.isArray()) {
            return this.arrayOf(this.leastCommonAncestor(type1.toArray().base(), type2.toArray().base()));
        }
        if (type1.isReference() && type2.isNull()) {
            return type1;
        }
        if (type2.isReference() && type1.isNull()) {
            return type2;
        }
        if (type1.isReference() && type2.isReference()) {
            Type t2;
            if (type1.isClass() && type1.toClass().flags().isInterface()) {
                return this.Object();
            }
            if (type2.isClass() && type2.toClass().flags().isInterface()) {
                return this.Object();
            }
            if (this.equals(type1, this.Object())) {
                return type1;
            }
            if (this.equals(type2, this.Object())) {
                return type2;
            }
            if (this.isSubtype(type1, type2)) {
                return type2;
            }
            if (this.isSubtype(type2, type1)) {
                return type1;
            }
            Type t1 = this.leastCommonAncestor(type1.toReference().superType(), type2);
            if (this.equals(t1, t2 = this.leastCommonAncestor(type2.toReference().superType(), type1))) {
                return t1;
            }
            return this.Object();
        }
        throw new SemanticException("No least common ancestor found for types \"" + type1 + "\" and \"" + type2 + "\".");
    }

    public boolean throwsSubset(ProcedureInstance p1, ProcedureInstance p2) {
        this.assert_(p1);
        this.assert_(p2);
        return p1.throwsSubsetImpl(p2);
    }

    public boolean hasFormals(ProcedureInstance pi, List formalTypes) {
        this.assert_(pi);
        this.assert_(formalTypes);
        return pi.hasFormalsImpl(formalTypes);
    }

    public boolean hasMethod(ReferenceType t, MethodInstance mi) {
        this.assert_(t);
        this.assert_(mi);
        return t.hasMethodImpl(mi);
    }

    public List overrides(MethodInstance mi) {
        return mi.overridesImpl();
    }

    public List implemented(MethodInstance mi) {
        return mi.implementedImpl(mi.container());
    }

    public boolean canOverride(MethodInstance mi, MethodInstance mj) {
        try {
            return mi.canOverrideImpl(mj, true);
        }
        catch (SemanticException e) {
            throw new InternalCompilerError(e);
        }
    }

    public void checkOverride(MethodInstance mi, MethodInstance mj) throws SemanticException {
        mi.canOverrideImpl(mj, false);
    }

    public boolean isSameMethod(MethodInstance m1, MethodInstance m2) {
        this.assert_(m1);
        this.assert_(m2);
        return m1.isSameMethodImpl(m2);
    }

    public boolean methodCallValid(MethodInstance prototype, String name, List argTypes) {
        this.assert_(prototype);
        this.assert_(argTypes);
        return prototype.methodCallValidImpl(name, argTypes);
    }

    public boolean callValid(ProcedureInstance prototype, List argTypes) {
        this.assert_(prototype);
        this.assert_(argTypes);
        return prototype.callValidImpl(argTypes);
    }

    public NullType Null() {
        return this.NULL_;
    }

    public PrimitiveType Void() {
        return this.VOID_;
    }

    public PrimitiveType Boolean() {
        return this.BOOLEAN_;
    }

    public PrimitiveType Char() {
        return this.CHAR_;
    }

    public PrimitiveType Byte() {
        return this.BYTE_;
    }

    public PrimitiveType Short() {
        return this.SHORT_;
    }

    public PrimitiveType Int() {
        return this.INT_;
    }

    public PrimitiveType Long() {
        return this.LONG_;
    }

    public PrimitiveType Float() {
        return this.FLOAT_;
    }

    public PrimitiveType Double() {
        return this.DOUBLE_;
    }

    protected ClassType load(String name) {
        try {
            return (ClassType)this.typeForName(name);
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("Cannot find class \"" + name + "\"; " + e.getMessage(), e);
        }
    }

    public Named forName(String name) throws SemanticException {
        try {
            return this.systemResolver.find(name);
        }
        catch (SemanticException e) {
            if (!StringUtil.isNameShort(name)) {
                String containerName = StringUtil.getPackageComponent(name);
                String shortName = StringUtil.getShortNameComponent(name);
                try {
                    Named container2 = this.forName(containerName);
                    if (container2 instanceof ClassType) {
                        return this.classContextResolver((ClassType)container2).find(shortName);
                    }
                }
                catch (SemanticException e2) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public Type typeForName(String name) throws SemanticException {
        return (Type)((Object)this.forName(name));
    }

    public ClassType Object() {
        if (this.OBJECT_ != null) {
            return this.OBJECT_;
        }
        this.OBJECT_ = this.load("java.lang.Object");
        return this.OBJECT_;
    }

    public ClassType Class() {
        if (this.CLASS_ != null) {
            return this.CLASS_;
        }
        this.CLASS_ = this.load("java.lang.Class");
        return this.CLASS_;
    }

    public ClassType String() {
        if (this.STRING_ != null) {
            return this.STRING_;
        }
        this.STRING_ = this.load("java.lang.String");
        return this.STRING_;
    }

    public ClassType Throwable() {
        if (this.THROWABLE_ != null) {
            return this.THROWABLE_;
        }
        this.THROWABLE_ = this.load("java.lang.Throwable");
        return this.THROWABLE_;
    }

    public ClassType Error() {
        return this.load("java.lang.Error");
    }

    public ClassType Exception() {
        return this.load("java.lang.Exception");
    }

    public ClassType RuntimeException() {
        return this.load("java.lang.RuntimeException");
    }

    public ClassType Cloneable() {
        return this.load("java.lang.Cloneable");
    }

    public ClassType Serializable() {
        return this.load("java.io.Serializable");
    }

    public ClassType NullPointerException() {
        return this.load("java.lang.NullPointerException");
    }

    public ClassType ClassCastException() {
        return this.load("java.lang.ClassCastException");
    }

    public ClassType OutOfBoundsException() {
        return this.load("java.lang.ArrayIndexOutOfBoundsException");
    }

    public ClassType ArrayStoreException() {
        return this.load("java.lang.ArrayStoreException");
    }

    public ClassType ArithmeticException() {
        return this.load("java.lang.ArithmeticException");
    }

    protected NullType createNull() {
        return new NullType_c(this);
    }

    protected PrimitiveType createPrimitive(PrimitiveType.Kind kind) {
        return new PrimitiveType_c((TypeSystem)this, kind);
    }

    public Object placeHolder(TypeObject o) {
        this.assert_(o);
        return this.placeHolder(o, new HashSet());
    }

    public Object placeHolder(TypeObject o, Set roots) {
        this.assert_(o);
        if (o instanceof ClassType) {
            ClassType ct = (ClassType)o;
            if (ct.isLocal() || ct.isAnonymous()) {
                throw new InternalCompilerError("Cannot serialize " + o + ".");
            }
            return new PlaceHolder_c(ct);
        }
        return o;
    }

    public UnknownType unknownType(Position pos) {
        return this.unknownType;
    }

    public UnknownPackage unknownPackage(Position pos) {
        return this.unknownPackage;
    }

    public UnknownQualifier unknownQualifier(Position pos) {
        return this.unknownQualifier;
    }

    public Package packageForName(Package prefix, String name) throws SemanticException {
        return this.createPackage(prefix, name);
    }

    public Package packageForName(String name) throws SemanticException {
        if (name == null || name.equals("")) {
            return null;
        }
        String s = StringUtil.getShortNameComponent(name);
        String p = StringUtil.getPackageComponent(name);
        return this.packageForName(this.packageForName(p), s);
    }

    public Package createPackage(Package prefix, String name) {
        this.assert_(prefix);
        return new Package_c(this, prefix, name);
    }

    public Package createPackage(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        String s = StringUtil.getShortNameComponent(name);
        String p = StringUtil.getPackageComponent(name);
        return this.createPackage(this.createPackage(p), s);
    }

    public ArrayType arrayOf(Type type) {
        this.assert_(type);
        return this.arrayOf(type.position(), type);
    }

    public ArrayType arrayOf(Position pos, Type type) {
        this.assert_(type);
        return this.arrayType(pos, type);
    }

    protected ArrayType arrayType(Position pos, Type type) {
        return new ArrayType_c(this, pos, type);
    }

    public ArrayType arrayOf(Type type, int dims) {
        return this.arrayOf(null, type, dims);
    }

    public ArrayType arrayOf(Position pos, Type type, int dims) {
        if (dims > 1) {
            return this.arrayOf(pos, this.arrayOf(pos, type, dims - 1));
        }
        if (dims == 1) {
            return this.arrayOf(pos, type);
        }
        throw new InternalCompilerError("Must call arrayOf(type, dims) with dims > 0");
    }

    public Type typeForClass(Class clazz) throws SemanticException {
        if (clazz == Void.TYPE) {
            return this.VOID_;
        }
        if (clazz == Boolean.TYPE) {
            return this.BOOLEAN_;
        }
        if (clazz == Byte.TYPE) {
            return this.BYTE_;
        }
        if (clazz == Character.TYPE) {
            return this.CHAR_;
        }
        if (clazz == Short.TYPE) {
            return this.SHORT_;
        }
        if (clazz == Integer.TYPE) {
            return this.INT_;
        }
        if (clazz == Long.TYPE) {
            return this.LONG_;
        }
        if (clazz == Float.TYPE) {
            return this.FLOAT_;
        }
        if (clazz == Double.TYPE) {
            return this.DOUBLE_;
        }
        if (clazz.isArray()) {
            return this.arrayOf(this.typeForClass(clazz.getComponentType()));
        }
        return (Type)((Object)this.systemResolver.find(clazz.getName()));
    }

    public Set getTypeEncoderRootSet(Type t) {
        return Collections.singleton(t);
    }

    public String getTransformedClassName(ClassType ct) {
        StringBuffer sb = new StringBuffer(ct.fullName().length());
        if (!ct.isMember() && !ct.isTopLevel()) {
            return null;
        }
        while (ct.isMember()) {
            sb.insert(0, ct.name());
            sb.insert(0, '$');
            if ((ct = ct.outer()).isMember() || ct.isTopLevel()) continue;
            return null;
        }
        sb.insert(0, ct.fullName());
        return sb.toString();
    }

    public String translatePackage(Resolver c, Package p) {
        return p.translate(c);
    }

    public String translateArray(Resolver c, ArrayType t) {
        return t.translate(c);
    }

    public String translateClass(Resolver c, ClassType t) {
        return t.translate(c);
    }

    public String translatePrimitive(Resolver c, PrimitiveType t) {
        return t.translate(c);
    }

    public PrimitiveType primitiveForName(String name) throws SemanticException {
        if (name.equals("void")) {
            return this.Void();
        }
        if (name.equals("boolean")) {
            return this.Boolean();
        }
        if (name.equals("char")) {
            return this.Char();
        }
        if (name.equals("byte")) {
            return this.Byte();
        }
        if (name.equals("short")) {
            return this.Short();
        }
        if (name.equals("int")) {
            return this.Int();
        }
        if (name.equals("long")) {
            return this.Long();
        }
        if (name.equals("float")) {
            return this.Float();
        }
        if (name.equals("double")) {
            return this.Double();
        }
        throw new SemanticException("Unrecognized primitive type \"" + name + "\".");
    }

    public LazyClassInitializer defaultClassInitializer() {
        if (this.defaultClassInit == null) {
            this.defaultClassInit = new LazyClassInitializer_c(this);
        }
        return this.defaultClassInit;
    }

    public final ParsedClassType createClassType() {
        return this.createClassType(this.defaultClassInitializer(), null);
    }

    public final ParsedClassType createClassType(Source fromSource) {
        return this.createClassType(this.defaultClassInitializer(), fromSource);
    }

    public final ParsedClassType createClassType(LazyClassInitializer init) {
        return this.createClassType(init, null);
    }

    public ParsedClassType createClassType(LazyClassInitializer init, Source fromSource) {
        return new ParsedClassType_c(this, init, fromSource);
    }

    public List defaultPackageImports() {
        ArrayList<String> l = new ArrayList<String>(1);
        l.add("java.lang");
        return l;
    }

    public PrimitiveType promote(Type t1, Type t2) throws SemanticException {
        if (!t1.isNumeric()) {
            throw new SemanticException("Cannot promote non-numeric type " + t1);
        }
        if (!t2.isNumeric()) {
            throw new SemanticException("Cannot promote non-numeric type " + t2);
        }
        return this.promoteNumeric(t1.toPrimitive(), t2.toPrimitive());
    }

    protected PrimitiveType promoteNumeric(PrimitiveType t1, PrimitiveType t2) {
        if (t1.isDouble() || t2.isDouble()) {
            return this.Double();
        }
        if (t1.isFloat() || t2.isFloat()) {
            return this.Float();
        }
        if (t1.isLong() || t2.isLong()) {
            return this.Long();
        }
        return this.Int();
    }

    public PrimitiveType promote(Type t) throws SemanticException {
        if (!t.isNumeric()) {
            throw new SemanticException("Cannot promote non-numeric type " + t);
        }
        return this.promoteNumeric(t.toPrimitive());
    }

    protected PrimitiveType promoteNumeric(PrimitiveType t) {
        if (t.isByte() || t.isShort() || t.isChar()) {
            return this.Int();
        }
        return t.toPrimitive();
    }

    public void checkMethodFlags(Flags f) throws SemanticException {
        if (!f.clear(this.METHOD_FLAGS).equals(Flags.NONE)) {
            throw new SemanticException("Cannot declare method with flags " + f.clear(this.METHOD_FLAGS) + ".");
        }
        if (f.isAbstract() && f.isPrivate()) {
            throw new SemanticException("Cannot declare method that is both abstract and private.");
        }
        if (f.isAbstract() && f.isStatic()) {
            throw new SemanticException("Cannot declare method that is both abstract and static.");
        }
        if (f.isAbstract() && f.isFinal()) {
            throw new SemanticException("Cannot declare method that is both abstract and final.");
        }
        if (f.isAbstract() && f.isNative()) {
            throw new SemanticException("Cannot declare method that is both abstract and native.");
        }
        if (f.isAbstract() && f.isSynchronized()) {
            throw new SemanticException("Cannot declare method that is both abstract and synchronized.");
        }
        if (f.isAbstract() && f.isStrictFP()) {
            throw new SemanticException("Cannot declare method that is both abstract and strictfp.");
        }
        this.checkAccessFlags(f);
    }

    public void checkLocalFlags(Flags f) throws SemanticException {
        if (!f.clear(this.LOCAL_FLAGS).equals(Flags.NONE)) {
            throw new SemanticException("Cannot declare local variable with flags " + f.clear(this.LOCAL_FLAGS) + ".");
        }
    }

    public void checkFieldFlags(Flags f) throws SemanticException {
        if (!f.clear(this.FIELD_FLAGS).equals(Flags.NONE)) {
            throw new SemanticException("Cannot declare field with flags " + f.clear(this.FIELD_FLAGS) + ".");
        }
        this.checkAccessFlags(f);
    }

    public void checkConstructorFlags(Flags f) throws SemanticException {
        if (!f.clear(this.CONSTRUCTOR_FLAGS).equals(Flags.NONE)) {
            throw new SemanticException("Cannot declare constructor with flags " + f.clear(this.CONSTRUCTOR_FLAGS) + ".");
        }
        this.checkAccessFlags(f);
    }

    public void checkInitializerFlags(Flags f) throws SemanticException {
        if (!f.clear(this.INITIALIZER_FLAGS).equals(Flags.NONE)) {
            throw new SemanticException("Cannot declare initializer with flags " + f.clear(this.INITIALIZER_FLAGS) + ".");
        }
    }

    public void checkTopLevelClassFlags(Flags f) throws SemanticException {
        if (!f.clear(this.TOP_LEVEL_CLASS_FLAGS).equals(Flags.NONE)) {
            throw new SemanticException("Cannot declare a top-level class with flag(s) " + f.clear(this.TOP_LEVEL_CLASS_FLAGS) + ".");
        }
        if (f.isFinal() && f.isInterface()) {
            throw new SemanticException("Cannot declare a final interface.");
        }
        this.checkAccessFlags(f);
    }

    public void checkMemberClassFlags(Flags f) throws SemanticException {
        if (!f.clear(this.MEMBER_CLASS_FLAGS).equals(Flags.NONE)) {
            throw new SemanticException("Cannot declare a member class with flag(s) " + f.clear(this.MEMBER_CLASS_FLAGS) + ".");
        }
        if (f.isStrictFP() && f.isInterface()) {
            throw new SemanticException("Cannot declare a strictfp interface.");
        }
        if (f.isFinal() && f.isInterface()) {
            throw new SemanticException("Cannot declare a final interface.");
        }
        this.checkAccessFlags(f);
    }

    public void checkLocalClassFlags(Flags f) throws SemanticException {
        if (f.isInterface()) {
            throw new SemanticException("Cannot declare a local interface.");
        }
        if (!f.clear(this.LOCAL_CLASS_FLAGS).equals(Flags.NONE)) {
            throw new SemanticException("Cannot declare a local class with flag(s) " + f.clear(this.LOCAL_CLASS_FLAGS) + ".");
        }
        this.checkAccessFlags(f);
    }

    public void checkAccessFlags(Flags f) throws SemanticException {
        int count = 0;
        if (f.isPublic()) {
            ++count;
        }
        if (f.isProtected()) {
            ++count;
        }
        if (f.isPrivate()) {
            ++count;
        }
        if (count > 1) {
            throw new SemanticException("Invalid access flags: " + f.retain(this.ACCESS_FLAGS) + ".");
        }
    }

    protected List abstractSuperInterfaces(ReferenceType rt) {
        ClassType c;
        LinkedList<ReferenceType> superInterfaces = new LinkedList<ReferenceType>();
        superInterfaces.add(rt);
        Iterator iter = rt.interfaces().iterator();
        while (iter.hasNext()) {
            ClassType interf = (ClassType)iter.next();
            superInterfaces.addAll(this.abstractSuperInterfaces(interf));
        }
        if (rt.superType() != null && (c = rt.superType().toClass()).flags().isAbstract()) {
            superInterfaces.addAll(this.abstractSuperInterfaces(c));
        }
        return superInterfaces;
    }

    public void checkClassConformance(ClassType ct) throws SemanticException {
        if (ct.flags().isInterface()) {
            return;
        }
        List superInterfaces = this.abstractSuperInterfaces(ct);
        Iterator i = superInterfaces.iterator();
        while (i.hasNext()) {
            ReferenceType rt = (ReferenceType)i.next();
            Iterator j = rt.methods().iterator();
            while (j.hasNext()) {
                MethodInstance mi = (MethodInstance)j.next();
                if (!mi.flags().isAbstract()) continue;
                boolean implFound = false;
                ClassType curr = ct;
                while (curr != null && !implFound) {
                    List possible = curr.methods(mi.name(), mi.formalTypes());
                    Iterator k = possible.iterator();
                    while (k.hasNext()) {
                        MethodInstance mj = (MethodInstance)k.next();
                        if (mj.flags().isAbstract() || (!this.isAccessible((MemberInstance)mi, ct) || !this.isAccessible((MemberInstance)mj, ct)) && !this.isAccessible((MemberInstance)mi, mj.container().toClass())) continue;
                        if (!this.equals(ct, mj.container()) && !this.equals(ct, mi.container())) {
                            try {
                                this.checkOverride(mj, mi);
                            }
                            catch (SemanticException e) {
                                throw new SemanticException(e.getMessage(), ct.position());
                            }
                        }
                        implFound = true;
                        break;
                    }
                    if (curr == mi.container()) break;
                    curr = curr.superType() == null ? null : curr.superType().toReference();
                }
                if (implFound || ct.flags().isAbstract()) continue;
                throw new SemanticException(ct.fullName() + " should be " + "declared abstract; it does not define " + mi.signature() + ", which is declared in " + rt.toClass().fullName(), ct.position());
            }
        }
    }

    public Type staticTarget(Type t) {
        return t;
    }

    protected void initFlags() {
        this.flagsForName = new HashMap();
        this.flagsForName.put("public", Flags.PUBLIC);
        this.flagsForName.put("private", Flags.PRIVATE);
        this.flagsForName.put("protected", Flags.PROTECTED);
        this.flagsForName.put("static", Flags.STATIC);
        this.flagsForName.put("final", Flags.FINAL);
        this.flagsForName.put("synchronized", Flags.SYNCHRONIZED);
        this.flagsForName.put("transient", Flags.TRANSIENT);
        this.flagsForName.put("native", Flags.NATIVE);
        this.flagsForName.put("interface", Flags.INTERFACE);
        this.flagsForName.put("abstract", Flags.ABSTRACT);
        this.flagsForName.put("volatile", Flags.VOLATILE);
        this.flagsForName.put("strictfp", Flags.STRICTFP);
    }

    public Flags createNewFlag(String name, Flags after) {
        Flags f = Flags.createFlag(name, name, name, after);
        this.flagsForName.put(name, f);
        return f;
    }

    public Flags NoFlags() {
        return Flags.NONE;
    }

    public Flags Public() {
        return Flags.PUBLIC;
    }

    public Flags Private() {
        return Flags.PRIVATE;
    }

    public Flags Protected() {
        return Flags.PROTECTED;
    }

    public Flags Static() {
        return Flags.STATIC;
    }

    public Flags Final() {
        return Flags.FINAL;
    }

    public Flags Synchronized() {
        return Flags.SYNCHRONIZED;
    }

    public Flags Transient() {
        return Flags.TRANSIENT;
    }

    public Flags Native() {
        return Flags.NATIVE;
    }

    public Flags Interface() {
        return Flags.INTERFACE;
    }

    public Flags Abstract() {
        return Flags.ABSTRACT;
    }

    public Flags Volatile() {
        return Flags.VOLATILE;
    }

    public Flags StrictFP() {
        return Flags.STRICTFP;
    }

    public Flags flagsForBits(int bits) {
        Flags f = Flags.NONE;
        if ((bits & 1) != 0) {
            f = f.Public();
        }
        if ((bits & 2) != 0) {
            f = f.Private();
        }
        if ((bits & 4) != 0) {
            f = f.Protected();
        }
        if ((bits & 8) != 0) {
            f = f.Static();
        }
        if ((bits & 0x10) != 0) {
            f = f.Final();
        }
        if ((bits & 0x20) != 0) {
            f = f.Synchronized();
        }
        if ((bits & 0x80) != 0) {
            f = f.Transient();
        }
        if ((bits & 0x100) != 0) {
            f = f.Native();
        }
        if ((bits & 0x200) != 0) {
            f = f.Interface();
        }
        if ((bits & 0x400) != 0) {
            f = f.Abstract();
        }
        if ((bits & 0x40) != 0) {
            f = f.Volatile();
        }
        if ((bits & 0x800) != 0) {
            f = f.StrictFP();
        }
        return f;
    }

    public Flags flagsForName(String name) {
        Flags f = (Flags)this.flagsForName.get(name);
        if (f == null) {
            throw new InternalCompilerError("No flag named \"" + name + "\".");
        }
        return f;
    }

    public String toString() {
        return StringUtil.getShortNameComponent(this.getClass().getName());
    }

    protected class MostSpecificComparator
    implements Comparator {
        protected MostSpecificComparator() {
        }

        public int compare(Object o1, Object o2) {
            ProcedureInstance p1 = (ProcedureInstance)o1;
            ProcedureInstance p2 = (ProcedureInstance)o2;
            if (TypeSystem_c.this.moreSpecific(p1, p2)) {
                return -1;
            }
            if (TypeSystem_c.this.moreSpecific(p2, p1)) {
                return 1;
            }
            if (p1.flags().isAbstract() == p2.flags().isAbstract()) {
                return 0;
            }
            if (p1.flags().isAbstract()) {
                return 1;
            }
            return -1;
        }
    }
}

