/*
 * Decompiled with CFR 0.152.
 */
package soot.baf;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import soot.AbstractJasminClass;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.Modifier;
import soot.NullType;
import soot.PackManager;
import soot.PatchingChain;
import soot.RefType;
import soot.ShortType;
import soot.SootClass;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.StmtAddressType;
import soot.Timers;
import soot.Trap;
import soot.Type;
import soot.TypeSwitch;
import soot.Unit;
import soot.UnitBox;
import soot.Value;
import soot.baf.AddInst;
import soot.baf.AndInst;
import soot.baf.ArrayLengthInst;
import soot.baf.ArrayReadInst;
import soot.baf.ArrayWriteInst;
import soot.baf.BafBody;
import soot.baf.CmpInst;
import soot.baf.CmpgInst;
import soot.baf.CmplInst;
import soot.baf.DivInst;
import soot.baf.DoubleWordType;
import soot.baf.Dup1Inst;
import soot.baf.Dup1_x1Inst;
import soot.baf.Dup1_x2Inst;
import soot.baf.Dup2Inst;
import soot.baf.Dup2_x1Inst;
import soot.baf.Dup2_x2Inst;
import soot.baf.DynamicInvokeInst;
import soot.baf.EnterMonitorInst;
import soot.baf.ExitMonitorInst;
import soot.baf.FieldGetInst;
import soot.baf.FieldPutInst;
import soot.baf.GotoInst;
import soot.baf.IdentityInst;
import soot.baf.IfCmpEqInst;
import soot.baf.IfCmpGeInst;
import soot.baf.IfCmpGtInst;
import soot.baf.IfCmpLeInst;
import soot.baf.IfCmpLtInst;
import soot.baf.IfCmpNeInst;
import soot.baf.IfEqInst;
import soot.baf.IfGeInst;
import soot.baf.IfGtInst;
import soot.baf.IfLeInst;
import soot.baf.IfLtInst;
import soot.baf.IfNeInst;
import soot.baf.IfNonNullInst;
import soot.baf.IfNullInst;
import soot.baf.IncInst;
import soot.baf.Inst;
import soot.baf.InstBox;
import soot.baf.InstSwitch;
import soot.baf.InstanceCastInst;
import soot.baf.InstanceOfInst;
import soot.baf.InterfaceInvokeInst;
import soot.baf.JSRInst;
import soot.baf.LoadInst;
import soot.baf.LookupSwitchInst;
import soot.baf.MulInst;
import soot.baf.NegInst;
import soot.baf.NewArrayInst;
import soot.baf.NewInst;
import soot.baf.NewMultiArrayInst;
import soot.baf.NopInst;
import soot.baf.OpTypeArgInst;
import soot.baf.OrInst;
import soot.baf.PopInst;
import soot.baf.PrimitiveCastInst;
import soot.baf.PushInst;
import soot.baf.RemInst;
import soot.baf.ReturnInst;
import soot.baf.ReturnVoidInst;
import soot.baf.ShlInst;
import soot.baf.ShrInst;
import soot.baf.SpecialInvokeInst;
import soot.baf.StaticGetInst;
import soot.baf.StaticInvokeInst;
import soot.baf.StaticPutInst;
import soot.baf.StoreInst;
import soot.baf.SubInst;
import soot.baf.SwapInst;
import soot.baf.TableSwitchInst;
import soot.baf.ThrowInst;
import soot.baf.UshrInst;
import soot.baf.VirtualInvokeInst;
import soot.baf.XorInst;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.ClassConstant;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.IdentityRef;
import soot.jimple.IntConstant;
import soot.jimple.JimpleBody;
import soot.jimple.LongConstant;
import soot.jimple.NullConstant;
import soot.jimple.ParameterRef;
import soot.jimple.StringConstant;
import soot.jimple.ThisRef;
import soot.options.Options;
import soot.tagkit.JasminAttribute;
import soot.tagkit.LineNumberTag;
import soot.tagkit.Tag;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.BriefBlockGraph;
import soot.util.ArraySet;

public class JasminClass
extends AbstractJasminClass {
    public JasminClass(SootClass sootClass) {
        super(sootClass);
    }

    @Override
    protected void assignColorsToLocals(Body body) {
        super.assignColorsToLocals(body);
        if (Options.v().time()) {
            Timers.v().packTimer.end();
        }
    }

    @Override
    protected void emitMethodBody(SootMethod method) {
        BriefBlockGraph blockGraph;
        List<Block> blocks;
        BafBody body;
        Body activeBody;
        if (Options.v().time()) {
            Timers.v().buildJasminTimer.end();
        }
        if (!((activeBody = method.getActiveBody()) instanceof BafBody)) {
            if (activeBody instanceof JimpleBody) {
                if (Options.v().verbose()) {
                    G.v().out.println("Was expecting Baf body for " + method + " but found a Jimple body. Will convert body to Baf on the fly.");
                }
                activeBody = PackManager.v().convertJimpleBodyToBaf(method);
            } else {
                throw new RuntimeException("method: " + method.getName() + " has an invalid active body!");
            }
        }
        if ((body = (BafBody)activeBody) == null) {
            throw new RuntimeException("method: " + method.getName() + " has no active body!");
        }
        if (Options.v().time()) {
            Timers.v().buildJasminTimer.start();
        }
        PatchingChain<Unit> instList = body.getUnits();
        int stackLimitIndex = -1;
        this.subroutineToReturnAddressSlot = new HashMap(10, 0.7f);
        this.unitToLabel = new HashMap(instList.size() * 2 + 1, 0.7f);
        this.labelCount = 0;
        for (UnitBox uBox : body.getUnitBoxes(true)) {
            InstBox box = (InstBox)uBox;
            if (this.unitToLabel.containsKey(box.getUnit())) continue;
            this.unitToLabel.put(box.getUnit(), "label" + this.labelCount++);
        }
        ArraySet<Unit> handlerUnits = new ArraySet<Unit>(body.getTraps().size());
        for (Trap trap : body.getTraps()) {
            handlerUnits.add(trap.getHandlerUnit());
            if (trap.getBeginUnit() == trap.getEndUnit()) continue;
            this.emit(".catch " + JasminClass.slashify(trap.getException().getName()) + " from " + (String)this.unitToLabel.get(trap.getBeginUnit()) + " to " + (String)this.unitToLabel.get(trap.getEndUnit()) + " using " + (String)this.unitToLabel.get(trap.getHandlerUnit()));
        }
        int localCount = 0;
        int[] paramSlots = new int[method.getParameterCount()];
        int thisSlot = 0;
        HashSet<Local> assignedLocals = new HashSet<Local>();
        this.localToSlot = new HashMap(body.getLocalCount() * 2 + 1, 0.7f);
        if (!method.isStatic()) {
            thisSlot = 0;
            ++localCount;
        }
        for (int i = 0; i < method.getParameterCount(); ++i) {
            paramSlots[i] = localCount;
            localCount += JasminClass.sizeOfType(method.getParameterType(i));
        }
        for (Unit u : instList) {
            Inst s = (Inst)u;
            if (!(s instanceof IdentityInst) || !(((IdentityInst)s).getLeftOp() instanceof Local)) continue;
            Local l = (Local)((IdentityInst)s).getLeftOp();
            IdentityRef identity = (IdentityRef)((IdentityInst)s).getRightOp();
            int slot = 0;
            if (identity instanceof ThisRef) {
                if (method.isStatic()) {
                    throw new RuntimeException("Attempting to use 'this' in static method");
                }
                slot = thisSlot;
            } else {
                if (!(identity instanceof ParameterRef)) continue;
                slot = paramSlots[((ParameterRef)identity).getIndex()];
            }
            this.localToSlot.put(l, new Integer(slot));
            assignedLocals.add(l);
        }
        for (Local local : body.getLocals()) {
            if (!assignedLocals.add(local)) continue;
            this.localToSlot.put(local, new Integer(localCount));
            localCount += JasminClass.sizeOfType(local.getType());
        }
        if (!Modifier.isNative(method.getModifiers()) && !Modifier.isAbstract(method.getModifiers())) {
            this.emit("    .limit stack ?");
            stackLimitIndex = this.code.size() - 1;
            this.emit("    .limit locals " + localCount);
        }
        this.isEmittingMethodCode = true;
        this.maxStackHeight = 0;
        this.isNextGotoAJsr = false;
        for (Unit u : instList) {
            Inst s = (Inst)u;
            if (this.unitToLabel.containsKey(s)) {
                this.emit((String)this.unitToLabel.get(s) + ":");
            }
            this.emitInst(s);
        }
        this.isEmittingMethodCode = false;
        this.maxStackHeight = 0;
        if (activeBody.getUnits().size() != 0 && (blocks = (blockGraph = new BriefBlockGraph(activeBody)).getBlocks()).size() != 0) {
            List entryPoints = blockGraph.getHeads();
            for (Block entryBlock : entryPoints) {
                Integer initialHeight = handlerUnits.contains(entryBlock.getHead()) ? new Integer(1) : new Integer(0);
                if (this.blockToStackHeight == null) {
                    this.blockToStackHeight = new HashMap();
                }
                this.blockToStackHeight.put(entryBlock, initialHeight);
                if (this.blockToLogicalStackHeight == null) {
                    this.blockToLogicalStackHeight = new HashMap();
                }
                this.blockToLogicalStackHeight.put(entryBlock, initialHeight);
            }
            for (Block nextBlock : entryPoints) {
                this.calculateStackHeight(nextBlock);
                this.calculateLogicalStackHeightCheck(nextBlock);
            }
        }
        if (!Modifier.isNative(method.getModifiers()) && !Modifier.isAbstract(method.getModifiers())) {
            this.code.set(stackLimitIndex, "    .limit stack " + this.maxStackHeight);
        }
        for (Tag t : body.getTags()) {
            if (!(t instanceof JasminAttribute)) continue;
            this.emit(".code_attribute " + t.getName() + " \"" + ((JasminAttribute)t).getJasminValue(this.unitToLabel) + "\"");
        }
    }

    void emitInst(Inst inst) {
        LineNumberTag lnTag = (LineNumberTag)inst.getTag("LineNumberTag");
        if (lnTag != null) {
            this.emit(".line " + lnTag.getLineNumber());
        }
        inst.apply(new InstSwitch(){

            @Override
            public void caseReturnVoidInst(ReturnVoidInst i) {
                JasminClass.this.emit("return");
            }

            @Override
            public void caseReturnInst(ReturnInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid return type " + t.toString());
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        JasminClass.this.emit("dreturn");
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        JasminClass.this.emit("freturn");
                    }

                    @Override
                    public void caseIntType(IntType t) {
                        JasminClass.this.emit("ireturn");
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        JasminClass.this.emit("ireturn");
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        JasminClass.this.emit("ireturn");
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        JasminClass.this.emit("ireturn");
                    }

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        JasminClass.this.emit("ireturn");
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        JasminClass.this.emit("lreturn");
                    }

                    @Override
                    public void caseArrayType(ArrayType t) {
                        JasminClass.this.emit("areturn");
                    }

                    @Override
                    public void caseRefType(RefType t) {
                        JasminClass.this.emit("areturn");
                    }

                    @Override
                    public void caseNullType(NullType t) {
                        JasminClass.this.emit("areturn");
                    }
                });
            }

            @Override
            public void caseNopInst(NopInst i) {
                JasminClass.this.emit("nop");
            }

            @Override
            public void caseEnterMonitorInst(EnterMonitorInst i) {
                JasminClass.this.emit("monitorenter");
            }

            @Override
            public void casePopInst(PopInst i) {
                if (i.getWordCount() == 2) {
                    JasminClass.this.emit("pop2");
                } else {
                    JasminClass.this.emit("pop");
                }
            }

            @Override
            public void caseExitMonitorInst(ExitMonitorInst i) {
                JasminClass.this.emit("monitorexit");
            }

            @Override
            public void caseGotoInst(GotoInst i) {
                JasminClass.this.emit("goto " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
            }

            @Override
            public void caseJSRInst(JSRInst i) {
                JasminClass.this.emit("jsr " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
            }

            @Override
            public void casePushInst(PushInst i) {
                if (i.getConstant() instanceof IntConstant) {
                    IntConstant v = (IntConstant)i.getConstant();
                    if (v.value == -1) {
                        JasminClass.this.emit("iconst_m1");
                    } else if (v.value >= 0 && v.value <= 5) {
                        JasminClass.this.emit("iconst_" + v.value);
                    } else if (v.value >= -128 && v.value <= 127) {
                        JasminClass.this.emit("bipush " + v.value);
                    } else if (v.value >= Short.MIN_VALUE && v.value <= Short.MAX_VALUE) {
                        JasminClass.this.emit("sipush " + v.value);
                    } else {
                        JasminClass.this.emit("ldc " + v.toString());
                    }
                } else if (i.getConstant() instanceof StringConstant) {
                    JasminClass.this.emit("ldc " + i.getConstant().toString());
                } else if (i.getConstant() instanceof ClassConstant) {
                    JasminClass.this.emit("ldc_w " + ((ClassConstant)i.getConstant()).getValue());
                } else if (i.getConstant() instanceof DoubleConstant) {
                    DoubleConstant v = (DoubleConstant)i.getConstant();
                    if (v.value == 0.0 && 1.0 / v.value > 0.0) {
                        JasminClass.this.emit("dconst_0");
                    } else if (v.value == 1.0) {
                        JasminClass.this.emit("dconst_1");
                    } else {
                        String s = JasminClass.this.doubleToString(v);
                        JasminClass.this.emit("ldc2_w " + s);
                    }
                } else if (i.getConstant() instanceof FloatConstant) {
                    FloatConstant v = (FloatConstant)i.getConstant();
                    if (v.value == 0.0f && 1.0f / v.value > 1.0f) {
                        JasminClass.this.emit("fconst_0");
                    } else if (v.value == 1.0f) {
                        JasminClass.this.emit("fconst_1");
                    } else if (v.value == 2.0f) {
                        JasminClass.this.emit("fconst_2");
                    } else {
                        String s = JasminClass.this.floatToString(v);
                        JasminClass.this.emit("ldc " + s);
                    }
                } else if (i.getConstant() instanceof LongConstant) {
                    LongConstant v = (LongConstant)i.getConstant();
                    if (v.value == 0L) {
                        JasminClass.this.emit("lconst_0");
                    } else if (v.value == 1L) {
                        JasminClass.this.emit("lconst_1");
                    } else {
                        JasminClass.this.emit("ldc2_w " + v.toString());
                    }
                } else if (i.getConstant() instanceof NullConstant) {
                    JasminClass.this.emit("aconst_null");
                } else {
                    throw new RuntimeException("unsupported opcode");
                }
            }

            @Override
            public void caseIdentityInst(IdentityInst i) {
                if (i.getRightOp() instanceof CaughtExceptionRef && i.getLeftOp() instanceof Local) {
                    int slot = (Integer)JasminClass.this.localToSlot.get(i.getLeftOp());
                    if (slot >= 0 && slot <= 3) {
                        JasminClass.this.emit("astore_" + slot);
                    } else {
                        JasminClass.this.emit("astore " + slot);
                    }
                }
            }

            @Override
            public void caseStoreInst(StoreInst i) {
                final int slot = (Integer)JasminClass.this.localToSlot.get(i.getLocal());
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void caseArrayType(ArrayType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("astore_" + slot);
                        } else {
                            JasminClass.this.emit("astore " + slot);
                        }
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("dstore_" + slot);
                        } else {
                            JasminClass.this.emit("dstore " + slot);
                        }
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("fstore_" + slot);
                        } else {
                            JasminClass.this.emit("fstore " + slot);
                        }
                    }

                    @Override
                    public void caseIntType(IntType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("istore_" + slot);
                        } else {
                            JasminClass.this.emit("istore " + slot);
                        }
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("istore_" + slot);
                        } else {
                            JasminClass.this.emit("istore " + slot);
                        }
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("istore_" + slot);
                        } else {
                            JasminClass.this.emit("istore " + slot);
                        }
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("istore_" + slot);
                        } else {
                            JasminClass.this.emit("istore " + slot);
                        }
                    }

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("istore_" + slot);
                        } else {
                            JasminClass.this.emit("istore " + slot);
                        }
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("lstore_" + slot);
                        } else {
                            JasminClass.this.emit("lstore " + slot);
                        }
                    }

                    @Override
                    public void caseRefType(RefType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("astore_" + slot);
                        } else {
                            JasminClass.this.emit("astore " + slot);
                        }
                    }

                    @Override
                    public void caseStmtAddressType(StmtAddressType t) {
                        JasminClass.this.isNextGotoAJsr = true;
                        JasminClass.this.returnAddressSlot = slot;
                    }

                    @Override
                    public void caseNullType(NullType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("astore_" + slot);
                        } else {
                            JasminClass.this.emit("astore " + slot);
                        }
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid local type:" + t);
                    }
                });
            }

            @Override
            public void caseLoadInst(LoadInst i) {
                final int slot = (Integer)JasminClass.this.localToSlot.get(i.getLocal());
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void caseArrayType(ArrayType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("aload_" + slot);
                        } else {
                            JasminClass.this.emit("aload " + slot);
                        }
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid local type to load" + t);
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("dload_" + slot);
                        } else {
                            JasminClass.this.emit("dload " + slot);
                        }
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("fload_" + slot);
                        } else {
                            JasminClass.this.emit("fload " + slot);
                        }
                    }

                    @Override
                    public void caseIntType(IntType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("iload_" + slot);
                        } else {
                            JasminClass.this.emit("iload " + slot);
                        }
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("iload_" + slot);
                        } else {
                            JasminClass.this.emit("iload " + slot);
                        }
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("iload_" + slot);
                        } else {
                            JasminClass.this.emit("iload " + slot);
                        }
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("iload_" + slot);
                        } else {
                            JasminClass.this.emit("iload " + slot);
                        }
                    }

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("iload_" + slot);
                        } else {
                            JasminClass.this.emit("iload " + slot);
                        }
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("lload_" + slot);
                        } else {
                            JasminClass.this.emit("lload " + slot);
                        }
                    }

                    @Override
                    public void caseRefType(RefType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("aload_" + slot);
                        } else {
                            JasminClass.this.emit("aload " + slot);
                        }
                    }

                    @Override
                    public void caseNullType(NullType t) {
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("aload_" + slot);
                        } else {
                            JasminClass.this.emit("aload " + slot);
                        }
                    }
                });
            }

            @Override
            public void caseArrayWriteInst(ArrayWriteInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void caseArrayType(ArrayType t) {
                        JasminClass.this.emit("aastore");
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        JasminClass.this.emit("dastore");
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        JasminClass.this.emit("fastore");
                    }

                    @Override
                    public void caseIntType(IntType t) {
                        JasminClass.this.emit("iastore");
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        JasminClass.this.emit("lastore");
                    }

                    @Override
                    public void caseRefType(RefType t) {
                        JasminClass.this.emit("aastore");
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        JasminClass.this.emit("bastore");
                    }

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        JasminClass.this.emit("bastore");
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        JasminClass.this.emit("castore");
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        JasminClass.this.emit("sastore");
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid type: " + t);
                    }
                });
            }

            @Override
            public void caseArrayReadInst(ArrayReadInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void caseArrayType(ArrayType ty) {
                        JasminClass.this.emit("aaload");
                    }

                    @Override
                    public void caseBooleanType(BooleanType ty) {
                        JasminClass.this.emit("baload");
                    }

                    @Override
                    public void caseByteType(ByteType ty) {
                        JasminClass.this.emit("baload");
                    }

                    @Override
                    public void caseCharType(CharType ty) {
                        JasminClass.this.emit("caload");
                    }

                    @Override
                    public void defaultCase(Type ty) {
                        throw new RuntimeException("invalid base type");
                    }

                    @Override
                    public void caseDoubleType(DoubleType ty) {
                        JasminClass.this.emit("daload");
                    }

                    @Override
                    public void caseFloatType(FloatType ty) {
                        JasminClass.this.emit("faload");
                    }

                    @Override
                    public void caseIntType(IntType ty) {
                        JasminClass.this.emit("iaload");
                    }

                    @Override
                    public void caseLongType(LongType ty) {
                        JasminClass.this.emit("laload");
                    }

                    @Override
                    public void caseNullType(NullType ty) {
                        JasminClass.this.emit("aaload");
                    }

                    @Override
                    public void caseRefType(RefType ty) {
                        JasminClass.this.emit("aaload");
                    }

                    @Override
                    public void caseShortType(ShortType ty) {
                        JasminClass.this.emit("saload");
                    }
                });
            }

            @Override
            public void caseIfNullInst(IfNullInst i) {
                JasminClass.this.emit("ifnull " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
            }

            @Override
            public void caseIfNonNullInst(IfNonNullInst i) {
                JasminClass.this.emit("ifnonnull " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
            }

            @Override
            public void caseIfEqInst(IfEqInst i) {
                JasminClass.this.emit("ifeq " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
            }

            @Override
            public void caseIfNeInst(IfNeInst i) {
                JasminClass.this.emit("ifne " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
            }

            @Override
            public void caseIfGtInst(IfGtInst i) {
                JasminClass.this.emit("ifgt " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
            }

            @Override
            public void caseIfGeInst(IfGeInst i) {
                JasminClass.this.emit("ifge " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
            }

            @Override
            public void caseIfLtInst(IfLtInst i) {
                JasminClass.this.emit("iflt " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
            }

            @Override
            public void caseIfLeInst(IfLeInst i) {
                JasminClass.this.emit("ifle " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
            }

            @Override
            public void caseIfCmpEqInst(final IfCmpEqInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void caseIntType(IntType t) {
                        JasminClass.this.emit("if_icmpeq " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        JasminClass.this.emit("if_icmpeq " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        JasminClass.this.emit("if_icmpeq " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        JasminClass.this.emit("if_icmpeq " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        JasminClass.this.emit("if_icmpeq " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        JasminClass.this.emit("dcmpg");
                        JasminClass.this.emit("ifeq " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        JasminClass.this.emit("lcmp");
                        JasminClass.this.emit("ifeq " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        JasminClass.this.emit("fcmpg");
                        JasminClass.this.emit("ifeq " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseArrayType(ArrayType t) {
                        JasminClass.this.emit("if_acmpeq " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseRefType(RefType t) {
                        JasminClass.this.emit("if_acmpeq " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseNullType(NullType t) {
                        JasminClass.this.emit("if_acmpeq " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseIfCmpNeInst(final IfCmpNeInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void caseIntType(IntType t) {
                        JasminClass.this.emit("if_icmpne " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        JasminClass.this.emit("if_icmpne " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        JasminClass.this.emit("if_icmpne " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        JasminClass.this.emit("if_icmpne " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        JasminClass.this.emit("if_icmpne " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        JasminClass.this.emit("dcmpg");
                        JasminClass.this.emit("ifne " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        JasminClass.this.emit("lcmp");
                        JasminClass.this.emit("ifne " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        JasminClass.this.emit("fcmpg");
                        JasminClass.this.emit("ifne " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseArrayType(ArrayType t) {
                        JasminClass.this.emit("if_acmpne " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseRefType(RefType t) {
                        JasminClass.this.emit("if_acmpne " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseNullType(NullType t) {
                        JasminClass.this.emit("if_acmpne " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseIfCmpGtInst(final IfCmpGtInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void caseIntType(IntType t) {
                        JasminClass.this.emit("if_icmpgt " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        JasminClass.this.emit("if_icmpgt " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        JasminClass.this.emit("if_icmpgt " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        JasminClass.this.emit("if_icmpgt " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        JasminClass.this.emit("if_icmpgt " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        JasminClass.this.emit("dcmpg");
                        JasminClass.this.emit("ifgt " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        JasminClass.this.emit("lcmp");
                        JasminClass.this.emit("ifgt " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        JasminClass.this.emit("fcmpg");
                        JasminClass.this.emit("ifgt " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseArrayType(ArrayType t) {
                        JasminClass.this.emit("if_acmpgt " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseRefType(RefType t) {
                        JasminClass.this.emit("if_acmpgt " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseNullType(NullType t) {
                        JasminClass.this.emit("if_acmpgt " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseIfCmpGeInst(final IfCmpGeInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void caseIntType(IntType t) {
                        JasminClass.this.emit("if_icmpge " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        JasminClass.this.emit("if_icmpge " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        JasminClass.this.emit("if_icmpge " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        JasminClass.this.emit("if_icmpge " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        JasminClass.this.emit("if_icmpge " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        JasminClass.this.emit("dcmpg");
                        JasminClass.this.emit("ifge " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        JasminClass.this.emit("lcmp");
                        JasminClass.this.emit("ifge " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        JasminClass.this.emit("fcmpg");
                        JasminClass.this.emit("ifge " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseArrayType(ArrayType t) {
                        JasminClass.this.emit("if_acmpge " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseRefType(RefType t) {
                        JasminClass.this.emit("if_acmpge " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseNullType(NullType t) {
                        JasminClass.this.emit("if_acmpge " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseIfCmpLtInst(final IfCmpLtInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void caseIntType(IntType t) {
                        JasminClass.this.emit("if_icmplt " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        JasminClass.this.emit("if_icmplt " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        JasminClass.this.emit("if_icmplt " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        JasminClass.this.emit("if_icmplt " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        JasminClass.this.emit("if_icmplt " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        JasminClass.this.emit("dcmpg");
                        JasminClass.this.emit("iflt " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        JasminClass.this.emit("lcmp");
                        JasminClass.this.emit("iflt " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        JasminClass.this.emit("fcmpg");
                        JasminClass.this.emit("iflt " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseArrayType(ArrayType t) {
                        JasminClass.this.emit("if_acmplt " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseRefType(RefType t) {
                        JasminClass.this.emit("if_acmplt " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseNullType(NullType t) {
                        JasminClass.this.emit("if_acmplt " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseIfCmpLeInst(final IfCmpLeInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    @Override
                    public void caseIntType(IntType t) {
                        JasminClass.this.emit("if_icmple " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        JasminClass.this.emit("if_icmple " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        JasminClass.this.emit("if_icmple " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        JasminClass.this.emit("if_icmple " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        JasminClass.this.emit("if_icmple " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        JasminClass.this.emit("dcmpg");
                        JasminClass.this.emit("ifle " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        JasminClass.this.emit("lcmp");
                        JasminClass.this.emit("ifle " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        JasminClass.this.emit("fcmpg");
                        JasminClass.this.emit("ifle " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseArrayType(ArrayType t) {
                        JasminClass.this.emit("if_acmple " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseRefType(RefType t) {
                        JasminClass.this.emit("if_acmple " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void caseNullType(NullType t) {
                        JasminClass.this.emit("if_acmple " + (String)JasminClass.this.unitToLabel.get(i.getTarget()));
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseStaticGetInst(StaticGetInst i) {
                SootFieldRef field = i.getFieldRef();
                JasminClass.this.emit("getstatic " + AbstractJasminClass.slashify(field.declaringClass().getName()) + "/" + field.name() + " " + AbstractJasminClass.jasminDescriptorOf(field.type()));
            }

            @Override
            public void caseStaticPutInst(StaticPutInst i) {
                JasminClass.this.emit("putstatic " + AbstractJasminClass.slashify(i.getFieldRef().declaringClass().getName()) + "/" + i.getFieldRef().name() + " " + AbstractJasminClass.jasminDescriptorOf(i.getFieldRef().type()));
            }

            @Override
            public void caseFieldGetInst(FieldGetInst i) {
                JasminClass.this.emit("getfield " + AbstractJasminClass.slashify(i.getFieldRef().declaringClass().getName()) + "/" + i.getFieldRef().name() + " " + AbstractJasminClass.jasminDescriptorOf(i.getFieldRef().type()));
            }

            @Override
            public void caseFieldPutInst(FieldPutInst i) {
                JasminClass.this.emit("putfield " + AbstractJasminClass.slashify(i.getFieldRef().declaringClass().getName()) + "/" + i.getFieldRef().name() + " " + AbstractJasminClass.jasminDescriptorOf(i.getFieldRef().type()));
            }

            @Override
            public void caseInstanceCastInst(InstanceCastInst i) {
                Type castType = i.getCastType();
                if (castType instanceof RefType) {
                    JasminClass.this.emit("checkcast " + AbstractJasminClass.slashify(castType.toString()));
                } else if (castType instanceof ArrayType) {
                    JasminClass.this.emit("checkcast " + AbstractJasminClass.jasminDescriptorOf(castType));
                }
            }

            @Override
            public void caseInstanceOfInst(InstanceOfInst i) {
                Type checkType = i.getCheckType();
                if (checkType instanceof RefType) {
                    JasminClass.this.emit("instanceof " + AbstractJasminClass.slashify(checkType.toString()));
                } else if (checkType instanceof ArrayType) {
                    JasminClass.this.emit("instanceof " + AbstractJasminClass.jasminDescriptorOf(checkType));
                }
            }

            @Override
            public void caseNewInst(NewInst i) {
                JasminClass.this.emit("new " + AbstractJasminClass.slashify(i.getBaseType().toString()));
            }

            @Override
            public void casePrimitiveCastInst(PrimitiveCastInst i) {
                JasminClass.this.emit(i.toString());
            }

            @Override
            public void caseDynamicInvokeInst(DynamicInvokeInst i) {
                SootMethodRef m = i.getMethodRef();
                SootMethodRef bsm = i.getBootstrapMethodRef();
                String bsmArgString = "";
                Iterator<Value> iterator = i.getBootstrapArgs().iterator();
                while (iterator.hasNext()) {
                    Value val = iterator.next();
                    bsmArgString = bsmArgString + "(" + AbstractJasminClass.jasminDescriptorOf(val.getType()) + ")";
                    bsmArgString = bsmArgString + this.escape(val.toString());
                    if (!iterator.hasNext()) continue;
                    bsmArgString = bsmArgString + ",";
                }
                JasminClass.this.emit("invokedynamic \"" + m.name() + "\" " + AbstractJasminClass.jasminDescriptorOf(m) + " " + AbstractJasminClass.slashify(bsm.declaringClass().getName()) + "/" + bsm.name() + AbstractJasminClass.jasminDescriptorOf(bsm) + "(" + bsmArgString + ")");
            }

            private String escape(String bsmArgString) {
                return bsmArgString.replace(",", "\\comma").replace(" ", "\\blank").replace("\t", "\\tab").replace("\n", "\\newline");
            }

            @Override
            public void caseStaticInvokeInst(StaticInvokeInst i) {
                SootMethodRef m = i.getMethodRef();
                JasminClass.this.emit("invokestatic " + AbstractJasminClass.slashify(m.declaringClass().getName()) + "/" + m.name() + AbstractJasminClass.jasminDescriptorOf(m));
            }

            @Override
            public void caseVirtualInvokeInst(VirtualInvokeInst i) {
                SootMethodRef m = i.getMethodRef();
                JasminClass.this.emit("invokevirtual " + AbstractJasminClass.slashify(m.declaringClass().getName()) + "/" + m.name() + AbstractJasminClass.jasminDescriptorOf(m));
            }

            @Override
            public void caseInterfaceInvokeInst(InterfaceInvokeInst i) {
                SootMethodRef m = i.getMethodRef();
                JasminClass.this.emit("invokeinterface " + AbstractJasminClass.slashify(m.declaringClass().getName()) + "/" + m.name() + AbstractJasminClass.jasminDescriptorOf(m) + " " + (AbstractJasminClass.argCountOf(m) + 1));
            }

            @Override
            public void caseSpecialInvokeInst(SpecialInvokeInst i) {
                SootMethodRef m = i.getMethodRef();
                JasminClass.this.emit("invokespecial " + AbstractJasminClass.slashify(m.declaringClass().getName()) + "/" + m.name() + AbstractJasminClass.jasminDescriptorOf(m));
            }

            @Override
            public void caseThrowInst(ThrowInst i) {
                JasminClass.this.emit("athrow");
            }

            @Override
            public void caseCmpInst(CmpInst i) {
                JasminClass.this.emit("lcmp");
            }

            @Override
            public void caseCmplInst(CmplInst i) {
                if (i.getOpType().equals(FloatType.v())) {
                    JasminClass.this.emit("fcmpl");
                } else {
                    JasminClass.this.emit("dcmpl");
                }
            }

            @Override
            public void caseCmpgInst(CmpgInst i) {
                if (i.getOpType().equals(FloatType.v())) {
                    JasminClass.this.emit("fcmpg");
                } else {
                    JasminClass.this.emit("dcmpg");
                }
            }

            private void emitOpTypeInst(final String s, OpTypeArgInst i) {
                i.getOpType().apply(new TypeSwitch(){

                    private void handleIntCase() {
                        JasminClass.this.emit("i" + s);
                    }

                    @Override
                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseLongType(LongType t) {
                        JasminClass.this.emit("l" + s);
                    }

                    @Override
                    public void caseDoubleType(DoubleType t) {
                        JasminClass.this.emit("d" + s);
                    }

                    @Override
                    public void caseFloatType(FloatType t) {
                        JasminClass.this.emit("f" + s);
                    }

                    @Override
                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid argument type for div");
                    }
                });
            }

            @Override
            public void caseAddInst(AddInst i) {
                this.emitOpTypeInst("add", i);
            }

            @Override
            public void caseDivInst(DivInst i) {
                this.emitOpTypeInst("div", i);
            }

            @Override
            public void caseSubInst(SubInst i) {
                this.emitOpTypeInst("sub", i);
            }

            @Override
            public void caseMulInst(MulInst i) {
                this.emitOpTypeInst("mul", i);
            }

            @Override
            public void caseRemInst(RemInst i) {
                this.emitOpTypeInst("rem", i);
            }

            @Override
            public void caseShlInst(ShlInst i) {
                this.emitOpTypeInst("shl", i);
            }

            @Override
            public void caseAndInst(AndInst i) {
                this.emitOpTypeInst("and", i);
            }

            @Override
            public void caseOrInst(OrInst i) {
                this.emitOpTypeInst("or", i);
            }

            @Override
            public void caseXorInst(XorInst i) {
                this.emitOpTypeInst("xor", i);
            }

            @Override
            public void caseShrInst(ShrInst i) {
                this.emitOpTypeInst("shr", i);
            }

            @Override
            public void caseUshrInst(UshrInst i) {
                this.emitOpTypeInst("ushr", i);
            }

            @Override
            public void caseIncInst(IncInst i) {
                if (i.getUseBoxes().get(0).getValue() != i.getDefBoxes().get(0).getValue()) {
                    throw new RuntimeException("iinc def and use boxes don't match");
                }
                JasminClass.this.emit("iinc " + JasminClass.this.localToSlot.get(i.getLocal()) + " " + i.getConstant());
            }

            @Override
            public void caseArrayLengthInst(ArrayLengthInst i) {
                JasminClass.this.emit("arraylength");
            }

            @Override
            public void caseNegInst(NegInst i) {
                this.emitOpTypeInst("neg", i);
            }

            @Override
            public void caseNewArrayInst(NewArrayInst i) {
                if (i.getBaseType() instanceof RefType) {
                    JasminClass.this.emit("anewarray " + AbstractJasminClass.slashify(i.getBaseType().toString()));
                } else if (i.getBaseType() instanceof ArrayType) {
                    JasminClass.this.emit("anewarray " + AbstractJasminClass.jasminDescriptorOf(i.getBaseType()));
                } else {
                    JasminClass.this.emit("newarray " + i.getBaseType().toString());
                }
            }

            @Override
            public void caseNewMultiArrayInst(NewMultiArrayInst i) {
                JasminClass.this.emit("multianewarray " + AbstractJasminClass.jasminDescriptorOf(i.getBaseType()) + " " + i.getDimensionCount());
            }

            @Override
            public void caseLookupSwitchInst(LookupSwitchInst i) {
                JasminClass.this.emit("lookupswitch");
                List<IntConstant> lookupValues = i.getLookupValues();
                List<Unit> targets = i.getTargets();
                for (int j = 0; j < lookupValues.size(); ++j) {
                    JasminClass.this.emit("  " + lookupValues.get(j) + " : " + (String)JasminClass.this.unitToLabel.get(targets.get(j)));
                }
                JasminClass.this.emit("  default : " + (String)JasminClass.this.unitToLabel.get(i.getDefaultTarget()));
            }

            @Override
            public void caseTableSwitchInst(TableSwitchInst i) {
                JasminClass.this.emit("tableswitch " + i.getLowIndex() + " ; high = " + i.getHighIndex());
                List<Unit> targets = i.getTargets();
                for (int j = 0; j < targets.size(); ++j) {
                    JasminClass.this.emit("  " + (String)JasminClass.this.unitToLabel.get(targets.get(j)));
                }
                JasminClass.this.emit("default : " + (String)JasminClass.this.unitToLabel.get(i.getDefaultTarget()));
            }

            private boolean isDwordType(Type t) {
                return t instanceof LongType || t instanceof DoubleType || t instanceof DoubleWordType;
            }

            @Override
            public void caseDup1Inst(Dup1Inst i) {
                Type firstOpType = i.getOp1Type();
                if (this.isDwordType(firstOpType)) {
                    JasminClass.this.emit("dup2");
                } else {
                    JasminClass.this.emit("dup");
                }
            }

            @Override
            public void caseDup2Inst(Dup2Inst i) {
                Type firstOpType = i.getOp1Type();
                Type secondOpType = i.getOp2Type();
                if (this.isDwordType(firstOpType)) {
                    JasminClass.this.emit("dup2");
                    if (this.isDwordType(secondOpType)) {
                        JasminClass.this.emit("dup2");
                    } else {
                        JasminClass.this.emit("dup");
                    }
                } else if (this.isDwordType(secondOpType)) {
                    if (this.isDwordType(firstOpType)) {
                        JasminClass.this.emit("dup2");
                    } else {
                        JasminClass.this.emit("dup");
                    }
                    JasminClass.this.emit("dup2");
                } else {
                    JasminClass.this.emit("dup2");
                }
            }

            @Override
            public void caseDup1_x1Inst(Dup1_x1Inst i) {
                Type opType = i.getOp1Type();
                Type underType = i.getUnder1Type();
                if (this.isDwordType(opType)) {
                    if (this.isDwordType(underType)) {
                        JasminClass.this.emit("dup2_x2");
                    } else {
                        JasminClass.this.emit("dup2_x1");
                    }
                } else if (this.isDwordType(underType)) {
                    JasminClass.this.emit("dup_x2");
                } else {
                    JasminClass.this.emit("dup_x1");
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void caseDup1_x2Inst(Dup1_x2Inst i) {
                Type opType = i.getOp1Type();
                Type under1Type = i.getUnder1Type();
                Type under2Type = i.getUnder2Type();
                if (this.isDwordType(opType)) {
                    if (this.isDwordType(under1Type) || this.isDwordType(under2Type)) throw new RuntimeException("magic not implemented yet");
                    JasminClass.this.emit("dup2_x2");
                } else if (this.isDwordType(under1Type) || this.isDwordType(under2Type)) {
                    throw new RuntimeException("magic not implemented yet");
                }
                JasminClass.this.emit("dup_x2");
            }

            @Override
            public void caseDup2_x1Inst(Dup2_x1Inst i) {
                Type op1Type = i.getOp1Type();
                Type op2Type = i.getOp2Type();
                Type under1Type = i.getUnder1Type();
                if (this.isDwordType(under1Type)) {
                    if (!this.isDwordType(op1Type) && !this.isDwordType(op2Type)) {
                        throw new RuntimeException("magic not implemented yet");
                    }
                    JasminClass.this.emit("dup2_x2");
                } else if (this.isDwordType(op1Type) && op2Type != null || this.isDwordType(op2Type)) {
                    throw new RuntimeException("magic not implemented yet");
                }
                JasminClass.this.emit("dup2_x1");
            }

            @Override
            public void caseDup2_x2Inst(Dup2_x2Inst i) {
                Type op1Type = i.getOp1Type();
                Type op2Type = i.getOp2Type();
                Type under1Type = i.getUnder1Type();
                Type under2Type = i.getUnder2Type();
                boolean malformed = true;
                if (this.isDwordType(op1Type)) {
                    if (op2Type == null && under1Type != null && (under2Type == null && this.isDwordType(under1Type) || !this.isDwordType(under1Type) && under2Type != null && !this.isDwordType(under2Type))) {
                        malformed = false;
                    }
                } else if (op1Type != null && op2Type != null && !this.isDwordType(op2Type) && (under2Type == null && this.isDwordType(under1Type) || under1Type != null && !this.isDwordType(under1Type) && under2Type != null && !this.isDwordType(under2Type))) {
                    malformed = false;
                }
                if (malformed) {
                    throw new RuntimeException("magic not implemented yet");
                }
                JasminClass.this.emit("dup2_x2");
            }

            @Override
            public void caseSwapInst(SwapInst i) {
                JasminClass.this.emit("swap");
            }
        });
    }

    private void calculateStackHeight(Block aBlock) {
        int blockHeight = (Integer)this.blockToStackHeight.get(aBlock);
        if (blockHeight > this.maxStackHeight) {
            this.maxStackHeight = blockHeight;
        }
        for (Unit u : aBlock) {
            Inst nInst = (Inst)u;
            if ((blockHeight -= nInst.getInMachineCount()) < 0) {
                throw new RuntimeException("Negative Stack height has been attained in :" + aBlock.getBody().getMethod().getSignature() + " \n" + "StackHeight: " + blockHeight + "\n" + "At instruction:" + nInst + "\n" + "Block:\n" + aBlock + "\n\nMethod: " + aBlock.getBody().getMethod().getName() + "\n" + aBlock.getBody().getMethod());
            }
            if ((blockHeight += nInst.getOutMachineCount()) <= this.maxStackHeight) continue;
            this.maxStackHeight = blockHeight;
        }
        for (Block b : aBlock.getSuccs()) {
            Integer i = (Integer)this.blockToStackHeight.get(b);
            if (i != null) {
                if (i == blockHeight) continue;
                throw new RuntimeException(aBlock.getBody().getMethod().getSignature() + ": incoherent stack height at block merge point " + b + aBlock + "\ncomputed blockHeight == " + blockHeight + " recorded blockHeight = " + i);
            }
            this.blockToStackHeight.put(b, new Integer(blockHeight));
            this.calculateStackHeight(b);
        }
    }

    private void calculateLogicalStackHeightCheck(Block aBlock) {
        int blockHeight = (Integer)this.blockToLogicalStackHeight.get(aBlock);
        for (Unit u : aBlock) {
            Inst nInst = (Inst)u;
            if ((blockHeight -= nInst.getInCount()) < 0) {
                throw new RuntimeException("Negative Stack Logical height has been attained: \nStackHeight: " + blockHeight + "\nAt instruction:" + nInst + "\nBlock:\n" + aBlock + "\n\nMethod: " + aBlock.getBody().getMethod().getName() + "\n" + aBlock.getBody().getMethod());
            }
            blockHeight += nInst.getOutCount();
        }
        for (Block b : aBlock.getSuccs()) {
            Integer i = (Integer)this.blockToLogicalStackHeight.get(b);
            if (i != null) {
                if (i == blockHeight) continue;
                throw new RuntimeException("incoherent logical stack height at block merge point " + b + aBlock);
            }
            this.blockToLogicalStackHeight.put(b, new Integer(blockHeight));
            this.calculateLogicalStackHeightCheck(b);
        }
    }
}

