/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.List;
import soot.SootMethodRef;
import soot.Unit;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.StaticInvokeInst;
import soot.jimple.ConvertToBaf;
import soot.jimple.ExprSwitch;
import soot.jimple.Jimple;
import soot.jimple.JimpleToBafContext;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.internal.AbstractInvokeExpr;
import soot.util.Switch;

public abstract class AbstractStaticInvokeExpr
extends AbstractInvokeExpr
implements StaticInvokeExpr,
ConvertToBaf {
    AbstractStaticInvokeExpr(SootMethodRef methodRef, List<Value> args) {
        this(methodRef, new ValueBox[args.size()]);
        for (int i = 0; i < args.size(); ++i) {
            this.argBoxes[i] = Jimple.v().newImmediateBox(args.get(i));
        }
    }

    @Override
    public boolean equivTo(Object o) {
        if (o instanceof AbstractStaticInvokeExpr) {
            AbstractStaticInvokeExpr ie = (AbstractStaticInvokeExpr)o;
            if (!this.getMethod().equals(ie.getMethod()) || this.argBoxes.length != ie.argBoxes.length) {
                return false;
            }
            for (int i = 0; i < this.argBoxes.length; ++i) {
                if (this.argBoxes[i].getValue().equivTo(ie.argBoxes[i].getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int equivHashCode() {
        return this.getMethod().equivHashCode();
    }

    @Override
    public abstract Object clone();

    protected AbstractStaticInvokeExpr(SootMethodRef methodRef, ValueBox[] argBoxes) {
        super(methodRef, argBoxes);
        if (!methodRef.isStatic()) {
            throw new RuntimeException("wrong static-ness");
        }
        this.methodRef = methodRef;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("staticinvoke " + this.methodRef.getSignature() + "(");
        for (int i = 0; i < this.argBoxes.length; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.argBoxes[i].getValue().toString());
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("staticinvoke");
        up.literal(" ");
        up.methodRef(this.methodRef);
        up.literal("(");
        for (int i = 0; i < this.argBoxes.length; ++i) {
            if (i != 0) {
                up.literal(", ");
            }
            this.argBoxes[i].toString(up);
        }
        up.literal(")");
    }

    @Override
    public void apply(Switch sw) {
        ((ExprSwitch)sw).caseStaticInvokeExpr(this);
    }

    @Override
    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        for (ValueBox element : this.argBoxes) {
            ((ConvertToBaf)((Object)element.getValue())).convertToBaf(context, out);
        }
        StaticInvokeInst u = Baf.v().newStaticInvokeInst(this.methodRef);
        out.add(u);
        u.addAllTagsOf(context.getCurrentUnit());
    }
}

