/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import soot.jimple.toolkits.typing.TypeException;
import soot.jimple.toolkits.typing.TypeVariable;

class StronglyConnectedComponents {
    List<TypeVariable> variables;
    Set<TypeVariable> black;
    List<TypeVariable> finished;
    List<List<TypeVariable>> forest = new LinkedList<List<TypeVariable>>();
    List<TypeVariable> current_tree;
    private static final boolean DEBUG = false;

    public static void merge(List<TypeVariable> typeVariableList) throws TypeException {
        new StronglyConnectedComponents(typeVariableList);
    }

    private StronglyConnectedComponents(List<TypeVariable> typeVariableList) throws TypeException {
        this.variables = typeVariableList;
        this.black = new TreeSet<TypeVariable>();
        this.finished = new LinkedList<TypeVariable>();
        for (TypeVariable var : this.variables) {
            if (this.black.contains(var)) continue;
            this.black.add(var);
            this.dfsg_visit(var);
        }
        this.black = new TreeSet<TypeVariable>();
        for (TypeVariable var : this.finished) {
            if (this.black.contains(var)) continue;
            this.current_tree = new LinkedList<TypeVariable>();
            this.forest.add(this.current_tree);
            this.black.add(var);
            this.dfsgt_visit(var);
        }
        for (List<TypeVariable> list : this.forest) {
            TypeVariable previous = null;
            Object s = null;
            for (TypeVariable current : list) {
                if (previous == null) {
                    previous = current;
                    continue;
                }
                previous = previous.union(current);
            }
        }
    }

    private void dfsg_visit(TypeVariable var) {
        List<TypeVariable> parents = var.parents();
        for (TypeVariable parent : parents) {
            if (this.black.contains(parent)) continue;
            this.black.add(parent);
            this.dfsg_visit(parent);
        }
        this.finished.add(0, var);
    }

    private void dfsgt_visit(TypeVariable var) {
        this.current_tree.add(var);
        List<TypeVariable> children = var.children();
        for (TypeVariable child : children) {
            if (this.black.contains(child)) continue;
            this.black.add(child);
            this.dfsgt_visit(child);
        }
    }
}

