/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.List;
import soot.G;
import soot.Local;
import soot.Timers;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.options.Options;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.BackwardFlowAnalysis;
import soot.toolkits.scalar.FlowAnalysis;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.LiveLocals;

public class SimpleLiveLocals
implements LiveLocals {
    final FlowAnalysis<Unit, FlowSet<Local>> analysis;

    public SimpleLiveLocals(UnitGraph graph) {
        if (Options.v().time()) {
            Timers.v().liveTimer.start();
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + graph.getBody().getMethod().getName() + "]     Constructing SimpleLiveLocals...");
        }
        this.analysis = new Analysis(graph);
        if (Options.v().time()) {
            Timers.v().liveAnalysisTimer.start();
        }
        this.analysis.doAnalysis();
        if (Options.v().time()) {
            Timers.v().liveAnalysisTimer.end();
        }
        if (Options.v().time()) {
            Timers.v().liveTimer.end();
        }
    }

    @Override
    public List<Local> getLiveLocalsAfter(Unit s) {
        return this.analysis.getFlowAfter(s).toList();
    }

    @Override
    public List<Local> getLiveLocalsBefore(Unit s) {
        return this.analysis.getFlowBefore(s).toList();
    }

    static class Analysis
    extends BackwardFlowAnalysis<Unit, FlowSet<Local>> {
        Analysis(UnitGraph g) {
            super(g);
        }

        @Override
        protected FlowSet<Local> newInitialFlow() {
            return new ArraySparseSet<Local>();
        }

        @Override
        protected void flowThrough(FlowSet<Local> in, Unit unit, FlowSet<Local> out) {
            Local l;
            Value v;
            in.copy(out);
            for (ValueBox box : unit.getDefBoxes()) {
                v = box.getValue();
                if (!(v instanceof Local)) continue;
                l = (Local)v;
                out.remove(l);
            }
            for (ValueBox box : unit.getUseBoxes()) {
                v = box.getValue();
                if (!(v instanceof Local)) continue;
                l = (Local)v;
                out.add(l);
            }
        }

        @Override
        protected void mergeInto(Unit succNode, FlowSet<Local> inout, FlowSet<Local> in) {
            inout.union(in);
        }

        @Override
        protected void merge(FlowSet<Local> in1, FlowSet<Local> in2, FlowSet<Local> out) {
            in1.union(in2, out);
        }

        @Override
        protected void copy(FlowSet<Local> source, FlowSet<Local> dest) {
            source.copy(dest);
        }
    }
}

