/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.client.cmdline;

import de.upb.pga3.panda2.client.core.Client;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HtmlParser {
    static final Logger LOGGER = LogManager.getLogger(HtmlParser.class);

    public static void parse(String textualResult, boolean testScenario) {
        block26: {
            try {
                StringBuilder output = new StringBuilder();
                String nextLineCharacter = "\n";
                String tabSpaceCharacter = "\t";
                String seperatorString = "-----";
                if (textualResult != null) {
                    File input = new File(textualResult);
                    if (input.exists() && !input.isDirectory()) {
                        Elements allElements;
                        Element stats;
                        HashMap<String, String> colorLegendMapping = new HashMap<String, String>();
                        colorLegendMapping.put("#007f22", "REQUIRED");
                        colorLegendMapping.put("#0006fd", "MAY BE REQUIRED");
                        colorLegendMapping.put("#927a3a", "UNUSED");
                        colorLegendMapping.put("#ff7500", "MAYBE_MISSING");
                        colorLegendMapping.put("#ff0000", "MISSING");
                        Document doc = Jsoup.parse((File)input, (String)"UTF-8");
                        output.append(String.valueOf(doc.title()) + "\n");
                        Element legend = doc.select("div.legend").first();
                        if (legend != null && !testScenario) {
                            output.append(String.valueOf(legend.text()) + "\n");
                        }
                        if ((stats = doc.select("div.stats").first()) != null) {
                            output.append("STATISTICS:\n");
                            for (Element row : stats.select("tr")) {
                                Elements tdatas = row.select("td:not([rowspan])");
                                Elements tstrongdatas = row.select("td:not([rowspan]) strong");
                                output.append(String.valueOf(((Element)tdatas.get(0)).text()) + " " + (tstrongdatas != null && tstrongdatas.size() > 0 ? ((Element)tstrongdatas.get(0)).text() : "") + "\n");
                                if (((Element)tdatas.get(0)).text() == null || ((Element)tdatas.get(0)).text().contains("worthy")) continue;
                                Elements tfontdatas = row.select("td:not([rowspan]) font");
                                for (Iterator tFontData : tfontdatas) {
                                    if (tFontData.attr("color").isEmpty()) continue;
                                    output.append(String.valueOf(tFontData.text()) + "\t" + (String)colorLegendMapping.get(tFontData.attr("color")) + "\n");
                                }
                            }
                        }
                        if ((allElements = doc.select("*")) != null) {
                            for (Element element : allElements) {
                                if (!element.className().isEmpty() && (element.className().equals("plus") || element.className().equals("spacer"))) {
                                    Element node = element.nextElementSibling();
                                    while (node != null && !node.tagName().equalsIgnoreCase("strong")) {
                                        node = node.nextElementSibling();
                                    }
                                    if (node != null) {
                                        output.append("-----" + node.text() + "-----" + "\n");
                                    }
                                }
                                if (element.className().isEmpty() || !element.className().equals("premissions")) continue;
                                Elements permissionsSelect = element.select("font");
                                for (Element row : permissionsSelect) {
                                    String permission = "";
                                    if (!row.attr("title").isEmpty()) {
                                        permission = row.attr("title");
                                    }
                                    output.append(String.valueOf(row.text()) + " " + "(" + permission + ")" + "\n");
                                }
                            }
                        }
                    } else {
                        Element legend;
                        Document doc = Jsoup.parse((String)textualResult);
                        Element stats = doc.select("div.stats").first();
                        if (stats != null) {
                            output.append("STATISTICS:\n");
                            for (Element row : stats.select("tr table tr")) {
                                Elements tdatas = row.select("td");
                                Elements tstrongdatas = row.select("td strong");
                                output.append(String.valueOf(tdatas != null && tdatas.size() > 0 ? ((Element)tdatas.get(0)).text() : "") + (tstrongdatas != null && tstrongdatas.size() > 0 ? ((Element)tstrongdatas.get(0)).text() : "") + "\n");
                            }
                        }
                        if ((legend = doc.select("div.legend").first()) != null) {
                            output.append(String.valueOf(legend.text()) + "\n");
                        }
                        Integer columnSpan = 0;
                        StringBuilder header = new StringBuilder();
                        for (Element table : doc.select("table[id=level2a]")) {
                            for (Element row : table.select("tbody tr th")) {
                                if (!row.attr("colspan").isEmpty()) {
                                    columnSpan = Integer.parseInt(row.attr("colspan"));
                                    header.append(String.valueOf(row.text()) + "\n");
                                    continue;
                                }
                                header.append(String.valueOf(row.text()) + "-----");
                            }
                            if (header.toString() != null) {
                                output.append(String.valueOf(header.toString()) + "\n");
                            }
                            for (Element row : table.select("tr:gt(1)")) {
                                Elements tdatas = row.select("td:not([rowspan])");
                                if (columnSpan == 2) {
                                    output.append(String.valueOf(((Element)tdatas.get(0)).text()) + " (SOURCE)" + "-----" + ((Element)tdatas.get(1)).text() + " (TARGET)" + "\n");
                                    continue;
                                }
                                if (columnSpan != 3 || tdatas.size() < 3) continue;
                                output.append(String.valueOf(((Element)tdatas.get(0)).text()) + " (SOURCE)" + "-----" + ((Element)tdatas.get(1)).text() + " (TARGET)" + "-----" + ((Element)tdatas.get(2)).text() + " (TARGET)" + "\n");
                            }
                        }
                    }
                    if (!testScenario) {
                        Client.print(output.toString());
                    }
                    LOGGER.info("Result was parsed successfully");
                    break block26;
                }
                throw new NullPointerException("HTML String for the textual result is null");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                LOGGER.error("Exception while parsing the HTML String for the textual result for Command Line." + ex.getMessage());
            }
        }
    }
}

