/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.client.core;

import de.upb.pga3.panda2.client.core.ResultLoader;
import de.upb.pga3.panda2.client.core.datastructures.ManifestInfo;
import de.upb.pga3.panda2.client.core.datastructures.UIMessage;
import de.upb.pga3.panda2.client.core.datastructures.UIMessageType;
import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.core.services.CoreServices;
import de.upb.pga3.panda2.core.services.XMLParser;
import java.io.File;

public class AppIdentifier {
    private ManifestInfo manifestInfo1;
    private ManifestInfo manifestInfo2;
    private String app1FingerPrint;
    private String app2FingerPrint;
    private XMLParser a3XMLParser = CoreServices.getXMLParserInstance();

    public ManifestInfo getManifestInfo1() {
        return this.manifestInfo1;
    }

    public void setManifestInfo1(ManifestInfo manifestInfo1) {
        this.manifestInfo1 = manifestInfo1;
    }

    public ManifestInfo getManifestInfo2() {
        return this.manifestInfo2;
    }

    public void setManifestInfo2(ManifestInfo manifestInfo2) {
        this.manifestInfo2 = manifestInfo2;
    }

    public String getApp1FingerPrint() {
        return this.app1FingerPrint;
    }

    public void setApp1FingerPrint(String app1FingerPrint) {
        this.app1FingerPrint = app1FingerPrint;
    }

    public String getApp2FingerPrint() {
        return this.app2FingerPrint;
    }

    public void setApp2FingerPrint(String app2FingerPrint) {
        this.app2FingerPrint = app2FingerPrint;
    }

    public UIMessage compareAppWithPreviousResult(File apk, File prevAnalResult) {
        if (prevAnalResult.toString().substring(prevAnalResult.toString().length() - 4, prevAnalResult.toString().length()).equals(".pa2")) {
            AnalysisResult loadedResult = ResultLoader.loadPreviousAnalysisResult(prevAnalResult.toString());
            return this.compareAppWithPreviousResult(apk, loadedResult);
        }
        return this.compareAppWithApp(apk, prevAnalResult);
    }

    public UIMessage compareAppWithPreviousResult(File apk, AnalysisResult prevAnalResult) {
        this.manifestInfo1 = this.getManifestInformation(apk);
        this.app1FingerPrint = this.getFingerPrint(apk);
        this.manifestInfo2 = AppIdentifier.getVersionInfoOfPreviousAnalysisResult(prevAnalResult);
        this.app2FingerPrint = AppIdentifier.getFingerPrintOfPreviousAnalysisResult(prevAnalResult);
        return this.compareManifestAndFingerPrintInformation();
    }

    public UIMessage compareAppWithApp(File apk1, File apk2) {
        this.manifestInfo1 = this.getManifestInformation(apk1);
        this.app1FingerPrint = this.getFingerPrint(apk1);
        this.manifestInfo2 = this.getManifestInformation(apk2);
        this.app2FingerPrint = this.getFingerPrint(apk2);
        return this.compareManifestAndFingerPrintInformation();
    }

    private ManifestInfo getManifestInformation(File apk) {
        this.a3XMLParser.fetchData(apk.toString());
        return this.a3XMLParser.getManifestInformation();
    }

    private String getFingerPrint(File apk) {
        this.a3XMLParser.fetchData(apk.toString());
        return this.a3XMLParser.getFingerprint();
    }

    private static ManifestInfo getVersionInfoOfPreviousAnalysisResult(AnalysisResult analysisResult) {
        return analysisResult.getAppManifestInfo();
    }

    private static String getFingerPrintOfPreviousAnalysisResult(AnalysisResult analysisResult) {
        return analysisResult.getAppFingerprint();
    }

    private UIMessage compareManifestAndFingerPrintInformation() {
        UIMessage uiMessage = null;
        uiMessage = this.app1FingerPrint != null && this.app2FingerPrint != null ? (this.app1FingerPrint.equals(this.app2FingerPrint) ? new UIMessage(UIMessageType.INFO, "Apps and its versions are the same") : (this.manifestInfo1 != null && this.manifestInfo2 != null ? (this.manifestInfo1.getVersionCode().equals(this.manifestInfo2.getVersionCode()) ? new UIMessage(UIMessageType.WARNING, "Apps are different but versions are the same") : new UIMessage(UIMessageType.SUGGESTION, "Apps and its versions are different")) : new UIMessage(UIMessageType.WARNING, "Apps are the same but no version information"))) : new UIMessage(UIMessageType.ERROR, "Missing App information");
        return uiMessage;
    }
}

