/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.client.gui;

import de.upb.pga3.panda2.client.core.AnalysisRegistry;
import de.upb.pga3.panda2.client.core.AppIdentifier;
import de.upb.pga3.panda2.client.core.datastructures.UIMessage;
import de.upb.pga3.panda2.client.core.datastructures.UIMessageType;
import de.upb.pga3.panda2.client.gui.GUIHelper;
import de.upb.pga3.panda2.client.gui.GuiConfig;
import de.upb.pga3.panda2.client.gui.Model;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class Wizard
extends Application {
    private static Wizard instance = null;
    private Model model;
    public static final String MODE_APP = "APP";
    public static final String MODE_ALL = "ALL";
    private final ImageView chooserFNF1;
    private final ImageView chooserFNF2;
    final ImageView chooserFNF3;
    Stage stage;
    ComboBox<String> page1Mode;
    private Text text2;
    private BorderPane pane;
    private Button btnPrev;
    private Button btnNext;
    private Button btnFinish;
    private Button btnCancel;
    private final int numPages = 2;
    private int currentPage;
    private final FileChooser chooserDialog1;
    private final FileChooser chooserDialog2;
    private final FileChooser chooserDialog3;
    private final AppIdentifier appIdentifier;
    private Image imgTick;
    String selectedLevel;
    boolean selectedAllmode;
    File selectedApk;
    File selectedPrevResult;
    List<File> selectedAdditionalApks;

    Wizard(Model model) {
        this.model = model;
        this.currentPage = 1;
        this.chooserFNF1 = new ImageView();
        this.chooserFNF2 = new ImageView();
        this.chooserFNF3 = new ImageView();
        this.selectedLevel = "Permission Usage (Intra App - Level 1)";
        this.selectedAllmode = false;
        this.selectedApk = null;
        this.selectedPrevResult = null;
        this.chooserDialog1 = new FileChooser();
        this.chooserDialog2 = new FileChooser();
        this.chooserDialog3 = new FileChooser();
        FileChooser.ExtensionFilter allFilesFilter = new FileChooser.ExtensionFilter("*.* - All files", new String[]{"*.*"});
        FileChooser.ExtensionFilter apkFilter = new FileChooser.ExtensionFilter("*.apk- Android application package", new String[]{"*.apk"});
        FileChooser.ExtensionFilter pa2Filter = new FileChooser.ExtensionFilter("*.pa2 - Panda2 Analysis Result File", new String[]{"*.pa2"});
        FileChooser.ExtensionFilter apkPa2Filter = new FileChooser.ExtensionFilter("*.pa2/*.apk - Panda2 Analysis Result File / Android application package", new String[]{"*.pa2", "*.apk"});
        this.chooserDialog1.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{apkFilter, allFilesFilter});
        this.chooserDialog2.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{apkPa2Filter, pa2Filter, apkFilter, allFilesFilter});
        this.chooserDialog3.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{apkFilter, allFilesFilter});
        this.appIdentifier = new AppIdentifier();
        instance = this;
    }

    public static Wizard getInstance() {
        return instance;
    }

    private Model getModel() {
        return this.model;
    }

    public void start(Stage stageParameter) {
        this.stage = stageParameter;
        this.stage.setTitle("Analysis Wizard");
        GUIHelper.setPandaIcon(this.stage);
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent we) {
                we.consume();
                Wizard.this.exitClicked();
            }
        });
        this.stage.setResizable(false);
        this.imgTick = new Image("file:data/images/tick_16.png");
        BorderPane bottomPane = new BorderPane();
        bottomPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        HBox buttonBox = new HBox();
        this.btnPrev = new Button("Previous");
        this.btnPrev.setGraphic((Node)new ImageView(new Image("file:data/images/left_16.png")));
        this.btnPrev.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Wizard.this.prevPage();
            }
        });
        this.btnNext = new Button("Next");
        this.btnNext.setGraphic((Node)new ImageView(new Image("file:data/images/right_16.png")));
        this.btnNext.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Wizard.this.nextPage();
            }
        });
        this.btnFinish = new Button("Finish");
        this.btnFinish.setMinHeight(24.0);
        this.btnFinish.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Wizard.this.finish();
            }
        });
        buttonBox.getChildren().addAll((Object[])new Node[]{this.btnPrev, this.btnNext, this.btnFinish});
        this.btnCancel = new Button("Cancel");
        this.btnCancel.setMinHeight(24.0);
        this.btnCancel.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Wizard.this.exitClicked();
            }
        });
        bottomPane.setLeft((Node)this.btnCancel);
        bottomPane.setRight((Node)buttonBox);
        this.pane = new BorderPane();
        this.pane.setBottom((Node)bottomPane);
        Scene scene = new Scene((Parent)this.pane, 550.0, 400.0);
        this.stage.setScene(scene);
        this.stage.show();
        this.loadPage();
    }

    private void loadPage() {
        this.checkFinish();
        this.checkComparison();
        if (this.currentPage >= 2) {
            this.btnNext.setDisable(true);
        } else {
            this.btnNext.setDisable(false);
        }
        if (this.currentPage <= 1) {
            this.btnPrev.setDisable(true);
        } else {
            this.btnPrev.setDisable(false);
        }
        switch (this.currentPage) {
            case 1: {
                this.pane.setCenter((Node)this.page1());
                break;
            }
            case 2: {
                this.pane.setCenter((Node)this.page2());
                break;
            }
            default: {
                this.pane.setCenter((Node)this.page1());
            }
        }
    }

    void nextPage() {
        ++this.currentPage;
        this.loadPage();
    }

    void prevPage() {
        --this.currentPage;
        this.loadPage();
    }

    void exitClicked() {
        this.stage.hide();
    }

    void finish() {
        this.stage.hide();
        this.getModel().startAnalysis(this.selectedLevel, this.selectedApk, this.selectedPrevResult, this.selectedAdditionalApks, this.selectedAllmode);
    }

    public void show() {
        this.currentPage = 1;
        this.loadPage();
        this.stage.show();
    }

    void checkFinish() {
        if (Wizard.getInstance().selectedApk != null && Wizard.getInstance().selectedApk.exists() && Wizard.getInstance().selectedApk.toString().length() >= 4 && Wizard.getInstance().selectedApk.toString().substring(Wizard.getInstance().selectedApk.toString().length() - 4, Wizard.getInstance().selectedApk.toString().length()).equals(".apk")) {
            if (this.currentPage == 2) {
                this.btnFinish.setDisable(false);
            } else {
                this.btnFinish.setDisable(true);
            }
            this.chooserFNF1.setImage(this.imgTick);
        } else {
            this.btnFinish.setDisable(true);
            this.chooserFNF1.setImage(new Image("file:data/images/delete_16.png"));
        }
    }

    void checkComparison() {
        if (Wizard.getInstance().selectedPrevResult == null) {
            this.chooserFNF2.setImage(new Image("file:data/images/info_16.png"));
        } else if (Wizard.getInstance().selectedPrevResult != null && Wizard.getInstance().selectedPrevResult.exists() && Wizard.getInstance().selectedPrevResult.toString().length() >= 4 && (Wizard.getInstance().selectedPrevResult.toString().substring(Wizard.getInstance().selectedPrevResult.toString().length() - 4, Wizard.getInstance().selectedPrevResult.toString().length()).equals(".pa2") || Wizard.getInstance().selectedPrevResult.toString().substring(Wizard.getInstance().selectedPrevResult.toString().length() - 4, Wizard.getInstance().selectedPrevResult.toString().length()).equals(".apk"))) {
            if (this.selectedApk != null && this.selectedPrevResult != null && this.selectedApk.exists() && this.selectedPrevResult.exists()) {
                UIMessage msg = this.appIdentifier.compareAppWithPreviousResult(this.selectedApk, this.selectedPrevResult);
                if (msg.getType() == UIMessageType.INFO) {
                    this.chooserFNF2.setImage(new Image("file:data/images/flag_16.png"));
                    this.text2.setText(msg.getBody());
                    this.text2.setFill((Paint)Color.BLUE);
                } else if (msg.getType() == UIMessageType.WARNING) {
                    this.chooserFNF2.setImage(new Image("file:data/images/warning_16.png"));
                    this.text2.setText(msg.getBody());
                    this.text2.setFill((Paint)Color.ORANGE);
                } else if (msg.getType() == UIMessageType.ERROR) {
                    this.chooserFNF2.setImage(new Image("file:data/images/delete_16.png"));
                    this.text2.setText(msg.getBody());
                    this.text2.setFill((Paint)Color.RED);
                } else {
                    this.chooserFNF2.setImage(this.imgTick);
                    this.text2.setText("");
                }
            } else {
                this.chooserFNF2.setImage(this.imgTick);
                this.text2.setText("");
            }
        } else {
            this.chooserFNF2.setImage(new Image("file:data/images/delete_16.png"));
        }
    }

    List<File> createAdditionalApkList(String apksStrParameter) {
        if (apksStrParameter != null && !apksStrParameter.equals("")) {
            String apksStr = apksStrParameter.replaceAll(",[ \t\n]*", ",").replaceAll("[\t\n]", "");
            List<String> tempList = Arrays.asList(apksStr.split(","));
            ArrayList<File> fileList = new ArrayList<File>();
            for (String item : tempList) {
                File file = new File(item);
                if (file.toString() != null && file.exists() && file.toString().length() >= 4 && file.toString().substring(file.toString().length() - 4, file.toString().length()).equals(".apk")) {
                    fileList.add(file);
                    continue;
                }
                this.chooserFNF3.setImage(new Image("file:data/images/delete_16.png"));
                return null;
            }
            this.chooserFNF3.setImage(this.imgTick);
            return fileList;
        }
        this.chooserFNF3.setImage(new Image("file:data/images/info_16.png"));
        return null;
    }

    private Pane page1() {
        VBox page1 = new VBox(15.0);
        page1.setFillWidth(true);
        page1.setMaxWidth(Double.MAX_VALUE);
        page1.setPadding(new Insets(15.0, 15.0, 15.0, 15.0));
        Text page1title = new Text("Step (" + this.currentPage + "/" + 2 + "): Choose Analysis");
        page1title.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)12.0));
        VBox page1Part1 = new VBox();
        Tooltip.install((Node)page1Part1, (Tooltip)new Tooltip("Select the type of analysis you want to run."));
        page1Part1.setFillWidth(true);
        page1Part1.setMaxWidth(Double.MAX_VALUE);
        Label page1Label1 = new Label("Analysis:");
        ObservableList page1AnalysisOptions = FXCollections.observableArrayList(AnalysisRegistry.getInstance().getAnalysisNames());
        final ComboBox page1Analysis = new ComboBox(page1AnalysisOptions);
        page1Analysis.setValue((Object)this.selectedLevel);
        page1Analysis.setMaxWidth(Double.MAX_VALUE);
        page1Analysis.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                for (String name : AnalysisRegistry.getInstance().getAnalysisNames()) {
                    if (!name.equals(page1Analysis.getValue())) continue;
                    Wizard.getInstance().selectedLevel = name;
                    if ("Permission Usage (Inter App - Level 2b)".equals(name)) {
                        Wizard.this.page1Mode.setDisable(false);
                        continue;
                    }
                    Wizard.this.page1Mode.setDisable(true);
                }
            }
        });
        VBox page1Part2 = new VBox();
        Tooltip.install((Node)page1Part2, (Tooltip)new Tooltip("In case of an Permission Usage (Inter App - Level 2b) analysis you can choose a mode here.\nAPP: In this mode all Apps reachable from the analysed App are considered.\nALL: In this mode connections from other Apps to the analysed App are considered as well."));
        page1Part2.setFillWidth(true);
        page1Part2.setMaxWidth(Double.MAX_VALUE);
        Label page1Label2 = new Label("Mode:");
        ObservableList page1ModeOptions = FXCollections.observableArrayList((Object[])new String[]{MODE_APP, MODE_ALL});
        this.page1Mode = new ComboBox(page1ModeOptions);
        if (this.selectedAllmode) {
            this.page1Mode.setValue((Object)MODE_ALL);
        } else {
            this.page1Mode.setValue((Object)MODE_APP);
        }
        this.page1Mode.setMaxWidth(Double.MAX_VALUE);
        this.page1Mode.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (((String)Wizard.this.page1Mode.getValue()).equals(Wizard.MODE_APP)) {
                    Wizard.this.selectedAllmode = false;
                } else if (((String)Wizard.this.page1Mode.getValue()).equals(Wizard.MODE_ALL)) {
                    Wizard.this.selectedAllmode = true;
                }
            }
        });
        if (this.selectedLevel == "Permission Usage (Inter App - Level 2b)") {
            this.page1Mode.setDisable(false);
        } else {
            this.page1Mode.setDisable(true);
        }
        page1Part1.getChildren().addAll((Object[])new Node[]{page1Label1, page1Analysis});
        page1Part2.getChildren().addAll((Object[])new Node[]{page1Label2, this.page1Mode});
        page1.getChildren().addAll((Object[])new Node[]{page1title, page1Part1, page1Part2});
        return page1;
    }

    private Pane page2() {
        VBox page = new VBox(15.0);
        page.setFillWidth(true);
        page.setMaxWidth(Double.MAX_VALUE);
        page.setPadding(new Insets(15.0, 15.0, 15.0, 15.0));
        Text title = new Text("Step (" + this.currentPage + "/" + 2 + "): Select input");
        title.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)12.0));
        VBox part1 = new VBox();
        Tooltip.install((Node)part1, (Tooltip)new Tooltip("Select the .apk file of the App you want to be analysed."));
        part1.setFillWidth(true);
        part1.setMaxWidth(Double.MAX_VALUE);
        Label label1 = new Label("Analysed App:");
        HBox chooser1 = new HBox(5.0);
        chooser1.setMaxWidth(Double.MAX_VALUE);
        final TextField chooserText1 = new TextField();
        if (this.selectedApk != null) {
            chooserText1.setText(this.selectedApk.toString());
        }
        chooserText1.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.equals("")) {
                    Wizard.getInstance().selectedApk = new File(newValue);
                    if (Wizard.this.selectedApk.getParentFile().exists()) {
                        GuiConfig.getInstance().setApkFolder(Wizard.getInstance().selectedApk.getParentFile());
                    }
                } else {
                    Wizard.getInstance().selectedApk = null;
                }
                Wizard.this.checkFinish();
                if (Wizard.this.selectedPrevResult != null) {
                    Wizard.this.checkComparison();
                }
            }
        });
        chooserText1.setPrefWidth(2.147483647E9);
        Button btnOpen1 = new Button("Browse...");
        btnOpen1.setMinWidth(75.0);
        btnOpen1.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Wizard.this.chooserDialog1.setInitialDirectory(GuiConfig.getInstance().getApkFolder());
                File file = Wizard.this.chooserDialog1.showOpenDialog((Window)Wizard.getInstance().stage);
                if (file != null) {
                    chooserText1.setText(file.toString());
                }
            }
        });
        chooser1.getChildren().addAll((Object[])new Node[]{this.chooserFNF1, chooserText1, btnOpen1});
        VBox part2 = new VBox();
        Tooltip.install((Node)part2, (Tooltip)new Tooltip("Optionally select an analysis result or an .apk file in order to create an analysis result for comparison here.\nThis automatically turns the tool into comparison mode."));
        part2.setFillWidth(true);
        part2.setMaxWidth(Double.MAX_VALUE);
        HBox part2labelBox = new HBox(3.0);
        Label label2 = new Label("Previous analysis for comparison (optional):");
        this.text2 = new Text();
        part2labelBox.getChildren().addAll((Object[])new Node[]{label2, this.text2});
        HBox chooser2 = new HBox(5.0);
        chooser2.setMaxWidth(Double.MAX_VALUE);
        final TextField chooserText2 = new TextField();
        if (this.selectedPrevResult != null) {
            chooserText2.setText(this.selectedPrevResult.toString());
        }
        chooserText2.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.equals("")) {
                    Wizard.getInstance().selectedPrevResult = new File(newValue);
                    if (Wizard.this.selectedPrevResult.getParentFile().exists()) {
                        GuiConfig.getInstance().setPrevResultFolder(Wizard.getInstance().selectedPrevResult.getParentFile());
                    }
                } else {
                    Wizard.getInstance().selectedPrevResult = null;
                }
                Wizard.this.checkComparison();
            }
        });
        chooserText2.setPrefWidth(2.147483647E9);
        Button btnOpen2 = new Button("Browse...");
        btnOpen2.setMinWidth(75.0);
        btnOpen2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Wizard.this.chooserDialog2.setInitialDirectory(GuiConfig.getInstance().getPrevResultFolder());
                File file = Wizard.this.chooserDialog2.showOpenDialog((Window)Wizard.getInstance().stage);
                if (file != null) {
                    chooserText2.setText(file.toString());
                }
            }
        });
        chooser2.getChildren().addAll((Object[])new Node[]{this.chooserFNF2, chooserText2, btnOpen2});
        VBox part3 = new VBox();
        Tooltip.install((Node)part3, (Tooltip)new Tooltip("For any inter-App analysis you can optionally specify more involved Apps here."));
        part3.setFillWidth(true);
        part3.setMaxWidth(Double.MAX_VALUE);
        Label label3 = new Label("Additional Apps (optional):");
        HBox chooser3 = new HBox(5.0);
        chooser3.setMaxWidth(Double.MAX_VALUE);
        final TextArea chooserText3 = new TextArea();
        if (this.selectedAdditionalApks != null) {
            chooserText3.setText(this.selectedAdditionalApks.toString());
        }
        chooserText3.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                try {
                    if (!newValue.equals("")) {
                        Wizard.getInstance().selectedAdditionalApks = Wizard.this.createAdditionalApkList(newValue);
                        if (Wizard.getInstance().selectedAdditionalApks != null) {
                            chooserText3.setText(chooserText3.getText().toString().replaceAll(",[ \t\n]*", ",\n"));
                        }
                        if (Wizard.this.selectedAdditionalApks.get(Wizard.getInstance().selectedAdditionalApks.size() - 1).getParentFile().exists()) {
                            GuiConfig.getInstance().setNnApkFolder(Wizard.getInstance().selectedAdditionalApks.get(Wizard.getInstance().selectedAdditionalApks.size() - 1).getParentFile());
                        }
                    } else {
                        Wizard.this.chooserFNF3.setImage(new Image("file:data/images/info_16.png"));
                        Wizard.getInstance().selectedAdditionalApks = null;
                    }
                }
                catch (NullPointerException e) {
                    Wizard.this.chooserFNF3.setImage(new Image("file:data/images/delete_16.png"));
                    Wizard.getInstance().selectedAdditionalApks = null;
                }
            }
        });
        if (this.selectedAdditionalApks != null) {
            String tempStr = this.selectedAdditionalApks.toString().substring(1, this.selectedAdditionalApks.toString().length() - 1);
            chooserText3.setText(tempStr);
            this.createAdditionalApkList(tempStr);
        } else {
            this.createAdditionalApkList(null);
        }
        Button btnOpen3 = new Button("Browse...");
        btnOpen3.setMinWidth(75.0);
        btnOpen3.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Wizard.this.chooserDialog3.setInitialDirectory(GuiConfig.getInstance().getNnApkFolder());
                List files = Wizard.this.chooserDialog3.showOpenMultipleDialog((Window)Wizard.getInstance().stage);
                if (files != null) {
                    String tempStr = chooserText3.getText().toString().replaceAll(",[ \t\n]*", ",");
                    if (tempStr != null && !tempStr.equals("")) {
                        chooserText3.setText((String.valueOf(tempStr) + "," + files.toString().substring(1, files.toString().length() - 1)).replaceAll(",", ",\n"));
                    } else {
                        chooserText3.setText(files.toString().substring(1, files.toString().length() - 1).replaceAll(",", ",\n"));
                    }
                }
            }
        });
        chooser3.getChildren().addAll((Object[])new Node[]{this.chooserFNF3, chooserText3, btnOpen3});
        if (this.selectedLevel == "Permission Usage (Inter App - Level 2b)") {
            chooser3.setDisable(false);
        } else {
            chooser3.setDisable(true);
        }
        part1.getChildren().addAll((Object[])new Node[]{label1, chooser1});
        part2.getChildren().addAll((Object[])new Node[]{part2labelBox, chooser2});
        part3.getChildren().addAll((Object[])new Node[]{label3, chooser3});
        page.getChildren().addAll((Object[])new Node[]{title, part1, part2, part3});
        return page;
    }
}

