/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.core;

import de.upb.pga3.panda2.core.Analysis;
import de.upb.pga3.panda2.core.AsyncAnalysisResult;
import de.upb.pga3.panda2.core.SootAdapter;
import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.utilities.MemoryUsageMonitor;
import de.upb.pga3.panda2.utilities.StopWatch;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnalysisRunner {
    static final Logger LOGGER = LogManager.getLogger(AnalysisRunner.class);

    public AnalysisResult analyze(List<Analysis> anaList) {
        LOGGER.info("Running analysis consiting of {} steps", anaList.size());
        MemoryUsageMonitor.getInstance().setWarnThreshold(5120);
        MemoryUsageMonitor.getInstance().setSkipSteps(10);
        MemoryUsageMonitor.getInstance().setupMonitoring(0);
        StopWatch sWatch = new StopWatch();
        sWatch.start();
        ArrayList<AnalysisResult> subResList = new ArrayList<AnalysisResult>();
        AnalysisResult resAgg = null;
        Analysis lastAna = null;
        for (Analysis ana : anaList) {
            if (!subResList.isEmpty() && ana.getPreviousAnalysisResult() == null) {
                if (lastAna.aggregates()) {
                    resAgg = (AnalysisResult)subResList.get(subResList.size() - 1);
                    subResList = new ArrayList();
                } else if (!ana.aggregates()) {
                    ana.setPreviousAnalysisResult((AnalysisResult)subResList.get(subResList.size() - 1));
                }
            }
            if (ana.aggregates()) {
                ana.provideSubResults(subResList);
                subResList = new ArrayList();
                if (resAgg != null) {
                    ana.setPreviousAnalysisResult(resAgg);
                }
            }
            lastAna = ana;
            SootAdapter.getInstance().reinitSoot();
            AnalysisResult res = ana.doAnalysis();
            subResList.add(res);
        }
        sWatch.stop();
        LOGGER.info("Finished analysis");
        LOGGER.info("Time needed for analysis: {}", sWatch.getTimeTaken().toString());
        LOGGER.info("Max. memory needed for analysis: {}MB", MemoryUsageMonitor.getInstance().getMaxMemSeen());
        return (AnalysisResult)subResList.get(subResList.size() - 1);
    }

    public void analyzeAsync(final List<Analysis> anaList, final AsyncAnalysisResult caller) {
        new Thread(){

            @Override
            public void run() {
                caller.analysisFinished(AnalysisRunner.this.analyze(anaList));
            }
        }.start();
    }
}

