/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.core.services;

import de.upb.pga3.panda2.core.datastructures.JavaAPIMethod;
import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.core.services.DataStorage;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public final class A3DataStorage
implements DataStorage {
    private static final A3DataStorage INSTANCE = new A3DataStorage();
    private static final Logger LOGGER = LogManager.getLogger(A3DataStorage.class);
    private Map<HashSet<String>, List<Permission>> hashmap = new HashMap<HashSet<String>, List<Permission>>();
    private Map<String, Permission> allPermissions = new HashMap<String, Permission>();
    private Path folder = Paths.get("data/", new String[0]);
    public static final String ALL_MAPPINGS = "allmappings";
    public static final String CONTENT_PROVIDER_FIELD_PERMISSION = "contentproviderfieldpermission";
    public static final String CONTENT_PROVIDER_PERMISSION = "contentproviderpermission";
    public static final String INTENT_PERMISSION = "intentpermission";
    public static final String PUBLISHED_API_MAPPING = "publishedapimapping";
    private BufferedReader bufferedReader;
    private MultiMap<String, JavaAPIMethod> mLstSources;
    private MultiMap<String, JavaAPIMethod> mLstSinks;
    private Set<String> androidCallBacks;

    private A3DataStorage() {
        try {
            this.bufferedReader = new BufferedReader(new FileReader(String.valueOf(this.folder.toString()) + "/listofallpermissions"));
            String curLine = "";
            this.bufferedReader.readLine();
            while ((curLine = this.bufferedReader.readLine()) != null) {
                this.allPermissions.put(curLine, new Permission(curLine));
            }
            this.bufferedReader.close();
        }
        catch (Exception e) {
            LOGGER.error("Error while reading " + this.folder.toString() + "/listofallpermissions" + " inputfile:\n" + e.getMessage());
        }
        try {
            this.hashmap.putAll(this.readPScoutResult(ALL_MAPPINGS));
            this.hashmap.putAll(this.readPScoutResult(CONTENT_PROVIDER_FIELD_PERMISSION));
            this.hashmap.putAll(this.readPScoutResult(CONTENT_PROVIDER_PERMISSION));
            this.hashmap.putAll(this.readPScoutResult(INTENT_PERMISSION));
            this.hashmap.putAll(this.readPScoutResult(PUBLISHED_API_MAPPING));
        }
        catch (IOException e) {
            LOGGER.error("An error accured while reading the input data:\n" + e.getMessage());
        }
        this.mLstSources = new HashMultiMap<String, JavaAPIMethod>();
        this.mLstSinks = new HashMultiMap<String, JavaAPIMethod>();
        this.androidCallBacks = new HashSet<String>();
        try {
            this.mLstSources.putAll(this.readSourceSinkAPIMethods("output_Sources.txt"));
            this.mLstSinks.putAll(this.readSourceSinkAPIMethods("output_Sinks.txt"));
            this.androidCallBacks = this.readCallBackClasses("androidcallbacks");
        }
        catch (IOException e) {
            LOGGER.error("An error accured while reading the input data:\n" + e.getMessage());
        }
        this.mLstSources.get("android.telephony.TelephonyManager");
        this.mLstSinks.get("android.telephony.SmsManager");
    }

    public static DataStorage getInstance() {
        return INSTANCE;
    }

    private Map<HashSet<String>, List<Permission>> readPScoutResult(String type) throws IOException {
        String curLine;
        HashMap<HashSet<String>, List<Permission>> hashmapToAdd = new HashMap<HashSet<String>, List<Permission>>();
        this.bufferedReader = new BufferedReader(new FileReader(String.valueOf(this.folder.toString()) + "/" + type));
        Permission permission = null;
        while ((curLine = this.bufferedReader.readLine()) != null) {
            ArrayList<Permission> value;
            HashSet<String> key;
            if (type == ALL_MAPPINGS || type == PUBLISHED_API_MAPPING || type == CONTENT_PROVIDER_FIELD_PERMISSION) {
                if (curLine.startsWith("<")) {
                    key = new HashSet<String>();
                    key.add(curLine.substring(1, curLine.indexOf(": ")));
                    key.add(curLine.substring(curLine.indexOf(" ", curLine.indexOf(": ") + 2) + 1, curLine.indexOf(">")));
                    if (hashmapToAdd.get(key) == null) {
                        value = new ArrayList<Permission>();
                        value.add(permission);
                    } else {
                        value = new ArrayList();
                        value.addAll((Collection)hashmapToAdd.get(key));
                        value.add(permission);
                    }
                    if (permission != null) {
                        hashmapToAdd.put(key, value);
                        continue;
                    }
                    this.bufferedReader.close();
                    throw new IOException("Found package, class and method before permission was defined in file: " + this.folder.toString() + "/" + type);
                }
                if (!curLine.startsWith("Permission:") && !curLine.startsWith("PERMISSION:") || (permission = this.allPermissions.get(curLine.substring(11))) != null) continue;
                permission = new Permission(curLine.substring(11));
                this.allPermissions.put(curLine.substring(11), permission);
                continue;
            }
            if (type == INTENT_PERMISSION) {
                key = new HashSet();
                key.add(curLine.substring(0, curLine.indexOf(" ")));
                permission = this.allPermissions.get(curLine.substring(curLine.indexOf(" ") + 1, curLine.length() - 2));
                if (permission == null) {
                    permission = new Permission(curLine.substring(curLine.indexOf(" ") + 1, curLine.length() - 2));
                    this.allPermissions.put(curLine.substring(curLine.indexOf(" ") + 1, curLine.length() - 2), permission);
                }
                value = new ArrayList();
                value.add(permission);
                hashmapToAdd.put(key, value);
                continue;
            }
            if (type != CONTENT_PROVIDER_PERMISSION) continue;
            curLine = curLine.replace(" pathPrefix", "");
            curLine = curLine.replace(" pathPattern", "");
            curLine = curLine.replace(" path", "");
            key = new HashSet();
            key.add(curLine.substring(0, curLine.indexOf(" ")));
            String permString = curLine.substring(curLine.indexOf(" ", curLine.indexOf(" ") + 1) + 1, curLine.length());
            permission = this.allPermissions.get(permString);
            if (permission == null) {
                if (permString.contains("grant-uri-permission")) {
                    permString = "grant-uri-permission";
                }
                permission = new Permission(permString);
                this.allPermissions.put(permString, permission);
            }
            value = new ArrayList();
            value.add(permission);
            hashmapToAdd.put(key, value);
        }
        this.bufferedReader.close();
        return hashmapToAdd;
    }

    @Override
    public List<Permission> mapAPICall(String pkgClass, String method) {
        HashSet<String> needle = new HashSet<String>();
        needle.add(pkgClass);
        needle.add(method);
        return this.hashmap.get(needle);
    }

    @Override
    public List<Permission> mapImplicitIntent(String actionName) {
        HashSet<String> needle = new HashSet<String>();
        needle.add(actionName);
        return this.hashmap.get(needle);
    }

    @Override
    public List<Permission> mapContentProviderURI(String uri) {
        HashSet<String> needle = new HashSet<String>();
        needle.add(uri);
        return this.hashmap.get(needle);
    }

    @Override
    public Map<String, Permission> getAllPermissions() {
        return this.allPermissions;
    }

    @Override
    public int getMaxAPILevel() {
        try {
            this.bufferedReader = new BufferedReader(new FileReader(String.valueOf(this.folder.toString()) + "/apilevel"));
            return Integer.valueOf(this.bufferedReader.readLine());
        }
        catch (NumberFormatException e) {
            LOGGER.error("Could not found API level information. " + this.folder.toString() + "/apilevel seems to be corrupted.\n" + e.getMessage());
            return -1;
        }
        catch (IOException e) {
            LOGGER.error(String.valueOf(this.folder.toString()) + " seems to be corrupted.\n" + e.getMessage());
            return -1;
        }
    }

    private MultiMap<String, JavaAPIMethod> readSourceSinkAPIMethods(String inType) throws IOException {
        HashMultiMap<String, JavaAPIMethod> mapMethods = new HashMultiMap<String, JavaAPIMethod>();
        this.bufferedReader = new BufferedReader(new FileReader(String.valueOf(this.folder.toString()) + "/" + inType));
        String curLine = "";
        while ((curLine = this.bufferedReader.readLine()) != null) {
            JavaAPIMethod method = this.parseMethod(curLine);
            if (method == null) continue;
            mapMethods.put(method.getClassName(), method);
        }
        return mapMethods;
    }

    private JavaAPIMethod parseMethod(String inLineData) {
        String[] lstSubStr;
        int iLength;
        if (inLineData != null && !inLineData.isEmpty() && (iLength = (lstSubStr = inLineData.split("->")).length) == 2) {
            String signature = lstSubStr[0].trim();
            int pos = signature.lastIndexOf(">");
            signature = signature.substring(0, pos + 1);
            JavaAPIMethod method = new JavaAPIMethod(signature);
            return method;
        }
        return null;
    }

    @Override
    public boolean isSource(String inClassName, String inSignature) {
        Set<JavaAPIMethod> setMethods;
        if (!(inSignature == null || inSignature.isEmpty() || inClassName == null || inClassName.isEmpty() || (setMethods = this.mLstSources.get(inClassName)) == null || setMethods.isEmpty())) {
            for (JavaAPIMethod method : setMethods) {
                String signature = method.getSignature();
                if (!signature.equals(inSignature)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSink(String inClassName, String inSignature) {
        Set<JavaAPIMethod> setMethods;
        if (!(inSignature == null || inSignature.isEmpty() || inClassName == null || inClassName.isEmpty() || (setMethods = this.mLstSinks.get(inClassName)) == null || setMethods.isEmpty())) {
            for (JavaAPIMethod method : setMethods) {
                String signature = method.getSignature();
                if (!signature.equals(inSignature)) continue;
                return true;
            }
        }
        return false;
    }

    private Set<String> readCallBackClasses(String fileType) throws IOException {
        String line;
        HashSet<String> callBacks = new HashSet<String>();
        this.bufferedReader = new BufferedReader(new FileReader(String.valueOf(this.folder.toString()) + "/" + fileType));
        while ((line = this.bufferedReader.readLine()) != null) {
            if (line.isEmpty()) continue;
            callBacks.add(line);
        }
        this.bufferedReader.close();
        return callBacks;
    }

    @Override
    public Set<String> getCallBackClasses() {
        return this.androidCallBacks;
    }
}

