/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.core.services;

import android.content.res.AXmlResourceParser;
import de.upb.pga3.panda2.core.services.ManifestXMLParser;
import java.io.File;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BinaryParser {
    private static final Logger LOGGER = LogManager.getLogger(ManifestXMLParser.class);
    private static final float[] RADIX_MULTS = new float[]{0.00390625f, 3.051758E-5f, 1.192093E-7f, 4.656613E-10f};
    private static final String[] DIMENSION_UNITS = new String[]{"px", "dip", "sp", "pt", "in", "mm", "", ""};
    private static final String[] FRACTION_UNITS = new String[]{"%", "%p", "", "", "", "", "", ""};

    public BinaryParser(String inAPKFile) {
        this.parseData(inAPKFile);
    }

    protected boolean parseData(String inAPKFile) {
        return false;
    }

    protected String getStrXMLFromAPK(File apkFile, String inXMLFileName) {
        StringBuilder xmlSb = new StringBuilder(100);
        try {
            int type;
            ZipFile file = new ZipFile(apkFile, 1);
            ZipEntry entry = file.getEntry(inXMLFileName);
            AXmlResourceParser parser = new AXmlResourceParser();
            parser.open(file.getInputStream(entry));
            StringBuilder sb = new StringBuilder(10);
            String indentStep = "\t";
            while ((type = parser.next()) != 1) {
                switch (type) {
                    case 0: {
                        this.constructXMLString(xmlSb, "<?xml version=\"1.0\" encoding=\"utf-8\"?>", new Object[0]);
                        break;
                    }
                    case 2: {
                        this.constructXMLString(false, xmlSb, "%s<%s%s", sb, this.getNamespacePrefix(parser.getPrefix()), parser.getName());
                        sb.append("\t");
                        int namespaceCountBefore = parser.getNamespaceCount(parser.getDepth() - 1);
                        int namespaceCount = parser.getNamespaceCount(parser.getDepth());
                        int i = namespaceCountBefore;
                        while (i != namespaceCount) {
                            this.constructXMLString(xmlSb, "%sxmlns:%s=\"%s\"", i == namespaceCountBefore ? "  " : sb, parser.getNamespacePrefix(i), parser.getNamespaceUri(i));
                            ++i;
                        }
                        int size = parser.getAttributeCount();
                        int i2 = 0;
                        while (i2 != size) {
                            this.constructXMLString(false, xmlSb, "%s%s%s=\"%s\"", " ", this.getNamespacePrefix(parser.getAttributePrefix(i2)), parser.getAttributeName(i2), this.getAttributeValue(parser, i2));
                            ++i2;
                        }
                        this.constructXMLString(xmlSb, ">", new Object[0]);
                        break;
                    }
                    case 3: {
                        sb.setLength(sb.length() - "\t".length());
                        this.constructXMLString(xmlSb, "%s</%s%s>", sb, this.getNamespacePrefix(parser.getPrefix()), parser.getName());
                        break;
                    }
                    case 4: {
                        this.constructXMLString(xmlSb, "%s%s", sb, parser.getText());
                    }
                }
            }
            parser.close();
        }
        catch (Exception e) {
            LOGGER.info("Exception: " + e.getMessage());
            e.printStackTrace();
        }
        return xmlSb.toString();
    }

    private String getNamespacePrefix(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return "";
        }
        return String.valueOf(prefix) + ":";
    }

    private String getAttributeValue(AXmlResourceParser parser, int index) {
        int type = parser.getAttributeValueType(index);
        int data = parser.getAttributeValueData(index);
        if (type == 3) {
            return parser.getAttributeValue(index);
        }
        if (type == 2) {
            return String.format("?%s%08X", this.getPackage(data), data);
        }
        if (type == 1) {
            return String.format("@%s%08X", this.getPackage(data), data);
        }
        if (type == 4) {
            return String.valueOf(Float.intBitsToFloat(data));
        }
        if (type == 17) {
            return String.format("0x%08X", data);
        }
        if (type == 18) {
            return data != 0 ? "true" : "false";
        }
        if (type == 5) {
            return String.valueOf(Float.toString(BinaryParser.complexToFloat(data))) + DIMENSION_UNITS[data & 0xF];
        }
        if (type == 6) {
            return String.valueOf(Float.toString(BinaryParser.complexToFloat(data))) + FRACTION_UNITS[data & 0xF];
        }
        if (type >= 28 && type <= 31) {
            return String.format("#%08X", data);
        }
        if (type >= 16 && type <= 31) {
            return String.valueOf(data);
        }
        return String.format("<0x%X, type 0x%02X>", data, type);
    }

    private String getPackage(int id) {
        if (id >>> 24 == 1) {
            return "android:";
        }
        return "";
    }

    private void constructXMLString(StringBuilder inXmlSb, String inFormat, Object ... inArguments) {
        inXmlSb.append(String.format(inFormat, inArguments));
    }

    private void constructXMLString(boolean inNewLine, StringBuilder inXmlSb, String inFormat, Object ... inArguments) {
        inXmlSb.append(String.format(inFormat, inArguments));
        if (inNewLine) {
            inXmlSb.append("\n");
        }
    }

    private static float complexToFloat(int complex) {
        return (float)(complex & 0xFFFFFF00) * RADIX_MULTS[complex >> 4 & 3];
    }
}

