/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.core.services;

import de.upb.pga3.panda2.core.services.LayoutBinaryParser;
import de.upb.pga3.panda2.core.services.XMLAttribute;
import de.upb.pga3.panda2.core.services.XMLHandler;
import de.upb.pga3.panda2.core.services.XMLNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;

public class XMLLayoutParser
extends SceneTransformer {
    private static final Logger LOGGER = LogManager.getLogger(XMLLayoutParser.class);
    private String packagename;
    private String apkName;
    private List<String> entryClasses;
    private final Map<String, List<String>> callbackMethods = new HashMap<String, List<String>>();

    public XMLLayoutParser(String packageName, String apkName, List<String> entryClasses) {
        this.packagename = packageName;
        this.apkName = apkName;
        this.entryClasses = entryClasses;
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        File apkFile = new File(this.apkName);
        if (!apkFile.exists()) {
            throw new RuntimeException("File " + this.apkName + " doesn't exist.");
        }
        try {
            ZipFile zFile = new ZipFile(apkFile);
            Enumeration<? extends ZipEntry> entries = zFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                this.parseLayoutFile(entryName, zFile.getInputStream(entry));
            }
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void parseLayoutFile(String fileName, InputStream iStream) {
        if (!fileName.startsWith("res/layout")) {
            return;
        }
        if (!fileName.endsWith(".xml")) {
            return;
        }
        String entryClass = fileName.substring(0, fileName.lastIndexOf("."));
        if (!this.packagename.isEmpty()) {
            entryClass = String.valueOf(this.packagename) + "." + entryClass;
        }
        if (!fileName.startsWith("res/layout")) {
            return;
        }
        try {
            XMLHandler handler = new XMLHandler(iStream, new LayoutBinaryParser());
            this.parseLayoutNode(fileName, handler.getDocument().getRootNode());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void parseLayoutNode(String layoutFile, XMLNode rootNode) {
        if (rootNode.getTag() == null || rootNode.getTag().isEmpty()) {
            return;
        }
        String tname = rootNode.getTag().trim();
        if (!(tname.equals("dummy") || tname.equals("include") || tname.equals("merge"))) {
            if (tname.equals("fragment")) {
                XMLAttribute<?> attr = rootNode.getAttribute("name");
                if (attr == null) {
                    LOGGER.warn("Fragment without class name detected in layout file");
                } else {
                    if (attr.getType() != 3) {
                        LOGGER.warn("Invalid targer resource " + attr.getValue() + "for fragment class value in lazout file");
                    }
                    this.getLayoutClass(attr.getValue().toString());
                }
            } else {
                this.parseLayoutAttributes(layoutFile, null, rootNode);
            }
        }
        for (XMLNode childNode : rootNode.getChildren()) {
            this.parseLayoutNode(layoutFile, childNode);
        }
    }

    private void parseLayoutAttributes(String layoutFile, SootClass childClass, XMLNode rootNode) {
        for (Map.Entry<String, XMLAttribute<?>> entry : rootNode.getAttributes().entrySet()) {
            String attName = entry.getKey().trim();
            XMLAttribute<?> attr = entry.getValue();
            if (attName.isEmpty() || !attName.equals("onClick") || attr.getType() != 3 || !(attr.getValue() instanceof String)) continue;
            String strData = ((String)attr.getValue()).trim();
            this.addCallbackMethod(layoutFile, strData);
        }
    }

    private void addCallbackMethod(String layoutFileName, String callbackMethod) {
        if (this.callbackMethods.containsKey(layoutFileName)) {
            this.callbackMethods.get(layoutFileName).add(callbackMethod);
        } else {
            ArrayList<String> callbacks = new ArrayList<String>();
            callbacks.add(callbackMethod);
            this.callbackMethods.put(layoutFileName, callbacks);
        }
    }

    private SootClass getLayoutClass(String className) {
        if (className.startsWith(";")) {
            className = className.substring(1);
        }
        if (className.contains("(") || className.contains("<") || className.contains("/")) {
            return null;
        }
        SootClass sc = Scene.v().forceResolve(className, 3);
        if ((sc == null || sc.isPhantom()) && !this.packagename.isEmpty()) {
            sc = Scene.v().forceResolve(String.valueOf(this.packagename) + "." + className, 3);
        }
        if (sc == null || sc.isPhantom()) {
            sc = Scene.v().forceResolve("android.view." + className, 3);
        }
        if (sc == null || sc.isPhantom()) {
            sc = Scene.v().forceResolve("android.widget." + className, 3);
        }
        if (sc == null || sc.isPhantom()) {
            sc = Scene.v().forceResolve("android.webkit." + className, 3);
        }
        if (sc == null || sc.isPhantom()) {
            LOGGER.info("Could not find layout class " + className);
            return null;
        }
        return sc;
    }

    public Map<String, List<String>> getLayoutCallbackMethods() {
        return this.callbackMethods;
    }
}

