/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl1;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.core.datastructures.DetailLevel;
import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.extension.lvl1.DetailLevelLvl1;
import de.upb.pga3.panda2.extension.lvl1.ResultLeafLvl1;
import de.upb.pga3.panda2.extension.lvl1.ResultTreeLvl1;
import de.upb.pga3.panda2.extension.lvl1.ResultTypeLvl1;
import de.upb.pga3.panda2.extension.lvl1.SVGArrowLvl1;
import de.upb.pga3.panda2.extension.lvl1.SVGBarLvl1;
import de.upb.pga3.panda2.extension.lvl1.SVGGraphicLvl1;
import de.upb.pga3.panda2.extension.lvl1.SVGPermissionLvl1;
import de.upb.pga3.panda2.utilities.HTMLFrameBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnalysisResultLvl1
extends AnalysisResult {
    private static final Logger LOGGER = LogManager.getLogger(AnalysisResultLvl1.class);
    private AnalysisGraph mAnalysisGraph;
    private ResultLeafLvl1 app;
    private ResultTreeLvl1 components;
    private ResultTreeLvl1 classes;
    private ResultTreeLvl1 methods;
    private AnalysisResultLvl1 prevResult;
    private Map<ResultLeafLvl1, ResultLeafLvl1> mapCurrentToPrev;
    private final List<String> filters;
    private List<String> activeFilters;
    private int[] permissionUses = null;
    private int[] permissionUsesAll = null;
    private int newPermissions;
    private int changedPermissions;
    private int unchangedPermissions;
    final int height = 1000;
    public static int barWidth = 75;
    final int permissionsStart = 250;
    final int permissionsWidth = 275;
    final int barsFirst = 0;
    final int width = 2 * 250 + 275;
    final int barsSecond = this.width - barWidth;
    Map<Permission, SVGPermissionLvl1> mapOfPermissions = new HashMap<Permission, SVGPermissionLvl1>();
    private File htmlFileTextual;
    private File htmlFileGraphical;
    public static final String TREEOPTION = "Expandable tree";

    public AnalysisResultLvl1(AnalysisGraph inGraph) {
        this.setResultIsFile(true);
        this.mAnalysisGraph = inGraph;
        this.htmlFileTextual = new File("data/temp/Level1_Result_textual.html");
        this.htmlFileGraphical = new File("data/temp/Level1_Result_graphical.html");
        this.prevResult = null;
        this.filters = new ArrayList<String>();
        this.filters.add(TREEOPTION);
        this.filters.add(ResultTypeLvl1.getStringOfType(0));
        this.filters.add(ResultTypeLvl1.getStringOfType(1));
        this.filters.add(ResultTypeLvl1.getStringOfType(2));
        this.filters.add(ResultTypeLvl1.getStringOfType(3));
        this.filters.add(ResultTypeLvl1.getStringOfType(4));
    }

    public void setApp(ResultLeafLvl1 result) {
        this.app = result;
        this.updateFilters(result);
    }

    public ResultLeafLvl1 getApp() {
        return this.app;
    }

    public void setComponents(ResultTreeLvl1 result) {
        this.components = result;
        this.updateFilters(result);
    }

    public ResultTreeLvl1 getComponents() {
        return this.components;
    }

    public void setClasses(ResultTreeLvl1 result) {
        this.classes = result;
        this.updateFilters(result);
    }

    public ResultTreeLvl1 getClasses() {
        return this.classes;
    }

    public void setMethods(ResultTreeLvl1 result) {
        this.methods = result;
        this.updateFilters(result);
    }

    public ResultTreeLvl1 getMethods() {
        return this.methods;
    }

    public AnalysisGraph getAnalysisGraph() {
        return this.mAnalysisGraph;
    }

    private int[] getPermissionUses(DetailLevel inDetailLvl, List<String> inFilters) {
        this.getTextualResult(inDetailLvl, inFilters, true);
        return this.permissionUses;
    }

    private void updateFilters(ResultTreeLvl1 result) {
        if (result != null) {
            for (ResultLeafLvl1 leaf : result.getLeafs().values()) {
                this.updateFilters(leaf);
            }
        }
    }

    private void updateFilters(ResultLeafLvl1 result) {
        if (result != null && !result.getPermissions(5).isEmpty()) {
            for (Permission permission : result.getPermissions(5)) {
                boolean add = true;
                for (String filter : this.filters) {
                    if (!filter.equals("Permission: " + permission.getName())) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                this.filters.add("Permission: " + permission.getName());
            }
        }
    }

    public void compare(AnalysisResult prevRes) {
        this.prevResult = (AnalysisResultLvl1)prevRes;
        this.mapOfPermissions = this.prevResult.getMapOfPermissions();
        this.mapCurrentToPrev = new HashMap<ResultLeafLvl1, ResultLeafLvl1>();
        this.mapCurrentToPrev.put(this.app, this.prevResult.getApp());
        for (ResultLeafLvl1 currentLeaf : this.classes.getLeafsAsList()) {
            for (ResultLeafLvl1 prevLeaf : this.prevResult.getClasses().getLeafsAsList()) {
                if (!currentLeaf.getName().equals(prevLeaf.getName())) continue;
                this.mapCurrentToPrev.put(currentLeaf, prevLeaf);
            }
        }
        for (ResultLeafLvl1 currentLeaf : this.components.getLeafsAsList()) {
            for (ResultLeafLvl1 prevLeaf : this.prevResult.getComponents().getLeafsAsList()) {
                if (!currentLeaf.getName().equals(prevLeaf.getName())) continue;
                this.mapCurrentToPrev.put(currentLeaf, prevLeaf);
            }
        }
        for (ResultLeafLvl1 currentLeaf : this.methods.getLeafsAsList()) {
            for (ResultLeafLvl1 prevLeaf : this.prevResult.getMethods().getLeafsAsList()) {
                if (!currentLeaf.getName().equals(prevLeaf.getName())) continue;
                this.mapCurrentToPrev.put(currentLeaf, prevLeaf);
            }
        }
    }

    @Override
    public String getGraphicalResult(DetailLevel inDetailLvl, List<String> inFilters, boolean inShowStats) {
        try {
            AnalysisResultLvl1.resetFile(this.htmlFileGraphical);
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.htmlFileGraphical));
            HTMLFrameBuilder fb = new HTMLFrameBuilder(bw, "Graphical result - Intra-App Permission Usage Analysis");
            fb.setHeaderAutoHide(inShowStats);
            fb.setHintPersistent(false);
            fb.setCustomStyle("div.icon { float: left; border: 1px solid #000000; width: 12px; height: 7px;\tmargin-right: 5px; margin-top: 3px;\t}");
            fb.addLegendEntry("<div class=\"icon\" style=\"background:#007f22;\"></div>", "REQUIRED");
            fb.addLegendEntry("<div class=\"icon\" style=\"background:#0006fd;\"></div>", "MAYBE REQUIRED");
            fb.addLegendEntry("<div class=\"icon\" style=\"background:#927a3a;\"></div>", "UNUSED");
            fb.addLegendEntry("<div class=\"icon\" style=\"background:#ff7500;\"></div>", "MAYBE MISSING");
            fb.addLegendEntry("<div class=\"icon\" style=\"background:#ff0000;\"></div>", "MISSING");
            fb.append("<center>");
            if (inDetailLvl == DetailLevelLvl1.APP) {
                if (this.prevResult != null) {
                    this.getGraphic(this.app, this.prevResult.getApp(), fb);
                } else {
                    this.getGraphic(this.app, null, fb);
                }
            } else if (inDetailLvl == DetailLevelLvl1.COMPONENT) {
                for (ResultLeafLvl1 leaf : this.components.getLeafsAsList()) {
                    if (leaf == null) continue;
                    if (this.prevResult != null) {
                        ResultLeafLvl1 compareLeaf = this.prevResult.getComponents().getLeaf(leaf.getName());
                        if (compareLeaf != null) {
                            this.getGraphic(leaf, compareLeaf, fb);
                            continue;
                        }
                        this.getGraphic(leaf, null, fb);
                        continue;
                    }
                    this.getGraphic(leaf, null, fb);
                }
            } else {
                fb.append("Graphical result only available in APP and COMPONENT mode. Please choose one of those.");
            }
            fb.append("</center>");
            String statsLine = "<strong>" + (this.permissionUsesAll[0] + this.permissionUsesAll[1] + this.permissionUsesAll[2] + this.permissionUsesAll[4] + this.permissionUsesAll[3]) + "</strong> (<font color=\"" + ResultTypeLvl1.getColorOfType(0) + "\">" + this.permissionUsesAll[0] + "</font> / <font color=\"" + ResultTypeLvl1.getColorOfType(1) + "\">" + this.permissionUsesAll[1] + "</font> / <font color=\"" + ResultTypeLvl1.getColorOfType(2) + "\">" + this.permissionUsesAll[2] + "</font> / <font color=\"" + ResultTypeLvl1.getColorOfType(4) + "\">" + this.permissionUsesAll[4] + "</font> / <font color=\"" + ResultTypeLvl1.getColorOfType(3) + "\">" + this.permissionUsesAll[3] + "</font>)";
            fb.addStaticticsRow("Analysed permission uses:", statsLine);
            fb.setAppTrustworthy(this.permissionUsesAll[3] + this.permissionUsesAll[4] == 0);
            fb.complete();
            bw.close();
        }
        catch (IOException e) {
            LOGGER.error("Could not access outputfile.");
        }
        return this.htmlFileGraphical.toString();
    }

    private void getGraphic(ResultLeafLvl1 leaf, ResultLeafLvl1 compLeaf, HTMLFrameBuilder fb) throws IOException {
        this.mapOfPermissions.clear();
        SVGGraphicLvl1 svgGraphic = this.getGraphic(leaf, compLeaf, 250, 0, 250 + 275, this.barsSecond);
        if (this.prevResult != null) {
            fb.append("<table width=\"" + this.width + "\"><tr><td>Current Result</td><td align=\"center\"><strong>" + leaf.getName() + "</strong></td><td align=\"right\">Previous Result</td></tr></table>\n");
        } else {
            fb.append("<strong>" + leaf.getName() + "</strong><br />\n");
        }
        fb.append("<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"" + this.width + "\" height=\"" + (13 + 20 * this.mapOfPermissions.values().size() + 2) + "\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">");
        fb.append(svgGraphic.toString());
        fb.append("</svg><br /><br />");
    }

    private SVGGraphicLvl1 getGraphic(ResultLeafLvl1 leaf, ResultLeafLvl1 compLeaf, int xLineStart, int xLineEnd, int xLineStartComp, int xLineEndComp) {
        int[] permissionUsesGraphical = new int[5];
        int[] permissionUsesGraphicalComp = new int[5];
        ArrayList<SVGArrowLvl1> arrows = new ArrayList<SVGArrowLvl1>();
        SVGBarLvl1[] bars = new SVGBarLvl1[5];
        int yBars = 0;
        SVGBarLvl1[] barsComp = new SVGBarLvl1[5];
        int yBarsComp = 0;
        int yPermissions = 13;
        int i = 0;
        while (i < 5) {
            if (leaf.getPermissions(i) != null) {
                for (Permission permission : leaf.getPermissions(i)) {
                    if (!this.activeFilters.contains(ResultTypeLvl1.getStringOfType(i)) && !this.activeFilters.contains("Permission: " + permission.getName())) continue;
                    int n = i;
                    permissionUsesGraphical[n] = permissionUsesGraphical[n] + 1;
                    if (this.mapOfPermissions.containsKey(permission)) continue;
                    this.mapOfPermissions.put(permission, new SVGPermissionLvl1(permission, yPermissions));
                    yPermissions += 20;
                }
            }
            if (compLeaf != null && compLeaf.getPermissions(i) != null) {
                for (Permission permission : compLeaf.getPermissions(i)) {
                    if (!this.activeFilters.contains(ResultTypeLvl1.getStringOfType(i)) && !this.activeFilters.contains("Permission: " + permission.getName())) continue;
                    int n = i;
                    permissionUsesGraphicalComp[n] = permissionUsesGraphicalComp[n] + 1;
                    if (this.mapOfPermissions.containsKey(permission)) continue;
                    this.mapOfPermissions.put(permission, new SVGPermissionLvl1(permission, yPermissions));
                    yPermissions += 20;
                }
            }
            ++i;
        }
        int sumPermissions = permissionUsesGraphical[0] + permissionUsesGraphical[1] + permissionUsesGraphical[2] + permissionUsesGraphical[4] + permissionUsesGraphical[3];
        int i2 = 0;
        while (i2 < 5) {
            int[] offset;
            int yLine;
            int barHeight = Math.round((float)permissionUsesGraphical[i2] / (float)sumPermissions * (float)(13 + 20 * sumPermissions));
            bars[i2] = new SVGBarLvl1(xLineEnd, yBars, barHeight);
            yBars += barHeight;
            if (compLeaf != null) {
                int barHeightComp = Math.round((float)permissionUsesGraphicalComp[i2] / (float)sumPermissions * (float)(13 + 20 * sumPermissions));
                barsComp[i2] = new SVGBarLvl1(xLineEndComp, yBarsComp, barHeightComp);
                yBarsComp += barHeightComp;
            }
            if (leaf.getPermissions(i2) != null) {
                for (Permission permission : leaf.getPermissions(i2)) {
                    if (!this.activeFilters.contains(ResultTypeLvl1.getStringOfType(i2)) && !this.activeFilters.contains("Permission: " + permission.getName())) continue;
                    yLine = this.mapOfPermissions.get(permission).getY() - 4;
                    offset = new int[]{-5, barWidth};
                    arrows.add(new SVGArrowLvl1(new int[]{xLineStart + offset[0], yLine}, new int[]{xLineEnd + offset[1], bars[i2].getClosestTo(yLine)}));
                }
            }
            if (compLeaf != null && compLeaf.getPermissions(i2) != null) {
                for (Permission permission : compLeaf.getPermissions(i2)) {
                    if (!this.activeFilters.contains(ResultTypeLvl1.getStringOfType(i2)) && !this.activeFilters.contains("Permission: " + permission.getName())) continue;
                    yLine = this.mapOfPermissions.get(permission).getY() - 4;
                    int[] nArray = new int[2];
                    nArray[0] = 5;
                    offset = nArray;
                    arrows.add(new SVGArrowLvl1(new int[]{xLineStartComp + offset[0], yLine}, new int[]{xLineEndComp + offset[1], barsComp[i2].getClosestTo(yLine)}));
                }
            }
            ++i2;
        }
        return new SVGGraphicLvl1(arrows, this.mapOfPermissions, bars, barsComp, xLineStart, compLeaf != null);
    }

    @Override
    public String getTextualResult(DetailLevel inDetailLvl, List<String> inFilters, boolean inShowStats) {
        this.permissionUses = new int[5];
        this.newPermissions = 0;
        this.changedPermissions = 0;
        this.unchangedPermissions = 0;
        int[] prevPermissionUses = null;
        if (this.prevResult != null) {
            prevPermissionUses = this.prevResult.getPermissionUses(inDetailLvl, inFilters);
        }
        if (inFilters == null) {
            this.activeFilters = this.getFilters();
            this.activeFilters.remove(TREEOPTION);
        } else {
            this.activeFilters = inFilters;
        }
        try {
            AnalysisResultLvl1.resetFile(this.htmlFileGraphical);
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.htmlFileTextual));
            HTMLFrameBuilder fb = new HTMLFrameBuilder(bw, "Textual result - Intra-App Permission Usage Analysis");
            fb.setHeaderAutoHide(inShowStats);
            fb.setHintPersistent(false);
            fb.setCustomStyle("div.icon { float: left; border: 1px solid #000000; width: 12px; height: 7px;\tmargin-right: 5px; margin-top: 3px;\t} div.plus { background: #C9C9C9; float: left; border: 1px outset #CCCCCC; padding: 0px 0px 0px 0px; margin-top: 2px; margin-right: 10px; height: 9px; width: 9px; } div.inner { margin-top:-2px; font-size: 10px; text-align: center; cursor: pointer;\t} div.spacer { float: left;\tmargin-top: 3px; margin-right: 10px; height: 11px; width: 11px;\t} div.popout { padding-left: 25px; visibility: hidden; max-height: 0px;\toverflow: hidden; }\tdiv.premissions { padding-left: 21px; }\ttable {\tborder-spacing:0px;\t} td { padding: 0px; }");
            fb.setCustomScript("function show(caller) {\tif(caller.nextElementSibling.nextElementSibling.nextElementSibling.nextElementSibling.nextElementSibling.style.visibility == 'visible') { caller.nextElementSibling.nextElementSibling.nextElementSibling.nextElementSibling.nextElementSibling.style.maxHeight='0px'; caller.nextElementSibling.nextElementSibling.nextElementSibling.nextElementSibling.nextElementSibling.style.visibility='hidden';\tcaller.firstElementChild.innerHTML='+';\tcaller.style.border='1px outset #CCCCCC'; } else { caller.nextElementSibling.nextElementSibling.nextElementSibling.nextElementSibling.nextElementSibling.style.maxHeight='99999px';\tcaller.nextElementSibling.nextElementSibling.nextElementSibling.nextElementSibling.nextElementSibling.style.visibility='visible'; caller.firstElementChild.innerHTML='-'; caller.style.border='1px inset #CCCCCC'; }}");
            fb.addLegendEntry("<div class=\"icon\" style=\"background:#007f22;\"></div>", "REQUIRED");
            fb.addLegendEntry("<div class=\"icon\" style=\"background:#0006fd;\"></div>", "MAYBE REQUIRED");
            fb.addLegendEntry("<div class=\"icon\" style=\"background:#927a3a;\"></div>", "UNUSED");
            fb.addLegendEntry("<div class=\"icon\" style=\"background:#ff7500;\"></div>", "MAYBE MISSING");
            fb.addLegendEntry("<div class=\"icon\" style=\"background:#ff0000;\"></div>", "MISSING");
            if (inDetailLvl == DetailLevelLvl1.CLASS) {
                this.getTextualForTree(this.classes, inDetailLvl, fb);
            } else if (inDetailLvl == DetailLevelLvl1.COMPONENT) {
                this.getTextualForTree(this.components, inDetailLvl, fb);
            } else if (inDetailLvl == DetailLevelLvl1.METHOD) {
                this.getTextualForTree(this.methods, inDetailLvl, fb);
            } else {
                this.getTextualForLeaf(this.app, this.getChildren(this.app, inDetailLvl), inDetailLvl, fb);
            }
            if (inDetailLvl == DetailLevelLvl1.APP && this.permissionUsesAll == null) {
                this.permissionUsesAll = this.permissionUses;
            } else if (inDetailLvl != DetailLevelLvl1.APP && this.permissionUsesAll == null) {
                this.getTextualResult(DetailLevelLvl1.APP, inFilters, inShowStats);
            }
            String statsLine = "<strong>" + (this.permissionUsesAll[0] + this.permissionUsesAll[1] + this.permissionUsesAll[2] + this.permissionUsesAll[4] + this.permissionUsesAll[3]) + "</strong> (<font color=\"" + ResultTypeLvl1.getColorOfType(0) + "\">" + this.permissionUsesAll[0] + "</font> / <font color=\"" + ResultTypeLvl1.getColorOfType(1) + "\">" + this.permissionUsesAll[1] + "</font> / <font color=\"" + ResultTypeLvl1.getColorOfType(2) + "\">" + this.permissionUsesAll[2] + "</font> / <font color=\"" + ResultTypeLvl1.getColorOfType(4) + "\">" + this.permissionUsesAll[4] + "</font> / <font color=\"" + ResultTypeLvl1.getColorOfType(3) + "\">" + this.permissionUsesAll[3] + "</font>)";
            fb.addStaticticsRow("Analysed permission uses:", statsLine);
            fb.addStaticticsRow("<br />", "<br />");
            fb.addStaticticsRow("<strong>Filtered</strong>", "");
            if (this.prevResult != null) {
                statsLine = "<strong>" + this.newPermissions + "</strong> / <strong>" + this.unchangedPermissions + "</strong> / <strong>" + this.changedPermissions + "</strong>";
                fb.addStaticticsRow("New/Un-/Changed permissions:", statsLine);
                statsLine = "<strong>" + (prevPermissionUses[0] + prevPermissionUses[1] + prevPermissionUses[2] + prevPermissionUses[4] + prevPermissionUses[3]) + "</strong> (<font color=\"" + ResultTypeLvl1.getColorOfType(0) + "\">" + prevPermissionUses[0] + "</font> / <font color=\"" + ResultTypeLvl1.getColorOfType(1) + "\">" + prevPermissionUses[1] + "</font> / <font color=\"" + ResultTypeLvl1.getColorOfType(2) + "\">" + prevPermissionUses[2] + "</font> / <font color=\"" + ResultTypeLvl1.getColorOfType(4) + "\">" + prevPermissionUses[4] + "</font> / <font color=\"" + ResultTypeLvl1.getColorOfType(3) + "\">" + prevPermissionUses[3] + "</font>) &#8594; ";
            } else {
                statsLine = "";
            }
            statsLine = String.valueOf(statsLine) + "<strong>" + (this.permissionUses[0] + this.permissionUses[1] + this.permissionUses[2] + this.permissionUses[4] + this.permissionUses[3]) + "</strong> (<font color=\"" + ResultTypeLvl1.getColorOfType(0) + "\">" + this.permissionUses[0] + "</font> / <font color=\"" + ResultTypeLvl1.getColorOfType(1) + "\">" + this.permissionUses[1] + "</font> / <font color=\"" + ResultTypeLvl1.getColorOfType(2) + "\">" + this.permissionUses[2] + "</font> / <font color=\"" + ResultTypeLvl1.getColorOfType(4) + "\">" + this.permissionUses[4] + "</font> / <font color=\"" + ResultTypeLvl1.getColorOfType(3) + "\">" + this.permissionUses[3] + "</font>)";
            fb.addStaticticsRow("Analysed permission uses:", statsLine);
            statsLine = this.prevResult != null ? "<strong>" + (prevPermissionUses[4] + prevPermissionUses[3]) + "</strong> (<font color=\"" + ResultTypeLvl1.getColorOfType(4) + "\">" + prevPermissionUses[4] + "</font> / <font color=\"" + ResultTypeLvl1.getColorOfType(3) + "\">" + prevPermissionUses[3] + "</font>) &#8594; " : "";
            statsLine = String.valueOf(statsLine) + "<strong>" + (this.permissionUses[4] + this.permissionUses[3]) + "</strong> (<font color=\"" + ResultTypeLvl1.getColorOfType(4) + "\">" + this.permissionUses[4] + "</font> / <font color=\"" + ResultTypeLvl1.getColorOfType(3) + "\">" + this.permissionUses[3] + "</font>)";
            fb.addStaticticsRow("Possibly malicious:", statsLine);
            fb.setAppTrustworthy(this.permissionUsesAll[3] + this.permissionUsesAll[4] == 0);
            fb.complete();
            bw.close();
        }
        catch (IOException e) {
            LOGGER.error("Could not access outputfile.");
        }
        return this.htmlFileTextual.toString();
    }

    private ResultTreeLvl1 getChildren(Object parent, DetailLevel inDetailLvl) {
        if (parent == this.app) {
            if (inDetailLvl == DetailLevelLvl1.APP || inDetailLvl == null) {
                return this.classes;
            }
        } else if (!(parent != this.classes && parent != this.components || inDetailLvl != DetailLevelLvl1.APP && inDetailLvl != DetailLevelLvl1.CLASS && inDetailLvl != DetailLevelLvl1.COMPONENT && inDetailLvl != null)) {
            return this.methods;
        }
        return null;
    }

    private void getTextualForTree(ResultTreeLvl1 tree, DetailLevel inDetailLvl, HTMLFrameBuilder fb) throws IOException {
        this.getTextualForTree(tree, inDetailLvl, null, fb);
    }

    private void getTextualForTree(ResultTreeLvl1 tree, DetailLevel inDetailLvl, ResultLeafLvl1 parentClass, HTMLFrameBuilder fb) throws IOException {
        if (tree != null) {
            for (ResultLeafLvl1 childLeaf : tree.getLeafsAsList()) {
                if (tree == this.methods && parentClass != null) {
                    if (!childLeaf.getName().contains(parentClass.getName())) continue;
                    this.getTextualForLeaf(childLeaf, this.getChildren(tree, inDetailLvl), inDetailLvl, fb);
                    continue;
                }
                this.getTextualForLeaf(childLeaf, this.getChildren(tree, inDetailLvl), inDetailLvl, fb);
            }
        }
    }

    private void getTextualForLeaf(ResultLeafLvl1 leaf, ResultTreeLvl1 children, DetailLevel inDetailLvl, HTMLFrameBuilder fb) throws IOException {
        if (children != null && this.activeFilters.contains(TREEOPTION)) {
            fb.append("<div class=\"plus\" onClick=\"show(this)\"><div class=\"inner\">+</div></div>");
        } else {
            fb.append("<div class=\"spacer\"></div>");
        }
        fb.append(" <strong>");
        if (this.methods.getLeafsAsList().contains(leaf)) {
            fb.append(AnalysisResultLvl1.fixString(leaf.getName()));
        } else {
            fb.append(leaf.getName());
        }
        fb.append("</strong><br />\n<div class=\"premissions\">\n");
        StringBuilder resultStr = new StringBuilder();
        int i = 0;
        while (i < 5) {
            if (leaf.getPermissions(i) != null) {
                for (Permission permission : leaf.getPermissions(i)) {
                    resultStr.append(this.getTextualForPermission(permission, i, leaf));
                }
            }
            ++i;
        }
        fb.append(resultStr.toString());
        fb.append("</div>\n<br />\n");
        if (this.activeFilters.contains(TREEOPTION)) {
            fb.append("<div class=\"popout\">\n\t");
            this.getTextualForTree(children, inDetailLvl, leaf, fb);
            fb.append("\n</div>\n");
            if (children != null || inDetailLvl == DetailLevelLvl1.METHOD) {
                fb.append("<br />\n");
            }
        }
    }

    private String getTextualForPermission(Permission permission, int type, ResultLeafLvl1 leaf) {
        if (this.activeFilters.contains(ResultTypeLvl1.getStringOfType(type)) || this.activeFilters.contains("Permission: " + permission.getName())) {
            int n = type;
            this.permissionUses[n] = this.permissionUses[n] + 1;
            if (this.prevResult == null) {
                return "\t<font color=\"" + ResultTypeLvl1.getColorOfType(type) + "\" title=\"" + ResultTypeLvl1.getStringOfType(type) + "\">" + permission.getName() + "</font><br />\n";
            }
            ResultLeafLvl1 prevLeaf = this.mapCurrentToPrev.get(leaf);
            if (prevLeaf != null) {
                int found = -1;
                int i = 0;
                while (i < 5) {
                    if (prevLeaf.getPermissions(i) != null) {
                        for (Permission prevPerm : prevLeaf.getPermissions(i)) {
                            if (!prevPerm.getName().equals(permission.getName())) continue;
                            found = i;
                            break;
                        }
                        if (found >= 0) break;
                    }
                    ++i;
                }
                if (type != found) {
                    ++this.changedPermissions;
                    return "\t<strong>" + permission.getName() + "</strong> <font color=\"" + ResultTypeLvl1.getColorOfType(found) + "\" title=\"" + ResultTypeLvl1.getStringOfType(found) + "\">" + ResultTypeLvl1.getStringOfType(found) + "</font> &#8594; <font color=\"" + ResultTypeLvl1.getColorOfType(type) + "\" title=\"" + ResultTypeLvl1.getStringOfType(type) + "\">" + ResultTypeLvl1.getStringOfType(type) + "</font><br />\n";
                }
                ++this.unchangedPermissions;
                return "\t<font color=\"" + ResultTypeLvl1.getColorOfType(type) + "\" title=\"" + ResultTypeLvl1.getStringOfType(type) + "\">" + permission.getName() + "</font> (unchanged)<br />\n";
            }
            ++this.newPermissions;
            return "\t<font color=\"" + ResultTypeLvl1.getColorOfType(type) + "\" title=\"" + ResultTypeLvl1.getStringOfType(type) + "\">" + permission.getName() + "</font> (new)<br />\n";
        }
        return "";
    }

    @Override
    public List<DetailLevel> getDetailLevels() {
        ArrayList<DetailLevel> detaillevelList = new ArrayList<DetailLevel>();
        DetailLevelLvl1[] detailLevelLvl1Array = DetailLevelLvl1.values();
        int n = detailLevelLvl1Array.length;
        int n2 = 0;
        while (n2 < n) {
            DetailLevelLvl1 item = detailLevelLvl1Array[n2];
            detaillevelList.add(item);
            ++n2;
        }
        return detaillevelList;
    }

    @Override
    public List<String> getFilters() {
        return this.filters;
    }

    public Map<Permission, SVGPermissionLvl1> getMapOfPermissions() {
        return this.mapOfPermissions;
    }

    private static String fixString(String str) {
        return str.substring(1, str.length() - 1).replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    private static void resetFile(File file) throws IOException {
        file.delete();
        file.createNewFile();
    }
}

