/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl1.analyzer;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Message;
import de.upb.pga3.panda2.core.datastructures.MessageType;
import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.core.datastructures.Transition;
import de.upb.pga3.panda2.core.services.CoreServices;
import de.upb.pga3.panda2.extension.lvl1.AnalysisResultLvl1;
import de.upb.pga3.panda2.extension.lvl1.ResultLeafLvl1;
import de.upb.pga3.panda2.extension.lvl1.ResultTreeLvl1;
import java.util.Collection;
import soot.Body;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;

public class ManifestPermissionComparerLvl1 {
    private AnalysisGraph graph;
    private EnhancedInput ei;
    private Collection<Permission> allPermissions;
    private ResultLeafLvl1 resultApp;
    private ResultTreeLvl1 resultComponents = new ResultTreeLvl1();
    private ResultTreeLvl1 resultClasses = new ResultTreeLvl1();
    private ResultTreeLvl1 resultMethods = new ResultTreeLvl1();
    private AnalysisResultLvl1 anaResult;
    boolean flagMissingMessage = false;
    boolean flagMaybeMissingMessage = false;
    boolean flagUnusedMessage = false;
    boolean flagMaybeRequiredMessage = false;

    public AnalysisResultLvl1 compare(AnalysisGraph inGraph) {
        this.graph = inGraph;
        this.ei = (EnhancedInput)this.graph.getInput();
        this.resultApp = new ResultLeafLvl1(this.ei.getAppName());
        this.allPermissions = CoreServices.getDataStorageInstance().getAllPermissions().values();
        this.fillUpPermissions();
        this.anaResult = new AnalysisResultLvl1(this.graph);
        this.anaResult.initialize(CoreServices.getXMLParserInstance());
        this.generateAnalysisResult();
        if (!this.ei.getMaybeMoreList().isEmpty()) {
            this.anaResult.addMessage(new Message(MessageType.SUGGESTION, "Suggestion: Deeper analysis", "There are some statements contained in the source code of this Application, that's permission use could not be determined.\nIn this case it is suggested to run a Level 2b analysis in order to get a more detailed result."));
        }
        return this.anaResult;
    }

    private void fillUpPermissions() {
        SootClass[] sootClassArray = this.ei.getAppClasses();
        int n = sootClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            SootClass componentOrClass = sootClassArray[n2];
            for (SootMethod method : componentOrClass.getMethods()) {
                if (componentOrClass.isInterface()) continue;
                try {
                    Body body = method.retrieveActiveBody();
                    for (Unit stm : body.getUnits()) {
                        if (this.ei.getMaybeMoreList().contains(stm)) {
                            if (!this.ei.getMaybeMoreList().contains(this.ei)) {
                                this.ei.addToMaybeMoreList(this.ei);
                            }
                            if (!this.ei.getMaybeMoreList().contains(method)) {
                                this.ei.addToMaybeMoreList(method);
                            }
                            if (!this.ei.getMaybeMoreList().contains(componentOrClass)) {
                                this.ei.addToMaybeMoreList(componentOrClass);
                            }
                        }
                        if (this.ei.getPermissionsFor(stm) == null || this.ei.getPermissionsFor(stm).isEmpty()) continue;
                        for (Permission stmtPerm : this.ei.getPermissionsFor(stm)) {
                            if (!this.ei.getPermissionsFor(method).contains(stmtPerm)) {
                                this.ei.addPermissionTo(method, stmtPerm);
                            }
                            if (this.ei.getPermissionsFor(componentOrClass).contains(stmtPerm)) continue;
                            this.ei.addPermissionTo(componentOrClass, stmtPerm);
                        }
                    }
                }
                catch (RuntimeException e) {
                    if (e.getMessage().contains("No method source set for method")) continue;
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    private void generateAnalysisResult() {
        SootClass[] sootClassArray = this.ei.getAppClasses();
        int n = sootClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            SootClass classOrComponentElement = sootClassArray[n2];
            if (!classOrComponentElement.isInterface()) {
                for (SootMethod methodElement : classOrComponentElement.getMethods()) {
                    this.checkElement(methodElement);
                }
                this.checkElement(classOrComponentElement);
            }
            ++n2;
        }
        this.checkElement(this.ei);
        this.anaResult.setApp(this.resultApp);
        this.anaResult.setComponents(this.resultComponents);
        this.anaResult.setClasses(this.resultClasses);
        this.anaResult.setMethods(this.resultMethods);
    }

    private void checkElement(Object element) {
        boolean inMaybeMore = false;
        for (Permission permission : this.allPermissions) {
            boolean hasPermission = this.ei.getPermissions().contains(permission);
            boolean assignedToDescendant = false;
            if (this.ei.getChildren(element) != null) {
                for (Object childElement : this.ei.getChildren(element)) {
                    if (!this.assignedToChild(childElement, permission)) continue;
                    assignedToDescendant = true;
                    break;
                }
            }
            if (!(hasPermission && assignedToDescendant || !hasPermission && assignedToDescendant || !this.ei.getMaybeMoreList().contains(element))) {
                inMaybeMore = true;
            }
            this.setInResult(element, permission, hasPermission, assignedToDescendant, inMaybeMore);
        }
    }

    private boolean assignedToChild(Object childElement, Permission permission) {
        block6: {
            block5: {
                for (Permission childPermission : this.ei.getPermissions(childElement)) {
                    if (childPermission != permission) continue;
                    return true;
                }
                if (!(childElement instanceof Unit)) break block5;
                if (this.graph.getOutgoingTransitions(childElement) == null) break block6;
                for (Transition t : this.graph.getOutgoingTransitions(childElement)) {
                    for (Permission permissionFromTarget : this.ei.getPermissionsFor((SootClass)t.getTarget())) {
                        if (permissionFromTarget != permission) continue;
                        return true;
                    }
                }
                break block6;
            }
            if (this.ei.getChildren(childElement) != null) {
                for (Object childsChildElement : this.ei.getChildren(childElement)) {
                    if (!this.assignedToChild(childsChildElement, permission)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void setInResult(Object element, Permission permission, boolean hasPermission, boolean assignedToChild, boolean inMaybeMore) {
        if (hasPermission) {
            if (assignedToChild) {
                this.setInResult(element, permission, 0);
                return;
            }
            if (inMaybeMore) {
                this.setInResult(element, permission, 1);
                if (!this.flagMaybeRequiredMessage) {
                    this.anaResult.addMessage(new Message(MessageType.WARNING, "MAYBE REQUIRED Permission", "The analyzed App contains one or more maybe required permissions. There might be a cooperation between this App and another that leads to a intended permission usage."));
                    this.flagMaybeRequiredMessage = true;
                }
                return;
            }
            this.setInResult(element, permission, 2);
            if (!this.flagUnusedMessage) {
                this.anaResult.addMessage(new Message(MessageType.WARNING, "UNUSED Permission", "The analyzed App contains one or more unused permissions. Permissions are declared in the Android manifest but never used."));
                this.flagUnusedMessage = true;
            }
            return;
        }
        if (assignedToChild) {
            this.setInResult(element, permission, 3);
            if (!this.flagMissingMessage) {
                this.anaResult.addMessage(new Message(MessageType.ERROR, "MISSING Permission", "The analyzed App contains one or more missing permissions. This should be considered as security critical and might lead to a data leak."));
                this.flagMissingMessage = true;
            }
            return;
        }
        if (inMaybeMore) {
            this.setInResult(element, permission, 4);
            if (!this.flagMaybeMissingMessage) {
                this.anaResult.addMessage(new Message(MessageType.WARNING, "MAYBE MISSING Permission", "The analyzed App contains one or more maybe missing permissions. There might be a cooperation between this App and another that leads to a unintended permission usage."));
                this.flagMaybeMissingMessage = true;
            }
            return;
        }
    }

    private void setInResult(Object element, Permission permission, int group) {
        if (element instanceof EnhancedInput) {
            this.resultApp.addPermission(permission, group);
        } else if (element instanceof SootClass) {
            ResultLeafLvl1 tempLeaf;
            if (this.ei.isAndroidComponent((SootClass)element)) {
                tempLeaf = this.resultComponents.getLeaf(element.toString());
                if (tempLeaf == null) {
                    tempLeaf = new ResultLeafLvl1(element.toString());
                    this.resultComponents.addLeaf(tempLeaf);
                }
                tempLeaf.addPermission(permission, group);
            }
            if ((tempLeaf = this.resultClasses.getLeaf(element.toString())) == null) {
                tempLeaf = new ResultLeafLvl1(element.toString());
                this.resultClasses.addLeaf(tempLeaf);
            }
            tempLeaf.addPermission(permission, group);
        } else {
            ResultLeafLvl1 tempLeaf = this.resultMethods.getLeaf(element.toString());
            if (tempLeaf == null) {
                tempLeaf = new ResultLeafLvl1(element.toString());
                this.resultMethods.addLeaf(tempLeaf);
            }
            tempLeaf.addPermission(permission, group);
        }
    }
}

