/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl2a.flowpath;

import de.upb.pga3.panda2.extension.lvl2a.flowpath.PathElement;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.ResourceElement;
import java.util.ArrayList;
import java.util.Iterator;

public class FlowPath
implements Iterable<PathElement> {
    final ArrayList<PathElement> mElements;

    public FlowPath() {
        this.mElements = new ArrayList();
    }

    public FlowPath(int initCapacity) {
        this.mElements = new ArrayList(initCapacity);
    }

    public void addElement(PathElement inPathElem) {
        if (inPathElem != null) {
            if (this.isComplete()) {
                throw new IllegalArgumentException("The path is already complete and nothing more can be added!");
            }
            if (this.mElements.isEmpty() && !(inPathElem instanceof ResourceElement)) {
                throw new IllegalArgumentException("The first element of a path must be of type ResourceElement!");
            }
        } else {
            throw new IllegalArgumentException("The path element to be added must not be empty!");
        }
        this.mElements.add(inPathElem);
    }

    public PathElement getElement(int i) {
        if (i < 0 || i >= this.mElements.size()) {
            throw new IllegalArgumentException("The given elemt index must match 0 <= i < length!");
        }
        return this.mElements.get(i);
    }

    public void trim() {
        this.mElements.trimToSize();
    }

    public ResourceElement getSink() {
        if (this.isComplete()) {
            return (ResourceElement)this.mElements.get(this.mElements.size() - 1);
        }
        return null;
    }

    public ResourceElement getSource() {
        if (this.isComplete()) {
            return (ResourceElement)this.mElements.get(0);
        }
        return null;
    }

    public boolean isComplete() {
        if (this.mElements.size() >= 2) {
            return this.mElements.get(0) instanceof ResourceElement && this.mElements.get(this.mElements.size() - 1) instanceof ResourceElement;
        }
        return false;
    }

    public int getLength() {
        return this.mElements.size();
    }

    public FlowPath getCommonPrefix(FlowPath inOther) {
        FlowPath common = new FlowPath();
        Iterator<PathElement> thisIt = this.iterator();
        Iterator<PathElement> otherIt = inOther.iterator();
        while (thisIt.hasNext() && otherIt.hasNext()) {
            PathElement elem = thisIt.next();
            if (!elem.equals(otherIt.next())) break;
            common.addElement(elem);
        }
        return common;
    }

    public FlowPath getSubPath(int inFromIdx, int inToIdx) {
        if (inFromIdx >= 0 && inFromIdx <= inToIdx && inToIdx <= this.getLength()) {
            FlowPath subPath = new FlowPath();
            subPath.mElements.addAll(this.mElements.subList(inFromIdx, inToIdx));
            return subPath;
        }
        throw new IllegalArgumentException("Given indexes are not matching the pattern: 0 <= from <= to <= length");
    }

    @Override
    public Iterator<PathElement> iterator() {
        Iterator<PathElement> it = new Iterator<PathElement>(){
            Iterator<PathElement> mListIt;
            {
                this.mListIt = FlowPath.this.mElements.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.mListIt.hasNext();
            }

            @Override
            public PathElement next() {
                return this.mListIt.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removing elements from a path is not allowed");
            }
        };
        return it;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mElements == null ? 0 : this.mElements.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlowPath other = (FlowPath)obj;
        return !(this.mElements == null ? other.mElements != null : !this.mElements.equals(other.mElements));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.mElements.size()) {
            sb.append(this.mElements.get(i).toFullString());
            if (i < this.mElements.size() - 1) {
                sb.append("\n################################\n");
            }
            ++i;
        }
        return sb.toString();
    }
}

