/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl2a.flowpath;

import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.ClassElement;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.PathElement;
import java.util.HashMap;
import java.util.Map;
import soot.SootMethod;

public final class MethodElement
implements PathElement {
    private static final long serialVersionUID = -1074736691487482090L;
    private static final Map<MethodElement, MethodElement> instancePool = new HashMap<MethodElement, MethodElement>();
    private final String methodSubSignature;
    private final ClassElement clazz;

    public static MethodElement get(SootMethod method, EnhancedInput input) {
        MethodElement methodEle = new MethodElement(method, input);
        if (instancePool.containsKey(methodEle)) {
            methodEle = instancePool.get(methodEle);
        } else {
            instancePool.put(methodEle, methodEle);
        }
        return methodEle;
    }

    private MethodElement(SootMethod method, EnhancedInput input) {
        if (method == null) {
            throw new IllegalArgumentException("The given method must not be null!");
        }
        if (input == null) {
            throw new IllegalArgumentException("The given enhanced input must not be null!");
        }
        this.methodSubSignature = method.getSubSignature();
        this.clazz = ClassElement.get(method.getDeclaringClass(), input);
    }

    public String getMethodSubSignature() {
        return this.toString();
    }

    public ClassElement getClassElement() {
        return this.clazz;
    }

    @Override
    public String toFullString() {
        return String.valueOf(this.clazz.toFullString()) + "\n" + this.toString();
    }

    public String toString() {
        return this.methodSubSignature;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
        result = 31 * result + (this.methodSubSignature == null ? 0 : this.methodSubSignature.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodElement other = (MethodElement)obj;
        if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
            return false;
        }
        return !(this.methodSubSignature == null ? other.methodSubSignature != null : !this.methodSubSignature.equals(other.methodSubSignature));
    }
}

