/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl2a.flowpath;

import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.MethodElement;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.PathElement;
import java.util.HashMap;
import java.util.Map;
import soot.Unit;

public final class StatementElement
implements PathElement {
    private static final long serialVersionUID = 3182548952315866563L;
    private static final Map<StatementElement, StatementElement> instancePool = new HashMap<StatementElement, StatementElement>();
    private final String statementStr;
    private final MethodElement method;

    public static StatementElement get(Unit statement, EnhancedInput input) {
        StatementElement stmntEle = new StatementElement(statement, input);
        if (instancePool.containsKey(stmntEle)) {
            stmntEle = instancePool.get(stmntEle);
        } else {
            instancePool.put(stmntEle, stmntEle);
        }
        return stmntEle;
    }

    private StatementElement(Unit statement, EnhancedInput input) {
        if (statement == null) {
            throw new IllegalArgumentException("The given statement must not be null!");
        }
        if (input == null) {
            throw new IllegalArgumentException("The given enhanced input must not be null!");
        }
        this.statementStr = statement.toString();
        this.method = MethodElement.get(input.getBodyForUnit(statement).getMethod(), input);
    }

    public String getStatementString() {
        return this.toString();
    }

    public MethodElement getMethodElement() {
        return this.method;
    }

    @Override
    public String toFullString() {
        return String.valueOf(this.method.toFullString()) + "\n" + this.toString();
    }

    public String toString() {
        return this.statementStr;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + (this.statementStr == null ? 0 : this.statementStr.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatementElement other = (StatementElement)obj;
        if (this.method == null ? other.method != null : !this.method.equals(other.method)) {
            return false;
        }
        return !(this.statementStr == null ? other.statementStr != null : !this.statementStr.equals(other.statementStr));
    }
}

