/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl2b;

import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.core.datastructures.DetailLevel;
import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.extension.lvl2b.DetailLevelLvl2b;
import de.upb.pga3.panda2.extension.lvl2b.ResultItemLvl2b;
import de.upb.pga3.panda2.extension.lvl2b.ResultLeafLvl2b;
import de.upb.pga3.panda2.extension.lvl2b.ResultTreeLvl2b;
import de.upb.pga3.panda2.extension.lvl2b.ResultTypeLvl2b;
import de.upb.pga3.panda2.extension.lvl2b.SVGArrowLvl2b;
import de.upb.pga3.panda2.extension.lvl2b.SVGBarLvl2b;
import de.upb.pga3.panda2.extension.lvl2b.SVGGraphicLvl2b;
import de.upb.pga3.panda2.extension.lvl2b.SVGPermissionLvl2b;
import de.upb.pga3.panda2.utilities.HTMLFrameBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnalysisResultLvl2b
extends AnalysisResult {
    private static final Logger LOGGER = LogManager.getLogger(AnalysisResultLvl2b.class);
    private ResultLeafLvl2b app;
    private ResultTreeLvl2b components;
    private AnalysisResultLvl2b prevResult;
    private Map<ResultLeafLvl2b, ResultLeafLvl2b> mapCurrentToPrev;
    List<String> filters;
    List<String> activeFilters;
    private int[] permissionUses;
    private int[] permissionUsesAll = null;
    private int newPermissions;
    private int changedPermissions;
    private int unchangedPermissions;
    final int height = 1000;
    public static int barWidth = 75;
    final int permissionsStart = 250;
    final int permissionsWidth = 275;
    final int barsFirst = 0;
    final int width = 2 * 250 + 275;
    final int barsSecond = this.width - barWidth;
    Map<Permission, SVGPermissionLvl2b> mapOfPermissions = new HashMap<Permission, SVGPermissionLvl2b>();
    private File htmlFileTextual;
    private File htmlFileGraphical;
    public static final String TREEOPTION = "Expandable tree";

    public AnalysisResultLvl2b() {
        this.setResultIsFile(true);
        this.htmlFileTextual = new File("data/temp/Level2b_Result_textual.html");
        this.htmlFileGraphical = new File("data/temp/Level2b_Result_graphical.html");
        this.prevResult = null;
        this.filters = new ArrayList<String>();
        this.filters.add(TREEOPTION);
        this.filters.add(ResultTypeLvl2b.getStringOfType(0));
        this.filters.add(ResultTypeLvl2b.getStringOfType(1));
        this.filters.add(ResultTypeLvl2b.getStringOfType(2));
        this.filters.add(ResultTypeLvl2b.getStringOfType(3));
        this.filters.add(ResultTypeLvl2b.getStringOfType(4));
    }

    public void setApp(ResultLeafLvl2b result) {
        this.app = result;
        this.updateFilters(result);
    }

    public ResultLeafLvl2b getApp() {
        return this.app;
    }

    public void setComponents(ResultTreeLvl2b result) {
        this.components = result;
        this.updateFilters(result);
    }

    public ResultTreeLvl2b getComponents() {
        return this.components;
    }

    public int[] getPermissionUses(DetailLevel inDetailLvl, List<String> inFilters) {
        this.getTextualResult(inDetailLvl, inFilters, true);
        return this.permissionUses;
    }

    private void updateFilters(ResultTreeLvl2b result) {
        if (result != null) {
            for (ResultLeafLvl2b leaf : result.getLeafs().values()) {
                this.updateFilters(leaf);
            }
        }
    }

    private void updateFilters(ResultLeafLvl2b result) {
        if (result != null && !result.getResultItems(5).isEmpty()) {
            for (ResultItemLvl2b resultItem : result.getResultItems(5)) {
                boolean add = true;
                for (String filter : this.filters) {
                    if (!filter.equals("Permission: " + resultItem.getPermission().getName())) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                this.filters.add("Permission: " + resultItem.getPermission().getName());
            }
        }
    }

    public void compare(AnalysisResult prevRes) {
        this.prevResult = (AnalysisResultLvl2b)prevRes;
        this.mapOfPermissions = this.prevResult.getMapOfPermissions();
        this.mapCurrentToPrev = new HashMap<ResultLeafLvl2b, ResultLeafLvl2b>();
        this.mapCurrentToPrev.put(this.app, this.prevResult.getApp());
        for (ResultLeafLvl2b currentLeaf : this.components.getLeafsAsList()) {
            for (ResultLeafLvl2b prevLeaf : this.prevResult.getComponents().getLeafsAsList()) {
                if (!currentLeaf.getName().equals(prevLeaf.getName())) continue;
                this.mapCurrentToPrev.put(currentLeaf, prevLeaf);
            }
        }
    }

    @Override
    public String getGraphicalResult(DetailLevel inDetailLvl, List<String> inFilters, boolean inShowStats) {
        try {
            AnalysisResultLvl2b.resetFile(this.htmlFileGraphical);
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.htmlFileGraphical));
            HTMLFrameBuilder fb = new HTMLFrameBuilder(bw, "Graphical result - Inter-App Permission Usage Analysis");
            fb.setHeaderAutoHide(inShowStats);
            fb.setHintPersistent(false);
            fb.setCustomStyle("div.icon { float: left; border: 1px solid #000000; width: 12px; height: 7px;\tmargin-right: 5px; margin-top: 3px;\t}");
            fb.addLegendEntry("<div class=\"icon\" style=\"background:#007f22;\"></div>", "REQUIRED");
            fb.addLegendEntry("<div class=\"icon\" style=\"background:#0006fd;\"></div>", "MAYBE REQUIRED");
            fb.addLegendEntry("<div class=\"icon\" style=\"background:#927a3a;\"></div>", "UNUSED");
            fb.addLegendEntry("<div class=\"icon\" style=\"background:#ff7500;\"></div>", "MAYBE MISSING");
            fb.addLegendEntry("<div class=\"icon\" style=\"background:#ff0000;\"></div>", "MISSING");
            fb.addLegendEntry("<br />", "<br />");
            fb.addLegendEntry("<div class=\"icon\" style=\"background:#000000; height:1px; width:50px; border:none;\"></div>", "Direct");
            fb.addLegendEntry("<div class=\"icon\" style=\"background:#000000; height:1px; width:14px; border:none;\"></div><div class=\"icon\" style=\"background:#000000; height:1px; width:14px; border:none;\"></div><div class=\"icon\" style=\"background:#000000; height:1px; width:12px; border:none;\"></div>", "Indirect");
            fb.addLegendEntry("<div class=\"icon\" style=\"background:#000000; height:3px; width:50px; border:none;\"></div>", "Direct &amp; Indirect");
            fb.append("<center>");
            if (inDetailLvl == DetailLevelLvl2b.APP) {
                if (this.prevResult != null) {
                    this.getGraphic(this.app, this.prevResult.getApp(), fb);
                } else {
                    this.getGraphic(this.app, null, fb);
                }
            } else if (inDetailLvl == DetailLevelLvl2b.COMPONENT) {
                for (ResultLeafLvl2b leaf : this.components.getLeafsAsList()) {
                    if (leaf == null) continue;
                    if (this.prevResult != null) {
                        ResultLeafLvl2b compareLeaf = this.prevResult.getComponents().getLeaf(leaf.getName());
                        if (compareLeaf != null) {
                            this.getGraphic(leaf, compareLeaf, fb);
                            continue;
                        }
                        this.getGraphic(leaf, null, fb);
                        continue;
                    }
                    this.getGraphic(leaf, null, fb);
                }
            } else {
                fb.append("Graphical result only available in APP and COMPONENT mode. Please choose one of those.");
            }
            fb.append("</center>");
            String statsLine = "<strong>" + (this.permissionUsesAll[0] + this.permissionUsesAll[1] + this.permissionUsesAll[2] + this.permissionUsesAll[4] + this.permissionUsesAll[3]) + "</strong> (<font color=\"" + ResultTypeLvl2b.getColorOfType(0) + "\">" + this.permissionUsesAll[0] + "</font> / <font color=\"" + ResultTypeLvl2b.getColorOfType(1) + "\">" + this.permissionUsesAll[1] + "</font> / <font color=\"" + ResultTypeLvl2b.getColorOfType(2) + "\">" + this.permissionUsesAll[2] + "</font> / <font color=\"" + ResultTypeLvl2b.getColorOfType(4) + "\">" + this.permissionUsesAll[4] + "</font> / <font color=\"" + ResultTypeLvl2b.getColorOfType(3) + "\">" + this.permissionUsesAll[3] + "</font>)";
            fb.addStaticticsRow("Analysed permission uses:", statsLine);
            fb.setAppTrustworthy(this.permissionUsesAll[3] + this.permissionUsesAll[4] == 0);
            fb.complete();
            bw.close();
        }
        catch (IOException e) {
            LOGGER.error("Could not access outputfile.");
        }
        return this.htmlFileGraphical.toString();
    }

    private void getGraphic(ResultLeafLvl2b leaf, ResultLeafLvl2b compLeaf, HTMLFrameBuilder fb) throws IOException {
        this.mapOfPermissions.clear();
        SVGGraphicLvl2b svgGraphic = this.getGraphic(leaf, compLeaf, 250, 0, 250 + 275, this.barsSecond);
        if (this.prevResult != null) {
            fb.append("<table width=\"" + this.width + "\"><tr><td>Current Result</td><td align=\"center\"><strong>" + leaf.getName() + "</strong></td><td align=\"right\">Previous Result</td></tr></table>\n");
        } else {
            fb.append("<strong>" + leaf.getName() + "</strong><br />\n");
        }
        fb.append("<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"" + this.width + "\" height=\"" + (13 + 20 * this.mapOfPermissions.values().size() + 2) + "\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">");
        fb.append(svgGraphic.toString());
        fb.append("</svg><br /><br />");
    }

    public SVGGraphicLvl2b getGraphic(ResultLeafLvl2b leaf, ResultLeafLvl2b compLeaf, int xLineStart, int xLineEnd, int xLineStartComp, int xLineEndComp) {
        int[] permissionUsesGraphical = new int[5];
        int[] permissionUsesGraphicalComp = new int[5];
        ArrayList<SVGArrowLvl2b> arrows = new ArrayList<SVGArrowLvl2b>();
        SVGBarLvl2b[] bars = new SVGBarLvl2b[5];
        int yBars = 0;
        SVGBarLvl2b[] barsComp = new SVGBarLvl2b[5];
        int yBarsComp = 0;
        int yPermissions = 13;
        int i = 0;
        while (i < 5) {
            if (leaf.getResultItems(i) != null) {
                for (ResultItemLvl2b resultItem : leaf.getResultItems(i)) {
                    if (!this.activeFilters.contains(ResultTypeLvl2b.getStringOfType(i)) && !this.activeFilters.contains("Permission: " + resultItem.getPermission().getName())) continue;
                    int n = i;
                    permissionUsesGraphical[n] = permissionUsesGraphical[n] + 1;
                    if (this.mapOfPermissions.containsKey(resultItem.getPermission())) continue;
                    this.mapOfPermissions.put(resultItem.getPermission(), new SVGPermissionLvl2b(resultItem.getPermission(), yPermissions));
                    yPermissions += 20;
                }
            }
            if (compLeaf != null && compLeaf.getResultItems(i) != null) {
                for (ResultItemLvl2b resultItem : compLeaf.getResultItems(i)) {
                    if (!this.activeFilters.contains(ResultTypeLvl2b.getStringOfType(i)) && !this.activeFilters.contains("Permission: " + resultItem.getPermission().getName())) continue;
                    int n = i;
                    permissionUsesGraphicalComp[n] = permissionUsesGraphicalComp[n] + 1;
                    if (this.mapOfPermissions.containsKey(resultItem.getPermission())) continue;
                    this.mapOfPermissions.put(resultItem.getPermission(), new SVGPermissionLvl2b(resultItem.getPermission(), yPermissions));
                    yPermissions += 20;
                }
            }
            ++i;
        }
        int sumPermissions = permissionUsesGraphical[0] + permissionUsesGraphical[1] + permissionUsesGraphical[2] + permissionUsesGraphical[4] + permissionUsesGraphical[3];
        int i2 = 0;
        while (i2 < 5) {
            int[] offset;
            int yLine;
            int barHeight = Math.round((float)permissionUsesGraphical[i2] / (float)sumPermissions * (float)(13 + 20 * sumPermissions));
            bars[i2] = new SVGBarLvl2b(xLineEnd, yBars, barHeight);
            yBars += barHeight;
            if (compLeaf != null) {
                int barHeightComp = Math.round((float)permissionUsesGraphicalComp[i2] / (float)sumPermissions * (float)(13 + 20 * sumPermissions));
                barsComp[i2] = new SVGBarLvl2b(xLineEndComp, yBarsComp, barHeightComp);
                yBarsComp += barHeightComp;
            }
            if (leaf.getResultItems(i2) != null) {
                for (ResultItemLvl2b resultItem : leaf.getResultItems(i2)) {
                    if (!this.activeFilters.contains(ResultTypeLvl2b.getStringOfType(i2)) && !this.activeFilters.contains("Permission: " + resultItem.getPermission().getName())) continue;
                    yLine = this.mapOfPermissions.get(resultItem.getPermission()).getY() - 4;
                    offset = new int[]{-5, barWidth};
                    arrows.add(new SVGArrowLvl2b(new int[]{xLineStart + offset[0], yLine}, new int[]{xLineEnd + offset[1], bars[i2].getClosestTo(yLine)}, resultItem.getDirect()));
                }
            }
            if (compLeaf != null && compLeaf.getResultItems(i2) != null) {
                for (ResultItemLvl2b resultItem : compLeaf.getResultItems(i2)) {
                    if (!this.activeFilters.contains(ResultTypeLvl2b.getStringOfType(i2)) && !this.activeFilters.contains("Permission: " + resultItem.getPermission().getName())) continue;
                    yLine = this.mapOfPermissions.get(resultItem.getPermission()).getY() - 4;
                    int[] nArray = new int[2];
                    nArray[0] = 5;
                    offset = nArray;
                    arrows.add(new SVGArrowLvl2b(new int[]{xLineStartComp + offset[0], yLine}, new int[]{xLineEndComp + offset[1], barsComp[i2].getClosestTo(yLine)}, resultItem.getDirect()));
                }
            }
            ++i2;
        }
        return new SVGGraphicLvl2b(arrows, this.mapOfPermissions, bars, barsComp, xLineStart, compLeaf != null);
    }

    @Override
    public String getTextualResult(DetailLevel inDetailLvl, List<String> inFilters, boolean inShowStats) {
        this.permissionUses = new int[5];
        this.newPermissions = 0;
        this.changedPermissions = 0;
        this.unchangedPermissions = 0;
        int[] prevPermissionUses = null;
        if (this.prevResult != null) {
            prevPermissionUses = this.prevResult.getPermissionUses(inDetailLvl, inFilters);
        }
        if (inFilters == null) {
            this.activeFilters = this.getFilters();
            this.activeFilters.remove(TREEOPTION);
        } else {
            this.activeFilters = inFilters;
        }
        try {
            AnalysisResultLvl2b.resetFile(this.htmlFileGraphical);
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.htmlFileTextual));
            HTMLFrameBuilder fb = new HTMLFrameBuilder(bw, "Textual result - Inter-App Permission Usage Analysis");
            fb.setHeaderAutoHide(inShowStats);
            fb.setHintPersistent(false);
            fb.setCustomStyle("div.icon { float: left; border: 1px solid #000000; width: 12px; height: 7px;\tmargin-right: 5px; margin-top: 3px;\t} div.plus { background: #C9C9C9; float: left; border: 1px outset #CCCCCC; padding: 0px 0px 0px 0px; margin-top: 2px; margin-right: 10px; height: 9px; width: 9px; } div.inner { margin-top:-2px; font-size: 10px; text-align: center; cursor: pointer;\t} div.spacer { float: left;\tmargin-top: 3px; margin-right: 10px; height: 11px; width: 11px;\t} div.popout { padding-left: 25px; visibility: hidden; max-height: 0px;\toverflow: hidden; }\tdiv.premissions { padding-left: 21px; }\ttable {\tborder-spacing:0px;\t} td { padding: 0px; }");
            fb.setCustomScript("function show(caller) {\tif(caller.nextElementSibling.nextElementSibling.nextElementSibling.nextElementSibling.nextElementSibling.style.visibility == 'visible') { caller.nextElementSibling.nextElementSibling.nextElementSibling.nextElementSibling.nextElementSibling.style.maxHeight='0px'; caller.nextElementSibling.nextElementSibling.nextElementSibling.nextElementSibling.nextElementSibling.style.visibility='hidden';\tcaller.firstElementChild.innerHTML='+';\tcaller.style.border='1px outset #CCCCCC'; } else { caller.nextElementSibling.nextElementSibling.nextElementSibling.nextElementSibling.nextElementSibling.style.maxHeight='99999px';\tcaller.nextElementSibling.nextElementSibling.nextElementSibling.nextElementSibling.nextElementSibling.style.visibility='visible'; caller.firstElementChild.innerHTML='-'; caller.style.border='1px inset #CCCCCC'; }}");
            fb.addLegendEntry("<div class=\"icon\" style=\"background:#007f22;\"></div>", "REQUIRED");
            fb.addLegendEntry("<div class=\"icon\" style=\"background:#0006fd;\"></div>", "MAYBE REQUIRED");
            fb.addLegendEntry("<div class=\"icon\" style=\"background:#927a3a;\"></div>", "UNUSED");
            fb.addLegendEntry("<div class=\"icon\" style=\"background:#ff7500;\"></div>", "MAYBE MISSING");
            fb.addLegendEntry("<div class=\"icon\" style=\"background:#ff0000;\"></div>", "MISSING");
            if (inDetailLvl == DetailLevelLvl2b.COMPONENT) {
                this.getTextualForTree(this.components, inDetailLvl, fb);
            } else {
                this.getTextualForLeaf(this.app, this.getChildren(this.app, inDetailLvl), inDetailLvl, fb);
            }
            if (inDetailLvl == DetailLevelLvl2b.APP && this.permissionUsesAll == null) {
                this.permissionUsesAll = this.permissionUses;
            } else if (inDetailLvl != DetailLevelLvl2b.APP && this.permissionUsesAll == null) {
                this.getTextualResult(DetailLevelLvl2b.APP, inFilters, inShowStats);
            }
            String statsLine = "<strong>" + (this.permissionUsesAll[0] + this.permissionUsesAll[1] + this.permissionUsesAll[2] + this.permissionUsesAll[4] + this.permissionUsesAll[3]) + "</strong> (<font color=\"" + ResultTypeLvl2b.getColorOfType(0) + "\">" + this.permissionUsesAll[0] + "</font> / <font color=\"" + ResultTypeLvl2b.getColorOfType(1) + "\">" + this.permissionUsesAll[1] + "</font> / <font color=\"" + ResultTypeLvl2b.getColorOfType(2) + "\">" + this.permissionUsesAll[2] + "</font> / <font color=\"" + ResultTypeLvl2b.getColorOfType(4) + "\">" + this.permissionUsesAll[4] + "</font> / <font color=\"" + ResultTypeLvl2b.getColorOfType(3) + "\">" + this.permissionUsesAll[3] + "</font>)";
            fb.addStaticticsRow("Analysed permission uses:", statsLine);
            fb.addStaticticsRow("<br />", "<br />");
            fb.addStaticticsRow("<strong>Filtered</strong>", "");
            if (this.prevResult != null) {
                statsLine = "<strong>" + this.newPermissions + "</strong> / <strong>" + this.unchangedPermissions + "</strong> / <strong>" + this.changedPermissions + "</strong>";
                fb.addStaticticsRow("New/Un-/Changed permissions:", statsLine);
                statsLine = "<strong>" + (prevPermissionUses[0] + prevPermissionUses[1] + prevPermissionUses[2] + prevPermissionUses[4] + prevPermissionUses[3]) + "</strong> (<font color=\"" + ResultTypeLvl2b.getColorOfType(0) + "\">" + prevPermissionUses[0] + "</font> / <font color=\"" + ResultTypeLvl2b.getColorOfType(1) + "\">" + prevPermissionUses[1] + "</font> / <font color=\"" + ResultTypeLvl2b.getColorOfType(2) + "\">" + prevPermissionUses[2] + "</font> / <font color=\"" + ResultTypeLvl2b.getColorOfType(4) + "\">" + prevPermissionUses[4] + "</font> / <font color=\"" + ResultTypeLvl2b.getColorOfType(3) + "\">" + prevPermissionUses[3] + "</font>) &#8594; ";
            } else {
                statsLine = "";
            }
            statsLine = String.valueOf(statsLine) + "<strong>" + (this.permissionUses[0] + this.permissionUses[1] + this.permissionUses[2] + this.permissionUses[4] + this.permissionUses[3]) + "</strong> (<font color=\"" + ResultTypeLvl2b.getColorOfType(0) + "\">" + this.permissionUses[0] + "</font> / <font color=\"" + ResultTypeLvl2b.getColorOfType(1) + "\">" + this.permissionUses[1] + "</font> / <font color=\"" + ResultTypeLvl2b.getColorOfType(2) + "\">" + this.permissionUses[2] + "</font> / <font color=\"" + ResultTypeLvl2b.getColorOfType(4) + "\">" + this.permissionUses[4] + "</font> / <font color=\"" + ResultTypeLvl2b.getColorOfType(3) + "\">" + this.permissionUses[3] + "</font>)";
            fb.addStaticticsRow("Analysed permission uses:", statsLine);
            statsLine = this.prevResult != null ? "<strong>" + (prevPermissionUses[4] + prevPermissionUses[3]) + "</strong> (<font color=\"" + ResultTypeLvl2b.getColorOfType(4) + "\">" + prevPermissionUses[4] + "</font> / <font color=\"" + ResultTypeLvl2b.getColorOfType(3) + "\">" + prevPermissionUses[3] + "</font>) &#8594; " : "";
            statsLine = String.valueOf(statsLine) + "<strong>" + (this.permissionUses[4] + this.permissionUses[3]) + "</strong> (<font color=\"" + ResultTypeLvl2b.getColorOfType(4) + "\">" + this.permissionUses[4] + "</font> / <font color=\"" + ResultTypeLvl2b.getColorOfType(3) + "\">" + this.permissionUses[3] + "</font>)";
            fb.addStaticticsRow("Possibly malicious:", statsLine);
            fb.setAppTrustworthy(this.permissionUsesAll[3] + this.permissionUsesAll[4] == 0);
            fb.complete();
            bw.close();
        }
        catch (IOException e) {
            LOGGER.error("Could not access outputfile.");
        }
        return this.htmlFileTextual.toString();
    }

    private ResultTreeLvl2b getChildren(Object parent, DetailLevel inDetailLvl) {
        if (parent == this.app && (inDetailLvl == DetailLevelLvl2b.APP || inDetailLvl == null)) {
            return this.components;
        }
        return null;
    }

    private void getTextualForTree(ResultTreeLvl2b tree, DetailLevel inDetailLvl, HTMLFrameBuilder fb) throws IOException {
        if (tree != null) {
            for (ResultLeafLvl2b childLeaf : tree.getLeafsAsList()) {
                this.getTextualForLeaf(childLeaf, this.getChildren(tree, inDetailLvl), inDetailLvl, fb);
            }
        }
    }

    private void getTextualForLeaf(ResultLeafLvl2b leaf, ResultTreeLvl2b children, DetailLevel inDetailLvl, HTMLFrameBuilder fb) throws IOException {
        if (children != null && this.activeFilters.contains(TREEOPTION)) {
            fb.append("<div class=\"plus\" onClick=\"show(this)\"><div class=\"inner\">+</div></div>");
        } else {
            fb.append("<div class=\"spacer\"></div>");
        }
        fb.append(" <strong>" + leaf.getName() + "</strong><br />\n" + "<div class=\"premissions\">\n");
        StringBuilder resultStr = new StringBuilder();
        int i = 0;
        while (i < 5) {
            if (leaf.getResultItems(i) != null) {
                for (ResultItemLvl2b resultItem : leaf.getResultItems(i)) {
                    resultStr.append(this.getTextualForResultItem(resultItem, i, leaf));
                }
            }
            ++i;
        }
        fb.append(resultStr.toString());
        fb.append("</div>\n<br />\n");
        if (this.activeFilters.contains(TREEOPTION)) {
            fb.append("<div class=\"popout\">\n\t");
            this.getTextualForTree(children, inDetailLvl, fb);
            fb.append("\n</div>\n\n");
        }
    }

    private String getTextualForResultItem(ResultItemLvl2b resultItem, int type, ResultLeafLvl2b leaf) {
        if (this.activeFilters.contains(ResultTypeLvl2b.getStringOfType(type)) || this.activeFilters.contains("Permission: " + resultItem.getPermission().getName())) {
            int n = type;
            this.permissionUses[n] = this.permissionUses[n] + 1;
            if (this.prevResult == null) {
                return "\t<font color=\"" + ResultTypeLvl2b.getColorOfType(type) + "\" title=\"" + ResultTypeLvl2b.getStringOfType(type) + "\">" + resultItem.getPermission().getName() + "</font>" + resultItem.getDirectString() + "<br />\n";
            }
            ResultLeafLvl2b prevLeaf = this.mapCurrentToPrev.get(leaf);
            if (prevLeaf != null) {
                int found = -1;
                int i = 0;
                while (i < 5) {
                    if (prevLeaf.getResultItems(i) != null) {
                        for (ResultItemLvl2b prevResultItem : prevLeaf.getResultItems(i)) {
                            if (!prevResultItem.getPermission().getName().equals(resultItem.getPermission().getName())) continue;
                            found = i;
                            break;
                        }
                        if (found >= 0) break;
                    }
                    ++i;
                }
                if (type != found) {
                    ++this.changedPermissions;
                    return "\t<strong>" + resultItem.getPermission().getName() + "</strong> <font color=\"" + ResultTypeLvl2b.getColorOfType(found) + "\" title=\"" + ResultTypeLvl2b.getStringOfType(found) + "\">" + ResultTypeLvl2b.getStringOfType(found) + "</font>" + resultItem.getDirectString() + " &#8594; <font color=\"" + ResultTypeLvl2b.getColorOfType(type) + "\" title=\"" + ResultTypeLvl2b.getStringOfType(type) + "\">" + ResultTypeLvl2b.getStringOfType(type) + "</font>" + resultItem.getDirectString() + "<br />\n";
                }
                ++this.unchangedPermissions;
                return "\t<font color=\"" + ResultTypeLvl2b.getColorOfType(type) + "\" title=\"" + ResultTypeLvl2b.getStringOfType(type) + "\">" + resultItem.getPermission().getName() + "</font>" + resultItem.getDirectString() + " <strong>(unchanged)</strong><br />\n";
            }
            ++this.newPermissions;
            return "\t<font color=\"" + ResultTypeLvl2b.getColorOfType(type) + "\" title=\"" + ResultTypeLvl2b.getStringOfType(type) + "\">" + resultItem.getPermission().getName() + "</font>" + resultItem.getDirectString() + " <strong>(new)</strong><br />\n";
        }
        return "";
    }

    @Override
    public List<DetailLevel> getDetailLevels() {
        ArrayList<DetailLevel> detaillevelList = new ArrayList<DetailLevel>();
        DetailLevelLvl2b[] detailLevelLvl2bArray = DetailLevelLvl2b.values();
        int n = detailLevelLvl2bArray.length;
        int n2 = 0;
        while (n2 < n) {
            DetailLevelLvl2b item = detailLevelLvl2bArray[n2];
            detaillevelList.add(item);
            ++n2;
        }
        return detaillevelList;
    }

    public Map<Permission, SVGPermissionLvl2b> getMapOfPermissions() {
        return this.mapOfPermissions;
    }

    @Override
    public List<String> getFilters() {
        return this.filters;
    }

    private static void resetFile(File file) throws IOException {
        file.delete();
        file.createNewFile();
    }
}

