/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Body;
import soot.JastAddJ.Constant;
import soot.JastAddJ.Expr;
import soot.JastAddJ.IntegerLiteral;
import soot.JastAddJ.LongLiteral;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.Unary;
import soot.Value;

public class MinusExpr
extends Unary
implements Cloneable {
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public MinusExpr clone() throws CloneNotSupportedException {
        MinusExpr node = (MinusExpr)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public MinusExpr copy() {
        try {
            MinusExpr node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    public MinusExpr fullCopy() {
        MinusExpr tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.fullCopy();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    @Override
    public void typeCheck() {
        if (!this.getOperand().type().isNumericType()) {
            this.error("unary minus only operates on numeric types");
        }
    }

    @Override
    public Value eval(Body b) {
        return b.newNegExpr(this.asImmediate(b, this.getOperand().eval(b)), this);
    }

    public MinusExpr() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[1];
    }

    public MinusExpr(Expr p0) {
        this.setChild(p0, 0);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return true;
    }

    @Override
    public void setOperand(Expr node) {
        this.setChild(node, 0);
    }

    @Override
    public Expr getOperand() {
        return (Expr)this.getChild(0);
    }

    @Override
    public Expr getOperandNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constant constant() {
        ASTNode$State state = this.state();
        Constant constant = this.type().minus(this.getOperand().constant());
        return constant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConstant() {
        ASTNode$State state = this.state();
        boolean bl = this.getOperand().isConstant();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String printPreOp() {
        ASTNode$State state = this.state();
        String string = "-";
        return string;
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.getOperand().type().unaryNumericPromotion();
    }

    @Override
    public ASTNode rewriteTo() {
        if (this.getOperand() instanceof IntegerLiteral && ((IntegerLiteral)this.getOperand()).isDecimal() && this.getOperand().isPositive()) {
            ++this.state().duringLiterals;
            IntegerLiteral result = this.rewriteRule0();
            --this.state().duringLiterals;
            return result;
        }
        if (this.getOperand() instanceof LongLiteral && ((LongLiteral)this.getOperand()).isDecimal() && this.getOperand().isPositive()) {
            ++this.state().duringLiterals;
            LongLiteral result = this.rewriteRule1();
            --this.state().duringLiterals;
            return result;
        }
        return super.rewriteTo();
    }

    private IntegerLiteral rewriteRule0() {
        IntegerLiteral original = (IntegerLiteral)this.getOperand();
        IntegerLiteral literal = new IntegerLiteral("-" + original.getLITERAL());
        literal.setDigits(original.getDigits());
        literal.setKind(original.getKind());
        return literal;
    }

    private LongLiteral rewriteRule1() {
        LongLiteral original = (LongLiteral)this.getOperand();
        LongLiteral literal = new LongLiteral("-" + original.getLITERAL());
        literal.setDigits(original.getDigits());
        literal.setKind(original.getKind());
        return literal;
    }
}

