/*
 * Decompiled with CFR 0.152.
 */
package soot;

import beaver.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import soot.ArrayType;
import soot.ClassSource;
import soot.G;
import soot.JastAddJ.BytecodeParser;
import soot.JastAddJ.CompilationUnit;
import soot.JastAddJ.JastAddJavaParser;
import soot.JastAddJ.JavaParser;
import soot.JastAddJ.Program;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SourceLocator;
import soot.Type;
import soot.javaToJimple.IInitialResolver;
import soot.options.Options;

public class SootResolver {
    private final Map<SootClass, Collection<Type>> classToTypesSignature = new HashMap<SootClass, Collection<Type>>();
    private final Map<SootClass, Collection<Type>> classToTypesHierarchy = new HashMap<SootClass, Collection<Type>>();
    private final Deque<SootClass>[] worklist = new Deque[4];
    private Program program;

    public SootResolver(Singletons.Global g) {
        this.worklist[1] = new ArrayDeque<SootClass>();
        this.worklist[2] = new ArrayDeque<SootClass>();
        this.worklist[3] = new ArrayDeque<SootClass>();
        this.program = new Program();
        this.program.state().reset();
        this.program.initBytecodeReader(new BytecodeParser());
        this.program.initJavaParser(new JavaParser(){

            @Override
            public CompilationUnit parse(InputStream is, String fileName) throws IOException, Parser.Exception {
                return new JastAddJavaParser().parse(is, fileName);
            }
        });
        this.program.options().initOptions();
        this.program.options().addKeyValueOption("-classpath");
        this.program.options().setValueForOption(Scene.v().getSootClassPath(), "-classpath");
        if (Options.v().src_prec() == 4) {
            this.program.setSrcPrec(1);
        } else if (Options.v().src_prec() == 1) {
            this.program.setSrcPrec(2);
        } else if (Options.v().src_prec() == 2) {
            this.program.setSrcPrec(2);
        }
        this.program.initPaths();
    }

    public static SootResolver v() {
        return G.v().soot_SootResolver();
    }

    private boolean resolveEverything() {
        if (Options.v().on_the_fly()) {
            return false;
        }
        return Options.v().whole_program() || Options.v().whole_shimple() || Options.v().full_resolver() || Options.v().output_format() == 15;
    }

    public SootClass makeClassRef(String className) {
        if (Scene.v().containsClass(className)) {
            return Scene.v().getSootClass(className);
        }
        SootClass newClass = new SootClass(className);
        newClass.setResolvingLevel(0);
        Scene.v().addClass(newClass);
        return newClass;
    }

    public SootClass resolveClass(String className, int desiredLevel) {
        SootClass resolvedClass = null;
        try {
            resolvedClass = this.makeClassRef(className);
            this.addToResolveWorklist(resolvedClass, desiredLevel);
            this.processResolveWorklist();
            return resolvedClass;
        }
        catch (SootClassNotFoundException e) {
            if (resolvedClass != null) {
                assert (resolvedClass.resolvingLevel() == 0);
                Scene.v().removeClass(resolvedClass);
            }
            throw e;
        }
    }

    private void processResolveWorklist() {
        for (int i = 3; i >= 1; --i) {
            while (!this.worklist[i].isEmpty()) {
                SootClass sc = this.worklist[i].pop();
                if (this.resolveEverything()) {
                    boolean onlySignatures;
                    boolean bl = onlySignatures = sc.isPhantom() || Options.v().no_bodies_for_excluded() && Scene.v().isExcluded(sc) && !Scene.v().getBasicClasses().contains(sc.getName());
                    if (onlySignatures) {
                        this.bringToSignatures(sc);
                        sc.setPhantomClass();
                        for (SootMethod m : sc.getMethods()) {
                            m.setPhantom(true);
                        }
                        for (SootField f : sc.getFields()) {
                            f.setPhantom(true);
                        }
                        continue;
                    }
                    this.bringToBodies(sc);
                    continue;
                }
                switch (i) {
                    case 3: {
                        this.bringToBodies(sc);
                        break;
                    }
                    case 2: {
                        this.bringToSignatures(sc);
                        break;
                    }
                    case 1: {
                        this.bringToHierarchy(sc);
                    }
                }
            }
        }
    }

    private void addToResolveWorklist(Type type, int level) {
        if (type instanceof RefType) {
            this.addToResolveWorklist(((RefType)type).getSootClass(), level);
        } else if (type instanceof ArrayType) {
            this.addToResolveWorklist(((ArrayType)type).baseType, level);
        }
    }

    private void addToResolveWorklist(SootClass sc, int desiredLevel) {
        if (sc.resolvingLevel() >= desiredLevel) {
            return;
        }
        this.worklist[desiredLevel].add(sc);
    }

    private void bringToHierarchy(SootClass sc) {
        boolean modelAsPhantomRef;
        if (sc.resolvingLevel() >= 1) {
            return;
        }
        if (Options.v().debug_resolver()) {
            G.v().out.println("bringing to HIERARCHY: " + sc);
        }
        sc.setResolvingLevel(1);
        String className = sc.getName();
        ClassSource is = SourceLocator.v().getClassSource(className);
        boolean bl = modelAsPhantomRef = is == null;
        if (modelAsPhantomRef) {
            if (!Scene.v().allowsPhantomRefs()) {
                String suffix = "";
                if (className.equals("java.lang.Object")) {
                    suffix = " Try adding rt.jar to Soot's classpath, e.g.:\njava -cp sootclasses.jar soot.Main -cp .:/path/to/jdk/jre/lib/rt.jar <other options>";
                } else if (className.equals("javax.crypto.Cipher")) {
                    suffix = " Try adding jce.jar to Soot's classpath, e.g.:\njava -cp sootclasses.jar soot.Main -cp .:/path/to/jdk/jre/lib/rt.jar:/path/to/jdk/jre/lib/jce.jar <other options>";
                }
                throw new SootClassNotFoundException("couldn't find class: " + className + " (is your soot-class-path set properly?)" + suffix);
            }
            G.v().out.println("Warning: " + className + " is a phantom class!");
            sc.setPhantomClass();
            this.classToTypesSignature.put(sc, Collections.emptyList());
            this.classToTypesHierarchy.put(sc, Collections.emptyList());
        } else {
            IInitialResolver.Dependencies dependencies = is.resolve(sc);
            if (!dependencies.typesToSignature.isEmpty()) {
                this.classToTypesSignature.put(sc, dependencies.typesToSignature);
            }
            if (!dependencies.typesToHierarchy.isEmpty()) {
                this.classToTypesHierarchy.put(sc, dependencies.typesToHierarchy);
            }
        }
        this.reResolveHierarchy(sc);
    }

    public void reResolveHierarchy(SootClass sc) {
        if (sc.hasSuperclass()) {
            this.addToResolveWorklist(sc.getSuperclass(), 1);
        }
        if (sc.hasOuterClass()) {
            this.addToResolveWorklist(sc.getOuterClass(), 1);
        }
        for (SootClass iface : sc.getInterfaces()) {
            this.addToResolveWorklist(iface, 1);
        }
    }

    private void bringToSignatures(SootClass sc) {
        if (sc.resolvingLevel() >= 2) {
            return;
        }
        this.bringToHierarchy(sc);
        if (Options.v().debug_resolver()) {
            G.v().out.println("bringing to SIGNATURES: " + sc);
        }
        sc.setResolvingLevel(2);
        for (SootField f : sc.getFields()) {
            this.addToResolveWorklist(f.getType(), 1);
        }
        for (SootMethod m : sc.getMethods()) {
            this.addToResolveWorklist(m.getReturnType(), 1);
            for (Type ptype : m.getParameterTypes()) {
                this.addToResolveWorklist(ptype, 1);
            }
            for (SootClass exception : m.getExceptions()) {
                this.addToResolveWorklist(exception, 1);
            }
        }
        if (sc.hasSuperclass()) {
            this.addToResolveWorklist(sc.getSuperclass(), 2);
        }
        for (SootClass iface : sc.getInterfaces()) {
            this.addToResolveWorklist(iface, 2);
        }
    }

    private void bringToBodies(SootClass sc) {
        if (sc.resolvingLevel() >= 3) {
            return;
        }
        this.bringToSignatures(sc);
        if (Options.v().debug_resolver()) {
            G.v().out.println("bringing to BODIES: " + sc);
        }
        sc.setResolvingLevel(3);
        Collection<Type> references = this.classToTypesHierarchy.get(sc);
        if (references != null) {
            for (Type t : references) {
                this.addToResolveWorklist(t, 1);
            }
        }
        if ((references = this.classToTypesSignature.get(sc)) != null) {
            for (Type t : references) {
                this.addToResolveWorklist(t, 2);
            }
        }
    }

    public void reResolve(SootClass cl, int newResolvingLevel) {
        int resolvingLevel = cl.resolvingLevel();
        if (resolvingLevel >= newResolvingLevel) {
            return;
        }
        this.reResolveHierarchy(cl);
        cl.setResolvingLevel(newResolvingLevel);
        this.addToResolveWorklist(cl, resolvingLevel);
        this.processResolveWorklist();
    }

    public void reResolve(SootClass cl) {
        this.reResolve(cl, 1);
    }

    public Program getProgram() {
        return this.program;
    }

    private class SootClassNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1563461446590293827L;

        private SootClassNotFoundException(String s) {
            super(s);
        }
    }
}

