/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import soot.PatchingChain;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.ValueBox;
import soot.VoidType;
import soot.jimple.AssignStmt;
import soot.jimple.DoubleConstant;
import soot.jimple.FieldRef;
import soot.jimple.FloatConstant;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.LongConstant;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.tagkit.DoubleConstantValueTag;
import soot.tagkit.FloatConstantValueTag;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.LongConstantValueTag;
import soot.tagkit.StringConstantValueTag;
import soot.tagkit.Tag;

public class ConstantValueToInitializerTransformer
extends SceneTransformer {
    public static ConstantValueToInitializerTransformer v() {
        return new ConstantValueToInitializerTransformer();
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        for (SootClass sc : Scene.v().getClasses()) {
            this.transformClass(sc);
        }
    }

    public void transformClass(SootClass sc) {
        PatchingChain<Unit> units;
        SootMethod smInit = null;
        HashSet<SootField> alreadyInitialized = new HashSet<SootField>();
        for (SootField sf : sc.getFields()) {
            if (!sf.isStatic() || !sf.isFinal() || alreadyInitialized.contains(sf)) continue;
            for (Tag t : sf.getTags()) {
                AssignStmt initStmt = null;
                if (t instanceof DoubleConstantValueTag) {
                    double value = ((DoubleConstantValueTag)t).getDoubleValue();
                    initStmt = Jimple.v().newAssignStmt(Jimple.v().newStaticFieldRef(sf.makeRef()), DoubleConstant.v(value));
                } else if (t instanceof FloatConstantValueTag) {
                    float value = ((FloatConstantValueTag)t).getFloatValue();
                    initStmt = Jimple.v().newAssignStmt(Jimple.v().newStaticFieldRef(sf.makeRef()), FloatConstant.v(value));
                } else if (t instanceof IntegerConstantValueTag) {
                    int value = ((IntegerConstantValueTag)t).getIntValue();
                    initStmt = Jimple.v().newAssignStmt(Jimple.v().newStaticFieldRef(sf.makeRef()), IntConstant.v(value));
                } else if (t instanceof LongConstantValueTag) {
                    long value = ((LongConstantValueTag)t).getLongValue();
                    initStmt = Jimple.v().newAssignStmt(Jimple.v().newStaticFieldRef(sf.makeRef()), LongConstant.v(value));
                } else if (t instanceof StringConstantValueTag) {
                    String value = ((StringConstantValueTag)t).getStringValue();
                    initStmt = Jimple.v().newAssignStmt(Jimple.v().newStaticFieldRef(sf.makeRef()), StringConstant.v(value));
                }
                if (initStmt == null) continue;
                if (smInit == null) {
                    smInit = this.getOrCreateInitializer(sc, alreadyInitialized);
                }
                smInit.getActiveBody().getUnits().addFirst(initStmt);
            }
        }
        if (smInit != null && ((units = smInit.getActiveBody().getUnits()).isEmpty() || !(units.getLast() instanceof ReturnVoidStmt))) {
            units.add(Jimple.v().newReturnVoidStmt());
        }
    }

    private SootMethod getOrCreateInitializer(SootClass sc, Set<SootField> alreadyInitialized) {
        SootMethod smInit = sc.getMethodByNameUnsafe("<clinit>");
        if (smInit == null) {
            smInit = new SootMethod("<clinit>", Collections.<Type>emptyList(), VoidType.v());
            smInit.setActiveBody(Jimple.v().newBody(smInit));
            sc.addMethod(smInit);
            smInit.setModifiers(9);
        } else {
            smInit.retrieveActiveBody();
            for (Unit u : smInit.getActiveBody().getUnits()) {
                Stmt s = (Stmt)u;
                for (ValueBox vb : s.getDefBoxes()) {
                    if (!(vb.getValue() instanceof FieldRef)) continue;
                    alreadyInitialized.add(((FieldRef)vb.getValue()).getField());
                }
            }
        }
        return smInit;
    }
}

