/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.Account;
import android.accounts.AccountAuthenticatorResponse;
import android.accounts.AccountManager;
import android.accounts.AccountManagerCallback;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorDescription;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.io.IOException;

public class GrantCredentialsPermissionActivity
extends Activity
implements View.OnClickListener {
    public static final String EXTRAS_ACCOUNT = "account";
    public static final String EXTRAS_ACCOUNT_TYPE_LABEL = "accountTypeLabel";
    public static final String EXTRAS_AUTH_TOKEN_LABEL = "authTokenLabel";
    public static final String EXTRAS_AUTH_TOKEN_TYPE = "authTokenType";
    public static final String EXTRAS_PACKAGES = "application";
    public static final String EXTRAS_REQUESTING_UID = "uid";
    public static final String EXTRAS_RESPONSE = "response";
    private Account mAccount;
    private String mAuthTokenType;
    protected LayoutInflater mInflater;
    private Bundle mResultBundle = null;
    private int mUid;

    private String getAccountLabel(Account account) {
        for (AuthenticatorDescription authenticatorDescription : AccountManager.get(this).getAuthenticatorTypes()) {
            if (!authenticatorDescription.type.equals(account.type)) continue;
            try {
                String string2 = this.createPackageContext(authenticatorDescription.packageName, 0).getString(authenticatorDescription.labelId);
                return string2;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return account.type;
            }
            catch (Resources.NotFoundException notFoundException) {
                return account.type;
            }
        }
        return account.type;
    }

    private View newPackageView(String string2) {
        View view = this.mInflater.inflate(17367206, null);
        ((TextView)view.findViewById(16909203)).setText(string2);
        return view;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void finish() {
        AccountAuthenticatorResponse accountAuthenticatorResponse = (AccountAuthenticatorResponse)this.getIntent().getParcelableExtra(EXTRAS_RESPONSE);
        if (accountAuthenticatorResponse != null) {
            if (this.mResultBundle != null) {
                accountAuthenticatorResponse.onResult(this.mResultBundle);
            } else {
                accountAuthenticatorResponse.onError(4, "canceled");
            }
        }
        super.finish();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onClick(View view) {
        switch (view.getId()) {
            case 16909126: {
                AccountManager.get(this).updateAppPermission(this.mAccount, this.mAuthTokenType, this.mUid, true);
                Intent intent = new Intent();
                intent.putExtra("retry", true);
                this.setResult(-1, intent);
                this.setAccountAuthenticatorResult(intent.getExtras());
            }
            default: {
                break;
            }
            case 16909125: {
                AccountManager.get(this).updateAppPermission(this.mAccount, this.mAuthTokenType, this.mUid, false);
                this.setResult(0);
            }
        }
        this.finish();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void onCreate(Bundle bundle) {
        String string2;
        super.onCreate(bundle);
        this.setContentView(17367153);
        this.setTitle(17040687);
        this.mInflater = (LayoutInflater)this.getSystemService("layout_inflater");
        Bundle bundle2 = this.getIntent().getExtras();
        if (bundle2 == null) {
            this.setResult(0);
            this.finish();
            return;
        }
        this.mAccount = (Account)bundle2.getParcelable(EXTRAS_ACCOUNT);
        this.mAuthTokenType = bundle2.getString(EXTRAS_AUTH_TOKEN_TYPE);
        this.mUid = bundle2.getInt(EXTRAS_REQUESTING_UID);
        PackageManager packageManager = this.getPackageManager();
        String[] stringArray = packageManager.getPackagesForUid(this.mUid);
        if (this.mAccount == null || this.mAuthTokenType == null || stringArray == null) {
            this.setResult(0);
            this.finish();
            return;
        }
        try {
            string2 = this.getAccountLabel(this.mAccount);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setResult(0);
            this.finish();
            return;
        }
        final TextView textView = (TextView)this.findViewById(16909122);
        textView.setVisibility(8);
        AccountManagerCallback<String> accountManagerCallback = new AccountManagerCallback<String>(){

            @Override
            public void run(AccountManagerFuture<String> accountManagerFuture) {
                try {
                    final String string2 = accountManagerFuture.getResult();
                    if (!TextUtils.isEmpty(string2)) {
                        GrantCredentialsPermissionActivity.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                if (!GrantCredentialsPermissionActivity.this.isFinishing()) {
                                    textView.setText(string2);
                                    textView.setVisibility(0);
                                }
                            }
                        });
                    }
                    return;
                }
                catch (AuthenticatorException authenticatorException) {
                    return;
                }
                catch (IOException iOException) {
                    return;
                }
                catch (OperationCanceledException operationCanceledException) {
                    return;
                }
            }
        };
        AccountManager.get(this).getAuthTokenLabel(this.mAccount.type, this.mAuthTokenType, accountManagerCallback, null);
        this.findViewById(16909126).setOnClickListener(this);
        this.findViewById(16909125).setOnClickListener(this);
        LinearLayout linearLayout = (LinearLayout)this.findViewById(16909118);
        int n = stringArray.length;
        int n2 = 0;
        while (true) {
            String string3;
            if (n2 >= n) {
                ((TextView)this.findViewById(16909121)).setText(this.mAccount.name);
                ((TextView)this.findViewById(16909120)).setText(string2);
                return;
            }
            String string4 = stringArray[n2];
            try {
                String string5;
                string3 = string5 = packageManager.getApplicationLabel(packageManager.getApplicationInfo(string4, 0)).toString();
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                string3 = string4;
            }
            linearLayout.addView(this.newPackageView(string3));
            ++n2;
        }
    }

    public final void setAccountAuthenticatorResult(Bundle bundle) {
        this.mResultBundle = bundle;
    }
}

