/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.os.Trace;
import android.util.ArrayMap;
import dalvik.system.PathClassLoader;

class ApplicationLoaders {
    private static final ApplicationLoaders gApplicationLoaders = new ApplicationLoaders();
    private final ArrayMap<String, ClassLoader> mLoaders = new ArrayMap();

    ApplicationLoaders() {
    }

    public static ApplicationLoaders getDefault() {
        return gApplicationLoaders;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClassLoader getClassLoader(String string2, String string3, ClassLoader classLoader) {
        ClassLoader classLoader2 = ClassLoader.getSystemClassLoader().getParent();
        ArrayMap<String, ClassLoader> arrayMap = this.mLoaders;
        synchronized (arrayMap) {
            if (classLoader == null) {
                classLoader = classLoader2;
            }
            if (classLoader != classLoader2) {
                Trace.traceBegin(64L, string2);
                PathClassLoader pathClassLoader = new PathClassLoader(string2, classLoader);
                Trace.traceEnd(64L);
                return pathClassLoader;
            }
            ClassLoader classLoader3 = this.mLoaders.get(string2);
            if (classLoader3 != null) {
                return classLoader3;
            }
            Trace.traceBegin(64L, string2);
            PathClassLoader pathClassLoader = new PathClassLoader(string2, string3, classLoader);
            Trace.traceEnd(64L);
            this.mLoaders.put(string2, pathClassLoader);
            return pathClassLoader;
        }
    }
}

