/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.SpannableString;
import android.text.style.StyleSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.android.internal.R;
import java.text.NumberFormat;

public class ProgressDialog
extends AlertDialog {
    public static final int STYLE_HORIZONTAL = 1;
    public static final int STYLE_SPINNER;
    private boolean mHasStarted;
    private int mIncrementBy;
    private int mIncrementSecondaryBy;
    private boolean mIndeterminate;
    private Drawable mIndeterminateDrawable;
    private int mMax;
    private CharSequence mMessage;
    private TextView mMessageView;
    private ProgressBar mProgress;
    private Drawable mProgressDrawable;
    private TextView mProgressNumber;
    private String mProgressNumberFormat;
    private TextView mProgressPercent;
    private NumberFormat mProgressPercentFormat;
    private int mProgressStyle = 0;
    private int mProgressVal;
    private int mSecondaryProgressVal;
    private Handler mViewUpdateHandler;

    public ProgressDialog(Context context) {
        super(context);
        this.initFormats();
    }

    public ProgressDialog(Context context, int n) {
        super(context, n);
        this.initFormats();
    }

    private void initFormats() {
        this.mProgressNumberFormat = "%1d/%2d";
        this.mProgressPercentFormat = NumberFormat.getPercentInstance();
        this.mProgressPercentFormat.setMaximumFractionDigits(0);
    }

    private void onProgressChanged() {
        if (this.mProgressStyle == 1 && this.mViewUpdateHandler != null && !this.mViewUpdateHandler.hasMessages(0)) {
            this.mViewUpdateHandler.sendEmptyMessage(0);
        }
    }

    public static ProgressDialog show(Context context, CharSequence charSequence, CharSequence charSequence2) {
        return ProgressDialog.show(context, charSequence, charSequence2, false);
    }

    public static ProgressDialog show(Context context, CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        return ProgressDialog.show(context, charSequence, charSequence2, bl, false, null);
    }

    public static ProgressDialog show(Context context, CharSequence charSequence, CharSequence charSequence2, boolean bl, boolean bl2) {
        return ProgressDialog.show(context, charSequence, charSequence2, bl, bl2, null);
    }

    public static ProgressDialog show(Context context, CharSequence charSequence, CharSequence charSequence2, boolean bl, boolean bl2, DialogInterface.OnCancelListener onCancelListener) {
        ProgressDialog progressDialog = new ProgressDialog(context);
        progressDialog.setTitle(charSequence);
        progressDialog.setMessage(charSequence2);
        progressDialog.setIndeterminate(bl);
        progressDialog.setCancelable(bl2);
        progressDialog.setOnCancelListener(onCancelListener);
        progressDialog.show();
        return progressDialog;
    }

    public int getMax() {
        if (this.mProgress != null) {
            return this.mProgress.getMax();
        }
        return this.mMax;
    }

    public int getProgress() {
        if (this.mProgress != null) {
            return this.mProgress.getProgress();
        }
        return this.mProgressVal;
    }

    public int getSecondaryProgress() {
        if (this.mProgress != null) {
            return this.mProgress.getSecondaryProgress();
        }
        return this.mSecondaryProgressVal;
    }

    public void incrementProgressBy(int n) {
        if (this.mProgress != null) {
            this.mProgress.incrementProgressBy(n);
            this.onProgressChanged();
            return;
        }
        this.mIncrementBy = n + this.mIncrementBy;
    }

    public void incrementSecondaryProgressBy(int n) {
        if (this.mProgress != null) {
            this.mProgress.incrementSecondaryProgressBy(n);
            this.onProgressChanged();
            return;
        }
        this.mIncrementSecondaryBy = n + this.mIncrementSecondaryBy;
    }

    public boolean isIndeterminate() {
        if (this.mProgress != null) {
            return this.mProgress.isIndeterminate();
        }
        return this.mIndeterminate;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onCreate(Bundle bundle) {
        LayoutInflater layoutInflater = LayoutInflater.from(this.mContext);
        TypedArray typedArray = this.mContext.obtainStyledAttributes(null, R.styleable.AlertDialog, 16842845, 0);
        if (this.mProgressStyle == 1) {
            this.mViewUpdateHandler = new Handler(){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void handleMessage(Message message) {
                    super.handleMessage(message);
                    int n = ProgressDialog.this.mProgress.getProgress();
                    int n2 = ProgressDialog.this.mProgress.getMax();
                    if (ProgressDialog.this.mProgressNumberFormat != null) {
                        String string2 = ProgressDialog.this.mProgressNumberFormat;
                        TextView textView = ProgressDialog.this.mProgressNumber;
                        Object[] objectArray = new Object[]{n, n2};
                        textView.setText(String.format(string2, objectArray));
                    } else {
                        ProgressDialog.this.mProgressNumber.setText("");
                    }
                    if (ProgressDialog.this.mProgressPercentFormat != null) {
                        double d = (double)n / (double)n2;
                        SpannableString spannableString = new SpannableString(ProgressDialog.this.mProgressPercentFormat.format(d));
                        spannableString.setSpan(new StyleSpan(1), 0, spannableString.length(), 33);
                        ProgressDialog.this.mProgressPercent.setText(spannableString);
                        return;
                    }
                    ProgressDialog.this.mProgressPercent.setText("");
                }
            };
            View view = layoutInflater.inflate(typedArray.getResourceId(17, 17367084), null);
            this.mProgress = (ProgressBar)view.findViewById(16908301);
            this.mProgressNumber = (TextView)view.findViewById(16909024);
            this.mProgressPercent = (TextView)view.findViewById(16909023);
            this.setView(view);
        } else {
            View view = layoutInflater.inflate(typedArray.getResourceId(16, 17367233), null);
            this.mProgress = (ProgressBar)view.findViewById(16908301);
            this.mMessageView = (TextView)view.findViewById(16908299);
            this.setView(view);
        }
        typedArray.recycle();
        if (this.mMax > 0) {
            this.setMax(this.mMax);
        }
        if (this.mProgressVal > 0) {
            this.setProgress(this.mProgressVal);
        }
        if (this.mSecondaryProgressVal > 0) {
            this.setSecondaryProgress(this.mSecondaryProgressVal);
        }
        if (this.mIncrementBy > 0) {
            this.incrementProgressBy(this.mIncrementBy);
        }
        if (this.mIncrementSecondaryBy > 0) {
            this.incrementSecondaryProgressBy(this.mIncrementSecondaryBy);
        }
        if (this.mProgressDrawable != null) {
            this.setProgressDrawable(this.mProgressDrawable);
        }
        if (this.mIndeterminateDrawable != null) {
            this.setIndeterminateDrawable(this.mIndeterminateDrawable);
        }
        if (this.mMessage != null) {
            this.setMessage(this.mMessage);
        }
        this.setIndeterminate(this.mIndeterminate);
        this.onProgressChanged();
        super.onCreate(bundle);
    }

    @Override
    public void onStart() {
        super.onStart();
        this.mHasStarted = true;
    }

    @Override
    protected void onStop() {
        super.onStop();
        this.mHasStarted = false;
    }

    public void setIndeterminate(boolean bl) {
        if (this.mProgress != null) {
            this.mProgress.setIndeterminate(bl);
            return;
        }
        this.mIndeterminate = bl;
    }

    public void setIndeterminateDrawable(Drawable drawable2) {
        if (this.mProgress != null) {
            this.mProgress.setIndeterminateDrawable(drawable2);
            return;
        }
        this.mIndeterminateDrawable = drawable2;
    }

    public void setMax(int n) {
        if (this.mProgress != null) {
            this.mProgress.setMax(n);
            this.onProgressChanged();
            return;
        }
        this.mMax = n;
    }

    @Override
    public void setMessage(CharSequence charSequence) {
        if (this.mProgress != null) {
            if (this.mProgressStyle == 1) {
                super.setMessage(charSequence);
                return;
            }
            this.mMessageView.setText(charSequence);
            return;
        }
        this.mMessage = charSequence;
    }

    public void setProgress(int n) {
        if (this.mHasStarted) {
            this.mProgress.setProgress(n);
            this.onProgressChanged();
            return;
        }
        this.mProgressVal = n;
    }

    public void setProgressDrawable(Drawable drawable2) {
        if (this.mProgress != null) {
            this.mProgress.setProgressDrawable(drawable2);
            return;
        }
        this.mProgressDrawable = drawable2;
    }

    public void setProgressNumberFormat(String string2) {
        this.mProgressNumberFormat = string2;
        this.onProgressChanged();
    }

    public void setProgressPercentFormat(NumberFormat numberFormat) {
        this.mProgressPercentFormat = numberFormat;
        this.onProgressChanged();
    }

    public void setProgressStyle(int n) {
        this.mProgressStyle = n;
    }

    public void setSecondaryProgress(int n) {
        if (this.mProgress != null) {
            this.mProgress.setSecondaryProgress(n);
            this.onProgressChanged();
            return;
        }
        this.mSecondaryProgressVal = n;
    }
}

