/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Dialog;
import android.app.SearchManager;
import android.app.SearchableInfo;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.AutoCompleteTextView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.SearchView;
import android.widget.TextView;

public class SearchDialog
extends Dialog {
    private static final boolean DBG = false;
    private static final String IME_OPTION_NO_MICROPHONE = "nm";
    private static final String INSTANCE_KEY_APPDATA = "data";
    private static final String INSTANCE_KEY_COMPONENT = "comp";
    private static final String INSTANCE_KEY_USER_QUERY = "uQry";
    private static final String LOG_TAG = "SearchDialog";
    private static final int SEARCH_PLATE_LEFT_PADDING_NON_GLOBAL = 7;
    private Context mActivityContext;
    private ImageView mAppIcon;
    private Bundle mAppSearchData;
    private TextView mBadgeLabel;
    private View mCloseSearch;
    private BroadcastReceiver mConfChangeListener = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.CONFIGURATION_CHANGED")) {
                SearchDialog.this.onConfigurationChanged();
            }
        }
    };
    private ComponentName mLaunchComponent;
    private final SearchView.OnCloseListener mOnCloseListener = new SearchView.OnCloseListener(){

        @Override
        public boolean onClose() {
            return SearchDialog.this.onClosePressed();
        }
    };
    private final SearchView.OnQueryTextListener mOnQueryChangeListener = new SearchView.OnQueryTextListener(){

        @Override
        public boolean onQueryTextChange(String string2) {
            return false;
        }

        @Override
        public boolean onQueryTextSubmit(String string2) {
            SearchDialog.this.dismiss();
            return false;
        }
    };
    private final SearchView.OnSuggestionListener mOnSuggestionSelectionListener = new SearchView.OnSuggestionListener(){

        @Override
        public boolean onSuggestionClick(int n) {
            SearchDialog.this.dismiss();
            return false;
        }

        @Override
        public boolean onSuggestionSelect(int n) {
            return false;
        }
    };
    private AutoCompleteTextView mSearchAutoComplete;
    private int mSearchAutoCompleteImeOptions;
    private View mSearchPlate;
    private SearchView mSearchView;
    private SearchableInfo mSearchable;
    private String mUserQuery;
    private final Intent mVoiceAppSearchIntent;
    private final Intent mVoiceWebSearchIntent = new Intent("android.speech.action.WEB_SEARCH");
    private Drawable mWorkingSpinner;

    public SearchDialog(Context context, SearchManager searchManager) {
        super(context, SearchDialog.resolveDialogTheme(context));
        this.mVoiceWebSearchIntent.addFlags(0x10000000);
        this.mVoiceWebSearchIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", "web_search");
        this.mVoiceAppSearchIntent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        this.mVoiceAppSearchIntent.addFlags(0x10000000);
    }

    private void createContentView() {
        this.setContentView(17367256);
        ((SearchBar)this.findViewById(16909077)).setSearchDialog(this);
        this.mSearchView = (SearchView)this.findViewById(16909239);
        this.mSearchView.setIconified(false);
        this.mSearchView.setOnCloseListener(this.mOnCloseListener);
        this.mSearchView.setOnQueryTextListener(this.mOnQueryChangeListener);
        this.mSearchView.setOnSuggestionListener(this.mOnSuggestionSelectionListener);
        this.mSearchView.onActionViewExpanded();
        this.mCloseSearch = this.findViewById(16908327);
        this.mCloseSearch.setOnClickListener(new View.OnClickListener(){

            @Override
            public void onClick(View view) {
                SearchDialog.this.dismiss();
            }
        });
        this.mBadgeLabel = (TextView)this.mSearchView.findViewById(16909078);
        this.mSearchAutoComplete = (AutoCompleteTextView)this.mSearchView.findViewById(16909083);
        this.mAppIcon = (ImageView)this.findViewById(16909238);
        this.mSearchPlate = this.mSearchView.findViewById(16909082);
        this.mWorkingSpinner = this.getContext().getDrawable(17303264);
        this.setWorking(false);
        this.mBadgeLabel.setVisibility(8);
        this.mSearchAutoCompleteImeOptions = this.mSearchAutoComplete.getImeOptions();
    }

    private Intent createIntent(String string2, Uri uri, String string3, String string4, int n, String string5) {
        Intent intent = new Intent(string2);
        intent.addFlags(0x10000000);
        if (uri != null) {
            intent.setData(uri);
        }
        intent.putExtra("user_query", this.mUserQuery);
        if (string4 != null) {
            intent.putExtra("query", string4);
        }
        if (string3 != null) {
            intent.putExtra("intent_extra_data_key", string3);
        }
        if (this.mAppSearchData != null) {
            intent.putExtra("app_data", this.mAppSearchData);
        }
        if (n != 0) {
            intent.putExtra("action_key", n);
            intent.putExtra("action_msg", string5);
        }
        intent.setComponent(this.mSearchable.getSearchActivity());
        return intent;
    }

    private boolean doShow(String string2, boolean bl, ComponentName componentName, Bundle bundle) {
        if (!this.show(componentName, bundle)) {
            return false;
        }
        this.setUserQuery(string2);
        if (bl) {
            this.mSearchAutoComplete.selectAll();
        }
        return true;
    }

    private boolean isEmpty(AutoCompleteTextView autoCompleteTextView) {
        return TextUtils.getTrimmedLength(autoCompleteTextView.getText()) == 0;
    }

    static boolean isLandscapeMode(Context context) {
        return context.getResources().getConfiguration().orientation == 2;
    }

    private boolean isOutOfBounds(View view, MotionEvent motionEvent) {
        int n = (int)motionEvent.getX();
        int n2 = (int)motionEvent.getY();
        int n3 = ViewConfiguration.get(this.mContext).getScaledWindowTouchSlop();
        return n < -n3 || n2 < -n3 || n > n3 + view.getWidth() || n2 > n3 + view.getHeight();
    }

    private void launchIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        Log.d(LOG_TAG, "launching " + intent);
        try {
            this.getContext().startActivity(intent);
            this.dismiss();
            return;
        }
        catch (RuntimeException runtimeException) {
            Log.e(LOG_TAG, "Failed launch activity: " + intent, runtimeException);
            return;
        }
    }

    private boolean onClosePressed() {
        if (this.isEmpty(this.mSearchAutoComplete)) {
            this.dismiss();
            return true;
        }
        return false;
    }

    static int resolveDialogTheme(Context context) {
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(16844041, typedValue, true);
        return typedValue.resourceId;
    }

    private void setUserQuery(String string2) {
        if (string2 == null) {
            string2 = "";
        }
        this.mUserQuery = string2;
        this.mSearchAutoComplete.setText(string2);
        this.mSearchAutoComplete.setSelection(string2.length());
    }

    private boolean show(ComponentName componentName, Bundle bundle) {
        this.mSearchable = ((SearchManager)this.mContext.getSystemService("search")).getSearchableInfo(componentName);
        if (this.mSearchable == null) {
            return false;
        }
        this.mLaunchComponent = componentName;
        this.mAppSearchData = bundle;
        this.mActivityContext = this.mSearchable.getActivityContext(this.getContext());
        if (!this.isShowing()) {
            this.createContentView();
            this.mSearchView.setSearchableInfo(this.mSearchable);
            this.mSearchView.setAppSearchData(this.mAppSearchData);
            this.show();
        }
        this.updateUI();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateSearchAppIcon() {
        Drawable drawable2;
        PackageManager packageManager = this.getContext().getPackageManager();
        try {
            Drawable drawable3;
            drawable2 = drawable3 = packageManager.getApplicationIcon(packageManager.getActivityInfo((ComponentName)this.mLaunchComponent, (int)0).applicationInfo);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            drawable2 = packageManager.getDefaultActivityIcon();
            Log.w(LOG_TAG, this.mLaunchComponent + " not found, using generic app icon");
        }
        this.mAppIcon.setImageDrawable(drawable2);
        this.mAppIcon.setVisibility(0);
        this.mSearchPlate.setPadding(7, this.mSearchPlate.getPaddingTop(), this.mSearchPlate.getPaddingRight(), this.mSearchPlate.getPaddingBottom());
    }

    private void updateSearchAutoComplete() {
        this.mSearchAutoComplete.setDropDownDismissedOnCompletion(false);
        this.mSearchAutoComplete.setForceIgnoreOutsideTouch(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateSearchBadge() {
        Drawable drawable2;
        int n = 8;
        String string2 = null;
        if (this.mSearchable.useBadgeIcon()) {
            drawable2 = this.mActivityContext.getDrawable(this.mSearchable.getIconId());
            n = 0;
        } else {
            boolean bl = this.mSearchable.useBadgeLabel();
            drawable2 = null;
            string2 = null;
            if (bl) {
                string2 = this.mActivityContext.getResources().getText(this.mSearchable.getLabelId()).toString();
                drawable2 = null;
                n = 0;
            }
        }
        this.mBadgeLabel.setCompoundDrawablesWithIntrinsicBounds(drawable2, null, null, null);
        this.mBadgeLabel.setText(string2);
        this.mBadgeLabel.setVisibility(n);
    }

    private void updateUI() {
        block6: {
            block5: {
                if (this.mSearchable == null) break block5;
                this.mDecor.setVisibility(0);
                this.updateSearchAutoComplete();
                this.updateSearchAppIcon();
                this.updateSearchBadge();
                int n = this.mSearchable.getInputType();
                if ((n & 0xF) == 1) {
                    n &= 0xFFFEFFFF;
                    if (this.mSearchable.getSuggestAuthority() != null) {
                        n |= 0x10000;
                    }
                }
                this.mSearchAutoComplete.setInputType(n);
                this.mSearchAutoCompleteImeOptions = this.mSearchable.getImeOptions();
                this.mSearchAutoComplete.setImeOptions(this.mSearchAutoCompleteImeOptions);
                if (!this.mSearchable.getVoiceSearchEnabled()) break block6;
                this.mSearchAutoComplete.setPrivateImeOptions(IME_OPTION_NO_MICROPHONE);
            }
            return;
        }
        this.mSearchAutoComplete.setPrivateImeOptions(null);
    }

    @Override
    public void hide() {
        if (!this.isShowing()) {
            return;
        }
        InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (inputMethodManager != null) {
            inputMethodManager.hideSoftInputFromWindow(this.getWindow().getDecorView().getWindowToken(), 0);
        }
        super.hide();
    }

    public void launchQuerySearch() {
        this.launchQuerySearch(0, null);
    }

    protected void launchQuerySearch(int n, String string2) {
        this.launchIntent(this.createIntent("android.intent.action.SEARCH", null, null, this.mSearchAutoComplete.getText().toString(), n, string2));
    }

    @Override
    public void onBackPressed() {
        InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (inputMethodManager != null && inputMethodManager.isFullscreenMode() && inputMethodManager.hideSoftInputFromWindow(this.getWindow().getDecorView().getWindowToken(), 0)) {
            return;
        }
        this.cancel();
    }

    public void onConfigurationChanged() {
        if (this.mSearchable != null && this.isShowing()) {
            this.updateSearchAppIcon();
            this.updateSearchBadge();
            if (SearchDialog.isLandscapeMode(this.getContext())) {
                this.mSearchAutoComplete.ensureImeVisible(true);
            }
        }
    }

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Window window = this.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        layoutParams.width = -1;
        layoutParams.height = -1;
        layoutParams.gravity = 55;
        layoutParams.softInputMode = 16;
        window.setAttributes(layoutParams);
        this.setCanceledOnTouchOutside(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onRestoreInstanceState(Bundle bundle) {
        block3: {
            block2: {
                if (bundle == null) break block2;
                ComponentName componentName = (ComponentName)bundle.getParcelable(INSTANCE_KEY_COMPONENT);
                Bundle bundle2 = bundle.getBundle(INSTANCE_KEY_APPDATA);
                if (!this.doShow(bundle.getString(INSTANCE_KEY_USER_QUERY), false, componentName, bundle2)) break block3;
            }
            return;
        }
    }

    @Override
    public Bundle onSaveInstanceState() {
        if (!this.isShowing()) {
            return null;
        }
        Bundle bundle = new Bundle();
        bundle.putParcelable(INSTANCE_KEY_COMPONENT, this.mLaunchComponent);
        bundle.putBundle(INSTANCE_KEY_APPDATA, this.mAppSearchData);
        bundle.putString(INSTANCE_KEY_USER_QUERY, this.mUserQuery);
        return bundle;
    }

    @Override
    public void onStart() {
        super.onStart();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        this.getContext().registerReceiver(this.mConfChangeListener, intentFilter);
    }

    @Override
    public void onStop() {
        super.onStop();
        this.getContext().unregisterReceiver(this.mConfChangeListener);
        this.mLaunchComponent = null;
        this.mAppSearchData = null;
        this.mSearchable = null;
        this.mUserQuery = null;
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.mSearchAutoComplete.isPopupShowing() && this.isOutOfBounds(this.mSearchPlate, motionEvent)) {
            this.cancel();
            return true;
        }
        return super.onTouchEvent(motionEvent);
    }

    public void setListSelection(int n) {
        this.mSearchAutoComplete.setListSelection(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setWorking(boolean bl) {
        Drawable drawable2 = this.mWorkingSpinner;
        int n = bl ? 255 : 0;
        drawable2.setAlpha(n);
        this.mWorkingSpinner.setVisible(bl, false);
        this.mWorkingSpinner.invalidateSelf();
    }

    public boolean show(String string2, boolean bl, ComponentName componentName, Bundle bundle) {
        boolean bl2 = this.doShow(string2, bl, componentName, bundle);
        if (bl2) {
            this.mSearchAutoComplete.showDropDownAfterLayout();
        }
        return bl2;
    }

    public static class SearchBar
    extends LinearLayout {
        private SearchDialog mSearchDialog;

        public SearchBar(Context context) {
            super(context);
        }

        public SearchBar(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public void setSearchDialog(SearchDialog searchDialog) {
            this.mSearchDialog = searchDialog;
        }

        @Override
        public ActionMode startActionModeForChild(View view, ActionMode.Callback callback) {
            return null;
        }
    }
}

