/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.os.Parcelable;
import android.transition.TransitionUtils;
import android.view.View;
import java.util.List;
import java.util.Map;

public abstract class SharedElementCallback {
    static final SharedElementCallback NULL_CALLBACK = new SharedElementCallback(){};
    private Matrix mTempMatrix;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Parcelable onCaptureSharedElementSnapshot(View view, Matrix matrix, RectF rectF) {
        if (this.mTempMatrix == null) {
            this.mTempMatrix = new Matrix(matrix);
            return TransitionUtils.createViewBitmap(view, this.mTempMatrix, rectF);
        }
        this.mTempMatrix.set(matrix);
        return TransitionUtils.createViewBitmap(view, this.mTempMatrix, rectF);
    }

    public View onCreateSnapshotView(Context context, Parcelable parcelable) {
        boolean bl = parcelable instanceof Bitmap;
        View view = null;
        if (bl) {
            Bitmap bitmap = (Bitmap)parcelable;
            view = new View(context);
            view.setBackground(new BitmapDrawable(context.getResources(), bitmap));
        }
        return view;
    }

    public void onMapSharedElements(List<String> list, Map<String, View> map) {
    }

    public void onRejectSharedElements(List<View> list) {
    }

    public void onSharedElementEnd(List<String> list, List<View> list2, List<View> list3) {
    }

    public void onSharedElementStart(List<String> list, List<View> list2, List<View> list3) {
    }
}

