/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.IBackupAgent;
import android.app.QueuedWork;
import android.app.backup.BackupDataInput;
import android.app.backup.BackupDataOutput;
import android.app.backup.FullBackup;
import android.app.backup.FullBackupDataOutput;
import android.app.backup.IBackupManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructStat;
import android.util.Log;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import libcore.io.Libcore;

public abstract class BackupAgent
extends ContextWrapper {
    private static final boolean APP_BACKUP_DEBUG = false;
    private static final boolean DEBUG = true;
    private static final String TAG = "BackupAgent";
    public static final int TYPE_DIRECTORY = 2;
    public static final int TYPE_EOF = 0;
    public static final int TYPE_FILE = 1;
    public static final int TYPE_SYMLINK = 3;
    private final IBinder mBinder = new BackupServiceBinder().asBinder();
    Handler mHandler = null;

    public BackupAgent() {
        super(null);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyFile2Path(String var1_1, String var2_2, DataOutputStream var3_3) throws Exception {
        var4_4 = new File(var1_1);
        var5_5 = new File(var2_2 + "/" + var4_4.getName());
        var10_6 = Libcore.os.lstat(var1_1);
        if (OsConstants.S_ISLNK(var10_6.st_mode)) return;
        if (OsConstants.S_ISFIFO(var10_6.st_mode)) {
            return;
        }
        var11_7 = Libcore.os.stat((String)var1_1).st_mode;
        if (var3_3 == null) ** GOTO lbl32
        var12_8 = new FileInputStream(var1_1);
        Log.d("BackupAgent", "    start backup writting in copyFile2Path from " + var1_1 + ", st_mode: " + var11_7);
        try {
            var3_3.writeInt(1);
            var3_3.writeInt(var5_5.getAbsolutePath().getBytes().length);
            var3_3.write(var5_5.getAbsolutePath().getBytes());
            var3_3.writeInt(var11_7);
            var3_3.writeLong(var4_4.length());
            var15_9 = new byte[2048];
            while ((var16_10 = var12_8.read(var15_9)) != -1) {
                var3_3.write(var15_9, 0, var16_10);
            }
            var3_3.flush();
            ** GOTO lbl30
        }
        catch (Throwable var14_11) {
            var12_8.close();
            throw var14_11;
lbl30:
            // 2 sources

            var12_8.close();
            return;
lbl32:
            // 1 sources

            Log.d("BackupAgent", "    start restore writting in copyFile2Path from " + var1_1 + ", st_mode: " + var11_7);
            var18_13 = new FileInputStream(var1_1);
            var19_14 = true;
            if (var5_5.exists() && !var5_5.canWrite()) {
                Log.w("BackupAgent", "restore destPath is read-only, will delete it: " + var5_5.getAbsolutePath());
                if (!var5_5.delete()) {
                    Log.w("BackupAgent", "restore destPath is read-only and can't be deleted, will skip this file: " + var5_5.getAbsolutePath());
                    var19_14 = false;
                }
            }
            if (!var19_14) ** GOTO lbl70
            var23_15 = new FileOutputStream(var5_5.getAbsolutePath());
            try {
                var25_16 = new byte[2048];
                while ((var26_17 = var18_13.read(var25_16)) != -1) {
                    if (!var19_14) continue;
                    var23_15.write(var25_16, 0, var26_17);
                }
                Libcore.os.chmod(var5_5.getAbsolutePath(), var11_7);
                ** GOTO lbl64
            }
            catch (Throwable var24_18) {
                try {
                    try {
                        var23_15.close();
                        throw var24_18;
                    }
                    catch (IOException var21_19) {
                        Log.e("BackupAgent", "read file IO exception ", var21_19);
                        throw var21_19;
                    }
lbl64:
                    // 2 sources

                    var23_15.close();
                    ** GOTO lbl70
                }
                catch (Throwable var20_20) {
                    var18_13.close();
                    throw var20_20;
lbl70:
                    // 2 sources

                    try {
                        var18_13.close();
                        return;
                    }
                    catch (ErrnoException var8_12) {
                        Log.e("BackupAgent", "Error scanning file " + var1_1, var8_12);
                        throw var8_12;
                    }
                    catch (IOException var6_21) {
                        Log.e("BackupAgent", "read data IO exception ", var6_21);
                        throw var6_21;
                    }
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void copyFolder2Path(String var1_1, String var2_2, DataOutputStream var3_3) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [5 : 322->347)] android.system.ErrnoException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void dataCopy(String string2, String string3, DataOutputStream dataOutputStream) throws Exception {
        block3: {
            block2: {
                File file = new File(string2);
                if (!file.exists()) break block2;
                if (!file.isDirectory()) break block3;
                this.copyFolder2Path(string2, string3, dataOutputStream);
            }
            return;
        }
        this.copyFile2Path(string2, string3, dataOutputStream);
    }

    private void waitForSharedPrefs() {
        Handler handler = this.getHandler();
        SharedPrefsSynchronizer sharedPrefsSynchronizer = new SharedPrefsSynchronizer();
        handler.postAtFrontOfQueue(sharedPrefsSynchronizer);
        try {
            sharedPrefsSynchronizer.mLatch.await();
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void attach(Context context) {
        this.attachBaseContext(context);
    }

    /*
     * Unable to fully structure code
     */
    public final void fullBackupFile(File var1_1, FullBackupDataOutput var2_2) {
        block14: {
            block13: {
                block12: {
                    block11: {
                        var3_3 = this.getApplicationInfo();
                        var6_4 = new File(var3_3.dataDir).getCanonicalPath();
                        var7_5 = this.getFilesDir().getCanonicalPath();
                        var8_6 = this.getNoBackupFilesDir().getCanonicalPath();
                        var9_7 = this.getDatabasePath("foo").getParentFile().getCanonicalPath();
                        var10_8 = this.getSharedPrefsFile("foo").getParentFile().getCanonicalPath();
                        var11_9 = this.getCacheDir().getCanonicalPath();
                        if (var3_3.nativeLibraryDir != null) break block11;
                        var12_10 = null;
lbl11:
                        // 2 sources

                        while (true) {
                            var13_11 = Process.myUid();
                            var14_12 = null;
                            if (var13_11 == 1000) ** GOTO lbl22
                            var15_13 = this.getExternalFilesDir(null);
                            var14_12 = null;
                            if (var15_13 == null) ** GOTO lbl22
                            var14_12 = var15_13.getCanonicalPath();
lbl22:
                            // 3 sources

                            ** if (!(var16_14 = var1_1.getCanonicalPath()).startsWith((String)var11_9) && !var16_14.startsWith((String)var12_10) && !var16_14.startsWith((String)var8_6)) goto lbl-1000
lbl-1000:
                            // 1 sources

                            {
                                Log.w("BackupAgent", "lib, cache, and no_backup files are not backed up");
                                return;
                            }
lbl-1000:
                            // 1 sources

                            {
                            }
                            break;
                        }
                    }
                    try {
                        var12_10 = var23_15 = new File(var3_3.nativeLibraryDir).getCanonicalPath();
                        ** continue;
                    }
                    catch (IOException var4_16) {
                        Log.w("BackupAgent", "Unable to obtain canonical paths");
                        return;
                    }
                    if (var16_14.startsWith(var9_7)) {
                        var19_17 = "db";
                        var20_18 = var9_7;
lbl38:
                        // 5 sources

                        while (true) {
                            Log.i("BackupAgent", "backupFile() of " + var16_14 + " => domain=" + var19_17 + " rootpath=" + var20_18);
                            FullBackup.backupToTar(this.getPackageName(), var19_17, null, var20_18, var16_14, var2_2.getData());
                            return;
                        }
                    }
                    if (!var16_14.startsWith(var10_8)) break block12;
                    var19_17 = "sp";
                    var20_18 = var10_8;
                    ** GOTO lbl38
                }
                if (!var16_14.startsWith(var7_5)) break block13;
                var19_17 = "f";
                var20_18 = var7_5;
                ** GOTO lbl38
            }
            if (!var16_14.startsWith(var6_4)) break block14;
            var19_17 = "r";
            var20_18 = var6_4;
            ** GOTO lbl38
        }
        if (var14_12 != null && var16_14.startsWith(var14_12)) {
            var19_17 = "ef";
            var20_18 = var14_12;
            ** continue;
        }
        Log.w("BackupAgent", "File " + var16_14 + " is in an unsupported location; skipping");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void fullBackupFileTree(String string2, String string3, String string4, HashSet<String> hashSet, FullBackupDataOutput fullBackupDataOutput) {
        File file = new File(string4);
        if (file.exists()) {
            LinkedList<File> linkedList = new LinkedList<File>();
            linkedList.add(file);
            while (linkedList.size() > 0) {
                String string5;
                block8: {
                    File file2 = (File)linkedList.remove(0);
                    try {
                        File[] fileArray;
                        string5 = file2.getCanonicalPath();
                        if (hashSet != null && hashSet.contains(string5)) continue;
                        StructStat structStat = Os.lstat(string5);
                        if (OsConstants.S_ISLNK(structStat.st_mode)) {
                            Log.i(TAG, "Symlink (skipping)!: " + file2);
                        }
                        if (!OsConstants.S_ISDIR(structStat.st_mode) || (fileArray = file2.listFiles()) == null) break block8;
                        int n = fileArray.length;
                        for (int i = 0; i < n; ++i) {
                            linkedList.add(0, fileArray[i]);
                        }
                        break block8;
                    }
                    catch (IOException iOException) {
                        Log.w(TAG, "Error canonicalizing path of " + file2);
                    }
                    catch (ErrnoException errnoException) {
                        Log.w(TAG, "Error scanning file " + file2 + " : " + errnoException);
                    }
                    continue;
                }
                FullBackup.backupToTar(string2, string3, null, string4, string5, fullBackupDataOutput.getData());
            }
        }
    }

    Handler getHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(Looper.getMainLooper());
        }
        return this.mHandler;
    }

    public abstract void onBackup(ParcelFileDescriptor var1, BackupDataOutput var2, ParcelFileDescriptor var3) throws IOException;

    public final IBinder onBind() {
        return this.mBinder;
    }

    public void onCreate() {
    }

    /*
     * Unable to fully structure code
     */
    protected boolean onDataCopy(String var1_1, String var2_2, ParcelFileDescriptor var3_3) {
        Log.i("BackupAgent", "start onDataCopy...");
        var5_4 = true;
        var6_5 = null;
        if (var3_3 == null) ** GOTO lbl8
        try {
            var6_5 = new DataOutputStream(new FileOutputStream(var3_3.getFileDescriptor()));
lbl8:
            // 2 sources

            this.dataCopy(var1_1, var2_2, var6_5);
        }
        catch (Exception var12_7) {
            try {
                Log.e("BackupAgent", "exception happened during copying", var12_7);
            }
            catch (Throwable var7_9) {
                Log.d("BackupAgent", "    finally onDataCopy...");
                if (var6_5 != null) {
                    Log.d("BackupAgent", "    write EOF signal in onDataCopy...");
                    var6_5.write(new byte[4]);
                }
lbl37:
                // 4 sources

                throw var7_9;
                catch (IOException var9_10) {
                    Log.e("BackupAgent", "Unable to finalize backup stream!", var9_10);
                    ** continue;
                }
            }
            Log.d("BackupAgent", "    finally onDataCopy...");
            var5_4 = false;
            if (var6_5 == null) ** GOTO lbl16
            try {
                Log.d("BackupAgent", "    write EOF signal in onDataCopy...");
                var6_5.write(new byte[4]);
                var5_4 = false;
            }
            catch (IOException var15_8) {
                Log.e("BackupAgent", "Unable to finalize backup stream!", var15_8);
                var5_4 = false;
            }
            ** continue;
        }
        Log.d("BackupAgent", "    finally onDataCopy...");
        if (var6_5 != null) {
            Log.d("BackupAgent", "    write EOF signal in onDataCopy...");
            var6_5.write(new byte[4]);
        }
lbl16:
        // 5 sources

        while (true) {
            Log.d("BackupAgent", "    retunrn result in onDataCopy: " + var5_4);
            return var5_4;
        }
        catch (IOException var20_6) {
            Log.e("BackupAgent", "Unable to finalize backup stream!", var20_6);
            var5_4 = false;
        }
        ** GOTO lbl16
    }

    /*
     * Exception decompiling
     */
    protected boolean onDataRestore(ParcelFileDescriptor var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [9, 10 : 195->252)] java.lang.Exception
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void onDestroy() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onFullBackup(FullBackupDataOutput fullBackupDataOutput) throws IOException {
        File file;
        ApplicationInfo applicationInfo = this.getApplicationInfo();
        String string2 = new File(applicationInfo.dataDir).getCanonicalPath();
        String string3 = this.getFilesDir().getCanonicalPath();
        String string4 = this.getDatabasePath("foo").getParentFile().getCanonicalPath();
        String string5 = this.getSharedPrefsFile("foo").getParentFile().getCanonicalPath();
        String string6 = this.getCacheDir().getCanonicalPath();
        String string7 = applicationInfo.nativeLibraryDir != null ? new File(applicationInfo.nativeLibraryDir).getCanonicalPath() : null;
        HashSet<String> hashSet = new HashSet<String>();
        String string8 = this.getPackageName();
        if (string7 != null) {
            hashSet.add(string7);
        }
        hashSet.add(string6);
        hashSet.add(string4);
        hashSet.add(string5);
        hashSet.add(string3);
        this.fullBackupFileTree(string8, "r", string2, hashSet, fullBackupDataOutput);
        hashSet.add(string2);
        hashSet.remove(string3);
        this.fullBackupFileTree(string8, "f", string3, hashSet, fullBackupDataOutput);
        hashSet.add(string3);
        hashSet.remove(string4);
        this.fullBackupFileTree(string8, "db", string4, hashSet, fullBackupDataOutput);
        hashSet.add(string4);
        hashSet.remove(string5);
        this.fullBackupFileTree(string8, "sp", string5, hashSet, fullBackupDataOutput);
        if (Process.myUid() != 1000 && (file = this.getExternalFilesDir(null)) != null) {
            this.fullBackupFileTree(string8, "ef", file.getCanonicalPath(), null, fullBackupDataOutput);
        }
    }

    public abstract void onRestore(BackupDataInput var1, int var2, ParcelFileDescriptor var3) throws IOException;

    /*
     * Enabled aggressive block sorting
     */
    protected void onRestoreFile(ParcelFileDescriptor parcelFileDescriptor, long l, int n, String string2, String string3, long l2, long l3) throws IOException {
        String string4;
        block7: {
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block6: {
                                    Log.d(TAG, "onRestoreFile() size=" + l + " type=" + n + " domain=" + string2 + " relpath=" + string3 + " mode=" + l2 + " mtime=" + l3);
                                    if (!string2.equals("f")) break block6;
                                    string4 = this.getFilesDir().getCanonicalPath();
                                    break block7;
                                }
                                if (!string2.equals("db")) break block8;
                                string4 = this.getDatabasePath("foo").getParentFile().getCanonicalPath();
                                break block7;
                            }
                            if (!string2.equals("r")) break block9;
                            string4 = new File(this.getApplicationInfo().dataDir).getCanonicalPath();
                            break block7;
                        }
                        if (!string2.equals("sp")) break block10;
                        string4 = this.getSharedPrefsFile("foo").getParentFile().getCanonicalPath();
                        break block7;
                    }
                    if (!string2.equals("c")) break block11;
                    string4 = this.getCacheDir().getCanonicalPath();
                    break block7;
                }
                if (!string2.equals("ef")) break block12;
                int n2 = Process.myUid();
                string4 = null;
                if (n2 != 1000) {
                    File file = this.getExternalFilesDir(null);
                    string4 = null;
                    if (file != null) {
                        string4 = this.getExternalFilesDir(null).getCanonicalPath();
                        l2 = -1L;
                    }
                }
                break block7;
            }
            if (string2.equals("nb")) {
                string4 = this.getNoBackupFilesDir().getCanonicalPath();
            } else {
                Log.i(TAG, "Unrecognized domain " + string2);
                string4 = null;
            }
        }
        if (string4 != null) {
            File file = new File(string4, string3);
            String string5 = file.getCanonicalPath();
            if (string5.startsWith(string4 + File.separatorChar)) {
                Log.i(TAG, "[" + string2 + " : " + string3 + "] mapped to " + string5);
                this.onRestoreFile(parcelFileDescriptor, l, file, n, l2, l3);
                return;
            }
            Log.e(TAG, "Cross-domain restore attempt: " + string5);
        }
        Log.i(TAG, "[ skipping file " + string3 + "]");
        FullBackup.restoreFile(parcelFileDescriptor, l, n, l2, l3, null);
    }

    public void onRestoreFile(ParcelFileDescriptor parcelFileDescriptor, long l, File file, int n, long l2, long l3) throws IOException {
        FullBackup.restoreFile(parcelFileDescriptor, l, n, l2, l3, file);
    }

    public void onRestoreFinished() {
    }

    private class BackupServiceBinder
    extends IBackupAgent.Stub {
        private static final String DATACOPYRETURN = "datacopyresult";
        private static final String DATACOPYRETURNINTENT = "appbackuprestore.backupagent.copydatareturn";
        private static final String TAG = "BackupServiceBinder";

        private BackupServiceBinder() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void doBackup(ParcelFileDescriptor parcelFileDescriptor, ParcelFileDescriptor parcelFileDescriptor2, ParcelFileDescriptor parcelFileDescriptor3, int n, IBackupManager iBackupManager) throws RemoteException {
            long l = Binder.clearCallingIdentity();
            Log.v(TAG, "doBackup() invoked");
            BackupDataOutput backupDataOutput = new BackupDataOutput(parcelFileDescriptor2.getFileDescriptor());
            try {
                BackupAgent.this.onBackup(parcelFileDescriptor, backupDataOutput, parcelFileDescriptor3);
                return;
            }
            catch (IOException iOException) {
                Log.d(TAG, "onBackup (" + BackupAgent.this.getClass().getName() + ") threw", iOException);
                throw new RuntimeException(iOException);
            }
            catch (RuntimeException runtimeException) {
                Log.d(TAG, "onBackup (" + BackupAgent.this.getClass().getName() + ") threw", runtimeException);
                throw runtimeException;
            }
            finally {
                BackupAgent.this.waitForSharedPrefs();
                Binder.restoreCallingIdentity(l);
                iBackupManager.opComplete(n);
            }
        }

        @Override
        public void doDataCopy(String string2, String string3, ParcelFileDescriptor parcelFileDescriptor) throws RemoteException {
            Log.i(TAG, "start doDataCopy...");
            long l = Binder.clearCallingIdentity();
            boolean bl = BackupAgent.this.onDataCopy(string2, string3, parcelFileDescriptor);
            Intent intent = new Intent(DATACOPYRETURNINTENT);
            intent.putExtra(DATACOPYRETURN, bl);
            BackupAgent.this.getBaseContext().sendBroadcast(intent);
            Log.i(TAG, "end DataCopy sendBroadcast");
            Binder.restoreCallingIdentity(l);
            Log.i(TAG, "end doDataCopy, result: " + bl);
            if (!bl) {
                throw new RemoteException();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void doDataRestore(ParcelFileDescriptor parcelFileDescriptor) throws RemoteException {
            Log.i(TAG, "start doDataRestore...");
            long l = Binder.clearCallingIdentity();
            boolean bl = true;
            try {
                boolean bl2;
                bl = bl2 = BackupAgent.this.onDataRestore(parcelFileDescriptor);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            Intent intent = new Intent(DATACOPYRETURNINTENT);
            intent.putExtra(DATACOPYRETURN, bl);
            BackupAgent.this.getBaseContext().sendBroadcast(intent);
            Log.i(TAG, "end DataCopy sendBroadcast");
            Binder.restoreCallingIdentity(l);
            Log.i(TAG, "end doDataRestore, result: " + bl);
            if (!bl) {
                throw new RemoteException();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void doFullBackup(ParcelFileDescriptor parcelFileDescriptor, int n, IBackupManager iBackupManager) {
            long l = Binder.clearCallingIdentity();
            Log.v(TAG, "doFullBackup() invoked");
            BackupAgent.this.waitForSharedPrefs();
            try {
                BackupAgent.this.onFullBackup(new FullBackupDataOutput(parcelFileDescriptor));
                return;
            }
            catch (IOException iOException) {
                Log.d(TAG, "onBackup (" + BackupAgent.this.getClass().getName() + ") threw", iOException);
                throw new RuntimeException(iOException);
            }
            catch (RuntimeException runtimeException) {
                Log.d(TAG, "onBackup (" + BackupAgent.this.getClass().getName() + ") threw", runtimeException);
                throw runtimeException;
            }
            finally {
                BackupAgent.this.waitForSharedPrefs();
                new FileOutputStream(parcelFileDescriptor.getFileDescriptor()).write(new byte[4]);
                Binder.restoreCallingIdentity(l);
                iBackupManager.opComplete(n);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void doRestore(ParcelFileDescriptor parcelFileDescriptor, int n, ParcelFileDescriptor parcelFileDescriptor2, int n2, IBackupManager iBackupManager) throws RemoteException {
            long l = Binder.clearCallingIdentity();
            Log.v(TAG, "doRestore() invoked");
            BackupDataInput backupDataInput = new BackupDataInput(parcelFileDescriptor.getFileDescriptor());
            try {
                BackupAgent.this.onRestore(backupDataInput, n, parcelFileDescriptor2);
                return;
            }
            catch (IOException iOException) {
                Log.d(TAG, "onRestore (" + BackupAgent.this.getClass().getName() + ") threw", iOException);
                throw new RuntimeException(iOException);
            }
            catch (RuntimeException runtimeException) {
                Log.d(TAG, "onRestore (" + BackupAgent.this.getClass().getName() + ") threw", runtimeException);
                throw runtimeException;
            }
            finally {
                BackupAgent.this.waitForSharedPrefs();
                Binder.restoreCallingIdentity(l);
                iBackupManager.opComplete(n2);
            }
        }

        @Override
        public void doRestoreFile(ParcelFileDescriptor parcelFileDescriptor, long l, int n, String string2, String string3, long l2, long l3, int n2, IBackupManager iBackupManager) throws RemoteException {
            long l4 = Binder.clearCallingIdentity();
            try {
                BackupAgent.this.onRestoreFile(parcelFileDescriptor, l, n, string2, string3, l2, l3);
                return;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            finally {
                BackupAgent.this.waitForSharedPrefs();
                Binder.restoreCallingIdentity(l4);
                iBackupManager.opComplete(n2);
            }
        }

        @Override
        public void doRestoreFinished(int n, IBackupManager iBackupManager) {
            long l = Binder.clearCallingIdentity();
            try {
                BackupAgent.this.onRestoreFinished();
                return;
            }
            finally {
                BackupAgent.this.waitForSharedPrefs();
                Binder.restoreCallingIdentity(l);
                iBackupManager.opComplete(n);
            }
        }

        @Override
        public void fail(String string2) {
            BackupAgent.this.getHandler().post(new FailRunnable(string2));
        }
    }

    static class FailRunnable
    implements Runnable {
        private String mMessage;

        FailRunnable(String string2) {
            this.mMessage = string2;
        }

        @Override
        public void run() {
            throw new IllegalStateException(this.mMessage);
        }
    }

    class SharedPrefsSynchronizer
    implements Runnable {
        public final CountDownLatch mLatch = new CountDownLatch(1);

        SharedPrefsSynchronizer() {
        }

        @Override
        public void run() {
            QueuedWork.waitToFinish();
            this.mLatch.countDown();
        }
    }
}

