/*
 * Decompiled with CFR 0.152.
 */
package android.appwidget;

import android.appwidget.AppWidgetProviderInfo;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.RemoteViews;
import com.android.internal.appwidget.IAppWidgetService;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class AppWidgetManager {
    public static final String ACTION_APPWIDGET_BIND = "android.appwidget.action.APPWIDGET_BIND";
    public static final String ACTION_APPWIDGET_CONFIGURE = "android.appwidget.action.APPWIDGET_CONFIGURE";
    public static final String ACTION_APPWIDGET_DELETED = "android.appwidget.action.APPWIDGET_DELETED";
    public static final String ACTION_APPWIDGET_DISABLED = "android.appwidget.action.APPWIDGET_DISABLED";
    public static final String ACTION_APPWIDGET_ENABLED = "android.appwidget.action.APPWIDGET_ENABLED";
    public static final String ACTION_APPWIDGET_HOST_RESTORED = "android.appwidget.action.APPWIDGET_HOST_RESTORED";
    public static final String ACTION_APPWIDGET_OPTIONS_CHANGED = "android.appwidget.action.APPWIDGET_UPDATE_OPTIONS";
    public static final String ACTION_APPWIDGET_PICK = "android.appwidget.action.APPWIDGET_PICK";
    public static final String ACTION_APPWIDGET_RESTORED = "android.appwidget.action.APPWIDGET_RESTORED";
    public static final String ACTION_APPWIDGET_UPDATE = "android.appwidget.action.APPWIDGET_UPDATE";
    public static final String ACTION_KEYGUARD_APPWIDGET_PICK = "android.appwidget.action.KEYGUARD_APPWIDGET_PICK";
    public static final String EXTRA_APPWIDGET_ID = "appWidgetId";
    public static final String EXTRA_APPWIDGET_IDS = "appWidgetIds";
    public static final String EXTRA_APPWIDGET_OLD_IDS = "appWidgetOldIds";
    public static final String EXTRA_APPWIDGET_OPTIONS = "appWidgetOptions";
    public static final String EXTRA_APPWIDGET_PROVIDER = "appWidgetProvider";
    public static final String EXTRA_APPWIDGET_PROVIDER_PROFILE = "appWidgetProviderProfile";
    public static final String EXTRA_CATEGORY_FILTER = "categoryFilter";
    public static final String EXTRA_CUSTOM_EXTRAS = "customExtras";
    public static final String EXTRA_CUSTOM_INFO = "customInfo";
    public static final String EXTRA_CUSTOM_SORT = "customSort";
    public static final String EXTRA_HOST_ID = "hostId";
    public static final int INVALID_APPWIDGET_ID = 0;
    public static final String META_DATA_APPWIDGET_PROVIDER = "android.appwidget.provider";
    public static final String OPTION_APPWIDGET_HOST_CATEGORY = "appWidgetCategory";
    public static final String OPTION_APPWIDGET_MAX_HEIGHT = "appWidgetMaxHeight";
    public static final String OPTION_APPWIDGET_MAX_WIDTH = "appWidgetMaxWidth";
    public static final String OPTION_APPWIDGET_MIN_HEIGHT = "appWidgetMinHeight";
    public static final String OPTION_APPWIDGET_MIN_WIDTH = "appWidgetMinWidth";
    private final DisplayMetrics mDisplayMetrics;
    private final String mPackageName;
    private final IAppWidgetService mService;

    public AppWidgetManager(Context context, IAppWidgetService iAppWidgetService) {
        this.mPackageName = context.getOpPackageName();
        this.mService = iAppWidgetService;
        this.mDisplayMetrics = context.getResources().getDisplayMetrics();
    }

    private boolean bindAppWidgetIdIfAllowed(int n, int n2, ComponentName componentName, Bundle bundle) {
        if (this.mService == null) {
            return false;
        }
        try {
            boolean bl = this.mService.bindAppWidgetId(this.mPackageName, n, n2, componentName, bundle);
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    private void convertSizesToPixels(AppWidgetProviderInfo appWidgetProviderInfo) {
        appWidgetProviderInfo.minWidth = TypedValue.complexToDimensionPixelSize(appWidgetProviderInfo.minWidth, this.mDisplayMetrics);
        appWidgetProviderInfo.minHeight = TypedValue.complexToDimensionPixelSize(appWidgetProviderInfo.minHeight, this.mDisplayMetrics);
        appWidgetProviderInfo.minResizeWidth = TypedValue.complexToDimensionPixelSize(appWidgetProviderInfo.minResizeWidth, this.mDisplayMetrics);
        appWidgetProviderInfo.minResizeHeight = TypedValue.complexToDimensionPixelSize(appWidgetProviderInfo.minResizeHeight, this.mDisplayMetrics);
    }

    public static AppWidgetManager getInstance(Context context) {
        return (AppWidgetManager)context.getSystemService("appwidget");
    }

    public void bindAppWidgetId(int n, ComponentName componentName) {
        if (this.mService == null) {
            return;
        }
        this.bindAppWidgetId(n, componentName, null);
    }

    public void bindAppWidgetId(int n, ComponentName componentName, Bundle bundle) {
        if (this.mService == null) {
            return;
        }
        this.bindAppWidgetIdIfAllowed(n, Process.myUserHandle(), componentName, bundle);
    }

    public boolean bindAppWidgetIdIfAllowed(int n, ComponentName componentName) {
        if (this.mService == null) {
            return false;
        }
        return this.bindAppWidgetIdIfAllowed(n, UserHandle.myUserId(), componentName, null);
    }

    public boolean bindAppWidgetIdIfAllowed(int n, ComponentName componentName, Bundle bundle) {
        if (this.mService == null) {
            return false;
        }
        return this.bindAppWidgetIdIfAllowed(n, UserHandle.myUserId(), componentName, bundle);
    }

    public boolean bindAppWidgetIdIfAllowed(int n, UserHandle userHandle, ComponentName componentName, Bundle bundle) {
        if (this.mService == null) {
            return false;
        }
        return this.bindAppWidgetIdIfAllowed(n, userHandle.getIdentifier(), componentName, bundle);
    }

    public void bindRemoteViewsService(String string2, int n, Intent intent, IBinder iBinder) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.bindRemoteViewsService(string2, n, intent, iBinder);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    public int[] getAppWidgetIds(ComponentName componentName) {
        if (this.mService == null) {
            return new int[0];
        }
        try {
            int[] nArray = this.mService.getAppWidgetIds(componentName);
            return nArray;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AppWidgetProviderInfo getAppWidgetInfo(int n) {
        AppWidgetProviderInfo appWidgetProviderInfo;
        if (this.mService == null) {
            return null;
        }
        try {
            appWidgetProviderInfo = this.mService.getAppWidgetInfo(this.mPackageName, n);
            if (appWidgetProviderInfo == null) return appWidgetProviderInfo;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
        this.convertSizesToPixels(appWidgetProviderInfo);
        return appWidgetProviderInfo;
    }

    public Bundle getAppWidgetOptions(int n) {
        if (this.mService == null) {
            return Bundle.EMPTY;
        }
        try {
            Bundle bundle = this.mService.getAppWidgetOptions(this.mPackageName, n);
            return bundle;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    public List<AppWidgetProviderInfo> getInstalledProviders() {
        if (this.mService == null) {
            return Collections.emptyList();
        }
        return this.getInstalledProvidersForProfile(1, null);
    }

    public List<AppWidgetProviderInfo> getInstalledProviders(int n) {
        if (this.mService == null) {
            return Collections.emptyList();
        }
        return this.getInstalledProvidersForProfile(n, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<AppWidgetProviderInfo> getInstalledProvidersForProfile(int n, UserHandle userHandle) {
        if (this.mService == null) {
            return Collections.emptyList();
        }
        if (userHandle == null) {
            userHandle = Process.myUserHandle();
        }
        try {
            List<AppWidgetProviderInfo> list = this.mService.getInstalledProvidersForProfile(n, userHandle.getIdentifier());
            if (list == null) {
                return Collections.emptyList();
            }
            Iterator<AppWidgetProviderInfo> iterator = list.iterator();
            while (iterator.hasNext()) {
                this.convertSizesToPixels(iterator.next());
            }
            return list;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    public List<AppWidgetProviderInfo> getInstalledProvidersForProfile(UserHandle userHandle) {
        if (this.mService == null) {
            return Collections.emptyList();
        }
        return this.getInstalledProvidersForProfile(1, userHandle);
    }

    public boolean hasBindAppWidgetPermission(String string2) {
        if (this.mService == null) {
            return false;
        }
        try {
            boolean bl = this.mService.hasBindAppWidgetPermission(string2, UserHandle.myUserId());
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    public boolean hasBindAppWidgetPermission(String string2, int n) {
        if (this.mService == null) {
            return false;
        }
        try {
            boolean bl = this.mService.hasBindAppWidgetPermission(string2, n);
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    public void notifyAppWidgetViewDataChanged(int n, int n2) {
        if (this.mService == null) {
            return;
        }
        this.notifyAppWidgetViewDataChanged(new int[]{n}, n2);
    }

    public void notifyAppWidgetViewDataChanged(int[] nArray, int n) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.notifyAppWidgetViewDataChanged(this.mPackageName, nArray, n);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    public void partiallyUpdateAppWidget(int n, RemoteViews remoteViews) {
        if (this.mService == null) {
            return;
        }
        this.partiallyUpdateAppWidget(new int[]{n}, remoteViews);
    }

    public void partiallyUpdateAppWidget(int[] nArray, RemoteViews remoteViews) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.partiallyUpdateAppWidgetIds(this.mPackageName, nArray, remoteViews);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    public void setBindAppWidgetPermission(String string2, int n, boolean bl) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setBindAppWidgetPermission(string2, n, bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    public void setBindAppWidgetPermission(String string2, boolean bl) {
        if (this.mService == null) {
            return;
        }
        this.setBindAppWidgetPermission(string2, UserHandle.myUserId(), bl);
    }

    public void unbindRemoteViewsService(String string2, int n, Intent intent) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.unbindRemoteViewsService(string2, n, intent);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    public void updateAppWidget(int n, RemoteViews remoteViews) {
        if (this.mService == null) {
            return;
        }
        this.updateAppWidget(new int[]{n}, remoteViews);
    }

    public void updateAppWidget(ComponentName componentName, RemoteViews remoteViews) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.updateAppWidgetProvider(componentName, remoteViews);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    public void updateAppWidget(int[] nArray, RemoteViews remoteViews) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.updateAppWidgetIds(this.mPackageName, nArray, remoteViews);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    public void updateAppWidgetOptions(int n, Bundle bundle) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.updateAppWidgetOptions(this.mPackageName, n, bundle);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }
}

