/*
 * Decompiled with CFR 0.152.
 */
package android.appwidget;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;

public class AppWidgetProviderInfo
implements Parcelable {
    public static final Parcelable.Creator<AppWidgetProviderInfo> CREATOR = new Parcelable.Creator<AppWidgetProviderInfo>(){

        @Override
        public AppWidgetProviderInfo createFromParcel(Parcel parcel) {
            return new AppWidgetProviderInfo(parcel);
        }

        public AppWidgetProviderInfo[] newArray(int n) {
            return new AppWidgetProviderInfo[n];
        }
    };
    public static final int RESIZE_BOTH = 3;
    public static final int RESIZE_HORIZONTAL = 1;
    public static final int RESIZE_NONE = 0;
    public static final int RESIZE_VERTICAL = 2;
    public static final int WIDGET_CATEGORY_HOME_SCREEN = 1;
    public static final int WIDGET_CATEGORY_KEYGUARD = 2;
    public static final int WIDGET_CATEGORY_SEARCHBOX = 4;
    public int autoAdvanceViewId;
    public ComponentName configure;
    public int icon;
    public int initialKeyguardLayout;
    public int initialLayout;
    @Deprecated
    public String label;
    public int minHeight;
    public int minResizeHeight;
    public int minResizeWidth;
    public int minWidth;
    public int previewImage;
    public ComponentName provider;
    public ActivityInfo providerInfo;
    public int resizeMode;
    public int updatePeriodMillis;
    public int widgetCategory;

    public AppWidgetProviderInfo() {
    }

    public AppWidgetProviderInfo(Parcel parcel) {
        if (parcel.readInt() != 0) {
            this.provider = new ComponentName(parcel);
        }
        this.minWidth = parcel.readInt();
        this.minHeight = parcel.readInt();
        this.minResizeWidth = parcel.readInt();
        this.minResizeHeight = parcel.readInt();
        this.updatePeriodMillis = parcel.readInt();
        this.initialLayout = parcel.readInt();
        this.initialKeyguardLayout = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.configure = new ComponentName(parcel);
        }
        this.label = parcel.readString();
        this.icon = parcel.readInt();
        this.previewImage = parcel.readInt();
        this.autoAdvanceViewId = parcel.readInt();
        this.resizeMode = parcel.readInt();
        this.widgetCategory = parcel.readInt();
        this.providerInfo = (ActivityInfo)parcel.readParcelable(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Drawable loadDrawable(Context context, int n, int n2, boolean bl) {
        try {
            Resources resources = context.getPackageManager().getResourcesForApplication(this.providerInfo.applicationInfo);
            if (n2 > 0) {
                if (n > 0) return resources.getDrawableForDensity(n2, n);
                n = context.getResources().getDisplayMetrics().densityDpi;
                return resources.getDrawableForDensity(n2, n);
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        catch (Resources.NotFoundException notFoundException) {}
        if (!bl) return null;
        return this.providerInfo.loadIcon(context.getPackageManager());
    }

    /*
     * Enabled aggressive block sorting
     */
    public AppWidgetProviderInfo clone() {
        AppWidgetProviderInfo appWidgetProviderInfo = new AppWidgetProviderInfo();
        ComponentName componentName = this.provider == null ? null : this.provider.clone();
        appWidgetProviderInfo.provider = componentName;
        appWidgetProviderInfo.minWidth = this.minWidth;
        appWidgetProviderInfo.minHeight = this.minHeight;
        appWidgetProviderInfo.minResizeWidth = this.minResizeHeight;
        appWidgetProviderInfo.minResizeHeight = this.minResizeHeight;
        appWidgetProviderInfo.updatePeriodMillis = this.updatePeriodMillis;
        appWidgetProviderInfo.initialLayout = this.initialLayout;
        appWidgetProviderInfo.initialKeyguardLayout = this.initialKeyguardLayout;
        ComponentName componentName2 = this.configure == null ? null : this.configure.clone();
        appWidgetProviderInfo.configure = componentName2;
        String string2 = this.label;
        String string3 = null;
        if (string2 != null) {
            string3 = this.label.substring(0);
        }
        appWidgetProviderInfo.label = string3;
        appWidgetProviderInfo.icon = this.icon;
        appWidgetProviderInfo.previewImage = this.previewImage;
        appWidgetProviderInfo.autoAdvanceViewId = this.autoAdvanceViewId;
        appWidgetProviderInfo.resizeMode = this.resizeMode;
        appWidgetProviderInfo.widgetCategory = this.widgetCategory;
        appWidgetProviderInfo.providerInfo = this.providerInfo;
        return appWidgetProviderInfo;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public final UserHandle getProfile() {
        return new UserHandle(UserHandle.getUserId(this.providerInfo.applicationInfo.uid));
    }

    public final Drawable loadIcon(Context context, int n) {
        return this.loadDrawable(context, n, this.providerInfo.getIconResource(), true);
    }

    public final String loadLabel(PackageManager packageManager) {
        CharSequence charSequence = this.providerInfo.loadLabel(packageManager);
        if (charSequence != null) {
            return charSequence.toString().trim();
        }
        return null;
    }

    public final Drawable loadPreviewImage(Context context, int n) {
        return this.loadDrawable(context, n, this.previewImage, false);
    }

    public String toString() {
        return "AppWidgetProviderInfo(" + this.getProfile() + '/' + this.provider + ')';
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        if (this.provider != null) {
            parcel.writeInt(1);
            this.provider.writeToParcel(parcel, n);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.minWidth);
        parcel.writeInt(this.minHeight);
        parcel.writeInt(this.minResizeWidth);
        parcel.writeInt(this.minResizeHeight);
        parcel.writeInt(this.updatePeriodMillis);
        parcel.writeInt(this.initialLayout);
        parcel.writeInt(this.initialKeyguardLayout);
        if (this.configure != null) {
            parcel.writeInt(1);
            this.configure.writeToParcel(parcel, n);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeString(this.label);
        parcel.writeInt(this.icon);
        parcel.writeInt(this.previewImage);
        parcel.writeInt(this.autoAdvanceViewId);
        parcel.writeInt(this.resizeMode);
        parcel.writeInt(this.widgetCategory);
        parcel.writeParcelable(this.providerInfo, n);
    }
}

