/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.app.ActivityThread;
import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothA2dpSink;
import android.bluetooth.BluetoothActivityEnergyInfo;
import android.bluetooth.BluetoothAvrcpController;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothHeadsetClient;
import android.bluetooth.BluetoothHealth;
import android.bluetooth.BluetoothInputDevice;
import android.bluetooth.BluetoothMap;
import android.bluetooth.BluetoothPan;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.BluetoothSocket;
import android.bluetooth.IBluetooth;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothManagerCallback;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.os.Build;
import android.os.IBinder;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import android.util.Pair;
import com.asus.cta.CtaChecker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public final class BluetoothAdapter {
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED";
    public static final String ACTION_DISCOVERY_FINISHED = "android.bluetooth.adapter.action.DISCOVERY_FINISHED";
    public static final String ACTION_DISCOVERY_STARTED = "android.bluetooth.adapter.action.DISCOVERY_STARTED";
    public static final String ACTION_LOCAL_NAME_CHANGED = "android.bluetooth.adapter.action.LOCAL_NAME_CHANGED";
    public static final String ACTION_RADIO_STATE_CHANGED = "android.bluetooth.adapter.action.RADIO_STATE_CHANGED";
    public static final String ACTION_REQUEST_DISCOVERABLE = "android.bluetooth.adapter.action.REQUEST_DISCOVERABLE";
    public static final String ACTION_REQUEST_ENABLE = "android.bluetooth.adapter.action.REQUEST_ENABLE";
    public static final String ACTION_SCAN_MODE_CHANGED = "android.bluetooth.adapter.action.SCAN_MODE_CHANGED";
    public static final String ACTION_STATE_CHANGED = "android.bluetooth.adapter.action.STATE_CHANGED";
    public static final int ACTIVITY_ENERGY_INFO_CACHED = 0;
    public static final int ACTIVITY_ENERGY_INFO_REFRESHED = 1;
    private static final int ADDRESS_LENGTH = 17;
    public static final String BLUETOOTH_MANAGER_SERVICE = "bluetooth_manager";
    private static final int CONTROLLER_ENERGY_UPDATE_TIMEOUT_MILLIS = 30;
    private static final boolean DBG = true;
    public static final int ERROR = Integer.MIN_VALUE;
    public static final String EXTRA_CONNECTION_STATE = "android.bluetooth.adapter.extra.CONNECTION_STATE";
    public static final String EXTRA_DISCOVERABLE_DURATION = "android.bluetooth.adapter.extra.DISCOVERABLE_DURATION";
    public static final String EXTRA_LOCAL_NAME = "android.bluetooth.adapter.extra.LOCAL_NAME";
    public static final String EXTRA_PREVIOUS_CONNECTION_STATE = "android.bluetooth.adapter.extra.PREVIOUS_CONNECTION_STATE";
    public static final String EXTRA_PREVIOUS_SCAN_MODE = "android.bluetooth.adapter.extra.PREVIOUS_SCAN_MODE";
    public static final String EXTRA_PREVIOUS_STATE = "android.bluetooth.adapter.extra.PREVIOUS_STATE";
    public static final String EXTRA_SCAN_MODE = "android.bluetooth.adapter.extra.SCAN_MODE";
    public static final String EXTRA_STATE = "android.bluetooth.adapter.extra.STATE";
    public static final int RADIO_TYPE_BLE = 1;
    public static final int RADIO_TYPE_FM = 0;
    public static final int RADIO_TYPE_OTHER = 2;
    public static final int SCAN_MODE_CONNECTABLE = 21;
    public static final int SCAN_MODE_CONNECTABLE_DISCOVERABLE = 23;
    public static final int SCAN_MODE_NONE = 20;
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_DISCONNECTING = 3;
    public static final int STATE_OFF = 10;
    public static final int STATE_ON = 12;
    public static final int STATE_RADIO_OFF = 15;
    public static final int STATE_RADIO_ON = 14;
    public static final int STATE_TURNING_OFF = 13;
    public static final int STATE_TURNING_ON = 11;
    private static final String TAG = "BluetoothAdapter";
    private static final boolean VDBG;
    private static BluetoothAdapter sAdapter;
    private static BluetoothLeAdvertiser sBluetoothLeAdvertiser;
    private static BluetoothLeScanner sBluetoothLeScanner;
    private final Map<LeScanCallback, ScanCallback> mLeScanClients;
    private final Object mLock = new Object();
    private final IBluetoothManagerCallback mManagerCallback = new IBluetoothManagerCallback.Stub(){

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onBluetoothServiceDown() {
            var1_1 = BluetoothAdapter.access$000(BluetoothAdapter.this);
            synchronized (var1_1) {
                BluetoothAdapter.access$102(BluetoothAdapter.this, null);
                if (BluetoothAdapter.access$300(BluetoothAdapter.this) != null) {
                    BluetoothAdapter.access$300(BluetoothAdapter.this).clear();
                }
                if (BluetoothAdapter.access$400() != null) {
                    BluetoothAdapter.access$400().cleanup();
                }
                if (BluetoothAdapter.access$500() != null) {
                    BluetoothAdapter.access$500().cleanup();
                }
                for (IBluetoothManagerCallback var5_3 : BluetoothAdapter.access$200(BluetoothAdapter.this)) {
                    if (var5_3 == null) ** GOTO lbl16
                    try {
                        var5_3.onBluetoothServiceDown();
lbl16:
                        // 1 sources

                        Log.d("BluetoothAdapter", "onBluetoothServiceDown: cb is null!!!");
                    }
                    catch (Exception var7_4) {
                        Log.e("BluetoothAdapter", "", var7_4);
                    }
                }
                return;
            }
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onBluetoothServiceUp(IBluetooth var1_1) {
            var2_2 = BluetoothAdapter.access$000(BluetoothAdapter.this);
            synchronized (var2_2) {
                BluetoothAdapter.access$102(BluetoothAdapter.this, var1_1);
                for (IBluetoothManagerCallback var6_4 : BluetoothAdapter.access$200(BluetoothAdapter.this)) {
                    if (var6_4 == null) ** GOTO lbl10
                    try {
                        var6_4.onBluetoothServiceUp(var1_1);
lbl10:
                        // 1 sources

                        Log.d("BluetoothAdapter", "onBluetoothServiceUp: cb is null!!!");
                    }
                    catch (Exception var8_5) {
                        Log.e("BluetoothAdapter", "", var8_5);
                    }
                }
                return;
            }
        }
    };
    private final IBluetoothManager mManagerService;
    private ArrayList<IBluetoothManagerCallback> mProxyServiceStateCallbacks = new ArrayList();
    private IBluetooth mService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BluetoothAdapter(IBluetoothManager iBluetoothManager) {
        if (iBluetoothManager == null) {
            throw new IllegalArgumentException("bluetooth manager service is null");
        }
        try {
            this.mService = iBluetoothManager.registerAdapter(this.mManagerCallback);
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
        }
        this.mManagerService = iBluetoothManager;
        this.mLeScanClients = new HashMap<LeScanCallback, ScanCallback>();
    }

    static /* synthetic */ IBluetoothManagerCallback access$000(BluetoothAdapter bluetoothAdapter) {
        return bluetoothAdapter.mManagerCallback;
    }

    static /* synthetic */ IBluetooth access$102(BluetoothAdapter bluetoothAdapter, IBluetooth iBluetooth) {
        bluetoothAdapter.mService = iBluetooth;
        return iBluetooth;
    }

    static /* synthetic */ ArrayList access$200(BluetoothAdapter bluetoothAdapter) {
        return bluetoothAdapter.mProxyServiceStateCallbacks;
    }

    static /* synthetic */ Map access$300(BluetoothAdapter bluetoothAdapter) {
        return bluetoothAdapter.mLeScanClients;
    }

    static /* synthetic */ BluetoothLeAdvertiser access$400() {
        return sBluetoothLeAdvertiser;
    }

    static /* synthetic */ BluetoothLeScanner access$500() {
        return sBluetoothLeScanner;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean checkBluetoothAddress(String string2) {
        if (string2 != null && string2.length() == 17) {
            int n = 0;
            block4: while (true) {
                if (n >= 17) {
                    return true;
                }
                char c = string2.charAt(n);
                switch (n % 3) {
                    case 0: 
                    case 1: {
                        if ((c < '0' || c > '9') && (c < 'A' || c > 'F')) break block4;
                    }
                    default: {
                        break;
                    }
                    case 2: {
                        if (c != ':') break block4;
                    }
                }
                ++n;
            }
        }
        return false;
    }

    private BluetoothServerSocket createNewRfcommSocketAndRecord(String string2, UUID uUID, boolean bl, boolean bl2) throws IOException {
        BluetoothServerSocket bluetoothServerSocket = new BluetoothServerSocket(1, bl, bl2, new ParcelUuid(uUID));
        bluetoothServerSocket.setServiceName(string2);
        int n = bluetoothServerSocket.mSocket.bindListen();
        if (n != 0) {
            throw new IOException("Error: " + n);
        }
        return bluetoothServerSocket;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BluetoothAdapter getDefaultAdapter() {
        synchronized (BluetoothAdapter.class) {
            if (sAdapter != null) return sAdapter;
            IBinder iBinder = ServiceManager.getService(BLUETOOTH_MANAGER_SERVICE);
            if (iBinder != null) {
                sAdapter = new BluetoothAdapter(IBluetoothManager.Stub.asInterface(iBinder));
                return sAdapter;
            } else {
                Log.e(TAG, "Bluetooth binder is null");
            }
            return sAdapter;
        }
    }

    public static BluetoothServerSocket listenUsingScoOn() throws IOException {
        BluetoothServerSocket bluetoothServerSocket = new BluetoothServerSocket(2, false, false, -1);
        if (bluetoothServerSocket.mSocket.bindListen() < 0) {
            // empty if block
        }
        return bluetoothServerSocket;
    }

    private Set<BluetoothDevice> toDeviceSet(BluetoothDevice[] bluetoothDeviceArray) {
        return Collections.unmodifiableSet(new HashSet<BluetoothDevice>(Arrays.asList(bluetoothDeviceArray)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean cancelDiscovery() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService == null) return false;
                return this.mService.cancelDiscovery();
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public boolean changeApplicationBluetoothState(boolean bl, BluetoothStateChangeCallback bluetoothStateChangeCallback) {
        if (bluetoothStateChangeCallback == null) {
            // empty if block
        }
        return false;
    }

    public void closeProfileProxy(int n, BluetoothProfile bluetoothProfile) {
        if (bluetoothProfile == null) {
            return;
        }
        switch (n) {
            default: {
                return;
            }
            case 1: {
                ((BluetoothHeadset)bluetoothProfile).close();
                return;
            }
            case 2: {
                ((BluetoothA2dp)bluetoothProfile).close();
                return;
            }
            case 10: {
                ((BluetoothA2dpSink)bluetoothProfile).close();
                return;
            }
            case 11: {
                ((BluetoothAvrcpController)bluetoothProfile).close();
                return;
            }
            case 4: {
                ((BluetoothInputDevice)bluetoothProfile).close();
                return;
            }
            case 5: {
                ((BluetoothPan)bluetoothProfile).close();
                return;
            }
            case 3: {
                ((BluetoothHealth)bluetoothProfile).close();
                return;
            }
            case 7: {
                ((BluetoothGatt)bluetoothProfile).close();
                return;
            }
            case 8: {
                ((BluetoothGattServer)bluetoothProfile).close();
                return;
            }
            case 9: {
                ((BluetoothMap)bluetoothProfile).close();
                return;
            }
            case 16: 
        }
        ((BluetoothHeadsetClient)bluetoothProfile).close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean configHciSnoopLog(boolean bl) {
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService == null) return false;
                return this.mService.configHciSnoopLog(bl);
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public BluetoothSocket createVendorHciSocket(int n, int n2, int n3, int n4) throws IOException {
        return new BluetoothSocket(4, -1, false, false, new BluetoothDevice(this.getAddress()), n2 | (n << 16 | n3 << 8), null);
    }

    public boolean disable() {
        try {
            boolean bl = this.mManagerService.disable(true);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public boolean disable(boolean bl) {
        try {
            boolean bl2 = this.mManagerService.disable(bl);
            return bl2;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public boolean disableRadio(int n) {
        try {
            boolean bl = this.mManagerService.disableRadio(n);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean enable() {
        if (this.isEnabled()) {
            Log.d(TAG, "enable(): BT is already enabled..!");
            return true;
        }
        if (Build.CTA && !new CtaChecker(null).checkPermission(14, ActivityThread.currentPackageName())) {
            try {
                this.mManagerService.disable(true);
                return false;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "", remoteException);
                return false;
            }
        }
        try {
            return this.mManagerService.enable();
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public boolean enableNoAutoConnect() {
        if (this.isEnabled()) {
            Log.d(TAG, "enableNoAutoConnect(): BT is already enabled..!");
            return true;
        }
        try {
            boolean bl = this.mManagerService.enableNoAutoConnect();
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public boolean enableRadio(int n) {
        try {
            boolean bl = this.mManagerService.enableRadio(n);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.mManagerService.unregisterAdapter(this.mManagerCallback);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return;
        }
        finally {
            super.finalize();
        }
    }

    public String getAddress() {
        try {
            String string2 = this.mManagerService.getAddress();
            return string2;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BluetoothLeAdvertiser getBluetoothLeAdvertiser() {
        if (this.getState() != 12 || !this.isMultipleAdvertisementSupported()) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (sBluetoothLeAdvertiser == null) {
                sBluetoothLeAdvertiser = new BluetoothLeAdvertiser(this.mManagerService);
            }
            return sBluetoothLeAdvertiser;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BluetoothLeScanner getBluetoothLeScanner() {
        if (this.getState() != 12) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (sBluetoothLeScanner == null) {
                sBluetoothLeScanner = new BluetoothLeScanner(this.mManagerService);
            }
            return sBluetoothLeScanner;
        }
    }

    IBluetoothManager getBluetoothManager() {
        return this.mManagerService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    IBluetooth getBluetoothService(IBluetoothManagerCallback iBluetoothManagerCallback) {
        IBluetoothManagerCallback iBluetoothManagerCallback2 = this.mManagerCallback;
        synchronized (iBluetoothManagerCallback2) {
            if (iBluetoothManagerCallback == null) {
                Log.w(TAG, "getBluetoothService() called with no BluetoothManagerCallback");
            } else if (!this.mProxyServiceStateCallbacks.contains(iBluetoothManagerCallback)) {
                this.mProxyServiceStateCallbacks.add(iBluetoothManagerCallback);
            }
            return this.mService;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<BluetoothDevice> getBondedDevices() {
        if (this.getState() != 12) {
            return this.toDeviceSet(new BluetoothDevice[0]);
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService == null) return this.toDeviceSet(new BluetoothDevice[0]);
                return this.toDeviceSet(this.mService.getBondedDevices());
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getConnectionState() {
        if (this.getState() != 12) {
            return 0;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService == null) return 0;
                return this.mService.getAdapterConnectionState();
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "getConnectionState:", remoteException);
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BluetoothActivityEnergyInfo getControllerActivityEnergyInfo(int n) {
        if (this.getState() != 12) {
            return null;
        }
        try {
            if (!this.mService.isActivityAndEnergyReportingSupported()) {
                return null;
            }
            synchronized (this) {
                if (n != 1) break block9;
            }
        }
        catch (InterruptedException interruptedException) {
            Log.e(TAG, "getControllerActivityEnergyInfoCallback wait interrupted: " + interruptedException);
            return null;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "getControllerActivityEnergyInfoCallback: " + remoteException);
            return null;
        }
        {
            BluetoothActivityEnergyInfo bluetoothActivityEnergyInfo;
            block9: {
                this.mService.getActivityEnergyInfoFromController();
                this.wait(30L);
            }
            if (!(bluetoothActivityEnergyInfo = this.mService.reportActivityInfo()).isValid()) return null;
            return bluetoothActivityEnergyInfo;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getDiscoverableTimeout() {
        if (this.getState() != 12) {
            return -1;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService == null) return -1;
                return this.mService.getDiscoverableTimeout();
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return -1;
        }
    }

    public String getName() {
        try {
            String string2 = this.mManagerService.getName();
            return string2;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getProfileConnectionState(int n) {
        if (this.getState() != 12) {
            return 0;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService == null) return 0;
                return this.mService.getProfileConnectionState(n);
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "getProfileConnectionState:", remoteException);
            return 0;
        }
    }

    public boolean getProfileProxy(Context context, BluetoothProfile.ServiceListener serviceListener, int n) {
        if (context == null || serviceListener == null) {
            return false;
        }
        if (n == 1) {
            new BluetoothHeadset(context, serviceListener);
            return true;
        }
        if (n == 2) {
            new BluetoothA2dp(context, serviceListener);
            return true;
        }
        if (n == 10) {
            new BluetoothA2dpSink(context, serviceListener);
            return true;
        }
        if (n == 11) {
            new BluetoothAvrcpController(context, serviceListener);
            return true;
        }
        if (n == 4) {
            new BluetoothInputDevice(context, serviceListener);
            return true;
        }
        if (n == 5) {
            new BluetoothPan(context, serviceListener);
            return true;
        }
        if (n == 3) {
            new BluetoothHealth(context, serviceListener);
            return true;
        }
        if (n == 9) {
            new BluetoothMap(context, serviceListener);
            return true;
        }
        if (n == 16) {
            new BluetoothHeadsetClient(context, serviceListener);
            return true;
        }
        return false;
    }

    public BluetoothDevice getRemoteDevice(String string2) {
        return new BluetoothDevice(string2);
    }

    public BluetoothDevice getRemoteDevice(byte[] byArray) {
        if (byArray == null || byArray.length != 6) {
            throw new IllegalArgumentException("Bluetooth address must have 6 bytes");
        }
        Locale locale = Locale.US;
        Object[] objectArray = new Object[]{byArray[0], byArray[1], byArray[2], byArray[3], byArray[4], byArray[5]};
        return new BluetoothDevice(String.format(locale, "%02X:%02X:%02X:%02X:%02X:%02X", objectArray));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getScanMode() {
        if (this.getState() != 12) {
            return 20;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService == null) return 20;
                return this.mService.getScanMode();
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return 20;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getState() {
        block6: {
            try {
                IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
                synchronized (iBluetoothManagerCallback) {
                    if (this.mService == null) break block6;
                    return this.mService.getState();
                }
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "", remoteException);
            }
        }
        Log.d(TAG, "" + this.hashCode() + ": getState() :  mService = null. Returning STATE_OFF");
        return 10;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ParcelUuid[] getUuids() {
        if (this.getState() != 12) {
            return null;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService == null) return null;
                return this.mService.getUuids();
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDiscovering() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService == null) return false;
                return this.mService.isDiscovering();
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isEnabled() {
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService == null) return false;
                return this.mService.isEnabled();
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public boolean isMultipleAdvertisementSupported() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            boolean bl = this.mService.isMultiAdvertisementSupported();
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "failed to get isMultipleAdvertisementSupported, error: ", remoteException);
            return false;
        }
    }

    public boolean isOffloadedFilteringSupported() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            boolean bl = this.mService.isOffloadedFilteringSupported();
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "failed to get isOffloadedFilteringSupported, error: ", remoteException);
            return false;
        }
    }

    public boolean isOffloadedScanBatchingSupported() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            boolean bl = this.mService.isOffloadedScanBatchingSupported();
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "failed to get isOffloadedScanBatchingSupported, error: ", remoteException);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isRadioEnabled() {
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService == null) return false;
                return this.mService.isRadioEnabled();
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public BluetoothServerSocket listenUsingEncryptedRfcommOn(int n) throws IOException {
        BluetoothServerSocket bluetoothServerSocket = new BluetoothServerSocket(1, false, true, n);
        int n2 = bluetoothServerSocket.mSocket.bindListen();
        if (n2 < 0) {
            throw new IOException("Error: " + n2);
        }
        return bluetoothServerSocket;
    }

    public BluetoothServerSocket listenUsingEncryptedRfcommWithServiceRecord(String string2, UUID uUID) throws IOException {
        return this.createNewRfcommSocketAndRecord(string2, uUID, false, true);
    }

    public BluetoothServerSocket listenUsingInsecureRfcommOn(int n) throws IOException {
        BluetoothServerSocket bluetoothServerSocket = new BluetoothServerSocket(1, false, false, n);
        int n2 = bluetoothServerSocket.mSocket.bindListen();
        if (n2 != 0) {
            throw new IOException("Error: " + n2);
        }
        return bluetoothServerSocket;
    }

    public BluetoothServerSocket listenUsingInsecureRfcommWithServiceRecord(String string2, UUID uUID) throws IOException {
        return this.createNewRfcommSocketAndRecord(string2, uUID, false, false);
    }

    public BluetoothServerSocket listenUsingRfcommOn(int n) throws IOException {
        BluetoothServerSocket bluetoothServerSocket = new BluetoothServerSocket(1, true, true, n);
        int n2 = bluetoothServerSocket.mSocket.bindListen();
        if (n2 != 0) {
            throw new IOException("Error: " + n2);
        }
        return bluetoothServerSocket;
    }

    public BluetoothServerSocket listenUsingRfcommWithServiceRecord(String string2, UUID uUID) throws IOException {
        return this.createNewRfcommSocketAndRecord(string2, uUID, true, true);
    }

    public Pair<byte[], byte[]> readOutOfBandData() {
        if (this.getState() != 12) {
            // empty if block
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeServiceStateCallback(IBluetoothManagerCallback iBluetoothManagerCallback) {
        IBluetoothManagerCallback iBluetoothManagerCallback2 = this.mManagerCallback;
        synchronized (iBluetoothManagerCallback2) {
            this.mProxyServiceStateCallbacks.remove(iBluetoothManagerCallback);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDiscoverableTimeout(int n) {
        if (this.getState() != 12) {
            return;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService == null) break block6;
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return;
        }
        {
            block6: {
                this.mService.setDiscoverableTimeout(n);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setName(String string2) {
        if (this.getState() != 12) {
            return false;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService == null) return false;
                return this.mService.setName(string2);
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public boolean setScanMode(int n) {
        if (this.getState() != 12) {
            return false;
        }
        return this.setScanMode(n, this.getDiscoverableTimeout());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setScanMode(int n, int n2) {
        if (this.getState() != 12) {
            return false;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService == null) return false;
                return this.mService.setScanMode(n, n2);
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean startDiscovery() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService == null) return false;
                return this.mService.startDiscovery();
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    @Deprecated
    public boolean startLeScan(LeScanCallback leScanCallback) {
        return this.startLeScan(null, leScanCallback);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public boolean startLeScan(final UUID[] uUIDArray, final LeScanCallback leScanCallback) {
        Log.d(TAG, "startLeScan(): " + uUIDArray);
        if (leScanCallback == null) {
            Log.e(TAG, "startLeScan: null callback");
            return false;
        }
        BluetoothLeScanner bluetoothLeScanner = this.getBluetoothLeScanner();
        if (bluetoothLeScanner == null) {
            Log.e(TAG, "startLeScan: cannot get BluetoothLeScanner");
            return false;
        }
        Map<LeScanCallback, ScanCallback> map = this.mLeScanClients;
        synchronized (map) {
            block10: {
                if (this.mLeScanClients.containsKey(leScanCallback)) {
                    Log.e(TAG, "LE Scan has already started");
                    return false;
                }
                try {
                    IBluetoothGatt iBluetoothGatt = this.mManagerService.getBluetoothGatt();
                    if (iBluetoothGatt != null) break block10;
                }
                catch (RemoteException remoteException) {
                    Log.e(TAG, "", remoteException);
                    return false;
                }
                return false;
            }
            ScanCallback scanCallback = new ScanCallback(){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void onScanResult(int n, ScanResult scanResult) {
                    if (n != 1) {
                        Log.e(BluetoothAdapter.TAG, "LE Scan has already started");
                        return;
                    }
                    ScanRecord scanRecord = scanResult.getScanRecord();
                    if (scanRecord == null) return;
                    if (uUIDArray != null) {
                        ArrayList<ParcelUuid> arrayList = new ArrayList<ParcelUuid>();
                        UUID[] uUIDArray2 = uUIDArray;
                        int n2 = uUIDArray2.length;
                        for (int i = 0; i < n2; ++i) {
                            arrayList.add(new ParcelUuid(uUIDArray2[i]));
                        }
                        List<ParcelUuid> list = scanRecord.getServiceUuids();
                        if (list == null || !list.containsAll(arrayList)) {
                            Log.d(BluetoothAdapter.TAG, "uuids does not match");
                            return;
                        }
                    }
                    leScanCallback.onLeScan(scanResult.getDevice(), scanResult.getRssi(), scanRecord.getBytes());
                }
            };
            ScanSettings scanSettings = new ScanSettings.Builder().setCallbackType(1).setScanMode(2).build();
            ArrayList<ScanFilter> arrayList = new ArrayList<ScanFilter>();
            if (uUIDArray != null && uUIDArray.length > 0) {
                arrayList.add(new ScanFilter.Builder().setServiceUuid(new ParcelUuid(uUIDArray[0])).build());
            }
            bluetoothLeScanner.startScan(arrayList, scanSettings, scanCallback);
            this.mLeScanClients.put(leScanCallback, scanCallback);
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public void stopLeScan(LeScanCallback leScanCallback) {
        Log.d(TAG, "stopLeScan()");
        BluetoothLeScanner bluetoothLeScanner = this.getBluetoothLeScanner();
        if (bluetoothLeScanner == null) {
            return;
        }
        Map<LeScanCallback, ScanCallback> map = this.mLeScanClients;
        synchronized (map) {
            ScanCallback scanCallback = this.mLeScanClients.remove(leScanCallback);
            if (scanCallback == null) {
                Log.d(TAG, "scan not started yet");
                return;
            }
            bluetoothLeScanner.stopScan(scanCallback);
            return;
        }
    }

    public static interface BluetoothStateChangeCallback {
        public void onBluetoothStateChange(boolean var1);
    }

    public static interface LeScanCallback {
        public void onLeScan(BluetoothDevice var1, int var2, byte[] var3);
    }

    public class StateChangeCallbackWrapper
    extends IBluetoothStateChangeCallback.Stub {
        private BluetoothStateChangeCallback mCallback;

        StateChangeCallbackWrapper(BluetoothStateChangeCallback bluetoothStateChangeCallback) {
            this.mCallback = bluetoothStateChangeCallback;
        }

        @Override
        public void onBluetoothStateChange(boolean bl) {
            this.mCallback.onBluetoothStateChange(bl);
        }
    }
}

